/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.integration.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.component.version.ClientVersionUpdate;
import io.axoniq.axonserver.configuration.runtime.Endpoint;
import io.axoniq.axonserver.configuration.runtime.EventHandler;
import io.axoniq.axonserver.enterprise.cluster.NodeAllowsConnectionCheck;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.EventWithToken;
import io.axoniq.axonserver.integration.EndpointMessageFactory;
import io.axoniq.axonserver.integration.EventPublisher;
import io.axoniq.axonserver.integration.PayloadUtils;
import io.axoniq.axonserver.integration.WrappingTypes;
import io.axoniq.axonserver.integration.config.IntegrationConfiguration;
import io.axoniq.axonserver.integration.http.HttpCustomHeaders;
import io.axoniq.axonserver.integration.http.HttpMetadata;
import io.axoniq.axonserver.streams.connection.StreamEvent;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class HttpEventPublisher
implements EventPublisher {
    private final WebClient F;
    private final MediaType b;
    private final AtomicBoolean l;
    private final IntegrationConfiguration g;
    private final ObjectMapper m;
    private final String A;
    private static final Logger f = LoggerFactory.getLogger(HttpEventPublisher.class);
    private final String K;
    private final Endpoint e;

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void D(WebClient.RequestHeadersSpec requestHeadersSpec, String string, String string2) {
        void a2;
        Object a3 = string2;
        WebClient.RequestHeadersSpec a4 = requestHeadersSpec;
        String[] stringArray = new String[1];
        stringArray[0] = a3;
        a4.header((String)a2, stringArray);
    }

    @NotNull
    private /* synthetic */ MediaType D() {
        HttpEventPublisher a2;
        if (WrappingTypes.K.D().equals(a2.e.getWrappingType())) {
            return MediaType.APPLICATION_JSON;
        }
        return a2.b;
    }

    private /* synthetic */ String D(String string) {
        String a2 = string;
        HttpEventPublisher a3 = this;
        if (a2 != null && !a2.isBlank()) {
            return a3.e.getBaseUrl() + (String)a2;
        }
        return a3.D().replace("{name}", a3.K).replace(ClientVersionUpdate.D((Object)"kS\u007f^dUhDm"), a3.e.getContext());
    }

    /*
     * WARNING - void declaration
     */
    public HttpEventPublisher(Endpoint endpoint, EventHandler eventHandler, ObjectMapper objectMapper, IntegrationConfiguration integrationConfiguration, WebClient webClient) {
        void a2;
        void a3;
        void a4;
        void a5;
        HttpEventPublisher a6;
        HttpEventPublisher a7 = eventHandler;
        HttpEventPublisher httpEventPublisher = a6 = this;
        HttpEventPublisher httpEventPublisher2 = a6;
        HttpEventPublisher httpEventPublisher3 = a6;
        httpEventPublisher3.l = new AtomicBoolean();
        httpEventPublisher2.K = a7.getName();
        httpEventPublisher2.m = a5;
        a6.e = a4;
        a6.b = PayloadUtils.D((String)a6.e.getContentType());
        a6.A = a6.D(a7.getEventUrl());
        httpEventPublisher.g = a3;
        httpEventPublisher.F = a2;
    }

    public void close() {
        HttpEventPublisher a2;
        HttpEventPublisher httpEventPublisher = a2;
        f.debug(ClientVersionUpdate.D((Object)"kM*\u0010UFu^d\u0010`Er\\yCxUb\u0010s\\\u007fCuT0\u001d0Km"), (Object)httpEventPublisher.K, (Object)httpEventPublisher.A);
        a2.l.set(true);
    }

    private /* synthetic */ Throwable D(Throwable throwable) {
        Throwable a2 = throwable;
        HttpEventPublisher a3 = this;
        if (a2 instanceof MessagingPlatformException) {
            return a2;
        }
        return new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_ERROR, a2.getMessage(), a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(WebClient.RequestHeadersSpec<?> requestHeadersSpec, EventWithToken eventWithToken) {
        void a2;
        HttpEventPublisher a3 = eventWithToken;
        HttpEventPublisher a4 = this;
        a4.e.getMetaData().forEach((arg_0, arg_1) -> HttpEventPublisher.D((WebClient.RequestHeadersSpec)a2, arg_0, arg_1));
        if (WrappingTypes.A.D().equals(a4.e.getWrappingType())) {
            if (!a3.getEvent().getPayload().getType().isBlank()) {
                String[] stringArray = new String[1];
                stringArray[0] = a3.getEvent().getPayload().getType();
                a2.header(HttpCustomHeaders.E.D(), stringArray);
                String[] stringArray2 = new String[1];
                stringArray2[0] = a3.getEvent().getPayload().getType();
                a2.header(HttpCustomHeaders.m.D(), stringArray2);
            }
            if (!a3.getEvent().getPayload().getRevision().isBlank()) {
                String[] stringArray = new String[1];
                stringArray[0] = a3.getEvent().getPayload().getRevision();
                a2.header(HttpCustomHeaders.H.D(), stringArray);
            }
            String[] stringArray = new String[1];
            stringArray[0] = a3.getEvent().getMessageIdentifier();
            a2.header(HttpCustomHeaders.b.D(), stringArray);
            String[] stringArray3 = new String[1];
            stringArray3[0] = OffsetDateTime.ofInstant(Instant.ofEpochMilli(a3.getEvent().getTimestamp()), ZoneId.systemDefault()).toString();
            a2.header(HttpCustomHeaders.L.D(), stringArray3);
            String[] stringArray4 = new String[1];
            stringArray4[0] = "" + a3.getToken();
            a2.header(HttpCustomHeaders.C.D(), stringArray4);
            if (!a3.getEvent().getAggregateIdentifier().isBlank()) {
                String[] stringArray5 = new String[1];
                stringArray5[0] = a3.getEvent().getAggregateIdentifier();
                a2.header(HttpCustomHeaders.M.D(), stringArray5);
                String[] stringArray6 = new String[1];
                stringArray6[0] = a3.getEvent().getAggregateType();
                a2.header(HttpCustomHeaders.f.D(), stringArray6);
                String[] stringArray7 = new String[1];
                stringArray7[0] = String.valueOf(a3.getEvent().getAggregateSequenceNumber());
                a2.header(HttpCustomHeaders.G.D(), stringArray7);
            }
            if (a3.getEvent().getMetaDataCount() > 0) {
                String[] stringArray8 = new String[1];
                stringArray8[0] = HttpMetadata.D((ObjectMapper)a4.m, (Map)a3.getEvent().getMetaDataMap());
                a2.header(HttpCustomHeaders.K.D(), stringArray8);
            }
        }
    }

    private /* synthetic */ byte[] D(List<StreamEvent> list) throws JsonProcessingException {
        Object a2 = list;
        HttpEventPublisher a3 = this;
        if (WrappingTypes.A.D().equals(a3.e.getWrappingType())) {
            return ((StreamEvent)a2.get(0)).event().getEvent().getPayload().getData().toByteArray();
        }
        a2 = a2.stream().map(streamEvent -> {
            HttpEventPublisher a2 = streamEvent;
            HttpEventPublisher a3 = this;
            return EndpointMessageFactory.D((EventWithToken)a2.event(), (MediaType)a3.b);
        }).toList();
        return a3.m.writeValueAsBytes(a2);
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<Void> publish(List<StreamEvent> list) {
        void a2;
        HttpEventPublisher httpEventPublisher = this;
        if (httpEventPublisher.l.get()) {
            f.debug(NodeAllowsConnectionCheck.D((Object)"9\bxU\u0016\u0007;\u001c,\u0012b\u0001-U2\u0000 \u0019+\u0006*U6\u001ab\u0014b\u0016.\u001a1\u0010&U2\u0000 \u0019+\u0006*\u00100"), (Object)httpEventPublisher.K);
            return CompletableFuture.failedFuture(new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_CLOSED, ClientVersionUpdate.D((Object)"`eR|YcXuB0Q|BuQtI0S|_cUt")));
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        Object[] objectArray = new Object[3];
        objectArray[0] = a2.size();
        objectArray[1] = httpEventPublisher.K;
        objectArray[2] = httpEventPublisher.A;
        f.trace(NodeAllowsConnectionCheck.D((Object)"\u0006\u001c1\u0005#\u0001!\u001db\u000e?U'\u0003'\u001b6\u0006b\u000e?U6\u001ab\u000e?"), objectArray);
        try {
            HttpEventPublisher a3 = ((WebClient.RequestBodySpec)httpEventPublisher.F.post().uri(httpEventPublisher.A, new Object[0])).contentType(httpEventPublisher.D()).body((Publisher)Mono.just((Object)httpEventPublisher.D((List)a2)), byte[].class);
            httpEventPublisher.D((WebClient.RequestHeadersSpec)a3, ((StreamEvent)a2.get(0)).event());
            Mono.defer(() -> httpEventPublisher.D((WebClient.RequestHeadersSpec)a3)).retryWhen((Retry)Retry.backoff((long)Long.MAX_VALUE, (Duration)Duration.ofMillis(httpEventPublisher.g.getEventRetryBackoff())).filter(throwable -> {
                Object a2 = throwable;
                HttpEventPublisher a3 = this;
                if (!a3.l.get()) {
                    return true;
                }
                return false;
            }).maxBackoff(Duration.ofSeconds(30L)).doBeforeRetry(retrySignal -> {
                HttpEventPublisher a2 = retrySignal;
                HttpEventPublisher a3 = this;
                f.debug(NodeAllowsConnectionCheck.D((Object)"\u000e?UoU\u0010\u00106\u0007;Ob\u000e?"), (Object)a3.A, (Object)a2.failure().getMessage());
            })).subscribe(clientResponse -> {
                CompletableFuture a2 = clientResponse;
                CompletableFuture a3 = completableFuture;
                a2.releaseBody().subscribe();
                a3.complete(null);
            }, throwable -> {
                void a2;
                Object a3 = throwable;
                HttpEventPublisher a4 = this;
                a2.completeExceptionally(a4.D((Throwable)a3));
            });
            return completableFuture;
        }
        catch (Exception a3) {
            CompletableFuture<Void> completableFuture2 = completableFuture;
            completableFuture2.completeExceptionally(new MessagingPlatformException(ErrorCode.OTHER, a3.getMessage(), (Throwable)a3));
            return completableFuture2;
        }
    }

    private /* synthetic */ String D() {
        HttpEventPublisher a2;
        return a2.e.getBaseUrl() + a2.e.getEventUrl();
    }

    private /* synthetic */ Mono D(WebClient.RequestHeadersSpec requestHeadersSpec) {
        HttpEventPublisher a3 = requestHeadersSpec;
        HttpEventPublisher a4 = this;
        if (a4.l.get()) {
            return Mono.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_CLOSED, ClientVersionUpdate.D((Object)"`eR|YcXuB0Q|BuQtI0S|_cUt")));
        }
        return a3.exchangeToMono(a2 -> {
            if (a2.statusCode().is2xxSuccessful()) {
                return Mono.just((Object)a2);
            }
            return Mono.error((Throwable)new IllegalStateException(a2.statusCode().toString()));
        }).doOnSubscribe(subscription -> {
            HttpEventPublisher a2 = subscription;
            HttpEventPublisher a3 = this;
            f.debug(NodeAllowsConnectionCheck.D((Object)"\u0011\u0010,\u0011+\u001b%U'\u0003'\u001b6U6\u001ab\u000e?"), (Object)a3.A);
        }).doOnSuccess(clientResponse -> {
            HttpEventPublisher a2 = clientResponse;
            HttpEventPublisher a3 = this;
            f.debug(ClientVersionUpdate.D((Object)"ufU~D0Cu^d\u0010d_0Km"), (Object)a3.A);
        }).doOnError(throwable -> {
            Throwable a2 = throwable;
            HttpEventPublisher a3 = this;
            f.info(NodeAllowsConnectionCheck.D((Object)"\u0007\u00070\u001a0U1\u0010,\u0011+\u001b%U'\u0003'\u001b6U6\u001ab\u000e?Ob\u000e?"), (Object)a3.A, (Object)a2.getMessage());
        });
    }
}

