/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.file.EventStoreSchedulers;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class FileUtils {
    public static final Logger e = LoggerFactory.getLogger(FileUtils.class);

    public static boolean D(File file) {
        File file2 = file;
        if (!file2.exists()) {
            return true;
        }
        e.debug(SegmentIndexEntries.D((Object)"\u0019x1x)x}{4q8=&`"), (Object)file2.getAbsolutePath());
        try {
            Files.delete(file2.toPath());
        }
        catch (DirectoryNotEmptyException a2) {
            e.info(EventStoreSchedulers.D((Object)"O\u000b`\u0006l\u000e)\u001efJm\u000fe\u000f}\u000f)\u000e`\u0018l\t}\u0005{\u00133Jr\u0017%J`\u001e)\u0003zJg\u0005}Jl\u0007y\u001ep"), (Object)file2);
            return false;
        }
        catch (IOException a2) {
            e.warn(SegmentIndexEntries.D((Object)"\u001b|4q8y}i2=9x1x)xg=&`"), (Object)file2, (Object)a2);
            return false;
        }
        return true;
    }

    private /* synthetic */ FileUtils() {
        FileUtils a2;
    }

    public static void D(File a2) {
        if (a2.exists() && !a2.isDirectory()) {
            throw new MessagingPlatformException(ErrorCode.DIRECTORY_CREATION_FAILED, "Could not setup directory " + a2.getAbsolutePath());
        }
        if (!a2.exists() && !a2.mkdirs()) {
            throw new MessagingPlatformException(ErrorCode.DIRECTORY_CREATION_FAILED, "Could not setup directory " + a2.getAbsolutePath());
        }
    }

    private static /* synthetic */ boolean D(String string, File file, String string2) {
        String a2 = string2;
        String a3 = string;
        return a2.endsWith(a3);
    }

    public static FileVersion D(String string) {
        String string2 = string;
        String string3 = string2;
        String a2 = string3.substring(0, string3.indexOf(46));
        int n = a2.indexOf(95);
        if (n < 0) {
            return new FileVersion(Long.parseLong(a2), 0);
        }
        return new FileVersion(Long.parseLong(a2.substring(0, n)), Integer.parseInt(a2.substring(n + 1)));
    }

    public static String D(File a2) {
        try {
            return a2.getCanonicalFile().getAbsolutePath();
        }
        catch (IOException iOException) {
            return a2.getAbsolutePath();
        }
    }

    public static Mono<Void> D(File file, File file2) {
        File a2 = file2;
        File a3 = file;
        return Mono.create(monoSink -> {
            void a2;
            File file3 = a3;
            try {
                void v1;
                void a3;
                if (Files.getFileStore(file3.toPath()).equals(Files.getFileStore(a3.getParentFile().toPath()))) {
                    CopyOption[] copyOptionArray = new CopyOption[1];
                    copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.move(file3.toPath(), a3.toPath(), copyOptionArray);
                    v1 = a2;
                } else {
                    File a4 = File.createTempFile(a3.getName(), EventStoreSchedulers.D((Object)"D}\u0007y"), a3.getParentFile());
                    a4.deleteOnExit();
                    CopyOption[] copyOptionArray = new CopyOption[1];
                    copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.copy(file3.toPath(), a4.toPath(), copyOptionArray);
                    Files.delete(file3.toPath());
                    CopyOption[] copyOptionArray2 = new CopyOption[1];
                    copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.move(a4.toPath(), a3.toPath(), copyOptionArray2);
                    v1 = a2;
                }
                v1.success();
                return;
            }
            catch (Exception a4) {
                a2.error((Throwable)a4);
                return;
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }

    public static String[] D(File file, String string) {
        String[] a2 = string;
        File a3 = file;
        if ((a2 = a3.list((arg_0, arg_1) -> FileUtils.D((String)a2, arg_0, arg_1))) == null) {
            throw new MessagingPlatformException(ErrorCode.DATAFILE_READ_ERROR, "Could not list files in " + a3.getAbsolutePath());
        }
        return a2;
    }
}

