/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.enterprise.cluster.ClientConnectionInformation;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.file.AbstractFileStorageTier;
import io.axoniq.axonserver.localstorage.file.ByteBufferEventSource;
import io.axoniq.axonserver.localstorage.file.EventInformation;
import io.axoniq.axonserver.localstorage.file.EventSource;
import io.axoniq.axonserver.localstorage.file.FilePreparedTransaction;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.Segment;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.StorageTier;
import io.axoniq.axonserver.localstorage.file.Synchronizer;
import io.axoniq.axonserver.localstorage.file.WritableEventSource;
import io.axoniq.axonserver.localstorage.file.WritePosition;
import io.axoniq.axonserver.localstorage.file.b;
import io.axoniq.axonserver.localstorage.transformation.EventTransformer;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.localstorage.transformation.ProcessedEvent;
import io.axoniq.axonserver.localstorage.transformation.WrappedEvent;
import io.axoniq.axonserver.message.query.subscription.SubscriptionQueryDispatcher;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WritableFileStorageTier
extends AbstractFileStorageTier {
    private final FileSystemMonitor F;
    protected final AtomicLong b;
    private final EventTransformer l;
    protected final ConcurrentNavigableMap<Long, ByteBufferEventSource> g;
    private Path m;
    private static final Logger C = LoggerFactory.getLogger(WritableFileStorageTier.class);
    private final Synchronizer A;
    protected final AtomicReference<WritePosition> f;
    private final MeterFactory K;
    private final Gauge e;

    private static /* synthetic */ boolean D(long a2, FileVersion a3) {
        if (a3.D() < a2) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean D(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.g.remove((long)a2);
        if (byteBufferEventSource != null) {
            byteBufferEventSource.D(0L);
        }
        if (a4.H.remove(a3 = new FileVersion((long)a2, a3)) && FileUtils.D((File)a4.D(a3))) {
            return true;
        }
        return false;
    }

    private /* synthetic */ void L() {
        WritableFileStorageTier writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier = this;
        while (true) {
            if (writableFileStorageTier2.g.size() == 1) break;
            try {
                Thread.sleep(10L);
                writableFileStorageTier2 = writableFileStorageTier;
            }
            catch (InterruptedException a2) {
                Thread.currentThread().interrupt();
                throw new MessagingPlatformException(ErrorCode.OTHER, writableFileStorageTier.h + ": Interrupted while waiting for completion", (Throwable)a2);
            }
        }
    }

    public void close(boolean bl) {
        boolean a2 = bl;
        WritableFileStorageTier a3 = this;
        File file = new File(a3.E);
        WritableFileStorageTier writableFileStorageTier = a3;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.F.unregisterPath(writableFileStorageTier2.D());
        writableFileStorageTier.K.remove((Meter)a3.e);
        writableFileStorageTier2.A.L();
        writableFileStorageTier.g.forEach((l2, byteBufferEventSource) -> {
            void a2;
            WritableFileStorageTier a3 = byteBufferEventSource;
            WritableFileStorageTier a4 = this;
            a3.D(0L);
            if (a2 != false) {
                void a5;
                a4.A(a5.longValue());
            }
        });
        a3.D((T storageTier) -> {
            StorageTier a2 = storageTier;
            boolean a3 = a2;
            a2.close(a3);
        });
        boolean bl2 = a2;
        a3.H.cleanup(bl2);
        if (bl2) {
            FileUtils.D((File)file);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(FileVersion fileVersion) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.D((FileVersion)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.D(arg_0 -> WritableFileStorageTier.L((FileVersion)a2, arg_0), Optional.empty());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(WritePosition writePosition) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.g.remove(a2.g);
        C.debug(SubscriptionQueryDispatcher.D((Object)"_>y;r;70a:e\u007fl\";\u007fe:z>~1~1p\u007fd:p2r1c,-\u007fl\""), (Object)a2.g, (Object)writableFileStorageTier.getSegments());
        if (a3 != null) {
            a3.D((long)((StorageProperties)writableFileStorageTier.m.get()).getPrimaryCleanupDelay());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(WritePosition writePosition, StorageTier storageTier) {
        void a2;
        WritableFileStorageTier a3 = writePosition;
        WritableFileStorageTier a4 = this;
        a2.handover((Segment)new b(a4, (WritePosition)a3), () -> a4.L((WritePosition)a3));
    }

    private static /* synthetic */ Optional L(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FilePreparedTransaction D(List<Event> list, int n) {
        void a22;
        Object a3 = list;
        WritableFileStorageTier a4 = this;
        a3 = a3.stream().map(event -> {
            WritableFileStorageTier a2 = event;
            WritableFileStorageTier a3 = this;
            return new WrappedEvent((Event)a2, a3.l);
        }).collect(Collectors.toList());
        WritableFileStorageTier writableFileStorageTier = a4;
        int n2 = writableFileStorageTier.D((List)a3);
        WritePosition a22 = writableFileStorageTier.D(n2, a3.size(), (int)a22);
        return new FilePreparedTransaction(a22, n2, (List)a3);
    }

    private static /* synthetic */ Optional D(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }

    private /* synthetic */ void D(SortedSet<FileVersion> sortedSet) {
        SortedSet<FileVersion> a2 = sortedSet;
        WritableFileStorageTier a3 = this;
        C.warn(SubscriptionQueryDispatcher.D((Object)"$je7\u001db3|rt-r>c6y876y;r'7:y+e6r,79x-7$j\u007fd:p2r1c,"), (Object)a3.h, (Object)a2.size());
        Instant instant = Instant.now();
        if (a3.H.canBatchIndexParallel() && ((StorageProperties)a3.m.get()).isBulkIndexAllowParallel()) {
            C.info(ClientConnectionInformation.D((Object)"e\u001b$FW\bz\u0003f\u000fp\u0001>\u0011w\u0012vFn\u0007l\u0007r\n{\n>\u0015k\u0016n\tl\u0012"), (Object)a3.h);
            a2.parallelStream().forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.D(arg_0 -> WritableFileStorageTier.D((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.D());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.D();
                        if (!eventInformation.D()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.D().getAggregateSequenceNumber(), eventInformation.D(), eventInformation.D());
                        hashMap.computeIfAbsent(eventInformation.D().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.H.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        } else {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.h;
            objectArray[1] = a3.H.canBatchIndexParallel();
            objectArray[2] = ((StorageProperties)a3.m.get()).isBulkIndexAllowParallel();
            C.info(SubscriptionQueryDispatcher.D((Object)"$je7\u0016y;r'~1p\u007fd:f*r1c6v3{&7wR)v3b>c6x170q\u007fg>e>{3r376y;r'~1pe76y;r'T>g>u6{6c6r,-$j\u007f1y7<x1c:o+D:c+~1p,-$jv"), objectArray);
            a2.forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.D(arg_0 -> WritableFileStorageTier.D((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.D());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.D();
                        if (!eventInformation.D()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.D().getAggregateSequenceNumber(), eventInformation.D(), eventInformation.D());
                        hashMap.computeIfAbsent(eventInformation.D().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.H.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        }
        C.warn(ClientConnectionInformation.D((Object)"\u001dc\\>$k\nuK}\u0014{\u0007j\u000fp\u0001>\u000fp\u0002{\u001e>\u0012q\tuFe\u001b"), (Object)a3.h, (Object)Duration.between(instant, Instant.now()));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ WritePosition D(int n, int n2, int n3) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        int n4 = (int)Math.ceil((double)a3 / 32767.0);
        if ((n4 = a4 + n4 * 11) > 0x7FFFFFF6 || a4 <= 0) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a4;
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, String.format(SubscriptionQueryDispatcher.D((Object)"^3{:p>{\u007fc-v1d>t+~0y\u007fd6m:-\u007f2;"), objectArray));
        }
        do {
            if (!(a4 = (WritePosition)a5.f.getAndUpdate(arg_0 -> WritableFileStorageTier.D((int)a3, n4, (int)a2, arg_0))).D(n4) && !a4.A((int)a2)) continue;
            C.debug(ClientConnectionInformation.D((Object)"\u001dc\\>%l\u0003\u007f\u0012w\byFp\u0003iFm\u0003y\u000b{\bjFe\u001b"), (Object)a5.h, (Object)a4.f);
            WritePosition writePosition = a4;
            writePosition.b.D(writePosition.m, -1);
            WritableEventSource writableEventSource = a5.D(new FileVersion(a4.f, (int)a2), n4 + 5 + 4, true);
            a5.f.set(a4.D(writableEventSource, (int)a2));
        } while (!a4.L(n4) || a4.A((int)a2));
        return a4;
    }

    public Flux<FileVersion> fileVersions(String string) {
        Object a2 = string;
        WritableFileStorageTier a3 = this;
        return (Flux)a3.D(arg_0 -> WritableFileStorageTier.D((String)a2, arg_0), (Object)Flux.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ FileVersion D(FileVersion fileVersion, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        WritableEventSource a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier2 = this;
        if (!writableFileStorageTier2.H.validIndex((FileVersion)a3)) {
            return a3;
        }
        a2 = writableFileStorageTier2.D((FileVersion)a3, a2.getSegmentSize(), false);
        long l2 = a3.D();
        try {
            WritableFileStorageTier a42222 = a2.createEventIterator(a3.D());
            try {
                while (a42222.hasNext()) {
                    a42222.D();
                    ++l2;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (a42222 != null) {
                    try {
                        a42222.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable a42222) {
                        throwable.addSuppressed(a42222);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
        catch (Throwable a42222) {
            writableFileStorageTier2.g.remove(a3.D());
            a2.D(0L);
            throw a42222;
        }
        if (a42222 != null) {
            writableFileStorageTier = writableFileStorageTier2;
            a42222.close();
        } else {
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.g.remove(a3.D());
        a2.D(0L);
        return new FileVersion(l2, 0);
    }

    /*
     * WARNING - void declaration
     */
    public void D(long l2, long l3) {
        void a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a4 = (StorageProperties)writableFileStorageTier.m.get();
        File file = new File(writableFileStorageTier.E);
        FileUtils.D((File)file);
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
        writableFileStorageTier.H.init();
        writableFileStorageTier2.D((long)a3, file, (long)a2, (StorageProperties)a4);
        writableFileStorageTier2.m = file.toPath();
        writableFileStorageTier2.F.registerPath(writableFileStorageTier.D(), writableFileStorageTier.m, a4.minFreeSpace(), a4.warnFreeSpace());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)writableFileStorageTier.g.remove((long)a2);
        int a3 = 0;
        if (byteBufferEventSource != null) {
            ByteBufferEventSource byteBufferEventSource2 = byteBufferEventSource;
            a3 = byteBufferEventSource2.D();
            byteBufferEventSource2.D(0L);
        }
        writableFileStorageTier.D((long)a2, a3).forEach(arg_0 -> writableFileStorageTier.D((long)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public WritableFileStorageTier(EventTypeContext eventTypeContext, IndexManager indexManager, Supplier<StorageProperties> supplier, Supplier<StorageTier> supplier2, MeterFactory meterFactory, ScheduledExecutorService scheduledExecutorService, String string, EventTransformerFactory eventTransformerFactory, FileSystemMonitor fileSystemMonitor) {
        void a2;
        void a3;
        void a4;
        void a5;
        WritableFileStorageTier a6;
        void a7;
        void a8;
        void a9;
        void a10;
        WritableFileStorageTier a11;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = meterFactory;
        WritableFileStorageTier writableFileStorageTier3 = a11 = writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier4 = a11;
        super((EventTypeContext)a10, (IndexManager)a9, (Supplier)a8, (Supplier)a7, (MeterFactory)a6, (String)a5);
        WritableFileStorageTier writableFileStorageTier5 = a11;
        writableFileStorageTier5.f = new AtomicReference();
        WritableFileStorageTier writableFileStorageTier6 = a11;
        writableFileStorageTier4.b = new AtomicLong(-1L);
        WritableFileStorageTier writableFileStorageTier7 = a11;
        writableFileStorageTier4.g = new ConcurrentSkipListMap(Comparator.reverseOrder());
        writableFileStorageTier4.K = a6;
        writableFileStorageTier3.F = a4;
        writableFileStorageTier3.l = a3.get(((StorageProperties)a8.get()).getFlags());
        WritableFileStorageTier writableFileStorageTier8 = a11;
        writableFileStorageTier8.A = new Synchronizer((EventTypeContext)a10, (StorageProperties)a8.get(), (MeterFactory)a6, (ScheduledExecutorService)a2, writePosition -> {
            WritableFileStorageTier a2;
            WritableFileStorageTier a3 = writePosition;
            WritableFileStorageTier writableFileStorageTier = a2 = this;
            writableFileStorageTier.H.complete(new FileVersion(a3.g.longValue(), 0));
            writableFileStorageTier.D(arg_0 -> writableFileStorageTier.D((WritePosition)a3, arg_0));
        });
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a10.D();
        stringArray[2] = "type";
        stringArray[3] = a10.D().name();
        a11.e = a6.gauge((MetricName)BaseMetricName.R, Tags.of((String[])stringArray), (Object)a11.A, synchronizer -> {
            WritableFileStorageTier a2 = synchronizer;
            WritableFileStorageTier a3 = this;
            return (double)a3.b.get() - (double)a2.D();
        });
    }

    /*
     * WARNING - void declaration
     */
    public void L(long l2) {
        void a22;
        WritableFileStorageTier writableFileStorageTier = this;
        if (!writableFileStorageTier.g.containsKey((long)a22)) {
            return;
        }
        if (a22 == ((Long)writableFileStorageTier.g.firstKey()).longValue()) {
            C.info(SubscriptionQueryDispatcher.D((Object)"l\"-\u007fQ0e<~1p\u007fy:o+7,r8z:y+7+x\u007fu:7<e:v+r;"), (Object)writableFileStorageTier.h);
            StorageProperties a22 = (StorageProperties)writableFileStorageTier.m.get();
            WritePosition writePosition2 = (WritePosition)writableFileStorageTier.f.getAndUpdate(writePosition -> {
                StorageProperties a2 = writePosition;
                StorageProperties a3 = a22;
                return a2.D(0, a3.getSegmentSize(), 0);
            });
            if (writePosition2.D(a22.getSegmentSize())) {
                C.debug(ClientConnectionInformation.D((Object)"\u001dc\\>%l\u0003\u007f\u0012w\byFp\u0003iFm\u0003y\u000b{\bjFe\u001b"), (Object)writableFileStorageTier.h, (Object)writePosition2.f);
                WritePosition writePosition3 = writePosition2;
                writePosition3.b.D(writePosition3.m, -1);
                WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier;
                WritableFileStorageTier a3 = writableFileStorageTier2.D(new FileVersion(writePosition2.f, 0), a22.getSegmentSize(), false);
                writableFileStorageTier.f.set(writePosition2.D((WritableEventSource)a3, 0));
                writableFileStorageTier2.A.D(new WritePosition(writePosition2.f, 0, 0, (WritableEventSource)a3, Long.valueOf(writePosition2.f), writePosition2.A));
            }
        }
        writableFileStorageTier.L();
    }

    public long A() {
        WritableFileStorageTier a3;
        return (Long)a3.D((T a2) -> a2.allSegments().findFirst().orElse(-1L), (Object)-1L);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(ProcessedEvent processedEvent, long l2, int n, Map<String, List<IndexEntry>> map) {
        WritableFileStorageTier a3 = processedEvent;
        WritableFileStorageTier a4 = this;
        if (a3.isDomainEvent()) {
            void a5;
            void a6;
            void a7;
            a7.computeIfAbsent(a3.getAggregateIdentifier(), a2 -> new ArrayList()).add(new IndexEntry(a3.getAggregateSequenceNumber(), (int)a6, (long)a5));
        }
    }

    private static /* synthetic */ Stream L(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    public void activateSegmentVersion(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        a4.D(arg_0 -> WritableFileStorageTier.D((long)a2, a3, arg_0));
    }

    private static /* synthetic */ Boolean D(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.removeSegment(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FileVersion D(long l2, File file, FileVersion fileVersion, StorageProperties storageProperties) {
        void a2;
        void a3;
        WritableFileStorageTier a4;
        void a5;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = storageProperties;
        WritableFileStorageTier a6 = writableFileStorageTier;
        return Arrays.stream(FileUtils.D((File)a5, (String)a4.getEventsSuffix())).map(FileUtils::D).filter(arg_0 -> WritableFileStorageTier.D((long)a3, arg_0)).max(FileVersion::D).orElse((FileVersion)a2);
    }

    public void handover(Segment segment, Runnable runnable) {
        Runnable a2 = runnable;
        WritableFileStorageTier a3 = this;
        a2.run();
    }

    private static /* synthetic */ Flux D(String string, StorageTier storageTier) {
        String a2 = storageTier;
        String a3 = string;
        return a2.fileVersions(a3);
    }

    public SortedSet<Long> getSegments() {
        WritableFileStorageTier a2;
        return a2.g.keySet();
    }

    private static /* synthetic */ Integer D(Long l2, StorageTier storageTier) {
        Long a2 = storageTier;
        Long a3 = l2;
        return a2.currentSegmentVersion(a3);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ WritePosition D(int n, int n2, int n3, WritePosition writePosition) {
        void a2;
        void a3;
        WritePosition a4 = writePosition;
        int a5 = n;
        return a4.D(a5, (int)a3, (int)a2);
    }

    public void initSegments(long a2) {
    }

    private static /* synthetic */ Optional D(long a2, StorageTier a3) {
        return a3.eventSource(a2);
    }

    protected Optional<EventSource> D(long a2) {
        WritableFileStorageTier a3;
        if (a3.g.containsKey(a2)) {
            return Optional.of((EventSource)a3.g.get(a2));
        }
        return Optional.empty();
    }

    public long size() {
        WritableFileStorageTier a3;
        return a3.g.values().stream().mapToLong(a2 -> a2.K.capacity()).sum() + (Long)a3.D(StorageTier::size, (Object)0L);
    }

    private /* synthetic */ void D() {
        WritableFileStorageTier writableFileStorageTier = this;
        Object a2 = writableFileStorageTier.segmentsWithoutIndex();
        if (a2.size() > 0) {
            writableFileStorageTier.D((SortedSet)a2);
        }
        C.info(ClientConnectionInformation.D((Object)"\u001dc\\>/p\u0002{\u001e>\tpFz\u000fm\r>\u000fmFk\u0016>\u0012qFz\u0007j\u0003"), (Object)writableFileStorageTier.h);
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.D((long)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.D(arg_0 -> WritableFileStorageTier.D((long)a2, arg_0), Optional.empty());
    }

    private /* synthetic */ int D(List<ProcessedEvent> list) {
        Object a2 = list;
        WritableFileStorageTier a3 = this;
        long l2 = 0L;
        Object object = a2 = a2.iterator();
        while (object.hasNext()) {
            ProcessedEvent processedEvent = (ProcessedEvent)a2.next();
            l2 += (long)(4 + processedEvent.getSerializedSize());
            object = a2;
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, a3.h + ": Transaction size exceeds maximum size");
        }
        return (int)l2;
    }

    private static /* synthetic */ Stream D(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    public Integer currentSegmentVersion(Long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.g.get(a2);
        if (a3 != null) {
            return a3.D();
        }
        return (Integer)writableFileStorageTier.D(arg_0 -> WritableFileStorageTier.D((Long)a2, arg_0), (Object)0);
    }

    public int D() {
        WritableFileStorageTier a2;
        return a2.g.size();
    }

    protected Optional<EventSource> D(FileVersion fileVersion) {
        WritableFileStorageTier a2 = fileVersion;
        WritableFileStorageTier a3 = this;
        return a3.D(a2.D());
    }

    private static /* synthetic */ void D(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        a3.activateSegmentVersion(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(long l2, File file, long l3, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        int n;
        WritableFileStorageTier a3;
        HashMap<String, List> a222;
        WritableEventSource a4;
        FileVersion a5;
        long a6;
        WritableFileStorageTier writableFileStorageTier2;
        block10: {
            block8: {
                void a222;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier2 = this;
                a5 = writableFileStorageTier3.D(a6, (File)a5, new FileVersion((long)a222, 0), (StorageProperties)a4);
                writableFileStorageTier3.D(a5.D());
                a5 = writableFileStorageTier3.D(a5, (StorageProperties)a4);
                writableFileStorageTier3.D((T storageTier) -> {
                    FileVersion a2 = storageTier;
                    FileVersion a3 = a5;
                    a2.initSegments(a3.D());
                });
                WritableFileStorageTier writableFileStorageTier4 = writableFileStorageTier2;
                writableFileStorageTier4.D();
                a4 = writableFileStorageTier4.D(a5, a4.getSegmentSize(), false);
                writableFileStorageTier4.H.remove(a5);
                a6 = a5.D();
                a222 = new HashMap<String, List>();
                a3 = a4.createEventIterator();
                try {
                    WritableFileStorageTier writableFileStorageTier5 = a3;
                    while (writableFileStorageTier5.hasNext()) {
                        EventInformation eventInformation = a3.D();
                        if (eventInformation.D()) {
                            IndexEntry indexEntry = new IndexEntry(eventInformation.D().getAggregateSequenceNumber(), eventInformation.D(), a6);
                            a222.computeIfAbsent(eventInformation.D().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                        }
                        ++a6;
                        writableFileStorageTier5 = a3;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (a3 != null) {
                            try {
                                a3.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                n = a3.D();
                writableFileStorageTier2.b.set(a6 - 1L);
                if (a3 == null) break block8;
                writableFileStorageTier = writableFileStorageTier2;
                a3.close();
                break block10;
            }
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.H.addToActiveSegment(Long.valueOf(a5.D()), a222);
        a4.D(n, 0);
        a3 = new WritePosition(a6, n, a5.D(), a4, Long.valueOf(a5.D()), 0);
        WritableFileStorageTier writableFileStorageTier6 = writableFileStorageTier2;
        writableFileStorageTier6.f.set(a3);
        writableFileStorageTier6.A.L((WritePosition)a3);
        C.info(SubscriptionQueryDispatcher.D((Object)"l\"-\u007fD:p2r1c,76y6c6v3~%r;"), (Object)writableFileStorageTier2.h);
    }

    public long L() {
        WritableFileStorageTier a2;
        return a2.b.get();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(long l2, Integer n) {
        void a2;
        Integer a3 = n;
        WritableFileStorageTier a4 = this;
        a4.D((long)a2, a3.intValue());
    }

    public SortedSet<FileVersion> segmentsWithoutIndex() {
        WritableFileStorageTier a2;
        return (SortedSet)a2.D(StorageTier::segmentsWithoutIndex, Collections.emptySortedSet());
    }

    public long D() {
        WritableFileStorageTier a2;
        return ((WritePosition)a2.f.get()).f;
    }

    /*
     * WARNING - void declaration
     */
    public Stream<String> D(long l2, int n, boolean bl) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        if (a3 != false) {
            return Stream.concat(a5.g.entrySet().stream().map(entry -> {
                Map.Entry a2 = entry;
                Object a3 = this;
                return FileUtils.D((File)a3.D(new FileVersion(((Long)a2.getKey()).longValue(), ((ByteBufferEventSource)a2.getValue()).D())));
            }), (Stream)a5.D(arg_0 -> WritableFileStorageTier.D((long)a2, a4, arg_0), Stream.empty()));
        }
        return (Stream)a5.D(arg_0 -> WritableFileStorageTier.L((long)a2, a4, arg_0), Stream.empty());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(Map map, ProcessedEvent processedEvent, long l2, int n) {
        void a2;
        void a3;
        void a4;
        void a5;
        int n2 = n;
        WritableFileStorageTier a6 = this;
        a6.D((ProcessedEvent)a5, (long)a4, (int)a3, (Map)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(WritePosition writePosition, List<ProcessedEvent> list, Map<String, List<IndexEntry>> map) {
        void a2;
        void a3;
        WritableFileStorageTier a4 = writePosition;
        WritableFileStorageTier a5 = this;
        WritableFileStorageTier writableFileStorageTier = a4;
        a4.b.D((List)a3, writableFileStorageTier.m, writableFileStorageTier.f, (arg_0, arg_1, arg_2) -> a5.D((Map)a2, arg_0, arg_1, arg_2));
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeSegment(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        if (a4.g.containsKey((long)a2)) {
            return a4.D((long)a2, a3);
        }
        return (Boolean)a4.D(arg_0 -> WritableFileStorageTier.D((long)a2, a3, arg_0), (Object)true);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    protected WritableEventSource D(FileVersion fileVersion, int n, boolean bl) {
        WritableEventSource a2322;
        Object a32222;
        Object object;
        void a4;
        WritableFileStorageTier writableFileStorageTier;
        block21: {
            void a223322;
            writableFileStorageTier = this;
            StorageProperties storageProperties = (StorageProperties)writableFileStorageTier.m.get();
            File file = storageProperties.dataFile(writableFileStorageTier.E, (FileVersion)a4);
            int n2 = Math.max(storageProperties.getSegmentSize(), (int)a223322);
            if (file.exists()) {
                void a2322;
                if (a2322 != false && file.length() < (long)a223322) {
                    object = (ByteBufferEventSource)writableFileStorageTier.g.remove(a4.D());
                    if (object != null) {
                        object.D(0L);
                    }
                    FileUtils.D((File)file);
                } else {
                    n2 = (int)file.length();
                }
            } else if (a4.D() > 0) {
                object = storageProperties.dataFile(writableFileStorageTier.E, new FileVersion(a4.D(), 0));
                if (((File)object).exists()) {
                    a32222 = (ByteBufferEventSource)writableFileStorageTier.g.remove(a4.D());
                    if (a32222 != null) {
                        a32222.D(0L);
                    }
                    FileUtils.D((File)object);
                }
            }
            object = new RandomAccessFile(file, SubscriptionQueryDispatcher.D((Object)"e("));
            a32222 = ((RandomAccessFile)object).getChannel();
            C.info(ClientConnectionInformation.D((Object)"\u001dc\\>)n\u0003p\u000fp\u0001>\u0000w\n{Fe\u001b"), (Object)writableFileStorageTier.h, (Object)file);
            MappedByteBuffer mappedByteBuffer = ((FileChannel)a32222).map(FileChannel.MapMode.READ_WRITE, 0L, n2);
            mappedByteBuffer.put((byte)2);
            mappedByteBuffer.putInt(storageProperties.getFlags());
            WritableEventSource a223322 = new WritableEventSource(file.getAbsolutePath(), (ByteBuffer)mappedByteBuffer, a4.D(), a4.D(), writableFileStorageTier.l, storageProperties);
            writableFileStorageTier.g.put(a4.D(), a223322);
            a2322 = a223322;
            if (a32222 == null) break block21;
            ((AbstractInterruptibleChannel)a32222).close();
        }
        ((RandomAccessFile)object).close();
        return a2322;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Throwable throwable2;
                        block22: {
                            if (a32222 != null) {
                                try {
                                    ((AbstractInterruptibleChannel)a32222).close();
                                    throwable2 = throwable;
                                    break block22;
                                }
                                catch (Throwable a223322) {
                                    throwable.addSuppressed(a223322);
                                }
                            }
                            throwable2 = throwable;
                        }
                        throw throwable2;
                    }
                    catch (Throwable a32222) {
                        Throwable throwable3;
                        try {
                            ((RandomAccessFile)object).close();
                            throwable3 = a32222;
                        }
                        catch (Throwable throwable4) {
                            Throwable throwable5 = a32222;
                            throwable3 = throwable5;
                            throwable5.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Exception exception) {
                    throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, writableFileStorageTier.h + ": Failed to create segment: " + (FileVersion)a4, (Throwable)exception);
                }
            }
        }
    }

    private /* synthetic */ String D() {
        WritableFileStorageTier a2;
        WritableFileStorageTier writableFileStorageTier = a2;
        return writableFileStorageTier.h + "-" + writableFileStorageTier.h.D().name().toLowerCase();
    }

    public long D(List<Event> list, int n) {
        FilePreparedTransaction a2;
        WritableFileStorageTier a3;
        int a222 = n;
        WritableFileStorageTier writableFileStorageTier = a3 = this;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.F.checkFreeSpace(writableFileStorageTier2.m);
        HashMap hashMap = new HashMap();
        a2 = writableFileStorageTier.D((List)a2, a222);
        WritePosition a222 = a2.D();
        writableFileStorageTier2.D(a222, a2.D(), hashMap);
        writableFileStorageTier.H.addToActiveSegment(a222.g, hashMap);
        writableFileStorageTier.b.set(a222.f + (long)a2.D().size() - 1L);
        writableFileStorageTier.A.D(a222);
        return a222.f;
    }
}

