/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.tags.ClientTagsUpdate;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.message.query.subscription.DirectSubscriptionQueries;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="QueryCache")
public class QueryCache
implements NonReplacingConstraintCache<String, ActiveQuery> {
    private final int m = 25000;
    private final long A;
    private final Map<String, ActiveQuery> f;
    private final Logger K;
    private final long e;

    public Set<Map.Entry<String, ActiveQuery>> timedOut() {
        QueryCache a4;
        long l2 = System.currentTimeMillis() - a4.e;
        return a4.entrySet().stream().filter(a3 -> {
            if (((ActiveQuery)a3.getValue()).D() < l2) {
                return true;
            }
            return false;
        }).filter(a2 -> {
            if (!((ActiveQuery)a2.getValue()).L()) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
    }

    public int size() {
        QueryCache a2;
        return a2.f.size();
    }

    public QueryCache(@Value(value="${axoniq.axonserver.default-query-timeout:300000}") long defaultQueryTimeout, @Value(value="${axoniq.axonserver.query-cache-capacity:0}") long a2) {
        QueryCache queryCache = this;
        QueryCache queryCache2 = this;
        queryCache2.K = LoggerFactory.getLogger(QueryCache.class);
        queryCache2.m = 25000;
        QueryCache queryCache3 = this;
        queryCache.f = new ConcurrentHashMap();
        queryCache.e = defaultQueryTimeout;
        if (a2 > 0L) {
            this.A = a2;
            return;
        }
        defaultQueryTimeout = DataSize.ofBytes((long)Runtime.getRuntime().maxMemory()).toGigabytes();
        this.A = defaultQueryTimeout > 0L ? 25000L * defaultQueryTimeout : 25000L;
    }

    private /* synthetic */ void D() {
        QueryCache a2;
        if ((long)a2.f.size() >= a2.A) {
            throw new InsufficientBufferCapacityException("Query buffer is full (" + a2.A + "/" + a2.A + ") Query handlers might be slow. Try increasing 'axoniq.axonserver.query-cache-capacity' property.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(ActiveQuery activeQuery, String string) {
        void a2;
        Object a3 = string;
        QueryCache a4 = this;
        a4.K.debug(DirectSubscriptionQueries.D((Object)"\u0002>,!-454a 443(a*<q'>3q0$$#8q)0/5-43q(5$?58'8$5a38q\"=(4/%\u0012%34 <\b5a*<\u007f"), (Object)a2.A(), a3);
        if (a2.A((String)a3)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a3;
            if (a2.D((String)a3, ErrorCode.CONNECTION_TO_HANDLER_LOST, String.format(ClientTagsUpdate.D((Object)"$ \t!\u0002,\u0013&\b!G;\bo\u000f.\t+\u000b*\u0015oB<G#\b<\u0013"), objectArray))) {
                a4.remove(a2.A());
            }
        }
    }

    public ActiveQuery get(String string) {
        Object a2 = string;
        QueryCache a3 = this;
        return (ActiveQuery)a3.f.get(a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected, String string, ActiveQuery activeQuery) {
        void a2;
        QueryCache a3 = activeQuery;
        QueryCache a4 = this;
        a4.D((ActiveQuery)a3, a2.A());
    }

    public Collection<Map.Entry<String, ActiveQuery>> entrySet() {
        QueryCache a2;
        return a2.f.entrySet();
    }

    /*
     * WARNING - void declaration
     */
    public ActiveQuery putIfAbsent(String string, ActiveQuery activeQuery) {
        void a2;
        QueryCache a3;
        QueryCache a4 = activeQuery;
        QueryCache queryCache = a3 = this;
        queryCache.D();
        return (ActiveQuery)queryCache.f.putIfAbsent(a2, a4);
    }

    @EventListener
    public void on(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected) {
        QueryCache a2 = queryHandlerDisconnected;
        QueryCache a3 = this;
        a3.f.forEach((arg_0, arg_1) -> a3.D((TopologyEvents.QueryHandlerDisconnected)a2, arg_0, arg_1));
    }

    public ActiveQuery remove(String string) {
        QueryCache a2;
        Object a3 = string;
        QueryCache queryCache = a2 = this;
        queryCache.K.debug(ClientTagsUpdate.D((Object)"5*\n \u0011*G\"\u0002<\u0014.\u0000*.+G4\u001a"), a3);
        return (ActiveQuery)queryCache.f.remove(a3);
    }

    public boolean isEmpty() {
        QueryCache a2;
        return a2.f.isEmpty();
    }
}

