/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.ProcessingInstructionHelper;
import io.axoniq.axonserver.config.ReplicationGroupConfiguration;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.SerializedQuery;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.interceptor.DefaultExecutionContext;
import io.axoniq.axonserver.interceptor.QueryInterceptors;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.DispatchQueueMetrics;
import io.axoniq.axonserver.message.FlowControlQueues;
import io.axoniq.axonserver.message.QueueMetrics;
import io.axoniq.axonserver.message.SubscriptionKey;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.message.query.QueryDefinition;
import io.axoniq.axonserver.message.query.QueryHandler;
import io.axoniq.axonserver.message.query.QueryInstruction;
import io.axoniq.axonserver.message.query.QueryMetricsRegistry;
import io.axoniq.axonserver.message.query.QueryRegistrationCache;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.plugin.ExecutionContext;
import io.axoniq.axonserver.util.ConstraintCache;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import io.axoniq.axonserver.util.StringUtils;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="QueryDispatcher")
public class QueryDispatcher {
    private final QueryRegistrationCache b;
    private final NonReplacingConstraintCache<String, ActiveQuery> l;
    private final QueryInterceptors g;
    private final Map<String, AtomicInteger> m;
    private final Logger A;
    private final FlowControlQueues<QueryInstruction> f;
    private final DispatchQueueMetrics K;
    private final QueryMetricsRegistry e;

    /*
     * WARNING - void declaration
     */
    public void dispatchProxied(SerializedQuery serializedQuery, Consumer<QueryResponse> consumer, Consumer<String> consumer2, boolean bl) {
        void a22;
        void a3;
        void a4;
        void a322;
        QueryDispatcher queryDispatcher = this;
        void v0 = a322;
        QueryRequest queryRequest = v0.query();
        String string = v0.context();
        Object a5 = v0.clientStreamId();
        if ((string = queryDispatcher.b.find(string, queryRequest, (String)a5)) == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a5;
            objectArray[1] = queryRequest.getQuery();
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.CLIENT_DISCONNECTED.getCode()).setRequestIdentifier(queryRequest.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.D((String)String.format(ReplicationGroupConfiguration.D((Object)"E1o8h)&xu}h2r}`2s3b}q5o1c}v/i>c.u4h:<}#."), objectArray))).build());
            a3.accept(a5);
            return;
        }
        a5 = queryDispatcher.D(queryRequest.getMessageIdentifier(), a322.clientStreamId());
        ActiveQuery a22 = new ActiveQuery((String)a5, (SerializedQuery)a322, false, (Consumer)a4, (Consumer)a3, Collections.singleton(string), a22 != false && queryDispatcher.D(queryRequest));
        try {
            if (queryDispatcher.l.putIfAbsent(a5, (Object)a22) != null) {
                a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a322.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.D((String)SubscriptionKey.D((Object)"S\u0016g\u0011{Cu\nv\u000b\"\u0010w\u0013r\u000fk\u0006fCK'\"\u0002n\u0011g\u0002f\u001a\"\u0013p\u0006q\u0006l\u0017"))).build());
                a3.accept(ReplicationGroupConfiguration.D((Object)"\u0019s-j4e<r8O9"));
                return;
            }
            queryDispatcher.D((String)a5, a22);
            return;
        }
        catch (InsufficientBufferCapacityException a322) {
            a22.D(string.A(), ErrorCode.QUERY_DISPATCH_ERROR, a322.getMessage());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(String string, ActiveQuery activeQuery) {
        void a2;
        QueryDispatcher queryDispatcher = this;
        try {
            queryDispatcher.A.trace(SubscriptionKey.D((Object)"'k\u0010r\u0002v\u0000j\nl\u0004\"\u0012w\u0006p\u001a\"\u0018\u007fM,M"), (Object)a2.A());
            a2.D();
            return;
        }
        catch (MessagingPlatformException a3) {
            void a4;
            QueryDispatcher queryDispatcher2 = queryDispatcher;
            queryDispatcher2.A.debug(ReplicationGroupConfiguration.D((Object)"C/t2t}b(t4h:&9o.v<r>n4h:&2`}w(c/\u007f}} (}E<h>c1j4h:&*o)n}c/t2ts"), (Object)a2.A(), (Object)a3);
            a2.D(a3.getErrorCode(), a3.getMessage());
            queryDispatcher2.l.remove((Object)a4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleComplete(String string, String string2, String string3) {
        void a2;
        void a3;
        QueryDispatcher queryDispatcher = this;
        QueryDispatcher a4 = queryDispatcher.D((String)a3, (String)a2);
        if (a4 != null) {
            if (a4.L((String)a3)) {
                queryDispatcher.l.remove((Object)a4.A());
            }
            long l2 = System.currentTimeMillis() - a4.D();
            if (a4.D()) {
                void a5;
                queryDispatcher.e.addHandlerResponseTime(a4.D(), a4.L(), (String)a5, a4.D(), l2);
                return;
            }
        } else {
            queryDispatcher.A.debug(ReplicationGroupConfiguration.D((Object)"\u0013i}.0i/ct&4h;i/k<r4i3&;i/&&{}i3&>i0v1c)c9"), (Object)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(Consumer consumer, String string, String string2) {
        void a2;
        void a3;
        Object a4 = string2;
        QueryDispatcher a5 = this;
        a3.accept(a4);
        ((AtomicInteger)a5.m.get(a2)).decrementAndGet();
    }

    public MeterFactory.RateMeter queryRate(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        return a3.e.rateMeter((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(DefaultExecutionContext defaultExecutionContext, QueryResponse queryResponse, Consumer<QueryResponse> consumer) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher queryDispatcher = this;
        try {
            a4.accept(queryDispatcher.g.queryResponse((QueryResponse)a3, (ExecutionContext)a2));
            return;
        }
        catch (Exception a5) {
            queryDispatcher.A.warn(SubscriptionKey.D((Object)"\u0018\u007fY\"&z\u0000g\u0013v\nm\r\"\nlCp\u0006q\u0013m\rq\u0006\"\nl\u0017g\u0011a\u0006r\u0017m\u0011"), (Object)a2.contextName(), (Object)a5);
            Exception exception = a5;
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.EXCEPTION_IN_INTERCEPTOR.getCode()).setRequestIdentifier(a3.getRequestIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.D((String)exception.getMessage())).build());
            a2.compensate((Throwable)exception);
            return;
        }
    }

    private /* synthetic */ boolean D(QueryResponse queryResponse) {
        QueryDispatcher a2 = queryResponse;
        QueryDispatcher a3 = this;
        if (ErrorCode.NO_HANDLER_FOR_QUERY.getCode().equals(a2.getErrorCode()) || ErrorCode.TOO_MANY_REQUESTS.getCode().equals(a2.getErrorCode()) || ErrorCode.OTHER.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_REJECTED_BY_INTERCEPTOR.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_TIMEOUT.getCode().equals(a2.getErrorCode()) || ErrorCode.CONNECTION_TO_HANDLER_LOST.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_DUPLICATED.getCode().equals(a2.getErrorCode())) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(QueryHandler queryHandler, String string, String string2, long l2) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher a5 = queryHandler;
        QueryDispatcher a6 = this;
        void v0 = a4;
        a6.D((String)v0, a5.A(), () -> QueryDispatcher.D((QueryHandler)a5, (String)v0, (String)a3, (long)a2));
    }

    /*
     * WARNING - void declaration
     */
    public void completeWithError(String string, String string2, ErrorCode errorCode, String string3) {
        void a2;
        void a3;
        void a4;
        Object a5 = string;
        QueryDispatcher a6 = this;
        Object[] objectArray = new Object[4];
        objectArray[0] = a4;
        objectArray[1] = a5;
        objectArray[2] = a3.getCode();
        objectArray[3] = a2;
        a6.A.debug(SubscriptionKey.D((Object)" m\u000er\u000fg\u0017k\reCu\nv\u000b\"\u0006p\u0011m\u0011\"\u0017j\u0006\"\u0000m\u000eo\u0016l\na\u0002v\nm\r\"\u0014k\u0017jCcCq\u0013g\u0000k\u0005k\u0000\"\u000bc\rf\u000fg\u0011\"8a\u000fk\u0006l\u0017Q\u0017p\u0006c\u000eK\u0007?\u0018\u007f>.Cd\fpCv\u000bgCs\u0016g\u0011{CY\nf^y\u001e_M\"&p\u0011m\u0011\"\u0000m\u0007gY\"\u0018\u007fM\"&p\u0011m\u0011O\u0006q\u0010c\u0004gY\"\u0018\u007fM"), objectArray);
        ActiveQuery activeQuery = (ActiveQuery)a6.l.get(a5);
        if (activeQuery != null && activeQuery.D((String)a4, (ErrorCode)a3, (String)a2)) {
            a6.l.remove(a5);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void D(QueryHandler queryHandler, String string, String string2, long l2) {
        void a2;
        void a3;
        Object a4 = string2;
        QueryHandler a5 = queryHandler;
        a5.D((String)a3, (String)a4, (long)a2);
    }

    public FlowControlQueues<QueryInstruction> getQueryQueue() {
        QueryDispatcher a2;
        return a2.f;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Set<QueryHandler> D(String string, QueryRequest queryRequest) {
        void a2;
        QueryHandler queryHandler;
        void a3;
        QueryDispatcher queryDispatcher = this;
        Object a4 = ProcessingInstructionHelper.D((List)a3.getProcessingInstructionsList()) == 1 ? ((queryHandler = queryDispatcher.b.findOne((String)a2, (QueryRequest)a3)) == null ? Set.of() : Set.of(queryHandler)) : queryDispatcher.b.find((String)a2, (QueryRequest)a3);
        return a4;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(String string, String string2, long l2, QueryHandler queryHandler) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher a5;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryHandler;
        QueryDispatcher a6 = queryDispatcher;
        a6.L((QueryHandler)a5, (String)a4, (String)a3, (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void flowControl(String string, long l2) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        if ((a2 = (ActiveQuery)a3.l.get(a2)) != null) {
            void a4;
            a2.D().forEach(arg_0 -> a3.D((ActiveQuery)a2, (long)a4, arg_0));
        }
    }

    private /* synthetic */ boolean D(QueryRequest queryRequest) {
        QueryDispatcher a2 = queryRequest;
        QueryDispatcher a3 = this;
        return ProcessingInstructionHelper.D((List)a2.getProcessingInstructionsList());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(DefaultExecutionContext defaultExecutionContext, Consumer consumer, QueryResponse queryResponse) {
        void a2;
        void a3;
        QueryDispatcher a4 = queryResponse;
        QueryDispatcher a5 = this;
        a5.D((DefaultExecutionContext)a3, (QueryResponse)a4, (Consumer)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String D(String string, String string2) {
        void a2;
        Object a3 = string2;
        QueryDispatcher a4 = this;
        return (String)a2 + "/" + (String)a3;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(String string, String string2, Runnable runnable) {
        Runnable a22 = runnable;
        QueryDispatcher a3 = this;
        try {
            a22.run();
            return;
        }
        catch (MessagingPlatformException a22) {
            void a4;
            void a5;
            QueryDispatcher queryDispatcher = a3;
            queryDispatcher.A.debug(SubscriptionKey.D((Object)"G\u0011p\fpCf\nq\u0013c\u0017a\u000bk\reCd\u000fm\u0014\"\u0012w\u0006p\u001a\"\nl\u0010v\u0011w\u0000v\nm\r\"\u0017mCv\u0002p\u0004g\u0017\"\u0000n\ng\rvCy\u001e"), (Object)a5);
            queryDispatcher.completeWithError((String)a4, (String)a5, a22.getErrorCode(), a22.getMessage());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public QueryDispatcher(QueryRegistrationCache queryRegistrationCache, NonReplacingConstraintCache<String, ActiveQuery> nonReplacingConstraintCache, QueryMetricsRegistry queryMetricsRegistry, QueryInterceptors queryInterceptors, MeterFactory meterFactory, ClientIdRegistry clientIdRegistry, @Value(value="${axoniq.axonserver.query-queue-capacity-per-client:10000}") int n) {
        void a2;
        void clientIdRegistry2;
        void meterFactory2;
        void queryInterceptors2;
        void queryCache;
        void registrationCache;
        QueryDispatcher queryMetricsRegistry2;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryMetricsRegistry;
        QueryDispatcher queryDispatcher3 = queryMetricsRegistry2 = queryDispatcher;
        QueryDispatcher queryDispatcher4 = queryMetricsRegistry2;
        queryMetricsRegistry2.A = LoggerFactory.getLogger(QueryDispatcher.class);
        QueryDispatcher queryDispatcher5 = queryMetricsRegistry2;
        queryMetricsRegistry2.m = new ConcurrentHashMap();
        queryDispatcher4.b = registrationCache;
        queryDispatcher4.e = queryDispatcher2;
        queryDispatcher3.l = queryCache;
        queryDispatcher3.g = queryInterceptors2;
        QueryDispatcher queryDispatcher6 = queryMetricsRegistry2;
        queryDispatcher3.K = new DispatchQueueMetrics((MeterFactory)meterFactory2, (MetricName)BaseMetricName.la, (MetricName)BaseMetricName.q, (ClientIdRegistry)clientIdRegistry2);
        QueryDispatcher queryDispatcher7 = queryMetricsRegistry2;
        queryDispatcher6.f = new FlowControlQueues(Comparator.comparing(QueryInstruction::D).reversed(), (int)a2, (QueueMetrics)queryMetricsRegistry2.K, ErrorCode.TOO_MANY_REQUESTS);
        queryDispatcher2.gauge((MetricName)BaseMetricName.Da, (Object)queryCache, ConstraintCache::size);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(Consumer consumer, SerializedQuery serializedQuery, String string, QueryResponse queryResponse) {
        void a2;
        QueryDispatcher a3;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryResponse;
        QueryDispatcher a4 = queryDispatcher;
        QueryDispatcher queryDispatcher3 = a3;
        a2.accept(queryDispatcher3);
        if (a4.D((QueryResponse)queryDispatcher3)) {
            void a5;
            void a6;
            a4.e.error(a6.query().getQuery(), (String)a5, a3.getErrorCode());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ActiveQuery D(String string, String string2) {
        Object a2 = string2;
        QueryDispatcher a3 = this;
        ActiveQuery activeQuery = (ActiveQuery)a3.l.get(a2);
        if (activeQuery == null) {
            void a4;
            a2 = (String)a2 + "/" + (String)a4;
            activeQuery = (ActiveQuery)a3.l.get(a2);
        }
        return activeQuery;
    }

    public void deleteMetrics(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        a3.m.remove(a2);
        QueryDispatcher queryDispatcher = a3;
        queryDispatcher.e.remove((MetricName)BaseMetricName.B, (String)a2);
        queryDispatcher.e.removeForContext((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void flowControlProxied(String string, String string2, long l2, String string3, String string4) {
        void a2;
        void a3;
        void a4;
        void a5;
        Object a6 = string2;
        QueryDispatcher a7 = this;
        a7.D((String)a5, (String)a6, (String)a4, arg_0 -> a7.D((String)a3, (String)a6, (long)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(SerializedQuery serializedQuery, String string, Authentication authentication, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        Set set;
        QueryDispatcher a2;
        QueryDispatcher queryDispatcher;
        block5: {
            void a3;
            SerializedQuery serializedQuery2;
            void a4;
            Consumer<QueryResponse> consumer3;
            void a5;
            block4: {
                DefaultExecutionContext a6;
                void a7;
                queryDispatcher = this;
                a6 = new DefaultExecutionContext((String)a7, (Authentication)a6);
                consumer3 = arg_0 -> queryDispatcher.D(a6, (Consumer)a5, arg_0);
                try {
                    QueryDispatcher queryDispatcher2 = queryDispatcher;
                    serializedQuery2 = queryDispatcher2.g.queryRequest((SerializedQuery)a4, (ExecutionContext)a6);
                    a2 = serializedQuery2.query();
                    set = queryDispatcher2.D((String)a7, (QueryRequest)a2);
                    if (!set.isEmpty()) break block4;
                    consumer3.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.NO_HANDLER_FOR_QUERY.getCode()).setRequestIdentifier(a2.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.D((String)("No handler for query: " + a2.getQuery()))).build());
                    a3.accept(ReplicationGroupConfiguration.D((Object)"H2E1o8h)"));
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a7;
                    objectArray[1] = a4.query().getQuery();
                    objectArray[2] = exception;
                    queryDispatcher.A.warn(SubscriptionKey.D((Object)"\u0018\u007fY\"\u0005c\nn\u0006fCv\f\"\u0007k\u0010r\u0002v\u0000jCs\u0016g\u0011{Cy\u001e"), objectArray);
                    a2 = ErrorCode.fromException((Throwable)exception);
                    consumer3.accept(QueryResponse.newBuilder().setErrorCode(a2.getCode()).setRequestIdentifier(a4.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.D((String)StringUtils.getOrDefault((String)a2.getCode(), (String)exception.getClass().getName()))).build());
                    a3.accept(ReplicationGroupConfiguration.D((Object)"@<o1c9"));
                    a6.compensate((Throwable)exception);
                    return;
                }
            }
            set = new ActiveQuery(a2.getMessageIdentifier(), serializedQuery2, true, consumer3, (Consumer)a3, set, queryDispatcher.D((QueryRequest)a2));
            if (queryDispatcher.l.putIfAbsent((Object)a2.getMessageIdentifier(), (Object)set) == null) break block5;
            a5.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a4.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.D((String)SubscriptionKey.D((Object)"S\u0016g\u0011{Cu\nv\u000b\"\u0010w\u0013r\u000fk\u0006fCK'\"\u0002n\u0011g\u0002f\u001a\"\u0013p\u0006q\u0006l\u0017"))).build());
            a3.accept(ReplicationGroupConfiguration.D((Object)"\u0019s-j4e<r8O9"));
            return;
        }
        queryDispatcher.D(a2.getMessageIdentifier(), (ActiveQuery)set);
    }

    /*
     * WARNING - void declaration
     */
    public void cancelProxied(String string, String string2) {
        void a2;
        QueryDispatcher a3;
        Object a4 = string2;
        QueryDispatcher queryDispatcher = a3 = this;
        queryDispatcher.cancel(queryDispatcher.D((String)a2, (String)a4));
    }

    /*
     * WARNING - void declaration
     */
    public void query(SerializedQuery serializedQuery, Authentication authentication, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        void a2;
        Consumer<String> a3;
        Consumer<QueryResponse> a4;
        void a5;
        QueryDispatcher queryDispatcher = this;
        Object a6 = a5.context();
        a4 = arg_0 -> queryDispatcher.D(a4, (SerializedQuery)a5, (String)a6, arg_0);
        a3 = arg_0 -> queryDispatcher.D(a3, (String)a6, arg_0);
        QueryDispatcher queryDispatcher2 = queryDispatcher;
        queryDispatcher2.queryRate((String)a6).L();
        queryDispatcher2.m.computeIfAbsent(a6, string -> {
            void a2;
            QueryDispatcher queryDispatcher = this;
            Object a3 = new AtomicInteger();
            queryDispatcher.e.gauge((MetricName)BaseMetricName.B, Tags.of((String)"context", (String)a2), ((AtomicInteger)a3)::get);
            return a3;
        }).incrementAndGet();
        queryDispatcher.D((SerializedQuery)a5, (String)a6, (Authentication)a2, a4, a3);
    }

    /*
     * WARNING - void declaration
     */
    public void handleResponse(QueryResponse queryResponse, String string, String string2) {
        void a2;
        void a3;
        QueryDispatcher queryDispatcher = this;
        Object a4 = a3.getRequestIdentifier();
        if ((a4 = queryDispatcher.D((String)a2, (String)a4)) != null) {
            ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a4.D(), (String)a2);
            long l2 = System.currentTimeMillis() - a4.D();
            if (a4.D()) {
                void a5;
                queryDispatcher.e.addEndToEndResponseTime(a4.D(), a4.L(), (String)a5, clientStreamIdentification.D(), a4.L(), l2);
            }
            if (a4.D((QueryResponse)a3, (String)a2) && a4.L()) {
                a4.D((String)a2);
                return;
            }
        } else {
            queryDispatcher.A.debug(SubscriptionKey.D((Object)"L\f\"Ko\fp\u0006+Ck\rd\fp\u000ec\u0017k\flCd\fpCy\u001e"), (Object)a3.getRequestIdentifier());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(String string, String string2, String string3, Consumer<QueryHandler> consumer) {
        void a2;
        void a3;
        Object a4 = string;
        QueryDispatcher a5 = this;
        a4 = new QueryDefinition((String)a4, (String)a3);
        if ((a4 = a5.b.find((QueryDefinition)a4, (String)a2)) != null) {
            void a6;
            a6.accept(a4);
        }
    }

    public void cancel(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        if ((a2 = (ActiveQuery)a3.l.remove(a2)) != null) {
            a2.L();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(ActiveQuery activeQuery, long l2, QueryHandler queryHandler) {
        void a2;
        void a3;
        QueryDispatcher a4 = activeQuery;
        QueryDispatcher a5 = this;
        a5.L((QueryHandler)a3, a4.A(), a4.l(), (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void dispatchProxied(SerializedQuery serializedQuery, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        void a2;
        void a3;
        Object a4 = consumer2;
        QueryDispatcher a5 = this;
        a5.dispatchProxied((SerializedQuery)a3, (Consumer)a2, (Consumer)a4, true);
    }
}

