/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.component.tags.ClientTagsUpdate;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.ClusterRestController;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.axoniq.axonserver.transport.rest.EventStoreTransformationRestController;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin
@RestController(value="ClusterRestController")
@RequestMapping(value={"/v1/cluster"})
public class ClusterRestController {
    private static final Logger C;
    private final ClusterController L;
    public static final String F = "_none";
    private final ClusterTopology b;
    private final Predicate<String> l;
    private final ClusterTemplateController g;
    private final ApplicationEventPublisher m;
    private final DistributeLicenseService A;
    private final FeatureChecker f;
    private static final Logger K;
    private final RaftConfigServiceFactory e;

    static {
        K = AuditLog.getLogger();
        C = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }

    @PostMapping
    public ResponseEntity<RestResponse> D(@Valid @RequestBody ClusterJoinRequest clusterJoinRequest, @Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController;
        NodeInfo.Builder a2;
        ClusterRestController clusterRestController2 = clusterRestController3;
        ClusterRestController clusterRestController3 = clusterJoinRequest;
        ClusterRestController jsonClusterNode = clusterRestController2;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = clusterRestController3.getInternalHostName();
        objectArray[2] = clusterRestController3.internalGrpcPort;
        K.info(EventStoreTransformationRestController.D((Object)"D\"b\u0004?\u000bz(j<l-?-pyu6v7?:s,l-z+?8kyd$%\"bw"), objectArray);
        a2 = NodeInfo.newBuilder((NodeInfo)jsonClusterNode.L.getMe().toNodeInfo());
        String string = clusterRestController3.getContext();
        if (string != null && !string.isEmpty()) {
            if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, ClientTagsUpdate.D((Object)"$.\t!\b;G,\b\"\u0005&\t*G%\b&\t&\t(G,\b!\u0013*\u001f;G8\u000e;\u000fo\t $ \t;\u00027\u0013<I"));
            }
            if (!RaftAdminGroup.D((String)string) && !jsonClusterNode.l.test(string)) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
            }
            C.debug(EventStoreTransformationRestController.D((Object)"~={q6c?\u000bz>v*k<m0q>?4f*z5yy~7{y~={0q>?4zyk6?:p7k<g-?{d$=w"), (Object)string);
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName(string).build());
        } else if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
            C.debug(ClientTagsUpdate.D((Object)"\u0006+\u0003gNuG\u001d\u0002(\u000e<\u0013*\u0015&\t(G\"\u001e<\u0002#\u0001o\u0006!\u0003o\u0006+\u0003&\t(G\"\u0002o\u0013 G!\bo\u0004 \t;\u00027\u0013<I"));
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName("_none").build());
        } else {
            C.debug(EventStoreTransformationRestController.D((Object)"~={q6c?\u000bz>v*k<m0q>?4f*z5yy~7{y~={0q>?4zyk6?8s5?:p7k<g-lw"));
            clusterRestController = jsonClusterNode;
        }
        if (clusterRestController.L.nodes().count() > 1L) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new RestResponse(false, ClientTagsUpdate.D((Object)"\u0001\b+\u0002o\u0006#\u0015*\u0006+\u001eo\u0015*\u0000&\u0014;\u0002=\u0002+G&\to\u0006o\u0004#\u0012<\u0013*\u0015")));
        }
        try {
            ClusterRestController clusterRestController4 = jsonClusterNode;
            ClusterRestController clusterRestController5 = clusterRestController3;
            clusterRestController3 = clusterRestController4.e.getRaftConfigServiceStub(clusterRestController5.internalHostName, clusterRestController5.internalGrpcPort.intValue()).joinCluster(a2.build());
            clusterRestController4.m.publishEvent((Object)new ClusterEvents.LicenseUpdated(clusterRestController3.getLicense().toByteArray()));
            return ResponseEntity.accepted().body((Object)new RestResponse(true, EventStoreTransformationRestController.D((Object)"^:|<o-z=?3p0qym<n,z*ku?4~ ?-~2zy~yh1v5zyk6?)m6|<l*")));
        }
        catch (Exception this2) {
            return new RestResponse(false, this2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)this2));
        }
    }

    @GetMapping(value={"/download-template"})
    @ResponseBody
    public void D(HttpServletResponse httpServletResponse, @Parameter(hidden=true) Principal principal) throws IOException {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        K.info(ClientTagsUpdate.D((Object)"<4\u001a\u0012G\u001d\u0002>\u0012*\u0014;G,\u000b:\u0014;\u0002=G;\u0002\"\u0017#\u0006;\u0002o\u0003 \u0010!\u000b \u0006+I"), (Object)AuditLog.username((Principal)object));
        if (a2.b.isAdminNode()) {
            ServletOutputStream resp;
            object = EventStoreTransformationRestController.D((Object)"|5j*k<mtk<r)s8k<1 r5");
            String string = a2.g.buildYamlTemplate();
            void v1 = resp;
            resp = v1.getOutputStream();
            v1.setContentType(ClientTagsUpdate.D((Object)"\u0013*\u001f;H?\u000b.\u000e!\\o\u0004'\u0006=\u0014*\u0013r\u0012;\u0001b_"));
            v1.addHeader(EventStoreTransformationRestController.D((Object)"\u001ap7k<q-2\u001dv*o6l0k0p7"), "attachment; filename=\"" + (String)object + "\"");
            ServletOutputStream servletOutputStream = resp;
            servletOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            servletOutputStream.flush();
            servletOutputStream.close();
            return;
        }
        throw new RuntimeException(ClientTagsUpdate.D((Object)"> \u0012o\u0004.\to\u0012<\u0002o\u0013'\u000e<G)\u0012!\u0004;\u000e \t.\u000b&\u00136G \t#\u001eo\u0001=\b\"G.\u0003\"\u000e!G!\b+\u0002"));
    }

    /*
     * WARNING - void declaration
     */
    public ClusterRestController(ClusterController clusterController, RaftConfigServiceFactory raftConfigServiceFactory, FeatureChecker featureChecker, DistributeLicenseService distributeLicenseService, ApplicationEventPublisher applicationEventPublisher, ClusterTopology clusterTopology, ClusterTemplateController clusterTemplateController) {
        ClusterRestController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        ClusterRestController a9;
        ClusterRestController clusterRestController = clusterRestController2;
        ClusterRestController clusterRestController2 = clusterTemplateController;
        ClusterRestController clusterRestController3 = a9 = clusterRestController;
        ClusterRestController clusterRestController4 = a9;
        ClusterRestController clusterRestController5 = a9;
        ClusterRestController clusterRestController6 = a9;
        a9.l = new ContextNameValidation();
        a9.L = a8;
        clusterRestController5.e = a7;
        clusterRestController5.f = a6;
        clusterRestController4.A = a5;
        clusterRestController4.m = a4;
        clusterRestController3.b = a3;
        clusterRestController3.g = a2;
    }

    @GetMapping(path={"{name}"})
    public JsonClusterNode D(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        ClusterNode a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        K.info(ClientTagsUpdate.D((Object)"<4\u001a\u0012G\u001d\u0002>\u0012*\u0014;G!\b+\u0002o\u0003*\u0013.\u000e#\u0014o\u0001 \u0015o\u001c2I"), (Object)AuditLog.username((Principal)a2), object);
        a2 = name.L.getNode((String)object);
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, "Node " + (String)object + " not found");
        }
        return JsonClusterNode.from((ClusterNode)a2, (boolean)name.L.isActive((String)object));
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/upload-license"})
    public void D(@RequestParam(value="licenseFile") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        void a2;
        ClusterRestController clusterRestController = this;
        K.info(EventStoreTransformationRestController.D((Object)"D\"b\u0004?\u000bz(j<l-?5v:z7l<?,o=~-zw"), (Object)AuditLog.username((Principal)a2));
        C.info(ClientTagsUpdate.D((Object)"\u0001\u00028G#\u000e,\u0002!\u0014*G:\u0017#\b.\u0003*\u0003cG?\u0002=\u0001 \u0015\"\u000e!\u0000o\u000b&\u0004*\t<\u0002o\u0012?\u0003.\u0013*IaI"));
        try {
            void licenseFile;
            clusterRestController.A.distributeLicense(licenseFile.getBytes());
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            if (ErrorCode.NO_LEADER_AVAILABLE.equals((Object)messagingPlatformException.getErrorCode())) {
                throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, EventStoreTransformationRestController.D((Object)"\u0017pys<~=z+??p+?\u0006~=r0qw?\u001cq*j+zyk1~-?-w<?\u0006~=r0qym<o5v:~-v6qyx+p,oyv*?:m<~-z=?;z?p+zyj)s6~=v7xy~ys0|<q*zw"));
            }
            throw messagingPlatformException;
        }
        catch (LicenseException messagingPlatformException) {
            throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, messagingPlatformException.getMessage());
        }
    }

    @GetMapping
    public List<JsonClusterNode> D(@Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        K.info(EventStoreTransformationRestController.D((Object)"\u0002d$ByM<n,z*kyk6?5v*kyq6{<lw"), (Object)AuditLog.username((Principal)object));
        return a2.L.nodes().map(clusterNode -> {
            ClusterRestController a2 = clusterNode;
            ClusterRestController a3 = this;
            ClusterRestController clusterRestController = a2;
            return JsonClusterNode.from((ClusterNode)clusterRestController, (boolean)a3.L.isActive(clusterRestController.getName()));
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"{name}"})
    public void D(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        K.info(ClientTagsUpdate.D((Object)"<4\u001a\u0012G\u001d\u0002>\u0012*\u0014;G;\bo\u0003*\u000b*\u0013*G!\b+\u0002o\u001c2I"), (Object)AuditLog.username((Principal)a2), object);
        name.e.getRaftConfigService().deleteNode((String)object);
    }
}

