/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.ReplicationGroupConfiguration;
import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.plugin.PluginController;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.plugin.SimplePluginKey;
import io.axoniq.axonserver.rest.PluginConfigurationJSON;
import io.axoniq.axonserver.rest.PluginPropertyGroup;
import io.axoniq.axonserver.util.SerializedObjectMapper;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"v1/plugins"})
@CrossOrigin
public class PluginsRestController {
    public static final String g = "Plugins disabled";
    private final FeatureChecker m;
    private final Logger A;
    private final PluginController f;
    private static final Logger K = AuditLog.getLogger();
    private final boolean e;

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"configuration"})
    public Iterable<PluginPropertyGroup> D(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = this;
        if (!pluginsRestController.e || !pluginsRestController.m.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, g);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        K.info(ReplicationGroupConfiguration.D((Object)"\u0006} [}T8w(c.r}`2t}e2h;o:s/g)o2h}i;&&{r} (}"), objectArray);
        try {
            void context;
            return pluginsRestController.f.listProperties((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = name;
            objectArray2[1] = version;
            objectArray2[2] = runtimeException;
            pluginsRestController.A.warn(SerializedObjectMapper.D((Object)"\\\u000es\u0003\u007f\u000b:\u001buOh\nn\u001ds\nl\n:\u001fh\u0000j\nh\u001bs\niO|\u0000hOa\u0012 \u0014g"), objectArray2);
            throw runtimeException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping
    public void D(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @Parameter(hidden=true) Principal principal) {
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string2;
        PluginsRestController version = pluginsRestController;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)object);
        K.info(SerializedObjectMapper.D((Object)"4a\u0012GOH\nk\u001a\u007f\u001cnOn\u0000:\u001at\u0006t\u001cn\u000ev\u0003:\u001fv\u001a}\u0006tOa\u00125\u0014gA:"), objectArray);
        version.f.uninstallPlugin((PluginKey)new SimplePluginKey((String)name, (String)object));
    }

    private /* synthetic */ String D(String string) {
        String a2 = string;
        PluginsRestController a3 = this;
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.OTHER, SerializedObjectMapper.D((Object)"!uOj\u0003o\bs\u0001:\u001f{\fq\u000e}\n:\u001fh\u0000l\u0006~\n~"));
        }
        if (a2.contains(File.separator)) {
            throw new MessagingPlatformException(ErrorCode.OTHER, ReplicationGroupConfiguration.D((Object)"\u001bo1c3g0c}u5i(j9&3i)&>i3r<o3&9o/c>r2t$&.c-g/g)i/"));
        }
        int n = a2.lastIndexOf(46);
        if (n > 0) {
            return a2.substring(0, n) + "-" + System.currentTimeMillis() + a2.substring(n);
        }
        return (String)a2 + "-" + System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"configuration"})
    public void D(@RequestBody PluginConfigurationJSON pluginConfigurationJSON, @Parameter(hidden=true) Principal principal) {
        void a2;
        PluginsRestController pluginsRestController = pluginsRestController2;
        PluginsRestController pluginsRestController2 = pluginConfigurationJSON;
        PluginsRestController configurationJSON = pluginsRestController;
        if (!configurationJSON.e || !configurationJSON.m.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, g);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)pluginsRestController2.getName());
        objectArray[2] = StringUtils.sanitize((String)pluginsRestController2.getVersion());
        K.info(SerializedObjectMapper.D((Object)"A\u0014g2:=\u007f\u001eo\ni\u001b:\u001buOo\u001f~\u000en\n:\fu\u0001|\u0006}\u001ah\u000en\u0006u\u0001:\u0000|Oa\u00125\u0014gA:"), objectArray);
        configurationJSON.f.updateConfiguration((PluginKey)new SimplePluginKey(pluginsRestController2.getName(), pluginsRestController2.getVersion()), pluginsRestController2.getContext(), pluginsRestController2.getProperties());
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"status"})
    public void D(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @RequestParam(value="active") boolean bl, @Parameter(hidden=true) Principal principal) {
        void context;
        void version;
        void name;
        void a2;
        boolean bl2 = bl;
        PluginsRestController active = this;
        if (!active.e || !active.m.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, g);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = this != false ? SerializedObjectMapper.D((Object)"i\u001b{\u001dn") : ReplicationGroupConfiguration.D((Object)"u)i-");
        objectArray[2] = StringUtils.sanitize((String)name);
        objectArray[3] = StringUtils.sanitize((String)version);
        K.info(ReplicationGroupConfiguration.D((Object)"\u0006} [}T8w(c.r}r2&&{}v1s:o3&&{r} (}"), objectArray);
        active.f.updatePluginStatus((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context, (boolean)this);
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"context"})
    public void D(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string3;
        PluginsRestController context = pluginsRestController;
        if (!context.e || !context.m.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, g);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        objectArray[3] = StringUtils.sanitize((String)object);
        K.info(SerializedObjectMapper.D((Object)"A\u0014g2:=\u007f\u001eo\ni\u001b:\u001buOo\u0001h\n}\u0006i\u001b\u007f\u001d:\u001fv\u001a}\u0006tOa\u00125\u0014gO|\u0000hOy\u0000t\u001b\u007f\u0017nOa\u00124"), objectArray);
        context.f.unregisterPluginForContext((PluginKey)new SimplePluginKey((String)name, (String)version), (String)object);
    }

    /*
     * WARNING - void declaration
     */
    public PluginsRestController(PluginController pluginController, MessagingPlatformConfiguration messagingPlatformConfiguration, FeatureChecker featureChecker) {
        void a2;
        void a3;
        PluginsRestController a4;
        PluginsRestController a5 = featureChecker;
        PluginsRestController pluginsRestController = a4 = this;
        PluginsRestController pluginsRestController2 = a4;
        pluginsRestController2.A = LoggerFactory.getLogger(PluginsRestController.class);
        pluginsRestController2.e = a3.isPluginsEnabled();
        pluginsRestController.f = a2;
        pluginsRestController.m = a5;
    }

    @PostMapping(consumes={"multipart/form-data"})
    public PluginKey D(@RequestPart(value="bundle") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        PluginKey pluginBundle2;
        block6: {
            PluginsRestController pluginsRestController = object;
            Object object = principal;
            PluginsRestController a2 = pluginsRestController;
            if (!a2.e || !a2.m.plugins()) {
                throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, g);
            }
            K.info(ReplicationGroupConfiguration.D((Object)"\u0006} [}T8w(c.r}r2&4h.r<j1&-j(a4h}} (}"), (Object)AuditLog.username((Principal)object), (Object)StringUtils.sanitize((String)pluginBundle2.getOriginalFilename()));
            object = pluginBundle2.getInputStream();
            try {
                PluginsRestController pluginsRestController2 = a2;
                String string = pluginsRestController2.D(pluginBundle2.getOriginalFilename());
                pluginBundle2 = pluginsRestController2.f.addPlugin(string, (InputStream)object);
                if (object == null) break block6;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block7: {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                            throwable2 = throwable;
                            break block7;
                        }
                        catch (Throwable pluginBundle2) {
                            throwable.addSuppressed(pluginBundle2);
                        }
                    }
                    throwable2 = throwable;
                }
                throw throwable2;
            }
            ((InputStream)object).close();
        }
        return pluginBundle2;
    }

    @GetMapping
    public Iterable<PluginInfo> D(@Parameter(hidden=true) Principal principal) {
        PluginsRestController pluginsRestController = object;
        Object object = principal;
        PluginsRestController a2 = pluginsRestController;
        K.info(ReplicationGroupConfiguration.D((Object)"]&{\u0000&\u000fc,s8u)&)i}j4u)&>s/t8h)&-j(a4h.(}"), (Object)AuditLog.username((Principal)object));
        return a2.f.listPlugins();
    }
}

