/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import io.axoniq.axonserver.PrincipalAuthentication;
import io.axoniq.axonserver.access.application.ApplicationContextRoles;
import io.axoniq.axonserver.access.roles.RoleController;
import io.axoniq.axonserver.admin.user.api.UserAdminService;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.config.TagsConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminUserRole;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.transport.rest.UserRestController;
import io.axoniq.axonserver.transport.rest.b;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.validation.Valid;
import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="UserRestController")
@CrossOrigin
@RequestMapping(value={"/v1"})
public class UserRestController {
    private final RoleController A;
    private final UserAdminService f;
    private static final Logger K = LoggerFactory.getLogger(UserRestController.class);
    private static final Logger e = AuditLog.getLogger();

    /*
     * WARNING - void declaration
     */
    public UserRestController(UserAdminService userAdminService, RoleController roleController) {
        void a2;
        UserRestController a3;
        UserRestController a4 = roleController;
        UserRestController userRestController = a3 = this;
        userRestController.f = a2;
        userRestController.A = a4;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"users"})
    public void D(@RequestBody @Valid UserJson userJson, @Parameter(hidden=true) Principal principal) {
        void a2;
        UserRestController userRestController = userRestController2;
        UserRestController userRestController2 = userJson;
        UserRestController userJson2 = userRestController;
        if (a2 != null && userRestController2.userName.equals(a2.getName())) {
            throw new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, ApplicationContextRoles.D((Object)"I\u007fs0f|k\u007fpuc0s\u007f'soqiwb0~\u007frb'\u007fp~'suucuidnqkc"));
        }
        Set<Object> set = new HashSet();
        if (userRestController2.roles != null) {
            set = Arrays.stream(userRestController2.roles).map(AdminUserRole::parse).collect(Collectors.toSet());
        }
        UserRestController userRestController3 = userRestController2;
        userJson2.f.createOrUpdateUser(userRestController3.userName, userRestController3.password, set.stream().map(adminUserRole -> {
            UserRestController a2 = adminUserRole;
            UserRestController a3 = this;
            return new b(a3, (AdminUserRole)a2);
        }).collect(Collectors.toSet()), (Authentication)new PrincipalAuthentication((Principal)a2));
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"public/users"})
    public List<UserJson> D(@Parameter(hidden=true) Principal principal) {
        void a2;
        UserRestController userRestController = this;
        try {
            return userRestController.f.users((Authentication)new PrincipalAuthentication((Principal)a2)).stream().map(UserJson::new).sorted(Comparator.comparing(UserJson::getUserName)).collect(Collectors.toList());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a2);
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            K.info(TagsConfiguration.D((Object)"R\u0002t$)5`\n}Y|\nl\u000bzYo\u0018`\u0015l\u001d)T)\u0002t"), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"users/{name}"})
    public void D(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        void name;
        UserRestController userRestController = this;
        try {
            userRestController.f.deleteUser((String)name, (Authentication)new PrincipalAuthentication((Principal)a2));
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a2);
            objectArray[1] = name;
            objectArray[2] = exception.getMessage();
            e.error(ApplicationContextRoles.D((Object)"K|mZ0Cukusu'etuu0|m'vfykuc0*0|m"), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }
}

