/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.google.common.util.concurrent.AtomicDouble;
import io.axoniq.axonserver.PrincipalAuthentication;
import io.axoniq.axonserver.accesscontrol.VisibleContexts;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.UpdateReplicationGroupPayload;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.component.instance.PlatformClientComponents;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.grpc.SerializedCommandResponse;
import io.axoniq.axonserver.grpc.command.CommandResponse;
import io.axoniq.axonserver.integration.BatchingRequestQueue;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.EnterpriseCommandCache;
import io.axoniq.axonserver.message.command.CommandInformation;
import io.axoniq.axonserver.metric.AxonServerMetric;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MetricCollector;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.transport.rest.v2.CommandsRestControllerV2;
import io.axoniq.axonserver.transport.rest.v2.CounterMetric;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.security.Principal;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
@RequestMapping(value={"v2/commands"})
@CrossOrigin
@Tag(name="Commands", description="Operations for monitoring and managing commands in Axon Server")
public class CommandsRestControllerV2 {
    private final MeterRegistry b;
    private static final String l = "_all_";
    private final MetricCollector g;
    private static final Logger m = AuditLog.getLogger();
    private final PlatformClientComponents A;
    private final VisibleContexts f;
    private final EnterpriseCommandCache K;
    private static final MetricName e = BaseMetricName.b;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean D(String string, Set<String> set, String string2) {
        void a2;
        void a3;
        String a4 = string2;
        CommandsRestControllerV2 a5 = this;
        if (a3.contains(a2) && (a4.equals(l) || a4.equals(a2))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(produces={"application/json"}, path={"longrunning"})
    @Operation(summary="List long-running commands", description="Retrieves information about commands that have been running for longer than the specified interval")
    @ApiResponse(responseCode="200", description="Long-running commands retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=LongRunningCommand.class)))})
    public Flux<LongRunningCommand> D(@RequestParam(value="activeContext", required=false, defaultValue="_all_") @Schema(description="Context to filter commands for. Use '_all_' for all contexts.", defaultValue="_all_") String string, @RequestParam(name="interval", required=false, defaultValue="1000") @Schema(description="Minimum duration in milliseconds to consider a command as long-running", defaultValue="1000") int n) {
        void a2;
        CommandsRestControllerV2 commandsRestControllerV2 = object;
        Object object = string;
        CommandsRestControllerV2 activeContext = commandsRestControllerV2;
        long l2 = System.currentTimeMillis() - (long)a2;
        if (Objects.equals(object, l)) {
            return Flux.fromIterable(() -> {
                CommandsRestControllerV2 a2;
                return a2.K.entrySet().iterator();
            }).filter(a3 -> {
                if (((CommandInformation)a3.getValue()).D() < l2) {
                    return true;
                }
                return false;
            }).map(entry -> {
                Map.Entry a2 = entry;
                CommandsRestControllerV2 a3 = this;
                return new LongRunningCommand((String)a2.getKey(), (CommandInformation)a2.getValue(), a3.A);
            });
        }
        return Flux.fromStream(activeContext.K.getMessagesForContext((String)object).filter(a3 -> {
            if (a3.D() < l2) {
                return true;
            }
            return false;
        }).map(commandInformation -> {
            CommandsRestControllerV2 a2 = commandInformation;
            CommandsRestControllerV2 a3 = this;
            return new LongRunningCommand(a2.l(), (CommandInformation)a2, a3.A);
        }));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean D(Set set, String string, Gauge gauge) {
        void a2;
        void a3;
        CommandsRestControllerV2 a4 = gauge;
        CommandsRestControllerV2 a5 = this;
        return a5.D((Meter)a4, (Set)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ SerializedCommandResponse D(String string, ErrorCode errorCode, String string2) {
        void a2;
        void a3;
        Object a4 = string2;
        CommandsRestControllerV2 a5 = this;
        return new SerializedCommandResponse(CommandResponse.newBuilder().setMessageIdentifier(UUID.randomUUID().toString()).setRequestIdentifier((String)a3).setErrorCode(a2.getCode()).setErrorMessage(ErrorMessageFactory.D((String)a4)).build());
    }

    /*
     * WARNING - void declaration
     */
    public CommandsRestControllerV2(MeterRegistry meterRegistry, MetricCollector metricCollector, VisibleContexts visibleContexts, PlatformClientComponents platformClientComponents, EnterpriseCommandCache enterpriseCommandCache) {
        CommandsRestControllerV2 a2;
        void a3;
        void a4;
        void a5;
        void a6;
        CommandsRestControllerV2 a7;
        CommandsRestControllerV2 commandsRestControllerV2 = commandsRestControllerV22;
        CommandsRestControllerV2 commandsRestControllerV22 = enterpriseCommandCache;
        CommandsRestControllerV2 commandsRestControllerV23 = a7 = commandsRestControllerV2;
        CommandsRestControllerV2 commandsRestControllerV24 = a7;
        a7.b = a6;
        commandsRestControllerV24.g = a5;
        commandsRestControllerV24.f = a4;
        commandsRestControllerV23.A = a3;
        commandsRestControllerV23.K = a2;
    }

    private /* synthetic */ CommandInformation D(String string, CommandInformation commandInformation) {
        Object a2 = string;
        CommandsRestControllerV2 a3 = this;
        return (CommandInformation)a3.K.remove((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean D(Set set, String string, Counter counter) {
        void a2;
        void a3;
        CommandsRestControllerV2 a4 = counter;
        CommandsRestControllerV2 a5 = this;
        return a5.D((Meter)a4, (Set)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean D(Meter meter, Set<String> set, String string) {
        void a2;
        void a3;
        Object a4 = meter;
        CommandsRestControllerV2 a5 = this;
        a4 = a4.getId().getTag("context");
        return a5.D((String)a4, (Set)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean L(Set set, String string, Timer timer) {
        void a2;
        void a3;
        CommandsRestControllerV2 a4 = timer;
        CommandsRestControllerV2 a5 = this;
        return a5.D((Meter)a4, (Set)a3, (String)a2);
    }

    private static /* synthetic */ boolean D(String string, CommandInformation commandInformation) {
        String a2 = commandInformation;
        String a3 = string;
        return a2.l().equals(a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean D(Set set, String string, Timer timer) {
        void a2;
        void a3;
        CommandsRestControllerV2 a4 = timer;
        CommandsRestControllerV2 a5 = this;
        return a5.D((Meter)a4, (Set)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(produces={"application/json"}, path={"cancel"})
    @Operation(summary="Cancel a running command", description="Cancels a command that is currently being processed")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Command successfully cancelled", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Command not found or not accessible")})
    public Optional<String> D(@RequestParam(value="activeContext", required=false, defaultValue="_all_") @Schema(description="Context where the command is running. Use '_all_' to search in all contexts.", defaultValue="_all_") String string, @RequestParam(name="commandId") @Schema(description="Identifier of the command to cancel", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @Parameter(hidden=true) Principal principal) {
        void a2;
        void activeContext;
        CommandsRestControllerV2 commandsRestControllerV2 = object;
        Object object = string2;
        CommandsRestControllerV2 commandId = commandsRestControllerV2;
        m.info(BatchingRequestQueue.D((Object)"2\u0003\u001f\u0001\u0014\u000eQ\u0001\u001e\u000f\u001c\u0003\u001f\u0006Q\u0019\fB\u0018\fQ\u0001\u001e\f\u0005\u0007\t\u0016Q\u0019\f"), object, (Object)activeContext);
        Set set = commandId.f.visibleContexts(false, (Authentication)new PrincipalAuthentication((Principal)a2));
        if (Objects.equals(activeContext, l)) {
            return Optional.of((CommandInformation)commandId.K.remove((String)object)).map(commandInformation -> {
                Object a2 = commandInformation;
                CommandsRestControllerV2 a3 = this;
                CommandsRestControllerV2 commandsRestControllerV2 = a2;
                a2 = commandsRestControllerV2.l();
                commandsRestControllerV2.D().accept(a3.D((String)a2, ErrorCode.OTHER, UpdateReplicationGroupPayload.D((Object)"\nQ'S,\\%U-\u0010$Q'E(\\%IiR0\u0010<C,B")));
                return a2;
            });
        }
        if (!set.contains(activeContext)) {
            return Optional.empty();
        }
        return commandId.K.getMessagesForContext((String)activeContext).filter(arg_0 -> CommandsRestControllerV2.D((String)object, arg_0)).findFirst().map(arg_0 -> commandId.D((String)object, arg_0)).map(arg_0 -> commandId.D((Principal)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(produces={"application/json"})
    @Operation(summary="List command metrics", description="Retrieves metrics about command processing across contexts or for a specific context")
    @ApiResponse(responseCode="200", description="Command metrics retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=CounterMetric.class)))})
    public Flux<CounterMetric> D(@RequestParam(value="activeContext", required=false, defaultValue="_all_") @Schema(description="Context to filter metrics for. Use '_all_' for all contexts.", defaultValue="_all_") String string, @Parameter(hidden=true) Principal principal) {
        void activeContext;
        CommandsRestControllerV2 a2;
        CommandsRestControllerV2 commandsRestControllerV2 = object;
        Object object = principal;
        CommandsRestControllerV2 commandsRestControllerV22 = a2 = commandsRestControllerV2;
        object = commandsRestControllerV22.f.visibleContexts(false, (Authentication)new PrincipalAuthentication((Principal)object));
        return Flux.fromStream(commandsRestControllerV22.b.find(e.metric()).timers().stream().filter(arg_0 -> a2.D((Set)object, (String)activeContext, arg_0))).map(timer -> {
            CommandsRestControllerV2 a2 = timer;
            CommandsRestControllerV2 a3 = this;
            return new CounterMetric((Timer)a2, a3.A);
        }).mergeWith((Publisher)Flux.fromIterable((Iterable)a2.g.getAll(e.metric(), Tags.empty())).filter(arg_0 -> a2.D((Set)object, (String)activeContext, arg_0)).map(axonServerMetric -> {
            CommandsRestControllerV2 a2 = axonServerMetric;
            CommandsRestControllerV2 a3 = this;
            return new CounterMetric((AxonServerMetric)a2, a3.A);
        }));
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(produces={"application/json"}, path={"metrics"})
    @Operation(summary="Get command metrics summary", description="Retrieves summarized metrics for command processing including average duration, count, errors, and active commands")
    @ApiResponse(responseCode="200", description="Command metrics summary retrieved successfully", content={@Content(schema=@Schema(implementation=CommandMetrics.class))})
    public CommandMetrics D(@RequestParam(value="activeContext", required=false, defaultValue="_all_") @Schema(description="Context to filter metrics for. Use '_all_' for all contexts.", defaultValue="_all_") String string, @Parameter(hidden=true) Principal principal) {
        void activeContext;
        Set a2;
        CommandsRestControllerV2 commandsRestControllerV2;
        CommandsRestControllerV2 commandsRestControllerV22 = commandsRestControllerV2 = atomicLong;
        a2 = commandsRestControllerV22.f.visibleContexts(false, (Authentication)new PrincipalAuthentication((Principal)((Object)a2)));
        AtomicInteger atomicInteger = new AtomicInteger();
        commandsRestControllerV22.b.find(BaseMetricName.Ea.metric()).gauges().stream().filter(arg_0 -> commandsRestControllerV2.D(a2, (String)activeContext, arg_0)).forEach(gauge -> {
            AtomicInteger a2 = gauge;
            AtomicInteger a3 = atomicInteger;
            a3.addAndGet((int)a2.value());
        });
        AtomicInteger atomicInteger2 = new AtomicInteger();
        commandsRestControllerV2.b.find(BaseMetricName.Ma.metric()).counters().stream().filter(arg_0 -> commandsRestControllerV2.D(a2, (String)activeContext, arg_0)).forEach(counter -> {
            AtomicInteger a2 = counter;
            AtomicInteger a3 = atomicInteger2;
            a3.addAndGet((int)a2.count());
        });
        AtomicDouble atomicDouble = new AtomicDouble();
        AtomicLong atomicLong = new AtomicLong();
        commandsRestControllerV2.b.find(BaseMetricName.b.metric()).timers().stream().filter(arg_0 -> commandsRestControllerV2.L(a2, (String)activeContext, arg_0)).forEach(timer -> {
            void a2;
            AtomicDouble a3 = timer;
            AtomicDouble a4 = atomicDouble;
            a4.addAndGet(a3.totalTime(TimeUnit.MILLISECONDS));
            a2.addAndGet(a3.count());
        });
        double d2 = atomicLong.get() == 0L ? 0.0 : atomicDouble.get() / (double)atomicLong.get();
        return new CommandMetrics(d2, atomicLong.get(), atomicInteger2.get(), atomicInteger.get());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String D(Principal principal, CommandInformation commandInformation) {
        void a2;
        Object a3 = commandInformation;
        CommandsRestControllerV2 a4 = this;
        CommandsRestControllerV2 commandsRestControllerV2 = a3;
        a3 = commandsRestControllerV2.l();
        commandsRestControllerV2.D().accept(a4.D((String)a3, ErrorCode.OTHER, "Cancelled manually by " + a2.getName()));
        return a3;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean D(Set set, String string, AxonServerMetric axonServerMetric) {
        void a2;
        void a3;
        CommandsRestControllerV2 a4 = axonServerMetric;
        CommandsRestControllerV2 a5 = this;
        return a5.D(a4.tag("context"), (Set)a3, (String)a2);
    }
}

