/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.api.IntegrationAPI;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.runtime.CommandHandler;
import io.axoniq.axonserver.configuration.runtime.CommandHandlers;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.Action;
import io.axoniq.axonserver.grpc.internal.HandlerLogMessage;
import io.axoniq.axonserver.integration.logconsumer.AdminCommandHandlerLogConsumer;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.query.QueryDefinition;
import io.axoniq.axonserver.rest.PluginPropertyGroup;
import io.axoniq.axonserver.transport.rest.v2.URIUtils;
import io.axoniq.axonserver.transport.rest.v2.ValidationUtils;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.security.Principal;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@Tag(name="Integration Command Handlers", description="Operations to manage command handlers for integration endpoints")
public class IntegrationCommandHandlerControllerV2 {
    private final ObjectMapper m;
    private static final Logger A;
    private static final Integer f;
    private final RaftGroupServiceFactory K;
    private final CommandHandlers e;

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"v2/endpoints/{endpoint}/commandHandlers/{handler}"})
    @Operation(summary="Update a command handler", description="Update an existing command handler for a specific endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Update request accepted"), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Command handler or endpoint not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public CompletableFuture<ResponseEntity<Object>> D(@RequestBody @Schema(description="Updated command handler details", implementation=IntegrationAPI.CommandHandler.class) IntegrationAPI.CommandHandler commandHandler, @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid") String string, @PathVariable(value="handler") @Schema(description="Handler UUID", format="uuid") String string2, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = object;
        Object object = commandHandler;
        IntegrationCommandHandlerControllerV2 commandHandler2 = integrationCommandHandlerControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void handlerId;
            void endpoint;
            ValidationUtils.D((String)endpoint);
            ValidationUtils.D((String)handlerId);
            IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV22 = object;
            ValidationUtils.D((String)integrationCommandHandlerControllerV22.name(), (String)QueryDefinition.D((Object)"D\bG\f"));
            ValidationUtils.D((String)integrationCommandHandlerControllerV22.name(), (int)200, (String)PluginPropertyGroup.D((Object)"e-f)"));
            ValidationUtils.D((String)object.commandUrl(), (int)2000, (String)QueryDefinition.D((Object)"I\u0006G\u0004K\u0007N<X\u0005"));
            if (integrationCommandHandlerControllerV22.loadFactor() != null && object.loadFactor() < 0) {
                throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, PluginPropertyGroup.D((Object)"\u0000d-olm-h8d>+!~?\u007fli)+|+#ylg-y+n>"));
            }
            principal2 = (Principal)ObjectUtils.D((Object)principal2, (Object)GrpcContextAuthenticationProvider.f);
            if (A.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                A.info(QueryDefinition.D((Object)"2Q\u0014wIx\f[\u001cO\u001a^I^\u0006\n\u001cZ\rK\u001dOII\u0006G\u0004K\u0007NIB\bD\rF\fXIQ\u0014\n\u0000DIO\u0007N\u0019E\u0000D\u001d\n\u0012WG"), objectArray);
            }
            if (object.loadFactor() == null) {
                object = new IntegrationAPI.CommandHandler(object.name(), f, object.commandUrl());
            }
            IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV23 = commandHandler2;
            object = integrationCommandHandlerControllerV23.m.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId((String)handlerId).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.UPDATE).build();
            return ((CompletableFuture)integrationCommandHandlerControllerV23.K.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminCommandHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationCommandHandlerControllerV2.L((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::D);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.D((Throwable)principal2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"v2/endpoints/{endpoint}/commandHandlers"})
    @Operation(summary="Register a command handler", description="Register a new command handler for a specific endpoint. Command handlers process commands sent to the endpoint.")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Command handler successfully registered", content={@Content(schema=@Schema(implementation=IntegrationAPI.Id.class), mediaType="application/json")}), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Endpoint not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public CompletableFuture<ResponseEntity<Object>> D(@RequestBody @Schema(description="Command handler details", implementation=IntegrationAPI.CommandHandler.class) IntegrationAPI.CommandHandler commandHandler, @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid") String string, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", requiredMode=Schema.RequiredMode.REQUIRED, example="default") String string2) {
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = object;
        Object object = commandHandler;
        IntegrationCommandHandlerControllerV2 commandHandler2 = integrationCommandHandlerControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.D((String)endpoint);
            IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV22 = object;
            ValidationUtils.D((String)integrationCommandHandlerControllerV22.name(), (String)PluginPropertyGroup.D((Object)"E-f)"));
            ValidationUtils.D((String)integrationCommandHandlerControllerV22.name(), (int)200, (String)QueryDefinition.D((Object)"D\bG\f"));
            ValidationUtils.D((String)integrationCommandHandlerControllerV22.commandUrl(), (int)2000, (String)PluginPropertyGroup.D((Object)"h#f!j\"o\u0019y "));
            if (integrationCommandHandlerControllerV22.loadFactor() != null && object.loadFactor() < 0) {
                throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, QueryDefinition.D((Object)"%E\bNIL\bI\u001dE\u001b\n\u0004_\u001a^IH\f\nY\n\u0006XIF\bX\u000eO\u001b"));
            }
            principal2 = (Principal)ObjectUtils.D((Object)principal2, (Object)GrpcContextAuthenticationProvider.f);
            if (A.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                A.info(PluginPropertyGroup.D((Object)"\u0017p1VlY)z9n?\u007fl\u007f#+>n+b?\u007f)ylh#f!j\"olc-e(g)ylp1+%eln\"o<d%e8+7vb"), objectArray);
            }
            if (object.loadFactor() == null) {
                object = new IntegrationAPI.CommandHandler(object.name(), f, object.commandUrl());
            }
            IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV23 = commandHandler2;
            object = integrationCommandHandlerControllerV23.m.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId(UUID.randomUUID().toString()).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.ADD).build();
            return ((CompletableFuture)integrationCommandHandlerControllerV23.K.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminCommandHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationCommandHandlerControllerV2.D((HttpServletRequest)request, (HandlerLogMessage)object, arg_0))).exceptionally(ValidationUtils::D);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.D((Throwable)principal2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public IntegrationCommandHandlerControllerV2(ObjectMapper objectMapper, CommandHandlers commandHandlers, RaftGroupServiceFactory raftGroupServiceFactory) {
        void a2;
        void a3;
        IntegrationCommandHandlerControllerV2 a4;
        IntegrationCommandHandlerControllerV2 a5 = raftGroupServiceFactory;
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = a4 = this;
        a4.m = a3;
        integrationCommandHandlerControllerV2.e = a2;
        integrationCommandHandlerControllerV2.K = a5;
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"v2/endpoints/{endpoint}/commandHandlers/{handler}"})
    @Operation(summary="Delete a command handler", description="Remove a command handler from a specific endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Deletion request accepted"), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Command handler or endpoint not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public CompletableFuture<ResponseEntity<Object>> D(@PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid") String string, @PathVariable(value="handler") @Schema(description="Handler UUID", format="uuid") String string2, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = object;
        Object object = principal;
        IntegrationCommandHandlerControllerV2 principal2 = integrationCommandHandlerControllerV2;
        try {
            void request;
            void a2;
            void handlerId;
            HandlerLogMessage endpoint;
            ValidationUtils.D((String)endpoint);
            ValidationUtils.D((String)handlerId);
            object = (Principal)ObjectUtils.D((Object)object, (Object)GrpcContextAuthenticationProvider.f);
            if (A.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)object.getName());
                objectArray[1] = StringUtils.sanitize((String)handlerId);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                A.info(QueryDefinition.D((Object)"2Q\u0014wIx\f[\u001cO\u001a^I^\u0006\n\rO\u0005O\u001dOII\u0006G\u0004K\u0007NIB\bD\rF\fXIQ\u0014\n\u0000DIO\u0007N\u0019E\u0000D\u001d\n\u0012WG"), objectArray);
            }
            endpoint = HandlerLogMessage.newBuilder().setId((String)handlerId).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.DELETE).build();
            return ((CompletableFuture)principal2.K.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminCommandHandlerLogConsumer.class.getSimpleName(), endpoint.toByteArray()).thenApply(arg_0 -> IntegrationCommandHandlerControllerV2.D((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::D);
        }
        catch (MessagingPlatformException this2) {
            return CompletableFuture.completedFuture(ValidationUtils.D((Throwable)this2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/endpoints/{endpoint}/commandHandlers/{handler}"})
    @Operation(responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=IntegrationAPI.CommandHandler.class), mediaType="application/json")}), @ApiResponse(responseCode="400", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public ResponseEntity<Object> D(@PathVariable(value="endpoint") String string, @PathVariable(value="handler") String string2, @Parameter(hidden=true) Principal principal, @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) @RequestParam(value="context") String string3) {
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = object;
        Object object = string2;
        IntegrationCommandHandlerControllerV2 handlerId = integrationCommandHandlerControllerV2;
        try {
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.D((String)endpoint);
            ValidationUtils.D((String)object);
            principal2 = (Principal)ObjectUtils.D((Object)principal2, (Object)GrpcContextAuthenticationProvider.f);
            if (A.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                A.info(PluginPropertyGroup.D((Object)"P7v\u0011+\u001en=~)x8+8dll)\u007flh#f!j\"olc-e(g)ylp1+%eln\"o<d%e8+7vb"), objectArray);
            }
            if (!(object = (CommandHandler)handlerId.e.findById(UUID.fromString((String)object)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, PluginPropertyGroup.D((Object)"\u0004j\"o n>+\"d8+*d9e(")))).getEndpoint().getId().toString().equals(endpoint)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, QueryDefinition.D((Object)"!K\u0007N\u0005O\u001b\n\u0007E\u001d\n\u000fE\u001cD\r\n\u0000DIO\u0007N\u0019E\u0000D\u001d"));
            }
            if (!object.getEndpoint().getContext().equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, PluginPropertyGroup.D((Object)"C-e(g)yle#\u007flm#~\"olb\"+/d\"\u007f)s8"));
            }
            return ResponseEntity.ok((Object)new IntegrationAPI.CommandHandler(object.getName(), Integer.valueOf(object.getLoadFactor()), object.getCommandUrl()));
        }
        catch (MessagingPlatformException principal2) {
            return ValidationUtils.D((Throwable)principal2);
        }
    }

    private static /* synthetic */ ResponseEntity L(HttpServletRequest httpServletRequest, Void void_) {
        Object a2 = void_;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.D((HttpServletRequest)a3);
    }

    private static /* synthetic */ ResponseEntity D(HttpServletRequest httpServletRequest, HandlerLogMessage handlerLogMessage, Void void_) {
        HttpServletRequest a2 = handlerLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ResponseEntity.created((URI)URIUtils.D((StringBuffer)a3.getRequestURL(), (String)a2.getId())).body((Object)new IntegrationAPI.Id(a2.getId()));
    }

    static {
        f = 100;
        A = AuditLog.getLogger();
    }

    private static /* synthetic */ ResponseEntity D(HttpServletRequest httpServletRequest, Void void_) {
        Object a2 = void_;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.D((HttpServletRequest)a3);
    }
}

