/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.api.IntegrationAPI;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.runtime.EventHandler;
import io.axoniq.axonserver.configuration.runtime.EventHandlers;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.eventstore.EventSupplier;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.Action;
import io.axoniq.axonserver.grpc.internal.HandlerLogMessage;
import io.axoniq.axonserver.integration.logconsumer.AdminEventHandlerLogConsumer;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.event.EventDispatcher;
import io.axoniq.axonserver.message.query.QueryDefinition;
import io.axoniq.axonserver.streams.SequencingPolicyDefinition;
import io.axoniq.axonserver.streams.cluster.DefaultSequencingPolicyDefinition;
import io.axoniq.axonserver.streams.sequencing.SequencingPolicy;
import io.axoniq.axonserver.streams.sequencing.SequencingPolicyProvider;
import io.axoniq.axonserver.transport.rest.EventStoreTransformationRestController;
import io.axoniq.axonserver.transport.rest.v2.ValidationUtils;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.invoke.LambdaMetafactory;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@Tag(name="Integration Event Handlers", description="API endpoints for managing integration event handlers")
public class IntegrationEventHandlerRestControllerV2 {
    private final EventHandlers l;
    private final ObjectMapper g;
    private static final Logger m = AuditLog.getLogger();
    private final EventDispatcher A;
    private final RaftGroupServiceFactory f;
    private final EventSupplier K;
    private final SequencingPolicyProvider e;

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Delete an event handler", description="Removes an event handler from an integration endpoint.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Event handler successfully deleted"), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Event handler not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))})})
    @DeleteMapping(value={"v2/endpoints/{endpoint}/eventHandlers/{handler}"})
    public CompletableFuture<ResponseEntity<Object>> D(@Parameter(description="UUID of the integration endpoint", required=true) @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @Parameter(description="UUID of the event handler to delete", required=true) @PathVariable(value="handler") @Schema(description="Event handler UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @Parameter(hidden=true) Principal principal, @Parameter(description="Context name") @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV2 = object;
        Object object = principal;
        IntegrationEventHandlerRestControllerV2 principal2 = integrationEventHandlerRestControllerV2;
        try {
            void a3;
            void handlerId;
            HandlerLogMessage endpoint;
            ValidationUtils.D((String)endpoint);
            ValidationUtils.D((String)handlerId);
            object = (Principal)ObjectUtils.D((Object)object, (Object)GrpcContextAuthenticationProvider.f);
            if (m.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)object.getName());
                objectArray[1] = StringUtils.sanitize((String)handlerId);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                m.info(QueryDefinition.D((Object)"2Q\u0014wIx\f[\u001cO\u001a^I^\u0006\n\rO\u0005O\u001dOIO\u001fO\u0007^IB\bD\rF\fXIQ\u0014\n\u0000DIO\u0007N\u0019E\u0000D\u001d\n\u0012WG"), objectArray);
            }
            endpoint = HandlerLogMessage.newBuilder().setId((String)handlerId).setContext((String)a3).setEndpointId((String)endpoint).setAction(Action.DELETE).build();
            return ((CompletableFuture)principal2.f.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEventHandlerLogConsumer.class.getSimpleName(), endpoint.toByteArray()).thenApply(a2 -> ValidationUtils.D())).exceptionally(ValidationUtils::D);
        }
        catch (MessagingPlatformException this2) {
            return CompletableFuture.completedFuture(ValidationUtils.D((Throwable)this2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Update an existing event handler", description="Updates the configuration of an existing event handler for an integration endpoint.")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Event handler update accepted"), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Event handler not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))})})
    @PutMapping(value={"v2/endpoints/{endpoint}/eventHandlers/{handler}"})
    public CompletableFuture<ResponseEntity<Object>> D(@Parameter(description="Updated event handler configuration", required=true) @RequestBody @Schema(description="Updated event handler details", requiredMode=Schema.RequiredMode.REQUIRED) IntegrationAPI.EventHandler eventHandler, @Parameter(description="UUID of the integration endpoint", required=true) @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @Parameter(description="UUID of the event handler to update", required=true) @PathVariable(value="handler") @Schema(description="Event handler UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @Parameter(description="Context name") @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV2 = object;
        Object object = eventHandler;
        IntegrationEventHandlerRestControllerV2 eventHandler2 = integrationEventHandlerRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void handlerId;
            void endpoint;
            ValidationUtils.D((String)endpoint);
            ValidationUtils.D((String)handlerId);
            eventHandler2.D((IntegrationAPI.EventHandler)object);
            principal2 = (Principal)ObjectUtils.D((Object)principal2, (Object)GrpcContextAuthenticationProvider.f);
            if (m.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                m.info(QueryDefinition.D((Object)"2Q\u0014wIx\f[\u001cO\u001a^I^\u0006\n\u001cZ\rK\u001dOIO\u001fO\u0007^IB\bD\rF\fXIQ\u0014\n\u0000DIO\u0007N\u0019E\u0000D\u001d\n\u0012WG"), objectArray);
            }
            IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV22 = eventHandler2;
            object = integrationEventHandlerRestControllerV22.g.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId((String)handlerId).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.UPDATE).build();
            return ((CompletableFuture)integrationEventHandlerRestControllerV22.f.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEventHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationEventHandlerRestControllerV2.D((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::D);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.D((Throwable)principal2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public IntegrationEventHandlerRestControllerV2(EventDispatcher eventDispatcher, ObjectMapper objectMapper, RaftGroupServiceFactory raftGroupServiceFactory, EventHandlers eventHandlers, SequencingPolicyProvider sequencingPolicyProvider, EventSupplier eventSupplier) {
        IntegrationEventHandlerRestControllerV2 a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        IntegrationEventHandlerRestControllerV2 a8;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV2 = integrationEventHandlerRestControllerV22;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV22 = eventSupplier;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV23 = a8 = integrationEventHandlerRestControllerV2;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV24 = a8;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV25 = a8;
        integrationEventHandlerRestControllerV25.A = a7;
        integrationEventHandlerRestControllerV25.g = a6;
        integrationEventHandlerRestControllerV24.f = a5;
        integrationEventHandlerRestControllerV24.l = a4;
        integrationEventHandlerRestControllerV23.e = a3;
        integrationEventHandlerRestControllerV23.K = a2;
    }

    private /* synthetic */ void D(String string, String string2) {
        SequencingPolicy a22;
        String a32 = string2;
        IntegrationEventHandlerRestControllerV2 a4 = this;
        if (a22 != null) {
            String[] stringArray = StringUtils.isEmpty((String)a32) ? new String[]{} : a32.split(QueryDefinition.D((Object)"E"));
            int n = a32 = 0;
            while (n < stringArray.length) {
                stringArray[++a32] = stringArray[a32].trim();
                n = a32;
            }
            List<String> a32 = Arrays.asList(stringArray);
            a22 = a4.e.get((SequencingPolicyDefinition)new DefaultSequencingPolicyDefinition((String)a22, a32));
            try {
                Integer[] integerArray = new Integer[1];
                integerArray[0] = 0;
                a22.sequencer(a32, 0, integerArray);
                return;
            }
            catch (Exception a22) {
                throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, "sequencingPolicy: " + a22.getMessage());
            }
        }
    }

    private static /* synthetic */ ResponseEntity D(HttpServletRequest httpServletRequest, HandlerLogMessage handlerLogMessage, Void void_) {
        HttpServletRequest a2 = handlerLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.D((HttpServletRequest)a3, (String)a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/endpoints/{endpoint}/eventHandlers/{handler}"})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=IntegrationAPI.EventHandler.class), mediaType="application/json")}), @ApiResponse(responseCode="400", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public ResponseEntity<Object> D(@PathVariable(value="endpoint") String string, @PathVariable(value="handler") String string2, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") String string3) {
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV2 = object;
        Object object = string2;
        IntegrationEventHandlerRestControllerV2 handlerId = integrationEventHandlerRestControllerV2;
        try {
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.D((String)endpoint);
            ValidationUtils.D((String)object);
            principal2 = (Principal)ObjectUtils.D((Object)principal2, (Object)GrpcContextAuthenticationProvider.f);
            if (m.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                m.info(EventStoreTransformationRestController.D((Object)"D\"b\u0004?\u000bz(j<l-?-pyx<kyz/z7kyw8q=s<myd$?0qyz7{)p0q-?\"bw"), objectArray);
            }
            if (!(object = (EventHandler)handlerId.l.findById(UUID.fromString((String)object)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, EventStoreTransformationRestController.D((Object)"\u0011~7{5z+?7p-??p,q=")))).getEndpoint().getId().toString().equals(endpoint)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, QueryDefinition.D((Object)"!K\u0007N\u0005O\u001b\n\u0007E\u001d\n\u000fE\u001cD\r\n\u0000DIO\u0007N\u0019E\u0000D\u001d"));
            }
            if (!object.getEndpoint().getContext().equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, EventStoreTransformationRestController.D((Object)"W8q=s<myq6kyy6j7{yv7?:p7k<g-"));
            }
            return ResponseEntity.ok((Object)new IntegrationAPI.EventHandler(object.getName(), object.getBatchSize(), object.getFilter(), object.getSequencingPolicy(), object.getSequencingPolicyParameters(), object.getSegments(), "", object.getEventUrl()));
        }
        catch (MessagingPlatformException principal2) {
            return ValidationUtils.D((Throwable)principal2);
        }
    }

    @Operation(summary="Get available sequencing policies", description="Retrieves the list of available sequencing policies that can be used for event handlers")
    @ApiResponse(responseCode="200", description="Successfully retrieved sequencing policies", content={@Content(array=@ArraySchema(schema=@Schema(type="string")))})
    @GetMapping(value={"v2/sequencingPolicies"})
    public Set<String> D() {
        IntegrationEventHandlerRestControllerV2 a2;
        return a2.e.sequencingPolicies();
    }

    private /* synthetic */ void D(IntegrationAPI.EventHandler eventHandler) {
        IntegrationEventHandlerRestControllerV2 a2 = eventHandler;
        IntegrationEventHandlerRestControllerV2 a3 = this;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV2 = a2;
        ValidationUtils.D((String)integrationEventHandlerRestControllerV2.name(), (String)EventStoreTransformationRestController.D((Object)"q8r<"));
        ValidationUtils.D((String)integrationEventHandlerRestControllerV2.sequencingPolicy(), (String)QueryDefinition.D((Object)"Y\f[\u001cO\u0007I\u0000D\u000ez\u0006F\u0000I\u0010"));
        ValidationUtils.D((String)integrationEventHandlerRestControllerV2.sequencingPolicy(), (String)EventStoreTransformationRestController.D((Object)"l<n,z7|0q>O6s0| "), (Collection)a3.D());
        ValidationUtils.D((String)integrationEventHandlerRestControllerV2.name(), (int)200, (String)QueryDefinition.D((Object)"D\bG\f"));
        ValidationUtils.D((String)integrationEventHandlerRestControllerV2.eventUrl(), (int)2000, (String)EventStoreTransformationRestController.D((Object)"z/z7k\fm5"));
        ValidationUtils.D((String)integrationEventHandlerRestControllerV2.sequencingPolicyParameters(), (int)2000, (String)QueryDefinition.D((Object)"Y\f[\u001cO\u0007I\u0000D\u000ez\u0006F\u0000I\u0010z\bX\bG\f^\fX\u001a"));
        ValidationUtils.D((String)integrationEventHandlerRestControllerV2.filter(), (int)4000, (String)EventStoreTransformationRestController.D((Object)"y0s-z+"));
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV22 = a3;
        integrationEventHandlerRestControllerV22.K.validateFilter(a2.filter());
        integrationEventHandlerRestControllerV22.D(integrationEventHandlerRestControllerV2.sequencingPolicy(), a2.sequencingPolicyParameters());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Operation(summary="Register a new event handler", description="Registers a new event handler for an integration endpoint. The handler will process events according to the specified sequencing policy.")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Event handler successfully registered", content={@Content(schema=@Schema(implementation=IntegrationAPI.Id.class))}), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))})})
    @PostMapping(value={"v2/endpoints/{endpoint}/eventHandlers"})
    public CompletableFuture<ResponseEntity<Object>> D(@Parameter(description="Event handler configuration") @RequestBody @Schema(description="Event handler configuration details") IntegrationAPI.EventHandler var1_1, @Parameter(description="UUID of the integration endpoint", required=true) @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String var2_2, @Parameter(hidden=true) Principal var3_3, @Parameter(hidden=true) HttpServletRequest var4_4, @Parameter(description="Context name") @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String var5_5) {
        block8: {
            block7: {
                v0 = this /* !! */ ;
                this /* !! */  = var1_1;
                eventHandler = v0;
                ValidationUtils.D((String)endpoint);
                v1 = this /* !! */ ;
                eventHandler.D((IntegrationAPI.EventHandler)v1);
                if (v1.startPosition() != null && !this /* !! */ .startPosition().isEmpty() && !this /* !! */ .startPosition().equalsIgnoreCase(EventStoreTransformationRestController.D((Object)"K\u0018V\u0015"))) break block7;
                var6_6 = (Long)eventHandler.A.firstEventToken((String)a).block();
                this /* !! */  = this /* !! */ .withStartPosition((Long)var6_6);
                v2 = principal;
                ** GOTO lbl25
            }
            if (!this /* !! */ .startPosition().equalsIgnoreCase(QueryDefinition.D((Object)"b,k-"))) break block8;
            var6_6 = (Long)eventHandler.A.lastEventToken((String)a).block();
            this /* !! */  = this /* !! */ .withStartPosition((Long)var6_6);
            v2 = principal;
            ** GOTO lbl25
        }
        if (Long.parseLong(this /* !! */ .startPosition()) >= 0L) ** GOTO lbl-1000
        throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, EventStoreTransformationRestController.D((Object)"*k8m-O6l0k0p7?4j*ky}<?i?6mys8m>z+"));
        {
            catch (Exception var6_8) {
                return CompletableFuture.completedFuture(ValidationUtils.D((Throwable)var6_8));
            }
lbl-1000:
            // 1 sources

            {
                v2 = principal;
lbl25:
                // 3 sources

                var6_6 = (Principal)ObjectUtils.D((Object)v2, (Object)GrpcContextAuthenticationProvider.f);
                if (IntegrationEventHandlerRestControllerV2.m.isInfoEnabled()) {
                    v3 = new Object[3];
                    v3[0] = AuditLog.username((String)var6_6.getName());
                    v3[1] = StringUtils.sanitize((String)this /* !! */ .name());
                    v3[2] = StringUtils.sanitize((String)endpoint);
                    IntegrationEventHandlerRestControllerV2.m.info(EventStoreTransformationRestController.D((Object)"\u0002d$ByM<n,z*kyk6?+z>v*k<myz/z7kyw8q=s<myd$?0qyz7{)p0q-?\"bw"), v3);
                }
                v4 = eventHandler;
                this /* !! */  = v4.g.writeValueAsString((Object)this /* !! */ );
                this /* !! */  = HandlerLogMessage.newBuilder().setId(UUID.randomUUID().toString()).setData((String)this /* !! */ ).setContext((String)a).setEndpointId((String)endpoint).setAction(Action.ADD).build();
                return v4.f.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEventHandlerLogConsumer.class.getSimpleName(), this /* !! */ .toByteArray()).thenApply((Function<Void, ResponseEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, D(jakarta.servlet.http.HttpServletRequest io.axoniq.axonserver.grpc.internal.HandlerLogMessage java.lang.Void ), (Ljava/lang/Void;)Lorg/springframework/http/ResponseEntity;)((HttpServletRequest)request, (HandlerLogMessage)this /* !! */ )).exceptionally((Function<Throwable, ResponseEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, D(java.lang.Throwable ), (Ljava/lang/Throwable;)Lorg/springframework/http/ResponseEntity;)());
            }
        }
    }

    private static /* synthetic */ ResponseEntity D(HttpServletRequest httpServletRequest, Void void_) {
        Object a2 = void_;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.D((HttpServletRequest)a3);
    }
}

