/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.api.IntegrationAPI;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.runtime.QueryHandler;
import io.axoniq.axonserver.configuration.runtime.QueryHandlers;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalQueryMessageHandler;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.Action;
import io.axoniq.axonserver.grpc.internal.HandlerLogMessage;
import io.axoniq.axonserver.integration.logconsumer.AdminQueryHandlerLogConsumer;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.transport.rest.v2.ValidationUtils;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@Tag(name="Integration Query Handlers", description="Operations to manage query handlers for integration endpoints")
public class IntegrationQueryHandlerRestControllerV2 {
    private static final Logger A = AuditLog.getLogger();
    private final QueryHandlers f;
    private final RaftGroupServiceFactory K;
    private final ObjectMapper e;

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Update a query handler", description="Update an existing query handler for a specific endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Update request accepted"), @ApiResponse(responseCode="400", description="Invalid input parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Query handler not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    @PutMapping(value={"v2/endpoints/{endpoint}/queryHandlers/{handler}"})
    public CompletableFuture<ResponseEntity<Object>> D(@RequestBody @Schema(description="Updated query handler details", requiredMode=Schema.RequiredMode.REQUIRED, implementation=IntegrationAPI.QueryHandler.class) IntegrationAPI.QueryHandler queryHandler, @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @PathVariable(value="handler") @Schema(description="Handler UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = object;
        Object object = queryHandler;
        IntegrationQueryHandlerRestControllerV2 queryHandler2 = integrationQueryHandlerRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void handlerId;
            void endpoint;
            ValidationUtils.D((String)endpoint);
            ValidationUtils.D((String)handlerId);
            IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV22 = object;
            ValidationUtils.D((String)integrationQueryHandlerRestControllerV22.name(), (String)IndexEntry.D((Object)"_S\\W"));
            ValidationUtils.D((String)object.name(), (int)200, (String)InternalQueryMessageHandler.D((Object)"l\u0019o\u001d"));
            ValidationUtils.D((String)integrationQueryHandlerRestControllerV22.queryUrl(), (int)2000, (String)IndexEntry.D((Object)"@GT@HgC^"));
            principal2 = (Principal)ObjectUtils.D((Object)principal2, (Object)GrpcContextAuthenticationProvider.f);
            if (A.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                A.info(InternalQueryMessageHandler.D((Object)"#y\u0005_XP\u001ds\rg\u000bvXv\u0017\"\rr\u001cc\fgXs\rg\n{Xj\u0019l\u001cn\u001dpXy\u0005\"\u0011lXg\u0016f\bm\u0011l\f\"\u0003\u007fV"), objectArray);
            }
            IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV23 = queryHandler2;
            object = integrationQueryHandlerRestControllerV23.e.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId((String)handlerId).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.UPDATE).build();
            return ((CompletableFuture)integrationQueryHandlerRestControllerV23.K.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminQueryHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationQueryHandlerRestControllerV2.D((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::D);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.D((Throwable)principal2));
        }
    }

    private static /* synthetic */ ResponseEntity D(HttpServletRequest httpServletRequest, HandlerLogMessage handlerLogMessage, Void void_) {
        HttpServletRequest a2 = handlerLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.D((HttpServletRequest)a3, (String)a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Register a query handler", description="Register a new query handler for a specific endpoint to handle incoming query requests")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Query handler successfully registered", content={@Content(schema=@Schema(implementation=IntegrationAPI.Id.class), mediaType="application/json")}), @ApiResponse(responseCode="400", description="Invalid input parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Endpoint not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    @PostMapping(value={"v2/endpoints/{endpoint}/queryHandlers"})
    public CompletableFuture<ResponseEntity<Object>> D(@RequestBody @Schema(description="Query handler details", requiredMode=Schema.RequiredMode.REQUIRED, implementation=IntegrationAPI.QueryHandler.class) IntegrationAPI.QueryHandler queryHandler, @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2) {
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = object;
        Object object = queryHandler;
        IntegrationQueryHandlerRestControllerV2 queryHandler2 = integrationQueryHandlerRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.D((String)endpoint);
            IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV22 = object;
            ValidationUtils.D((String)integrationQueryHandlerRestControllerV22.name(), (String)IndexEntry.D((Object)"_S\\W"));
            ValidationUtils.D((String)integrationQueryHandlerRestControllerV22.name(), (int)200, (String)InternalQueryMessageHandler.D((Object)"l\u0019o\u001d"));
            ValidationUtils.D((String)integrationQueryHandlerRestControllerV22.queryUrl(), (int)2000, (String)IndexEntry.D((Object)"@GT@HgC^"));
            principal2 = (Principal)ObjectUtils.D((Object)principal2, (Object)GrpcContextAuthenticationProvider.f);
            if (A.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                A.info(InternalQueryMessageHandler.D((Object)"#y\u0005_XP\u001ds\rg\u000bvXv\u0017\"\ng\u001fk\u000bv\u001dpXs\rg\n{Xj\u0019l\u001cn\u001dpXy\u0005\"\u0011lXg\u0016f\bm\u0011l\f\"\u0003\u007fV"), objectArray);
            }
            IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV23 = queryHandler2;
            object = integrationQueryHandlerRestControllerV23.e.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId(UUID.randomUUID().toString()).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.ADD).build();
            return ((CompletableFuture)integrationQueryHandlerRestControllerV23.K.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminQueryHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationQueryHandlerRestControllerV2.D((HttpServletRequest)request, (HandlerLogMessage)object, arg_0))).exceptionally(ValidationUtils::D);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.D((Throwable)principal2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/endpoints/{endpoint}/queryHandlers/{handler}"})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=IntegrationAPI.QueryHandler.class), mediaType="application/json")}), @ApiResponse(responseCode="400", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public ResponseEntity<Object> D(@PathVariable(value="endpoint") String string, @PathVariable(value="handler") String string2, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") String string3) {
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = object;
        Object object = string2;
        IntegrationQueryHandlerRestControllerV2 handlerId = integrationQueryHandlerRestControllerV2;
        try {
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.D((String)endpoint);
            ValidationUtils.D((String)object);
            principal2 = (Principal)ObjectUtils.D((Object)principal2, (Object)GrpcContextAuthenticationProvider.f);
            if (A.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                A.info(InternalQueryMessageHandler.D((Object)"Y\u0003\u007f%\"*g\tw\u001dq\f\"\fmXe\u001dvXs\rg\n{Xj\u0019l\u001cn\u001dpXy\u0005\"\u0011lXg\u0016f\bm\u0011l\f\"\u0003\u007fV"), objectArray);
            }
            if (!(object = (QueryHandler)handlerId.f.findById(UUID.fromString((String)object)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, IndexEntry.D((Object)"zP\\U^T@\u0011\\^F\u0011T^G_V")))).getEndpoint().getId().toString().equals(endpoint)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, IndexEntry.D((Object)"zP\\U^T@\u0011\\^F\u0011T^G_V\u0011[_\u0012T\\UB^[_F"));
            }
            if (!object.getEndpoint().getContext().equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, InternalQueryMessageHandler.D((Object)"J\u0019l\u001cn\u001dpXl\u0017vXd\u0017w\u0016fXk\u0016\"\u001bm\u0016v\u001dz\f"));
            }
            return ResponseEntity.ok((Object)new IntegrationAPI.QueryHandler(object.getName(), object.getQueryUrl()));
        }
        catch (MessagingPlatformException principal2) {
            return ValidationUtils.D((Throwable)principal2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Delete a query handler", description="Remove a query handler from a specific endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Query handler successfully deleted"), @ApiResponse(responseCode="400", description="Invalid input parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Query handler not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    @DeleteMapping(value={"v2/endpoints/{endpoint}/queryHandlers/{handler}"})
    public CompletableFuture<ResponseEntity<Object>> D(@PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @PathVariable(value="handler") @Schema(description="Handler UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = object;
        Object object = principal;
        IntegrationQueryHandlerRestControllerV2 principal2 = integrationQueryHandlerRestControllerV2;
        try {
            void a3;
            void handlerId;
            HandlerLogMessage endpoint;
            ValidationUtils.D((String)endpoint);
            ValidationUtils.D((String)handlerId);
            object = (Principal)ObjectUtils.D((Object)object, (Object)GrpcContextAuthenticationProvider.f);
            if (A.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)object.getName());
                objectArray[1] = StringUtils.sanitize((String)handlerId);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                A.info(IndexEntry.D((Object)"iJOl\u0012cW@GTAE\u0012E]\u0011VT^TFT\u0012@GT@H\u0012YS_V]WC\u0012JO\u0011[_\u0012T\\UB^[_F\u0011IL\u001c"), objectArray);
            }
            endpoint = HandlerLogMessage.newBuilder().setId((String)handlerId).setContext((String)a3).setEndpointId((String)endpoint).setAction(Action.DELETE).build();
            return ((CompletableFuture)principal2.K.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminQueryHandlerLogConsumer.class.getSimpleName(), endpoint.toByteArray()).thenApply(a2 -> ValidationUtils.D())).exceptionally(ValidationUtils::D);
        }
        catch (MessagingPlatformException this2) {
            return CompletableFuture.completedFuture(ValidationUtils.D((Throwable)this2));
        }
    }

    private static /* synthetic */ ResponseEntity D(HttpServletRequest httpServletRequest, Void void_) {
        Object a2 = void_;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.D((HttpServletRequest)a3);
    }

    /*
     * WARNING - void declaration
     */
    public IntegrationQueryHandlerRestControllerV2(ObjectMapper objectMapper, QueryHandlers queryHandlers, RaftGroupServiceFactory raftGroupServiceFactory) {
        void a2;
        void a3;
        IntegrationQueryHandlerRestControllerV2 a4;
        IntegrationQueryHandlerRestControllerV2 a5 = raftGroupServiceFactory;
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = a4 = this;
        a4.e = a3;
        integrationQueryHandlerRestControllerV2.f = a2;
        integrationQueryHandlerRestControllerV2.K = a5;
    }
}

