/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.google.common.util.concurrent.AtomicDouble;
import io.axoniq.axonserver.PrincipalAuthentication;
import io.axoniq.axonserver.accesscontrol.VisibleContexts;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.component.instance.PlatformClientComponents;
import io.axoniq.axonserver.metric.AxonServerMetric;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MetricCollector;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.transport.rest.v2.CounterMetric;
import io.axoniq.axonserver.transport.rest.v2.QueriesRestControllerV2;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.security.Principal;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
@RequestMapping(value={"v2/queries"})
@CrossOrigin
@Tag(name="Queries", description="Operations for monitoring and analyzing queries in Axon Server")
public class QueriesRestControllerV2 {
    private final PlatformClientComponents g;
    private final MetricCollector m;
    private static final MetricName A = BaseMetricName.M;
    private static final String f = "_all_";
    private final VisibleContexts K;
    private final MeterRegistry e;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean D(Set set, String string, Gauge gauge) {
        void a2;
        void a3;
        QueriesRestControllerV2 a4 = gauge;
        QueriesRestControllerV2 a5 = this;
        return a5.D((Meter)a4, (Set)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean D(Meter meter, Set<String> set, String string) {
        void a2;
        void a3;
        Object a4 = meter;
        QueriesRestControllerV2 a5 = this;
        a4 = a4.getId().getTag("context");
        return a5.D((String)a4, (Set)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    public QueriesRestControllerV2(MeterRegistry meterRegistry, MetricCollector metricCollector, VisibleContexts visibleContexts, PlatformClientComponents platformClientComponents) {
        QueriesRestControllerV2 a2;
        void a3;
        void a4;
        void a5;
        QueriesRestControllerV2 a6;
        QueriesRestControllerV2 queriesRestControllerV2 = queriesRestControllerV22;
        QueriesRestControllerV2 queriesRestControllerV22 = platformClientComponents;
        QueriesRestControllerV2 queriesRestControllerV23 = a6 = queriesRestControllerV2;
        QueriesRestControllerV2 queriesRestControllerV24 = a6;
        queriesRestControllerV24.e = a5;
        queriesRestControllerV24.m = a4;
        queriesRestControllerV23.K = a3;
        queriesRestControllerV23.g = a2;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(produces={"application/json"}, path={"metrics"})
    @Operation(summary="Get query metrics summary", description="Retrieves summarized metrics for query processing including average duration, count, errors, and active queries")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Query metrics summary retrieved successfully", content={@Content(schema=@Schema(implementation=QueryMetrics.class))})})
    public QueryMetrics D(@RequestParam(value="activeContext", required=false, defaultValue="_all_") @Schema(description="Context to filter metrics for. Use '_all_' for all contexts.", defaultValue="_all_") String string, @Parameter(hidden=true) Principal principal) {
        void activeContext;
        Set a2;
        QueriesRestControllerV2 queriesRestControllerV2;
        QueriesRestControllerV2 queriesRestControllerV22 = queriesRestControllerV2 = atomicLong;
        a2 = queriesRestControllerV22.K.visibleContexts(false, (Authentication)new PrincipalAuthentication((Principal)((Object)a2)));
        AtomicInteger atomicInteger = new AtomicInteger();
        queriesRestControllerV22.e.find(BaseMetricName.B.metric()).gauges().stream().filter(arg_0 -> queriesRestControllerV2.D(a2, (String)activeContext, arg_0)).forEach(gauge -> {
            AtomicInteger a2 = gauge;
            AtomicInteger a3 = atomicInteger;
            a3.addAndGet((int)a2.value());
        });
        AtomicInteger atomicInteger2 = new AtomicInteger();
        queriesRestControllerV2.e.find(BaseMetricName.V.metric()).counters().stream().filter(arg_0 -> queriesRestControllerV2.D(a2, (String)activeContext, arg_0)).forEach(counter -> {
            AtomicInteger a2 = counter;
            AtomicInteger a3 = atomicInteger2;
            a3.addAndGet((int)a2.count());
        });
        AtomicDouble atomicDouble = new AtomicDouble();
        AtomicLong atomicLong = new AtomicLong();
        queriesRestControllerV2.e.find(BaseMetricName.M.metric()).timers().stream().filter(arg_0 -> queriesRestControllerV2.D(a2, (String)activeContext, arg_0)).forEach(timer -> {
            void a2;
            AtomicDouble a3 = timer;
            AtomicDouble a4 = atomicDouble;
            a4.addAndGet(a3.totalTime(TimeUnit.MILLISECONDS));
            a2.addAndGet(a3.count());
        });
        double d2 = atomicLong.get() == 0L ? 0.0 : atomicDouble.get() / (double)atomicLong.get();
        return new QueryMetrics(d2, atomicLong.get(), atomicInteger2.get(), atomicInteger.get());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean L(Set set, String string, Timer timer) {
        void a2;
        void a3;
        QueriesRestControllerV2 a4 = timer;
        QueriesRestControllerV2 a5 = this;
        return a5.D((Meter)a4, (Set)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean D(Set set, String string, Timer timer) {
        void a2;
        void a3;
        QueriesRestControllerV2 a4 = timer;
        QueriesRestControllerV2 a5 = this;
        return a5.D((Meter)a4, (Set)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean D(Set set, String string, Counter counter) {
        void a2;
        void a3;
        QueriesRestControllerV2 a4 = counter;
        QueriesRestControllerV2 a5 = this;
        return a5.D((Meter)a4, (Set)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean D(String string, Set<String> set, String string2) {
        void a2;
        void a3;
        String a4 = string2;
        QueriesRestControllerV2 a5 = this;
        if (a3.contains(a2) && (a4.equals(f) || a4.equals(a2))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean D(Set set, String string, AxonServerMetric axonServerMetric) {
        void a2;
        void a3;
        QueriesRestControllerV2 a4 = axonServerMetric;
        QueriesRestControllerV2 a5 = this;
        return a5.D(a4.tag("context"), (Set)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(produces={"application/json"})
    @Operation(summary="List query metrics", description="Retrieves detailed metrics about query processing across contexts or for a specific context")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Query metrics retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=CounterMetric.class)))})})
    public Flux<CounterMetric> D(@RequestParam(value="activeContext", required=false, defaultValue="_all_") @Schema(description="Context to filter metrics for. Use '_all_' for all contexts.", defaultValue="_all_") String string, @Parameter(hidden=true) Principal principal) {
        void activeContext;
        QueriesRestControllerV2 a3;
        QueriesRestControllerV2 queriesRestControllerV2 = object;
        Object object = principal;
        QueriesRestControllerV2 queriesRestControllerV22 = a3 = queriesRestControllerV2;
        object = queriesRestControllerV22.K.visibleContexts(false, (Authentication)new PrincipalAuthentication((Principal)object));
        return Flux.fromStream(queriesRestControllerV22.e.find(A.metric()).timers().stream()).filter(arg_0 -> a3.L((Set)object, (String)activeContext, arg_0)).map(timer -> {
            QueriesRestControllerV2 a2 = timer;
            QueriesRestControllerV2 a3 = this;
            return new CounterMetric((Timer)a2, a3.g);
        }).filter(a2 -> {
            if (a2.getSource() != null) {
                return true;
            }
            return false;
        }).mergeWith((Publisher)Flux.fromIterable((Iterable)a3.m.getAll(A.metric(), Tags.empty())).filter(arg_0 -> a3.D((Set)object, (String)activeContext, arg_0)).map(axonServerMetric -> {
            QueriesRestControllerV2 a2 = axonServerMetric;
            QueriesRestControllerV2 a3 = this;
            return new CounterMetric((AxonServerMetric)a2, a3.g);
        }));
    }
}

