/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.migration.migrators;

import io.axoniq.axonserver.migration.source.EventProducer;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class EventMigratorStatisticsReporter {
    private static final Logger log = LoggerFactory.getLogger(EventMigratorStatisticsReporter.class);
    private final EventProducer eventProducer;
    private boolean enabled = true;
    private long startToken = 0L;
    private long lastProcessedToken = 0L;
    private long numberStored = 0L;
    private long numberSkipped = 0L;
    private Instant timeStarted;
    private long minGlobalIndex;
    private long maxGlobalIndex;

    public void initialize(long lastProcessedToken) {
        this.minGlobalIndex = this.eventProducer.getMinIndex();
        this.maxGlobalIndex = this.eventProducer.getMaxIndex();
        if (this.minGlobalIndex == -1L || this.maxGlobalIndex == -1L) {
            this.enabled = false;
            return;
        }
        this.lastProcessedToken = lastProcessedToken;
        this.startToken = lastProcessedToken;
        this.timeStarted = Instant.now();
        log.info("Starting migration with global index {}. So progress before starting was {}% of total", (Object)this.lastProcessedToken, (Object)this.tokenPercentage());
    }

    public void reportBatchSaved(long lastProcessedToken, int resultSize, int storedSize) {
        if (!this.enabled) {
            return;
        }
        this.numberStored += (long)storedSize;
        this.numberSkipped += (long)(resultSize - storedSize);
        this.lastProcessedToken = lastProcessedToken;
    }

    @Scheduled(fixedRate=5000L, initialDelay=1000L)
    public void report() {
        if (!this.enabled || this.timeStarted == null) {
            return;
        }
        log.info("Global index: {}. Migrated events: {}, Events to go: {}. Progress: {}, Skipped: {}, Stored: {}, Skipped percentage: {}", new Object[]{this.lastProcessedToken, this.lastProcessedToken - this.minGlobalIndex, this.maxGlobalIndex - this.lastProcessedToken, this.tokenPercentage(), this.numberSkipped, this.numberStored, this.percentage(this.numberSkipped, this.numberSkipped + this.numberStored)});
        long secondsSinceStart = ChronoUnit.SECONDS.between(this.timeStarted, Instant.now());
        if (secondsSinceStart < 1L) {
            return;
        }
        double rate = (this.lastProcessedToken - this.startToken) / secondsSinceStart;
        double secondsRemaining = (double)(this.maxGlobalIndex - this.startToken) / rate;
        log.info("Processing at average rate of {} events/sec (including skipped, since start). Projected hours remaining: {}", (Object)rate, (Object)(secondsRemaining / 3600.0));
    }

    private Double tokenPercentage() {
        long correctedMax = this.maxGlobalIndex - this.minGlobalIndex;
        long correctedCurrent = this.lastProcessedToken - this.minGlobalIndex;
        return this.percentage(correctedCurrent, correctedMax);
    }

    private Double percentage(long progress, long total) {
        return (double)progress / (double)total;
    }

    public EventMigratorStatisticsReporter(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

