/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.NodeAddress;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.transport.rest.v2.EventProcessorRestControllerV2;
import io.axoniq.axonserver.transport.rest.v2.ReplicationRestControllerV2;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class ClusterController
implements SmartLifecycle {
    private final CurrentNodeProvider J;
    private final AdminNodes d;
    private final Limits L;
    private final Logger G;
    private final ClusterTagsCache A;
    private final ApplicationEventPublisher B;
    private volatile boolean C;
    private final AdminConfigurationFactory j;
    private final MessagingPlatformConfiguration m;
    private final RemoteConnections c;

    public Stream<ClusterNode> activeNodes() {
        ClusterController a2;
        return a2.nodes().filter(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            return a3.isActive(a2.getName());
        });
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(String string, Integer n) {
        Integer a2 = n;
        ClusterController a3 = this;
        if (a3.c.size() + 1 >= a2) {
            void a4;
            throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + (String)a4);
        }
    }

    public boolean isAdminNode() {
        ClusterController a2;
        return a2.J.isAdmin();
    }

    public void deleteOtherNodes() {
        ClusterController a2;
        ClusterController clusterController = a2;
        a2.d.deleteAllByNameNot(clusterController.getName());
        clusterController.c.sync();
    }

    private /* synthetic */ void C(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if (a3.c.contains((String)a2) || a3.m.getName().equals(a2)) {
            return;
        }
        a3.L.getMaxClusterSize().ifPresent(arg_0 -> a3.C((String)a2, arg_0));
    }

    public void publishEvent(Object object) {
        Object a2 = object;
        ClusterController a3 = this;
        a3.B.publishEvent(a2);
    }

    public boolean isActive(String string) {
        String a2 = string;
        ClusterController a3 = this;
        if (a2.equals(a3.m.getName()) || a3.c.get(a2) != null && a3.c.get(a2).isConnected()) {
            return true;
        }
        return false;
    }

    public synchronized void handleRemoteConnection(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.C((NodeInfo)a3);
        clusterController.c.updateNodeInfo((NodeInfo)a3);
        clusterController.B.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected((NodeInfo)a3));
    }

    public boolean isRunning() {
        ClusterController a2;
        return a2.C;
    }

    private /* synthetic */ ClusterNode C(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.G.info(ReplicationRestControllerV2.C((Object)"\u001eU;\u00111^;T\u007fJ\""), (Object)a3);
        a3 = clusterController.j.clusterNode((NodeInfo)a3);
        return clusterController.d.save((ClusterNode)a3);
    }

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        ClusterController clusterController = a2;
        a3.C(clusterController.getNodeName());
        if (clusterController.getNodeName().equals(a3.m.getName())) {
            ClusterController clusterController2 = a3;
            clusterController2.G.info(ReplicationRestControllerV2.C((Object)"\u000bC&X1V\u007fE0\u00115^6_\u007fF6E7\u0011<D-C:_+\u00111^;T\u007f_>\\:\u000b\u007fJ\""), (Object)a2.getNodeName());
            return clusterController2.getMe();
        }
        if (a2.getInternalHostName().equals(a3.m.getInternalHostname()) && a2.getGrpcInternalPort() == a3.m.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, EventProcessorRestControllerV2.C((Object)"g_JPKJ\u0004TKWJ\u001eGRQMP[V\u001eSWPV\u0004MESA\u001eLQWJJ_I[\u0004_JZ\u0004WJJALJ_H\u001eTQVJ"));
        }
        ClusterNode clusterNode = a3.d.findById(a2.getNodeName()).orElseGet(() -> a3.C((NodeInfo)a2));
        if (!a3.c.contains(a2.getNodeName())) {
            a3.C((NodeInfo)a2);
        }
        return clusterNode;
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a2;
        return a2.d.findAll().peek(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            if (a2 == null) {
                return null;
            }
            a2.setTags(a3.A.getClusterTags().getOrDefault(a2.getName(), Collections.emptyMap()));
            return a2;
        });
    }

    public String getName() {
        ClusterController a2;
        return a2.getMe().getName();
    }

    public ClusterNode getNode(String string) {
        Object a2 = string;
        Object a3 = this;
        if (((String)a2).equals(a3.getName())) {
            return a3.getMe();
        }
        a2 = a3.d.findById((String)a2).orElseGet(() -> ((ClusterController)a3).C((String)a2));
        return a3.C((ClusterNode)a2);
    }

    private /* synthetic */ void C() {
        Object a2;
        ClusterController clusterController;
        ClusterController clusterController2 = clusterController = this;
        Object object = clusterController2.d.findById(clusterController2.m.getName());
        if (((Optional)object).isEmpty()) {
            if (clusterController.d.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = clusterController.m.getName();
                a2 = String.format(ReplicationRestControllerV2.C((Object)"r*C-T1E\u007f_0U:\u00111P2T\u007fY>B\u007fR7P1V:Us\u00111T(\u00111P2T\u007f\u0014,\u001f\u007fb+P-E\u007fp'^1b:C)T-\u0011(X+Y\u007fC:R0G:C&\u00119X3Tq"), objectArray);
                throw new FailedToStartException((String)a2);
            }
            ClusterController clusterController3 = clusterController;
            a2 = clusterController3.j.clusterNode(clusterController3.m.getName(), clusterController.m.getFullyQualifiedHostname(), clusterController.m.getFullyQualifiedInternalHostname(), clusterController.m.getPort(), clusterController.m.getInternalPort(), clusterController.m.getHttpPort());
            clusterController3.d.save((ClusterNode)a2);
            return;
        }
        a2 = (ClusterNode)((Optional)object).get();
        if (!a2.getInternalHostName().equals(clusterController.m.getFullyQualifiedInternalHostname()) || !a2.getGrpcInternalPort().equals(clusterController.m.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getInternalHostName();
            objectArray[1] = a2.getGrpcInternalPort();
            objectArray[2] = clusterController.m.getFullyQualifiedInternalHostname();
            objectArray[3] = clusterController.m.getInternalPort();
            object = String.format(EventProcessorRestControllerV2.C((Object)"gKVLAPP\u001eJQ@[\u0003M\u0004WJJALJ_H\u001eLQWJJ_I[\u000bNKLP\u001e\f\u001bW\u0004\u0001Z\r\u001eL_W\u001eGVEPC[@\u0012\u0004\u001eJ[S\u001eR_HKAM\u0004\u001bW\u0004\u0001Z\n\u001ewJELP\u001eeFKPw[VHAL\u0004IMJL\u001eV[GQR[VG\u0004XMRA\u0010"), objectArray);
            throw new FailedToStartException((String)object);
        }
    }

    private /* synthetic */ void C(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        if (a2.getNodeName().equals(a3.m.getName())) {
            return;
        }
        a3.c.connect((NodeInfo)a2, true);
    }

    /*
     * WARNING - void declaration
     */
    public NodeAddress nodeAddress(String string) {
        ClusterController a2;
        void a3;
        ClusterController clusterController = this;
        if (a3.equals(clusterController.getName())) {
            return new NodeAddress(clusterController.getMe());
        }
        RemoteConnection remoteConnection = clusterController.c.get((String)a3);
        ClusterNode clusterNode = a2 = remoteConnection == null ? (ClusterNode)clusterController.d.findById((String)a3).orElse(null) : remoteConnection.getClusterNode();
        if (a2 == null) {
            return null;
        }
        return new NodeAddress((ClusterNode)a2);
    }

    public int getPhase() {
        return 50;
    }

    private /* synthetic */ ClusterNode C(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if ((a2 = a3.c.get((String)a2)) == null) {
            return null;
        }
        return a2.getClusterNode();
    }

    public void closeConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.c.disconnect((String)a2);
    }

    public void stop() {
        a.C = false;
    }

    public Set<String> remoteNodeNames() {
        ClusterController a2;
        return a2.c.nodes();
    }

    public Optional<RemoteConnection> getRemoteConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        return Optional.ofNullable(a3.c.get((String)a2));
    }

    Stream<RemoteConnection> activeConnections() {
        ClusterController a2;
        return a2.c.activeConnections();
    }

    @Transactional
    public synchronized void deleteNode(String string) {
        ClusterController clusterController;
        ClusterController a2;
        Object a3 = string;
        ClusterController clusterController2 = a2 = this;
        clusterController2.G.info(EventProcessorRestControllerV2.C((Object)"zARAJA\u001eJQ@[\u001e\u001e_C"), a3);
        clusterController2.B.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested((String)a3));
        if (clusterController2.m.getName().equals(a3)) {
            ClusterController clusterController3 = a2;
            clusterController = clusterController3;
            clusterController3.d.deleteAllByNameNot((String)a3);
            clusterController3.c.closeAll();
        } else {
            a2.d.findById((String)a3).ifPresent(arg_0 -> a2.C((String)a3, arg_0));
            clusterController = a2;
        }
        clusterController.B.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted((String)a3));
        a2.c.sync();
    }

    public ClusterNode getMe() {
        ClusterController a2;
        ClusterController clusterController = a2;
        return clusterController.C((ClusterNode)clusterController.J.get());
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a2;
        return a2.c.connections();
    }

    /*
     * WARNING - void declaration
     */
    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, AdminNodes adminNodes, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, RemoteConnections remoteConnections, CurrentNodeProvider currentNodeProvider) {
        void remoteConnections2;
        void limits2;
        void applicationEventPublisher2;
        void clusterTagsCache2;
        void adminConfigurationFactory2;
        void clusterNodeRepository;
        void messagingPlatformConfiguration2;
        ClusterController a2;
        ClusterController clusterController = clusterController2;
        ClusterController clusterController2 = currentNodeProvider;
        ClusterController clusterController3 = a2 = clusterController;
        ClusterController clusterController4 = a2;
        ClusterController clusterController5 = a2;
        ClusterController clusterController6 = a2;
        a2.G = LoggerFactory.getLogger(ClusterController.class);
        clusterController6.m = messagingPlatformConfiguration2;
        clusterController6.d = clusterNodeRepository;
        clusterController5.j = adminConfigurationFactory2;
        clusterController5.A = clusterTagsCache2;
        clusterController4.B = applicationEventPublisher2;
        clusterController4.L = limits2;
        clusterController3.c = remoteConnections2;
        clusterController3.J = clusterController2;
    }

    private /* synthetic */ void C(String string, ClusterNode clusterNode) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.d.deleteById((String)a2);
    }

    @Transactional
    public void start() {
        ClusterController a2;
        a2.C();
        a2.C = true;
    }
}

