/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.cluster.grpc.LeaderElectionService;
import io.axoniq.axonserver.cluster.grpc.LogReplicationService;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalAuthenticationInterceptor;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.enterprise.replication.admin.ReplicationGroupChangesHandler;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AxonServerInternalService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="MessagingClusterServer")
public class MessagingClusterServer
implements SmartLifecycle {
    private final MessagingPlatformConfiguration l;
    private final Supplier<ScheduledExecutorService> K;
    private static final DataSize J = DataSize.ofMegabytes((long)32L);
    private final List<AxonServerInternalService> d;
    private AdvancedTlsX509KeyManager.Closeable L;
    private boolean G;
    private final LogReplicationService A;
    private final ExecutorService B;
    private final Logger C;
    private final ApplicationEventPublisher j;
    private final LeaderElectionService m;
    private Server c;

    /*
     * WARNING - void declaration
     */
    public MessagingClusterServer(MessagingPlatformConfiguration messagingPlatformConfiguration, LogReplicationService logReplicationService, LeaderElectionService leaderElectionService, List<AxonServerInternalService> list, Supplier<ScheduledExecutorService> supplier, ApplicationEventPublisher applicationEventPublisher) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        MessagingClusterServer a7;
        MessagingClusterServer a8 = messagingPlatformConfiguration;
        MessagingClusterServer messagingClusterServer = a7 = this;
        MessagingClusterServer messagingClusterServer2 = a7;
        MessagingClusterServer messagingClusterServer3 = a7;
        MessagingClusterServer messagingClusterServer4 = a7;
        messagingClusterServer4.C = LoggerFactory.getLogger(MessagingClusterServer.class);
        messagingClusterServer4.l = a8;
        messagingClusterServer3.A = a6;
        messagingClusterServer3.m = a5;
        messagingClusterServer2.d = a4;
        messagingClusterServer2.K = a3;
        messagingClusterServer.j = a2;
        messagingClusterServer.B = Executors.newFixedThreadPool(a8.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(ReplicationGroupChangesHandler.C((Object)"0\u0001&\u001e'\b!@6\u00156\u000e&\u0019<\u001f~")));
    }

    public int getPhase() {
        return 50;
    }

    public void stop() {
        MessagingClusterServer messagingClusterServer = this;
        if (messagingClusterServer.L != null) {
            messagingClusterServer.L.close();
        }
        messagingClusterServer.B.shutdown();
        try {
            if (!messagingClusterServer.c.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
                messagingClusterServer2.C.debug(SerializedEventWithToken.C((Object)"#\u001d\u0017\u0011\u0000\u0014\u0010\u001e\t\u000bE\u0001\u0011\u001d\u0015\u0002\f\u001c\u0002R&\u001e\u0010\u0001\u0011\u0017\u0017R6\u0017\u0017\u0004\u0000\u0000"));
                messagingClusterServer2.c.shutdownNow();
            }
        }
        catch (InterruptedException a2) {
            messagingClusterServer.C.debug(ReplicationGroupChangesHandler.C((Object)"$=\u00196\u001f!\u0018#\u00196\ts\t&\u001f:\u00034M \u0005&\u00197\u0002$\u0003s\u00025M:\u0003'\b!\u00032\u0001s,+\u0002=>6\u001f%\b!"), (Throwable)a2);
            Thread.currentThread().interrupt();
        }
        messagingClusterServer.G = false;
        messagingClusterServer.C.info(SerializedEventWithToken.C((Object)"$\n\n\u001cE!\u0000\u0000\u0013\u0017\u0017R&\u001e\u0010\u0001\u0011\u0017\u0017R6\u0017\u0017\u0004\u0000\u0000E\u0001\u0011\u001d\u0015\u0002\u0000\u0016"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        MessagingClusterServer messagingClusterServer = this;
        try {
            NettyServerBuilder nettyServerBuilder;
            MessagingClusterServer a2;
            String string = ReplicationGroupChangesHandler.C((Object)"\u0003<M\u0000>\u001f");
            if (messagingClusterServer.l.getSsl() != null && messagingClusterServer.l.getSsl().isEnabled()) {
                Object object = messagingClusterServer.l.getSsl().getInternalCertChainFile();
                if (object == null) {
                    throw new RuntimeException(SerializedEventWithToken.C((Object)"\u0013\u001d\u001d\u000b\u001b\u0014\\\u0004\n\n\u001c\u0016\u0017\u0017\u0004\u0000\u0000K\u0001\u0016\u001eK\u0011\u0000\u0000\u0011_\u0006\u001a\u0004\u001b\u000b_\u0003\u001b\t\u0017E\u001c\n\u0006E\u0001\u0000\u0006"));
                }
                Object object2 = messagingClusterServer.l.getSsl().getInternalPrivateKeyFile();
                if (object2 == null) {
                    throw new RuntimeException(ReplicationGroupChangesHandler.C((Object)"\f+\u0002=\u0004\"C2\u0015<\u0003 \b!\u001b6\u001f}\u001e \u0001}\u001d!\u0004%\f'\b~\u00066\u0014~\u000b:\u00016M=\u0002'M \b'"));
                }
                object2 = new File((String)object2);
                object = new File((String)object);
                if (!((File)object2).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object2).getCanonicalPath());
                }
                if (!((File)object).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object).getCanonicalPath());
                }
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                messagingClusterServer.L = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile((File)object2, (File)object, 1L, TimeUnit.MINUTES, (ScheduledExecutorService)messagingClusterServer.K.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                object = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.l.getInternalPort(), (ServerCredentials)object);
                string = SerializedEventWithToken.C((Object)"!6>E\u0017\u000b\u0013\u0007\u001e\u0000\u0016");
                nettyServerBuilder = a2;
            } else {
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.l.getInternalPort());
                nettyServerBuilder = a2;
            }
            nettyServerBuilder.permitKeepAliveTime(messagingClusterServer.l.getMinKeepAliveTime(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(true);
            a2.maxInboundMessageSize((int)Math.max(J.toBytes(), Math.min(Integer.MAX_VALUE, (long)messagingClusterServer.l.getMaxMessageSize() + DataSize.ofMegabytes((long)1L).toBytes())));
            a2.intercept((ServerInterceptor)new InternalAuthenticationInterceptor(messagingClusterServer.l));
            messagingClusterServer.d.forEach(arg_0 -> MessagingClusterServer.C((NettyServerBuilder)a2, arg_0));
            MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
            a2.addService((BindableService)messagingClusterServer.m);
            a2.addService((BindableService)messagingClusterServer2.A);
            if (messagingClusterServer2.l.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(messagingClusterServer.l.getKeepAliveTime(), TimeUnit.MILLISECONDS);
                a2.keepAliveTimeout(messagingClusterServer.l.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(messagingClusterServer.l.getGrpcBufferedMessages()));
            a2.executor((Executor)messagingClusterServer.B);
            if (Epoll.isAvailable()) {
                v3 = messagingClusterServer;
                a2.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(ReplicationGroupChangesHandler.C((Object)"0\u0001&\u001e'\b!@1\u0002 \u001e~"))));
                a2.workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(SerializedEventWithToken.C((Object)"\u0011\t\u0007\u0016\u0006\u0000\u0000H\u0005\n\u0000\u000e\u0017\u0017_"))));
                a2.channelType(EpollServerSocketChannel.class);
            } else {
                a2.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(ReplicationGroupChangesHandler.C((Object)"0\u0001&\u001e'\b!@1\u0002 \u001e~"))));
                a2.workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(SerializedEventWithToken.C((Object)"\u0011\t\u0007\u0016\u0006\u0000\u0000H\u0005\n\u0000\u000e\u0017\u0017_"))));
                a2.channelType(NioServerSocketChannel.class);
                v3 = messagingClusterServer;
            }
            v3.c = a2.build();
            messagingClusterServer.c.start();
            messagingClusterServer.C.info(ReplicationGroupChangesHandler.C((Object)"\u0012\u0015<\u0003s>6\u001f%\b!M\u0010\u0001&\u001e'\b!M\u0000\b!\u001b6\u001fs\u001e'\f!\u00196\ts\u0002=M#\u0002!\u0019iM(\u0010s@s\u0016."), (Object)messagingClusterServer.l.getInternalPort(), (Object)string);
            messagingClusterServer.j.publishEvent((Object)new ReplicationServerStarted());
            messagingClusterServer.G = true;
            return;
        }
        catch (Exception a2) {
            throw new FailedToStartException(SerializedEventWithToken.C((Object)"!\u0011\u0013\u0017\u0006\f\u001c\u0002R$\n\n\u001cE!\u0000\u0000\u0013\u0017\u0017R&\u001e\u0010\u0001\u0011\u0017\u0017R6\u0017\u0017\u0004\u0000\u0000E\u0014\u0004\u001b\t\u0017\u0001R"), (Throwable)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void C(NettyServerBuilder nettyServerBuilder, AxonServerInternalService axonServerInternalService) {
        void a2;
        NettyServerBuilder nettyServerBuilder2 = nettyServerBuilder;
        LinkedList a3 = new LinkedList(a2.interceptors());
        if (a2.requiresContextInterceptor()) {
            a3.add(new ContextInterceptor());
        }
        nettyServerBuilder2.addService(ServerInterceptors.intercept((BindableService)a2, (List)a3));
    }

    public boolean isAutoStartup() {
        return true;
    }

    public boolean isRunning() {
        MessagingClusterServer a2;
        return a2.G;
    }
}

