/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.LifecycleController;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.UpdateReplicationGroupPayload;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.StateChanged;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.RaftProperties;
import io.axoniq.axonserver.configuration.runtime.ReplicationGroupMember;
import io.axoniq.axonserver.enterprise.cluster.GrpcRaftGroupFactory;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.ContextReplicationIndexProvider;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftGroup;
import io.axoniq.axonserver.enterprise.replication.RaftGroupRepositoryManager;
import io.axoniq.axonserver.enterprise.replication.group.ReplicationGroupController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.plugin.PluginConfigurationSerializer;
import io.axoniq.axonserver.util.StringUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;

@Controller
public class GrpcRaftController
implements SmartLifecycle,
RaftGroupManager,
ContextReplicationIndexProvider {
    private final MessagingPlatformConfiguration g;
    private final FileSystemMonitor E;
    private final Map<String, RaftGroup> l;
    private final Map<String, Long> K;
    private final RaftProperties J;
    public static final String d = "replication-logs";
    private final ReplicationGroupController L;
    private volatile boolean G;
    private final GrpcRaftGroupFactory A;
    private final LifecycleController B;
    private final AtomicBoolean C;
    private final ApplicationEventPublisher j;
    private final Logger m;
    private final RaftGroupRepositoryManager c;

    public String getMyLabel(List<Node> list) {
        Object a2 = list;
        GrpcRaftController a3 = this;
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Node node = (Node)a2.next();
            if (!node.getNodeName().equals(a3.g.getName())) continue;
            return node.getNodeId();
        }
        throw new RuntimeException(UpdateReplicationGroupPayload.C((Object)"\u0005\u00053\u0006\"J(\u00052J \u0003(\u000ef\t3\u00184\u000f(\u001ef\u0004)\u000e#J/\u0004f\u0004)\u000e#\u0019"));
    }

    public Collection<String> getRaftGroups() {
        GrpcRaftController a2;
        return a2.l.keySet();
    }

    private /* synthetic */ boolean C(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (a3.K.getOrDefault(a2, 0L) > System.currentTimeMillis()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(RaftNode raftNode, StateChanged stateChanged) {
        void a2;
        void a3;
        GrpcRaftController grpcRaftController = this;
        void v0 = a3;
        Object a4 = v0.C();
        long l2 = a2.I();
        if (v0.M() && !a3.h()) {
            grpcRaftController.j.publishEvent((Object)new ClusterEvents.LeaderStepDown((String)a4, l2));
            return;
        }
        if (a3.h() && !a3.M()) {
            grpcRaftController.j.publishEvent((Object)new ClusterEvents.BecomeLeader((String)a4, () -> ((RaftNode)a2).C(), l2));
            return;
        }
        if (a3.g()) {
            grpcRaftController.j.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a4, null, l2));
            return;
        }
        if (!StringUtils.isEmpty((String)a2.C())) {
            grpcRaftController.j.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a4, a2.C(), l2));
        }
    }

    public int getPhase() {
        return 100;
    }

    public Optional<RaftNode> raftNode(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if ((a2 = (RaftGroup)a3.l.get(a2)) != null) {
            return Optional.of(a2.localNode());
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public RaftNode getOrCreateRaftNode(String string, String string2) {
        void a2;
        GrpcRaftController grpcRaftController = this;
        if (!grpcRaftController.G) {
            throw new IllegalStateException(UpdateReplicationGroupPayload.C((Object)"9#\u00180\u000f4J5\u001e'\u00182\u001f6E5\u00023\u001e\"\u00051\u0004f\u0003(J6\u0018)\r4\u000f5\u0019"));
        }
        GrpcRaftController a3 = (RaftGroup)grpcRaftController.l.get(a2);
        if (a3 != null) {
            return a3.localNode();
        }
        Map map = grpcRaftController.l;
        synchronized (map) {
            a3 = (RaftGroup)grpcRaftController.l.get(a2);
            if (a3 == null) {
                void a4;
                if (grpcRaftController.C((String)a2)) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, PluginConfigurationSerializer.C((Object)"E/g&~)v>~%yjp8x?gjs/{/c#x$7#yjg8x-e/d9"));
                }
                a3 = grpcRaftController.C((String)a2, (String)a4);
                a3.startAndWait(null);
            }
        }
        return a3.localNode();
    }

    public RaftNode getRaftNode(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (!a3.G) {
            throw new IllegalStateException(UpdateReplicationGroupPayload.C((Object)"\u000f\u0004/\u001e/\u000b*\u0003<\u000b2\u0003)\u0004f\u00054J5\u00023\u001e\"\u00051\u0004f\u0003(J6\u0018)\r4\u000f5\u0019"));
        }
        if (!a3.l.containsKey(a2)) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.g.getName() + ": Not a member of " + (String)a2);
        }
        return ((RaftGroup)a3.l.get(a2)).localNode();
    }

    /*
     * WARNING - void declaration
     */
    public void prepareDeleteNodeFromReplicationGroup(String string, String string2) {
        void a2;
        GrpcRaftController a3;
        Object a4 = string2;
        GrpcRaftController grpcRaftController = a3 = this;
        grpcRaftController.c.prepareDeleteNodeFromReplicationGroup((String)a2, (String)a4);
        grpcRaftController.j.publishEvent((Object)new ClusterEvents.DeleteNodeFromReplicationGroupRequested((String)a2, (String)a4));
    }

    /*
     * WARNING - void declaration
     */
    public GrpcRaftController(MessagingPlatformConfiguration messagingPlatformConfiguration, RaftProperties raftProperties, RaftGroupRepositoryManager raftGroupRepositoryManager, ApplicationEventPublisher applicationEventPublisher, ReplicationGroupController replicationGroupController, GrpcRaftGroupFactory grpcRaftGroupFactory, FileSystemMonitor fileSystemMonitor, LifecycleController lifecycleController) {
        GrpcRaftController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        GrpcRaftController a10;
        GrpcRaftController grpcRaftController = grpcRaftController2;
        GrpcRaftController grpcRaftController2 = lifecycleController;
        GrpcRaftController grpcRaftController3 = a10 = grpcRaftController;
        GrpcRaftController grpcRaftController4 = a10;
        GrpcRaftController grpcRaftController5 = a10;
        GrpcRaftController grpcRaftController6 = a10;
        GrpcRaftController grpcRaftController7 = a10;
        a10.m = LoggerFactory.getLogger(GrpcRaftController.class);
        GrpcRaftController grpcRaftController8 = a10;
        grpcRaftController7.l = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController9 = a10;
        grpcRaftController8.K = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController10 = a10;
        grpcRaftController7.C = new AtomicBoolean();
        grpcRaftController6.g = a9;
        grpcRaftController6.c = a8;
        grpcRaftController5.L = a7;
        grpcRaftController5.J = a6;
        grpcRaftController4.j = a5;
        grpcRaftController4.A = a4;
        grpcRaftController3.E = a3;
        grpcRaftController3.B = a2;
    }

    public boolean ready() {
        GrpcRaftController a2;
        return a2.C.get();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(ReplicationGroupMember replicationGroupMember, AtomicInteger atomicInteger, Void void_, Throwable throwable) {
        Object a2;
        GrpcRaftController grpcRaftController = object;
        Object object = throwable;
        GrpcRaftController a3 = grpcRaftController;
        if (a2 == null) {
            void a4;
            a3.m.info(UpdateReplicationGroupPayload.C((Object)"\u0011;Pf8#\u001a*\u0003%\u000b2\u0003)\u0004f\r4\u00053\u001af\u00192\u000b4\u001e#\u000e"), (Object)a.groupId());
            if (a4.decrementAndGet() == 0) {
                GrpcRaftController grpcRaftController2 = a3;
                grpcRaftController2.B.setCleanShutdown();
                grpcRaftController2.C.set(true);
                return;
            }
        } else {
            a3.m.warn(PluginConfigurationSerializer.C((Object)"l7-jE/g&~)v>~%yjp8x?gjd>v8cjq+~&r."), (Object)a.groupId(), a2);
        }
    }

    private /* synthetic */ void C(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        a3.K.put(a2, System.currentTimeMillis() + 2L * (long)a3.J.getMaxElectionTimeout());
    }

    public Iterable<String> getAllNonAdminContexts() {
        GrpcRaftController a2;
        return a2.c.contexts();
    }

    public void start() {
        GrpcRaftController grpcRaftController = this;
        Object a2 = new File(grpcRaftController.J.getLogStorageFolder());
        GrpcRaftController grpcRaftController2 = grpcRaftController;
        FileUtils.C((File)a2);
        grpcRaftController2.E.registerPath(d, ((File)a2).toPath(), grpcRaftController.J.minFreeSpace(), grpcRaftController.J.warnFreeSpace());
        a2 = grpcRaftController2.c.getMyReplicationGroups();
        a2.forEach(replicationGroupMember -> {
            GrpcRaftController a2 = replicationGroupMember;
            GrpcRaftController a3 = this;
            a3.C(a2.groupId(), a2.nodeId());
        });
        grpcRaftController.G = true;
        AtomicInteger atomicInteger = new AtomicInteger(a2.size());
        a2.forEach(replicationGroupMember -> {
            GrpcRaftController a2 = replicationGroupMember;
            GrpcRaftController a3 = this;
            try {
                void a4;
                GrpcRaftController grpcRaftController = a3;
                grpcRaftController.m.info(UpdateReplicationGroupPayload.C((Object)"=\u0017|J\u0014\u000f6\u0006/\t'\u001e/\u0005(J!\u0018)\u001f6J5\u001e'\u00182\u0003(\r"), (Object)a2.groupId());
                ((RaftGroup)grpcRaftController.l.get(a2.groupId())).start(a2.role()).whenComplete((arg_0, arg_1) -> a3.C((ReplicationGroupMember)a2, (AtomicInteger)a4, arg_0, arg_1));
                return;
            }
            catch (Exception a4) {
                a3.m.warn(PluginConfigurationSerializer.C((Object)"1jp7\fv#{/sjc%7#y#c#v&~0rje/g&~)v>~%y\re%b:"), (Object)a2.groupId(), (Object)a4);
                return;
            }
        });
        grpcRaftController.m.info(PluginConfigurationSerializer.C((Object)"E/g&~)v>~%yjp8x?gjt%y>e%{&r878b$y#y-"));
        if (a2.isEmpty()) {
            grpcRaftController.C.set(true);
        }
    }

    public int electionTimeout() {
        GrpcRaftController a2;
        return a2.J.getMaxElectionTimeout();
    }

    public RaftNode waitForLeader(RaftGroup raftGroup) {
        GrpcRaftController a2 = raftGroup;
        GrpcRaftController a3 = this;
        GrpcRaftController grpcRaftController = a2;
        while (!grpcRaftController.localNode().d() || a2.logEntryProcessor().C() == 0L) {
            try {
                Thread.sleep(100L);
                grpcRaftController = a2;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(PluginConfigurationSerializer.C((Object)"^$c/e8b:cj`\"~&rj`+~>~$pjc%7(r)x'rj{/v.r8"));
            }
        }
        return a2.localNode();
    }

    /*
     * WARNING - void declaration
     */
    public RaftGroup initRaftGroup(String string, String string2, String string3) {
        void a2;
        Node a3;
        Object a4 = string2;
        GrpcRaftController a5 = this;
        a3 = Node.newBuilder().setNodeId((String)a4).setHost(a5.g.getFullyQualifiedInternalHostname()).setPort(a5.g.getInternalPort()).setNodeName((String)a3).setRole(Role.PRIMARY).build();
        GrpcRaftController grpcRaftController = a5;
        a4 = grpcRaftController.C((String)a2, (String)a4);
        a4.raftConfiguration().update(Collections.singletonList(a3));
        grpcRaftController.m.debug(UpdateReplicationGroupPayload.C((Object)"92\u000b4\u001ef\f4\u0005+J/\u0004/\u001e\u0014\u000b \u001e\u0001\u0018)\u001f6J=\u0017"), (Object)a2);
        Object object = a4;
        object.startAndWait(Role.PRIMARY);
        return object;
    }

    public RaftNode getRaftNodeForContext(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.L.findReplicationGroupByContext((String)a2).map(arg_0 -> a3.getRaftNode(arg_0)).orElseThrow(() -> a3.C((String)a2));
    }

    public RaftGroup getRaftGroup(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return (RaftGroup)a3.l.get(a2);
    }

    public String getMyName() {
        GrpcRaftController a2;
        return a2.g.getName();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(RaftGroup raftGroup, StateChanged stateChanged) {
        void a2;
        GrpcRaftController a3 = stateChanged;
        GrpcRaftController a4 = this;
        a4.C(a2.localNode(), (StateChanged)a3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private /* synthetic */ RaftGroup C(String string, String string2) {
        Object a2 = string2;
        GrpcRaftController a3 = this;
        Map map = a3.l;
        synchronized (map) {
            void a4;
            block4: {
                GrpcRaftController grpcRaftController = a3;
                grpcRaftController.m.info(PluginConfigurationSerializer.C((Object)"l7-j~$~>78r:{#t+c#x$7-e%b:"), (Object)a4);
                RaftGroup raftGroup = (RaftGroup)grpcRaftController.l.get(a4);
                if (raftGroup == null) break block4;
                return raftGroup;
            }
            a2 = a3.A.create((String)a4, (String)a2);
            a2.localNode().I(arg_0 -> a3.C((RaftGroup)a2, arg_0));
            a3.l.put(a4, a2);
            return a2;
        }
    }

    private /* synthetic */ Object C(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.getRaftNodeForContext((String)a2).C().localLogEntryStore().lastLogIndex();
    }

    private /* synthetic */ MessagingPlatformException C(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.g.getName() + ": Not a member of " + (String)a2);
    }

    @Scheduled(fixedDelay=1000L)
    public void syncStore() {
        GrpcRaftController a2;
        if (a2.G) {
            a2.l.forEach((string, raftGroup) -> {
                String a2 = raftGroup;
                String a3 = string;
                ((GrpcRaftGroup)a2).C();
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public void delete(String string, boolean bl) {
        void a2;
        Object a3 = string;
        GrpcRaftController a4 = this;
        if (a2 == false) {
            a4.C((String)a3);
        }
        a4.l.remove(a3);
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.L.deleteReplicationGroup((String)a3, (boolean)a2);
        grpcRaftController.j.publishEvent((Object)new ClusterEvents.ReplicationGroupDeleted((String)a3, (boolean)a2));
    }

    public boolean isRunning() {
        GrpcRaftController a2;
        return a2.G;
    }

    public long lastReplicationIndex(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        a3.m.atInfo().addArgument(a2).addArgument(() -> a3.C((String)a2)).log(PluginConfigurationSerializer.C((Object)"\u0006v9cje/g&~)v>~%yj~$s/ojq%ejt%y>r2cjl77#djl7"));
        return a3.getRaftNodeForContext((String)a2).C().localLogEntryStore().lastLogIndex();
    }

    public void stop() {
        GrpcRaftController a2;
        GrpcRaftController grpcRaftController = a2;
        grpcRaftController.E.unregisterPath(d);
        grpcRaftController.l.forEach((string, raftGroup) -> {
            String a2 = raftGroup;
            String a3 = string;
            a2.stop();
        });
        a2.G = false;
    }

    public Set<String> raftGroups() {
        GrpcRaftController a2;
        return a2.l.keySet();
    }

    public boolean isHealthy(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.getRaftNodeForContext((String)a2).g();
    }
}

