/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.admin;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.internal.AddressValidator;
import io.axoniq.axonserver.enterprise.replication.admin.LeaderElectionCheck;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.enterprise.replication.logconsumer.AdminNodeConsumer;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.DeleteNode;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.grpc.internal.UpdateLicense;
import io.axoniq.axonserver.licensing.LicenseManager;
import io.axoniq.axonserver.message.query.subscription.SubscriptionQueryDispatcher;
import io.axoniq.axonserver.rest.json.QueryResponseJson;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.axoniq.axonserver.taskscheduler.task.NodeContext;
import io.axoniq.axonserver.taskscheduler.task.PrepareDeleteNodeFromContextTask;
import io.axoniq.axonserver.taskscheduler.task.UnregisterNodeTask;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ClusterChangesHandler {
    private final AddressValidator G;
    private final FeatureChecker A;
    private final TaskPublisher B;
    private final Logger C;
    private final RaftGroupServiceFactory j;
    private final LicenseManager m;
    private final ClusterController c;

    public void deleteNode(String string) {
        String a2 = string;
        ClusterChangesHandler a3 = this;
        ClusterNode clusterNode = a3.c.getNode(a2);
        if (clusterNode == null) {
            a3.C.info(SubscriptionQueryDispatcher.C((Object)"o\u0014G\u0014_\u0014\u000b?D\u0015NK\u000b\nVQ\u0006Qe\u001eO\u0014\u000b\u001fD\u0005\u000b\u0017D\u0004E\u0015\u0005"), (Object)a2);
            return;
        }
        for (AdminReplicationGroupMember adminReplicationGroupMember2 : clusterNode.getReplicationGroups()) {
            if (LeaderElectionCheck.C((ClusterController)a3.c, (AdminReplicationGroup)adminReplicationGroupMember2.getReplicationGroup(), (String)a2)) continue;
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, "Cannot delete node at this moment, without the node there is no leader for " + adminReplicationGroupMember2.getReplicationGroup().getName());
        }
        a3.B.publishScheduledTask(RaftAdminGroup.C(), UnregisterNodeTask.class.getName(), (Object)a2, Duration.ofSeconds(1L));
        if (a2.equals(a3.c.getName())) {
            a3.C(Duration.ofSeconds(3L));
        }
        clusterNode.getReplicationGroups().forEach(adminReplicationGroupMember -> {
            void a2;
            ClusterChangesHandler a3 = adminReplicationGroupMember;
            ClusterChangesHandler a4 = this;
            a4.B.publishScheduledTask(RaftAdminGroup.C(), PrepareDeleteNodeFromContextTask.class.getName(), (Object)new NodeContext((String)a2, a3.getReplicationGroup().getName(), true), Duration.ZERO);
        });
    }

    /*
     * WARNING - void declaration
     */
    public ClusterChangesHandler(ClusterController clusterController, TaskPublisher taskPublisher, RaftGroupServiceFactory raftGroupServiceFactory, FeatureChecker featureChecker, AddressValidator addressValidator, LicenseManager licenseManager) {
        ClusterChangesHandler a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ClusterChangesHandler a8;
        ClusterChangesHandler clusterChangesHandler = clusterChangesHandler2;
        ClusterChangesHandler clusterChangesHandler2 = licenseManager;
        ClusterChangesHandler clusterChangesHandler3 = a8 = clusterChangesHandler;
        ClusterChangesHandler clusterChangesHandler4 = a8;
        ClusterChangesHandler clusterChangesHandler5 = a8;
        a8.C = LoggerFactory.getLogger(ClusterChangesHandler.class);
        clusterChangesHandler5.c = a7;
        clusterChangesHandler5.B = a6;
        clusterChangesHandler4.j = a5;
        clusterChangesHandler4.A = a4;
        clusterChangesHandler3.G = a3;
        clusterChangesHandler3.m = a2;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteNodeIfEmpty(String string) {
        void a3;
        ClusterChangesHandler clusterChangesHandler = this;
        ClusterChangesHandler a4 = clusterChangesHandler.c.getNode((String)a3);
        if (a4 == null) {
            return;
        }
        if (a4.getReplicationGroups().stream().anyMatch(a2 -> {
            if (a2.getReplicationGroup() != null) {
                if (a2.getReplicationGroup().getMembers().size() > 1) {
                    return true;
                }
            }
            return false;
        })) {
            throw new TransientException(QueryResponseJson.C((Object)" T\n^NH\u001aR\u0002WNV\u000bV\f^\u001c\u001b\u0001]NX\u0001U\u001a^\u0016O\u001d\u0015"));
        }
        clusterChangesHandler.j.appendToAdminAndWait(DeleteNode.class.getName(), DeleteNode.newBuilder().setNodeName((String)a3).build().toByteArray());
    }

    /*
     * WARNING - void declaration
     */
    public UpdateLicense join(NodeInfo nodeInfo) {
        void a2;
        ClusterChangesHandler clusterChangesHandler = this;
        clusterChangesHandler.A.getMaxClusterSize().ifPresent(n -> {
            Integer a2 = n;
            ClusterChangesHandler a3 = this;
            if (a3.c.nodes().count() >= (long)a2.intValue()) {
                throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached: " + a3.A.getMaxClusterSize());
            }
        });
        ClusterChangesHandler clusterChangesHandler2 = clusterChangesHandler;
        Object a3 = clusterChangesHandler2.j.getLeader(RaftAdminGroup.C());
        if (!clusterChangesHandler2.c.getName().equals(a3)) {
            throw new MessagingPlatformException(ErrorCode.NODE_IS_REPLICA, "Send join request to the leader of _admin context: " + (String)a3);
        }
        a3 = clusterChangesHandler.c.getNode(a2.getNodeName());
        if (!(a3 == null || a3.getInternalHostName().equals(a2.getInternalHostName()) && a3.getGrpcInternalPort().equals(a2.getGrpcInternalPort()))) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, QueryResponseJson.C((Object)"/\u001b\u0000T\n^NL\u0007O\u0006\u001b\u001aS\u000b\u001b\u001dZ\u0003^NU\u000fV\u000b\u001b\u000fU\n\u001b\nR\b]\u000bI\u000bU\u001a\u001b\u0007U\u001a^\u001cU\u000fWNS\u0001H\u001a\u001b\u0000Z\u0003^NZ\u0000_NK\u0001I\u001a\u001b\u000fW\u001c^\u000f_\u0017\u001b\u000bC\u0007H\u001aH"));
        }
        ClusterChangesHandler clusterChangesHandler3 = clusterChangesHandler;
        clusterChangesHandler3.G.validateAddress(a2.getInternalHostName(), a2.getGrpcInternalPort());
        a3 = clusterChangesHandler3.C();
        clusterChangesHandler3.j.appendToAdminAndWait(AdminNodeConsumer.class.getName(), a2.toByteArray());
        return UpdateLicense.newBuilder().setLicense(ByteString.copyFrom((byte[])a3)).build();
    }

    private /* synthetic */ byte[] C() {
        ClusterChangesHandler a2;
        return a2.m.readLicense();
    }

    private /* synthetic */ void C(Duration duration) {
        Duration a22 = duration;
        ClusterChangesHandler a3 = this;
        try {
            Thread.sleep(a22.toMillis());
            return;
        }
        catch (InterruptedException a22) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(a22);
        }
    }

    public static String C(Object object) {
        Object object2 = object;
        object2 = (String)object2;
        int n = ((String)object2).length();
        int a2 = n - 1;
        char[] cArray = new char[n];
        int n2 = 5 << 4 ^ (2 << 2 ^ 3);
        int cfr_ignored_0 = 4 << 4 ^ 1;
        int n3 = a2;
        int n4 = (3 ^ 5) << 3 ^ 5;
        while (n3 >= 0) {
            int n5 = a2--;
            cArray[n5] = (char)(((String)object2).charAt(n5) ^ n4);
            if (a2 < 0) break;
            int n6 = a2--;
            cArray[n6] = (char)(((String)object2).charAt(n6) ^ n2);
            n3 = a2;
        }
        return new String(cArray);
    }
}

