/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.diagnostics.DiagnosticsService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.manager.LeaderEventStoreLocator;
import io.axoniq.axonserver.enterprise.replication.ContextLeaderProvider;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.ClusterMetric;
import io.axoniq.axonserver.metric.MetricCollector;
import io.axoniq.axonserver.topology.Topology;
import io.grpc.Attributes;
import io.grpc.Grpc;
import io.grpc.ServerTransportFilter;
import io.grpc.Status;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ConnectedApplicationsFilter
extends ServerTransportFilter {
    private final AtomicInteger G;
    private final FeatureChecker A;
    private final String B;
    private final MetricCollector C;
    private final ContextLeaderProvider j;
    private final Logger m;
    private final Map<String, List<UUID>> c;

    @EventListener
    public void on(ClusterEvents.ContextLeaderStepDown contextLeaderStepDown) {
        ConnectedApplicationsFilter a2;
        ConnectedApplicationsFilter a3 = contextLeaderStepDown;
        ConnectedApplicationsFilter connectedApplicationsFilter = a2 = this;
        connectedApplicationsFilter.G.addAndGet(-connectedApplicationsFilter.c.getOrDefault(a3.context(), List.of()).size());
        a2.m.debug(LeaderEventStoreLocator.C((Object)"R\u0013\t\u000fY\u001eE\u0007J\u000f]\u0007F\u0000ZNJ\u0001G\u0000L\r]\u000bMNE\u0001J\u000fE\u0002P"), (Object)a2.G);
    }

    public void transportTerminated(Attributes attributes) {
        ConnectedApplicationsFilter a2 = attributes;
        ConnectedApplicationsFilter a3 = this;
        a3.G.decrementAndGet();
    }

    @EventListener
    public void on(TopologyEvents.EndpointConnected endpointConnected) {
        ConnectedApplicationsFilter a3 = endpointConnected;
        ConnectedApplicationsFilter a4 = this;
        if (a4.B.equals(a3.I())) {
            a4.c.computeIfAbsent(a3.g(), a2 -> new CopyOnWriteArrayList()).add(a3.C());
            if (a4.j.isLeader(a3.g())) {
                a4.G.incrementAndGet();
            }
        }
        a4.m.debug(DiagnosticsService.C((Object)"\u0019[BG\u0012V\u000eO\u0001G\u0016O\rH\u0011\u0006\u0001I\fH\u0007E\u0016C\u0006\u0006\u000eI\u0001G\u000eJ\u001b"), (Object)a4.G);
    }

    public boolean allowNewConnection() {
        int a2;
        ConnectedApplicationsFilter connectedApplicationsFilter = this;
        int n = (int)((ClusterMetric)connectedApplicationsFilter.C.apply((Object)BaseMetricName.Y.metric(), (Object)Tags.empty())).value();
        if (n + (a2 = connectedApplicationsFilter.G.incrementAndGet()) < connectedApplicationsFilter.A.maxConnections()) {
            return true;
        }
        return false;
    }

    @EventListener
    public void on(TopologyEvents.EndpointDisconnected endpointDisconnected) {
        ConnectedApplicationsFilter a2 = endpointDisconnected;
        ConnectedApplicationsFilter a3 = this;
        if (a3.B.equals(a2.C())) {
            a3.c.getOrDefault(a2.I(), Collections.emptyList()).remove(a2.C());
            if (a3.j.isLeader(a2.I())) {
                a3.G.decrementAndGet();
            }
        }
        a3.m.debug(LeaderEventStoreLocator.C((Object)"R\u0013\t\u000fY\u001eE\u0007J\u000f]\u0007F\u0000ZNJ\u0001G\u0000L\r]\u000bMNE\u0001J\u000fE\u0002P"), (Object)a3.G);
    }

    /*
     * WARNING - void declaration
     */
    public Attributes transportReady(Attributes attributes) {
        void a2;
        ConnectedApplicationsFilter connectedApplicationsFilter = this;
        int a3 = (int)((ClusterMetric)connectedApplicationsFilter.C.apply((Object)BaseMetricName.Y.metric(), (Object)Tags.empty())).value();
        ConnectedApplicationsFilter connectedApplicationsFilter2 = connectedApplicationsFilter;
        int n = connectedApplicationsFilter2.G.incrementAndGet();
        connectedApplicationsFilter2.m.debug(LeaderEventStoreLocator.C((Object)"\u0015TNH\u001eY\u0002@\rH\u001a@\u0001G\u001d\t\rF\u0000G\u000bJ\u001aL\n\t\u0002F\rH\u0002E\u0017\u0005NR\u0013\t\u001cL\u0003F\u001aL\u0002P"), (Object)connectedApplicationsFilter.G, (Object)a3);
        if (a3 + n > connectedApplicationsFilter.A.maxConnections()) {
            connectedApplicationsFilter.m.warn(DiagnosticsService.C((Object)"t\u0007@\u0017U\u0007BBE\rH\fC\u0001R\u000bI\f\u0006\u0004T\rKB]\u001f\nBR\rIBK\u0003H\u001b\u0006J]\u001f\u000fBI\u0012C\f\u0006\u0001I\fH\u0007E\u0016O\rH\u0011"), a2.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR), (Object)(a3 + n));
            throw Status.RESOURCE_EXHAUSTED.withDescription(LeaderEventStoreLocator.C((Object)"}\u0001FND\u000fG\u0017\t\u0001Y\u000bGNJ\u0001G\u0000L\r]\u0007F\u0000Z")).asRuntimeException();
        }
        return a2;
    }

    @EventListener
    public void on(ClusterEvents.BecomeContextLeader becomeContextLeader) {
        ConnectedApplicationsFilter a2;
        ConnectedApplicationsFilter a3 = becomeContextLeader;
        ConnectedApplicationsFilter connectedApplicationsFilter = a2 = this;
        connectedApplicationsFilter.G.addAndGet(connectedApplicationsFilter.c.getOrDefault(a3.context(), List.of()).size());
        a2.m.debug(DiagnosticsService.C((Object)"\u0019[BG\u0012V\u000eO\u0001G\u0016O\rH\u0011\u0006\u0001I\fH\u0007E\u0016C\u0006\u0006\u000eI\u0001G\u000eJ\u001b"), (Object)a2.G);
    }

    /*
     * WARNING - void declaration
     */
    public ConnectedApplicationsFilter(MeterRegistry meterRegistry, MetricCollector metricCollector, ContextLeaderProvider contextLeaderProvider, Topology topology, FeatureChecker featureChecker) {
        void a2;
        void a3;
        ConnectedApplicationsFilter a4;
        void a5;
        void a6;
        ConnectedApplicationsFilter a7;
        ConnectedApplicationsFilter connectedApplicationsFilter = connectedApplicationsFilter2;
        ConnectedApplicationsFilter connectedApplicationsFilter2 = featureChecker;
        ConnectedApplicationsFilter connectedApplicationsFilter3 = a7 = connectedApplicationsFilter;
        ConnectedApplicationsFilter connectedApplicationsFilter4 = a7;
        ConnectedApplicationsFilter connectedApplicationsFilter5 = a7;
        a7.G = new AtomicInteger();
        ConnectedApplicationsFilter connectedApplicationsFilter6 = a7;
        connectedApplicationsFilter5.c = new ConcurrentHashMap();
        a7.m = AuditLog.getLogger();
        connectedApplicationsFilter4.C = a6;
        connectedApplicationsFilter4.j = a5;
        connectedApplicationsFilter3.A = a4;
        connectedApplicationsFilter3.B = a3.getName();
        Gauge.builder((String)BaseMetricName.Y.metric(), a7.G::get).description(BaseMetricName.Y.description()).register((MeterRegistry)a2);
    }
}

