/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.AxonServerAccessController;
import io.axoniq.axonserver.LicenseAccessController;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AuthenticationInterceptor;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.grpc.LicenseInterceptor;
import io.axoniq.axonserver.integration.BatchingRequestQueue;
import io.axoniq.axonserver.message.command.CommandMetricsWebSocket;
import io.axoniq.axonserver.metric.MeterFactory;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerTransportFilter;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component(value="Gateway")
public class Gateway
implements SmartLifecycle {
    private final MeterFactory l;
    private final LicenseAccessController K;
    private boolean J;
    private final List<AxonServerClientService> d;
    private final MessagingPlatformConfiguration L;
    private final AxonServerAccessController G;
    private final Logger A;
    private final ExecutorService B;
    private final List<ServerTransportFilter> C;
    private final Supplier<ScheduledExecutorService> j;
    private Server m;
    private AdvancedTlsX509KeyManager.Closeable c;

    public boolean isAutoStartup() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, Supplier<ScheduledExecutorService> supplier, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        Gateway a9;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway gateway3 = a9 = gateway;
        Gateway gateway4 = a9;
        Gateway gateway5 = a9;
        Gateway gateway6 = a9;
        gateway6.A = LoggerFactory.getLogger(Gateway.class);
        gateway6.L = a8;
        gateway5.d = a7;
        gateway5.C = a6;
        gateway4.G = a5;
        gateway4.K = a4;
        a9.j = a3;
        gateway3.l = a2;
        gateway3.B = Executors.newFixedThreadPool(a9.L.getExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(BatchingRequestQueue.C((Object)"%C2RoT:T!D6^0\u001c")));
    }

    public boolean isRunning() {
        Gateway a2;
        return a2.J;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        Gateway gateway = this;
        String string = BatchingRequestQueue.C((Object)",^bb\u0011}");
        try {
            Gateway a2;
            Gateway gateway2;
            if (gateway.L.getSsl() != null && gateway.L.getSsl().isEnabled()) {
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                gateway.c = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile(new File(gateway.L.getSsl().getPrivateKeyFile()), new File(gateway.L.getSsl().getCertChainFile()), 1L, TimeUnit.MINUTES, (ScheduledExecutorService)gateway.j.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                ServerCredentials serverCredentials = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                string = CommandMetricsWebSocket.C((Object)"\f:\u0013I:\u0007>\u000b3\f;");
                Gateway gateway3 = gateway;
                gateway2 = gateway3;
                a2 = NettyServerBuilder.forPort((int)gateway3.L.getPort(), (ServerCredentials)serverCredentials);
            } else {
                Gateway gateway4 = gateway;
                gateway2 = gateway4;
                a2 = NettyServerBuilder.forPort((int)gateway4.L.getPort());
            }
            if (gateway2.L.getMaxMessageSize() > 0) {
                a2.maxInboundMessageSize(gateway.L.getMaxMessageSize());
            }
            a2.permitKeepAliveWithoutCalls(true).permitKeepAliveTime(gateway.L.getMinKeepAliveTime(), TimeUnit.MILLISECONDS);
            gateway.d.forEach(arg_0 -> ((NettyServerBuilder)a2).addService(arg_0));
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(gateway.L.getGrpcBufferedMessages()));
            if (gateway.L.getAccesscontrol().isEnabled()) {
                Gateway gateway5 = gateway;
                a2.intercept((ServerInterceptor)new AuthenticationInterceptor(gateway5.G, gateway5.l));
            }
            a2.intercept((ServerInterceptor)new LicenseInterceptor(gateway.K));
            a2.intercept((ServerInterceptor)new ContextInterceptor());
            if (gateway.L.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(gateway.L.getKeepAliveTime(), TimeUnit.MILLISECONDS).keepAliveTimeout(gateway.L.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.executor((Executor)gateway.B);
            gateway.C.forEach(arg_0 -> ((NettyServerBuilder)a2).addTransportFilter(arg_0));
            gateway.m = a2.build();
            gateway.m.start();
            gateway.A.info(BatchingRequestQueue.C((Object)"\u0003I-_bb'C4T0\u0011\u0005P6T5P;\u00111E#C6T&\u0011-_bA-C6\u000bbJ?\u0011o\u00119L"), (Object)gateway.L.getPort(), (Object)string);
            gateway.J = true;
            return;
        }
        catch (Exception exception) {
            throw new FailedToStartException(CommandMetricsWebSocket.C((Object)"\f\u001d>\u001b+\u00001\u000e\u007f('\u00061I\f\f-\u001f:\u001b\u007f.>\u001d:\u001e>\u0010\u007f\u000f>\u00003\f;"), (Throwable)exception);
        }
    }

    public int getPhase() {
        return 200;
    }

    public void stop() {
        Gateway gateway = this;
        if (gateway.c != null) {
            gateway.c.close();
        }
        Gateway gateway2 = gateway;
        gateway2.B.shutdown();
        if (gateway2.J) {
            try {
                if (!gateway.m.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                    Gateway gateway3 = gateway;
                    gateway3.A.debug(CommandMetricsWebSocket.C((Object)"/0\u001b<\f9\u001c3\u0005&I,\u001d0\u0019/\u00001\u000e\u007f*3\u001c,\u001d:\u001b\u007f::\u001b)\f-"));
                    gateway3.m.shutdownNow();
                }
            }
            catch (InterruptedException a2) {
                gateway.A.debug(BatchingRequestQueue.C((Object)"\u000b_6T0C7A6T&\u0011&D0X,VbB*D6U-F,\u0011-Wbv\u0010a\u0001\u00111T0G'C"), (Throwable)a2);
                Thread.currentThread().interrupt();
            }
        }
        gateway.J = false;
        gateway.A.info(CommandMetricsWebSocket.C((Object)"\u001e\u00110\u0007\u007f::\u001b)\f-I\u0018\b+\f(\b&I,\u001d0\u0019/\f;"));
    }

    /*
     * WARNING - void declaration
     */
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway a8 = gateway;
        a8((MessagingPlatformConfiguration)a7, (List)a6, (List)a5, (AxonServerAccessController)a4, (LicenseAccessController)a3, Executors::newSingleThreadScheduledExecutor, (MeterFactory)a2);
    }
}

