/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc.heartbeat;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.enterprise.cluster.AutoRebalancing;
import io.axoniq.axonserver.enterprise.cluster.ClusterEvent;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.Publisher;
import io.axoniq.axonserver.grpc.control.Heartbeat;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatPublisher;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.axonserver.heartbeat.enabled"}, matchIfMissing=true)
public class HeartbeatMonitor {
    private final ApplicationEventPublisher G;
    private final long A;
    private final Map<ClientStreamIdentification, ClientInformation> B;
    private final Map<ClientStreamIdentification, Instant> C;
    private final Publisher<PlatformOutboundInstruction> j;
    private final Logger m;
    private final Clock c;

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-initial-delay:5000}", fixedRateString="${axoniq.axonserver.client-heartbeat-frequency:1000}")
    public void sendHeartbeat() {
        HeartbeatMonitor a2;
        a2.j.publish((Object)PlatformOutboundInstruction.newBuilder().setHeartbeat(Heartbeat.newBuilder()).build());
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-check-initial-delay:10000}", fixedRateString="${axoniq.axonserver.client-heartbeat-check-rate:1000}")
    public void checkClientsStillAlive() {
        HeartbeatMonitor heartbeatMonitor;
        HeartbeatMonitor heartbeatMonitor2 = heartbeatMonitor = this;
        heartbeatMonitor2.m.debug(ClusterEvent.C((Object)"/\"\t)\u0007#\u0002-L)\u0003$\u0002/\u000f>\t.L)\u0000#\t$\u00189L+\u001e/L9\u0018#\u0000&L+\u0000#\u001a/BdB"));
        HeartbeatMonitor heartbeatMonitor3 = heartbeatMonitor;
        Object a2 = Instant.now(heartbeatMonitor2.c).minus(heartbeatMonitor3.A, ChronoUnit.MILLIS);
        heartbeatMonitor3.C.forEach((arg_0, arg_1) -> heartbeatMonitor.C((Instant)a2, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(Instant instant, ClientStreamIdentification clientStreamIdentification, Instant instant2) {
        void a2;
        void a3;
        HeartbeatMonitor a4 = clientStreamIdentification;
        HeartbeatMonitor a5 = this;
        if (a3.isBefore((Instant)a2) && a5.B.containsKey(a4)) {
            ClientInformation clientInformation = (ClientInformation)a5.B.get(a4);
            String string = clientInformation.m;
            String string2 = clientInformation.c;
            Object[] objectArray = new Object[4];
            objectArray[0] = a5.A;
            objectArray[1] = a4;
            objectArray[2] = a3;
            objectArray[3] = a2;
            a5.m.info(ClusterEvent.C((Object)"/&\u0005/\u0002>L#\u0002+\u000f>\u0005<\u0005>\u0015j\b/\u0018/\u000f>\t.L,\u00038L'\u00038\tj\u0018\"\r$L1\u0011j\u0001#\u0000&\u00059\t)\u0003$\b9Bj/&\u0005/\u0002>Vj\u00177@j\u0000+\u001f>-)\u0018#\u001a#\u00183Vj\u00177@j\u0018#\u0001/\u0003?\u0018pL1\u0011dL"), objectArray);
            a5.G.publishEvent((Object)new TopologyEvents.ApplicationInactivityTimeout((ClientStreamIdentification)a4, string, new ClientContext(string2, clientInformation.j)));
        }
    }

    private static /* synthetic */ void C(PlatformService platformService, BiConsumer biConsumer) {
        Object a2 = biConsumer;
        PlatformService a3 = platformService;
        a3.onInboundInstruction(PlatformInboundInstruction.RequestCase.HEARTBEAT, (arg_0, arg_1) -> HeartbeatMonitor.C((BiConsumer)a2, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    public HeartbeatMonitor(Consumer<BiConsumer<ClientStreamIdentification, PlatformInboundInstruction>> consumer, ApplicationEventPublisher applicationEventPublisher, Publisher<PlatformOutboundInstruction> publisher, long l2, Clock clock) {
        void a2;
        void a3;
        void a4;
        Object a5;
        void a6;
        HeartbeatMonitor heartbeatMonitor = object;
        Object object = clock;
        HeartbeatMonitor a7 = heartbeatMonitor;
        a7.m = LoggerFactory.getLogger(HeartbeatMonitor.class);
        HeartbeatMonitor heartbeatMonitor2 = a7;
        a7.B = new ConcurrentHashMap();
        HeartbeatMonitor heartbeatMonitor3 = a7;
        heartbeatMonitor2.C = new ConcurrentHashMap();
        a6.accept((clientStreamIdentification, platformInboundInstruction) -> {
            HeartbeatMonitor a2;
            HeartbeatMonitor a3 = clientStreamIdentification;
            HeartbeatMonitor heartbeatMonitor = a2 = this;
            heartbeatMonitor.m.trace(AutoRebalancing.C((Object)"\u000f\\&K3{\"X3\u00195\\$\\.O\"]g_5V*\u0019<D"), (Object)a3);
            heartbeatMonitor.C.put(a3, Instant.now(a2.c));
        });
        HeartbeatMonitor heartbeatMonitor4 = a7;
        HeartbeatMonitor heartbeatMonitor5 = a7;
        heartbeatMonitor5.c = a5;
        heartbeatMonitor5.G = a4;
        heartbeatMonitor4.A = a3;
        heartbeatMonitor4.j = a2;
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public HeartbeatMonitor(PlatformService platformService, HeartbeatPublisher heartbeatPublisher, ApplicationEventPublisher applicationEventPublisher, @Value(value="${axoniq.axonserver.client-heartbeat-timeout:5000}") long l2) {
        void a2;
        void heartbeatPublisher2;
        void platformService2;
        HeartbeatMonitor heartbeatMonitor = heartbeatMonitor2;
        HeartbeatMonitor heartbeatMonitor2 = applicationEventPublisher;
        HeartbeatMonitor eventPublisher = heartbeatMonitor;
        eventPublisher(arg_0 -> HeartbeatMonitor.C((PlatformService)platformService2, arg_0), (ApplicationEventPublisher)heartbeatMonitor2, (Publisher)heartbeatPublisher2, (long)a2, Clock.systemUTC());
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected applicationConnected) {
        HeartbeatMonitor a2 = applicationConnected;
        HeartbeatMonitor a3 = this;
        ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a2.I(), a2.g());
        a3.B.put(clientStreamIdentification, new ClientInformation(a2.d(), a2.M(), a2.I()));
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        HeartbeatMonitor a2 = applicationDisconnected;
        HeartbeatMonitor a3 = this;
        a2 = new ClientStreamIdentification(a2.I(), a2.M());
        a3.C.remove(a2);
        a3.B.remove(a2);
        a3.m.debug(AutoRebalancing.C((Object)"\u0014M(IgT(W.M(K.W \u0019/\\&K3[\"X3\u0019!V5\u0019$U.\\)MgB:\u0017"), (Object)a2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void C(BiConsumer biConsumer, PlatformService.ClientComponent clientComponent, PlatformInboundInstruction platformInboundInstruction) {
        void a2;
        BiConsumer a3 = clientComponent;
        BiConsumer a4 = biConsumer;
        a4.accept(new ClientStreamIdentification(a3.getContext(), a3.getClientStreamId()), a2);
    }
}

