/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.integration.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.configuration.runtime.Endpoint;
import io.axoniq.axonserver.configuration.runtime.EventHandler;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.EventWithToken;
import io.axoniq.axonserver.integration.EndpointMessageFactory;
import io.axoniq.axonserver.integration.EventPublisher;
import io.axoniq.axonserver.integration.PayloadUtils;
import io.axoniq.axonserver.integration.WrappingTypes;
import io.axoniq.axonserver.integration.config.IntegrationConfiguration;
import io.axoniq.axonserver.integration.http.HttpCustomHeaders;
import io.axoniq.axonserver.integration.http.HttpMetadata;
import io.axoniq.axonserver.localstorage.transaction.PreparedTransaction;
import io.axoniq.axonserver.streams.connection.StreamEvent;
import io.axoniq.axonserver.transport.rest.json.warning.ActiveWarnings;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class HttpEventPublisher
implements EventPublisher {
    private final AtomicBoolean d;
    private final String L;
    private final IntegrationConfiguration G;
    private final WebClient A;
    private final Endpoint B;
    private static final Logger C = LoggerFactory.getLogger(HttpEventPublisher.class);
    private final String j;
    private final MediaType m;
    private final ObjectMapper c;

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void C(WebClient.RequestHeadersSpec requestHeadersSpec, String string, String string2) {
        void a2;
        Object a3 = string2;
        WebClient.RequestHeadersSpec a4 = requestHeadersSpec;
        String[] stringArray = new String[1];
        stringArray[0] = a3;
        a4.header((String)a2, stringArray);
    }

    private /* synthetic */ Mono C(WebClient.RequestHeadersSpec requestHeadersSpec) {
        HttpEventPublisher a3 = requestHeadersSpec;
        HttpEventPublisher a4 = this;
        if (a4.d.get()) {
            return Mono.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_CLOSED, ActiveWarnings.C((Object)"]:o#d<e*\u007fol#\u007f*l+ton#b<h+")));
        }
        return a3.exchangeToMono(a2 -> {
            if (a2.statusCode().is2xxSuccessful()) {
                return Mono.just((Object)a2);
            }
            return Mono.error((Throwable)new IllegalStateException(a2.statusCode().toString()));
        }).doOnSubscribe(subscription -> {
            HttpEventPublisher a2 = subscription;
            HttpEventPublisher a3 = this;
            C.debug(PreparedTransaction.C((Object)"Wfjgmmc#auamp#pl$xy"), (Object)a3.L);
        }).doOnSuccess(clientResponse -> {
            HttpEventPublisher a2 = clientResponse;
            HttpEventPublisher a3 = this;
            C.debug(ActiveWarnings.C((Object)"H9h!yo~*c;-;bov2"), (Object)a3.L);
        }).doOnError(throwable -> {
            Throwable a2 = throwable;
            HttpEventPublisher a3 = this;
            C.warn(PreparedTransaction.C((Object)"Aqvlv#wfjgmmc#auamp#pl$xy9$xy"), (Object)a3.L, (Object)a2.getMessage());
        });
    }

    /*
     * WARNING - void declaration
     */
    public HttpEventPublisher(Endpoint endpoint, EventHandler eventHandler, ObjectMapper objectMapper, IntegrationConfiguration integrationConfiguration, WebClient webClient) {
        void a2;
        void a3;
        void a4;
        void a5;
        HttpEventPublisher a6;
        HttpEventPublisher a7 = eventHandler;
        HttpEventPublisher httpEventPublisher = a6 = this;
        HttpEventPublisher httpEventPublisher2 = a6;
        HttpEventPublisher httpEventPublisher3 = a6;
        httpEventPublisher3.d = new AtomicBoolean();
        httpEventPublisher2.j = a7.getName();
        httpEventPublisher2.c = a5;
        a6.B = a4;
        a6.m = PayloadUtils.C((String)a6.B.getContentType());
        a6.L = a6.C(a7.getEventUrl());
        httpEventPublisher.G = a3;
        httpEventPublisher.A = a2;
    }

    @NotNull
    private /* synthetic */ MediaType C() {
        HttpEventPublisher a2;
        if (WrappingTypes.j.C().equals(a2.B.getWrappingType())) {
            return MediaType.APPLICATION_JSON;
        }
        return a2.m;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(WebClient.RequestHeadersSpec<?> requestHeadersSpec, EventWithToken eventWithToken) {
        void a2;
        HttpEventPublisher a3 = eventWithToken;
        HttpEventPublisher a4 = this;
        a4.B.getMetaData().forEach((arg_0, arg_1) -> HttpEventPublisher.C((WebClient.RequestHeadersSpec)a2, arg_0, arg_1));
        if (WrappingTypes.m.C().equals(a4.B.getWrappingType())) {
            if (!a3.getEvent().getPayload().getType().isBlank()) {
                String[] stringArray = new String[1];
                stringArray[0] = a3.getEvent().getPayload().getType();
                a2.header(HttpCustomHeaders.E.C(), stringArray);
                String[] stringArray2 = new String[1];
                stringArray2[0] = a3.getEvent().getPayload().getType();
                a2.header(HttpCustomHeaders.L.C(), stringArray2);
            }
            if (!a3.getEvent().getPayload().getRevision().isBlank()) {
                String[] stringArray = new String[1];
                stringArray[0] = a3.getEvent().getPayload().getRevision();
                a2.header(HttpCustomHeaders.B.C(), stringArray);
            }
            String[] stringArray = new String[1];
            stringArray[0] = a3.getEvent().getMessageIdentifier();
            a2.header(HttpCustomHeaders.d.C(), stringArray);
            String[] stringArray3 = new String[1];
            stringArray3[0] = OffsetDateTime.ofInstant(Instant.ofEpochMilli(a3.getEvent().getTimestamp()), ZoneId.systemDefault()).toString();
            a2.header(HttpCustomHeaders.G.C(), stringArray3);
            String[] stringArray4 = new String[1];
            stringArray4[0] = "" + a3.getToken();
            a2.header(HttpCustomHeaders.m.C(), stringArray4);
            if (!a3.getEvent().getAggregateIdentifier().isBlank()) {
                String[] stringArray5 = new String[1];
                stringArray5[0] = a3.getEvent().getAggregateIdentifier();
                a2.header(HttpCustomHeaders.c.C(), stringArray5);
                String[] stringArray6 = new String[1];
                stringArray6[0] = a3.getEvent().getAggregateType();
                a2.header(HttpCustomHeaders.A.C(), stringArray6);
                String[] stringArray7 = new String[1];
                stringArray7[0] = String.valueOf(a3.getEvent().getAggregateSequenceNumber());
                a2.header(HttpCustomHeaders.J.C(), stringArray7);
            }
            if (a3.getEvent().getMetaDataCount() > 0) {
                String[] stringArray8 = new String[1];
                stringArray8[0] = HttpMetadata.C((ObjectMapper)a4.c, (Map)a3.getEvent().getMetaDataMap());
                a2.header(HttpCustomHeaders.l.C(), stringArray8);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<Void> publish(List<StreamEvent> list) {
        void a2;
        HttpEventPublisher httpEventPublisher = this;
        if (httpEventPublisher.d.get()) {
            C.debug(PreparedTransaction.C((Object)"\u007f~>#Pq}jjd$wk#tvfompl#pl$b$`hlwf`#tvfomplfv"), (Object)httpEventPublisher.j);
            return CompletableFuture.failedFuture(new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_CLOSED, ActiveWarnings.C((Object)"]:o#d<e*\u007fol#\u007f*l+ton#b<h+")));
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        Object[] objectArray = new Object[3];
        objectArray[0] = a2.size();
        objectArray[1] = httpEventPublisher.j;
        objectArray[2] = httpEventPublisher.L;
        C.trace(PreparedTransaction.C((Object)"@jwsewgk$xy#auampp$xy#pl$xy"), objectArray);
        try {
            HttpEventPublisher a3 = ((WebClient.RequestBodySpec)httpEventPublisher.A.post().uri(httpEventPublisher.L, new Object[0])).contentType(httpEventPublisher.C()).body((Publisher)Mono.just((Object)httpEventPublisher.C((List)a2)), byte[].class);
            httpEventPublisher.C((WebClient.RequestHeadersSpec)a3, ((StreamEvent)a2.get(0)).event());
            Mono.defer(() -> httpEventPublisher.C((WebClient.RequestHeadersSpec)a3)).retryWhen((Retry)Retry.backoff((long)Long.MAX_VALUE, (Duration)Duration.ofMillis(httpEventPublisher.G.getEventRetryBackoff())).filter(throwable -> {
                Object a2 = throwable;
                HttpEventPublisher a3 = this;
                if (!a3.d.get()) {
                    return true;
                }
                return false;
            }).maxBackoff(Duration.ofSeconds(30L)).doBeforeRetry(retrySignal -> {
                HttpEventPublisher a2 = retrySignal;
                HttpEventPublisher a3 = this;
                C.debug(PreparedTransaction.C((Object)"xy#)#Vfpq}9$xy"), (Object)a3.L, (Object)a2.failure().getMessage());
            })).subscribe(clientResponse -> {
                CompletableFuture a2 = clientResponse;
                CompletableFuture a3 = completableFuture;
                a2.releaseBody().subscribe();
                a3.complete(null);
            }, throwable -> {
                void a2;
                Object a3 = throwable;
                HttpEventPublisher a4 = this;
                a2.completeExceptionally(a4.C((Throwable)a3));
            });
            return completableFuture;
        }
        catch (Exception a3) {
            CompletableFuture<Void> completableFuture2 = completableFuture;
            completableFuture2.completeExceptionally(new MessagingPlatformException(ErrorCode.OTHER, a3.getMessage(), (Throwable)a3));
            return completableFuture2;
        }
    }

    private /* synthetic */ String C(String string) {
        String a2 = string;
        HttpEventPublisher a3 = this;
        if (a2 != null && !a2.isBlank()) {
            return a3.B.getBaseUrl() + (String)a2;
        }
        return a3.C().replace("{name}", a3.j).replace(ActiveWarnings.C((Object)"4n c;h7y2"), a3.B.getContext());
    }

    public void close() {
        HttpEventPublisher a2;
        HttpEventPublisher httpEventPublisher = a2;
        C.debug(ActiveWarnings.C((Object)"4pu-\n{*c;-?x-a&~'h=-,a ~*io ov2"), (Object)httpEventPublisher.j, (Object)httpEventPublisher.L);
        a2.d.set(true);
    }

    private /* synthetic */ Throwable C(Throwable throwable) {
        Throwable a2 = throwable;
        HttpEventPublisher a3 = this;
        if (a2 instanceof MessagingPlatformException) {
            return a2;
        }
        return new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_ERROR, a2.getMessage(), a2);
    }

    private /* synthetic */ String C() {
        HttpEventPublisher a2;
        return a2.B.getBaseUrl() + a2.B.getEventUrl();
    }

    private /* synthetic */ byte[] C(List<StreamEvent> list) throws JsonProcessingException {
        Object a2 = list;
        HttpEventPublisher a3 = this;
        if (WrappingTypes.m.C().equals(a3.B.getWrappingType())) {
            return ((StreamEvent)a2.get(0)).event().getEvent().getPayload().getData().toByteArray();
        }
        a2 = a2.stream().map(streamEvent -> {
            HttpEventPublisher a2 = streamEvent;
            HttpEventPublisher a3 = this;
            return EndpointMessageFactory.C((EventWithToken)a2.event(), (MediaType)a3.m);
        }).toList();
        return a3.c.writeValueAsBytes(a2);
    }
}

