/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.config.TagsConfiguration;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.integration.rsocket.RsocketEventPublishers;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.localstorage.file.PersistedBloomFilter;
import io.axoniq.axonserver.localstorage.file.RemoteAggregateSequenceNumberResolver;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntriesSerializer;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.a;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class StandardIndexManager
implements IndexManager {
    private ScheduledFuture<?> i;
    private final Supplier<IndexManager> b;
    private final ConcurrentNavigableMap<Long, Map<String, IndexEntries>> k;
    protected final String e;
    private final EventType D;
    private final String g;
    private final RemoteAggregateSequenceNumberResolver E;
    private static final ScheduledExecutorService l;
    private final AtomicLong K;
    private final ConcurrentNavigableMap<FileVersion, PersistedBloomFilter> J;
    private final MeterFactory.RateMeter d;
    private static final String L = "aggregateMap";
    private final MeterFactory.RateMeter G;
    private final Counter A;
    private final ConcurrentSkipListMap<FileVersion, a> B;
    private static final Logger C;
    private final ConcurrentNavigableMap<Long, Integer> j;
    protected final Supplier<StorageProperties> m;
    private final Counter c;

    /*
     * WARNING - void declaration
     */
    public Mono<Void> activateVersion(FileVersion fileVersion, File file) {
        void a2;
        StandardIndexManager a3 = fileVersion;
        StandardIndexManager a4 = this;
        if (a4.j.containsKey(a3.C())) {
            return a4.C((FileVersion)a3, (File)a2);
        }
        IndexManager indexManager = (IndexManager)a4.b.get();
        if (indexManager != null) {
            return indexManager.activateVersion((FileVersion)a3, (File)a2);
        }
        return Mono.empty();
    }

    private static /* synthetic */ Integer C(FileVersion fileVersion, Long l2, Integer n) {
        Integer a2 = n;
        FileVersion a3 = fileVersion;
        return a2 == null ? a3.C() : Math.max(a3.C(), a2);
    }

    static {
        C = LoggerFactory.getLogger(StandardIndexManager.class);
        l = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(TagsConfiguration.C((Object)"\u0014\u0007\u0019\f\u0005D\u0010\b\u0013\b\u001a\f\u000fD")));
    }

    /*
     * WARNING - void declaration
     */
    public SegmentIndexEntries lastIndexEntries(String string, long l2) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        for (Long l3 : standardIndexManager.k.descendingKeySet()) {
            StandardIndexManager a4 = (IndexEntries)((Map)standardIndexManager.k.get(l3)).get(a3);
            if (a4 == null || a4.firstSequenceNumber() >= a2) continue;
            StandardIndexManager standardIndexManager2 = a4;
            return new SegmentIndexEntries(new FileVersion(l3.longValue(), 0), standardIndexManager2.range(standardIndexManager2.firstSequenceNumber(), (long)a2, EventType.j.equals((Object)standardIndexManager.D)));
        }
        if (!standardIndexManager.j.isEmpty()) {
            return standardIndexManager.lastIndexEntriesFromClosedSegments((String)a3, (long)a2, ((Long)standardIndexManager.j.keySet().first()).longValue());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void I(FileVersion fileVersion, Map<String, IndexEntries> map) {
        DBMaker.Maker maker;
        void a2;
        File file;
        Map a3;
        StorageProperties storageProperties;
        StandardIndexManager standardIndexManager;
        block14: {
            DBMaker.Maker maker2;
            block9: {
                DBMaker.Maker maker3;
                block13: {
                    block12: {
                        block11: {
                            standardIndexManager = this;
                            storageProperties = (StorageProperties)standardIndexManager.m.get();
                            if (a3 == null) {
                                a3 = Collections.emptyMap();
                            }
                            if (!FileUtils.C((File)(file = storageProperties.indexTemp(standardIndexManager.g, a2.C())))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + file);
                            }
                            maker2 = DBMaker.fileDB((File)file);
                            if (!storageProperties.isUseMmapIndex()) break block11;
                            maker2.fileMmapEnable();
                            if (!storageProperties.isForceCleanMmapIndex()) break block12;
                            DBMaker.Maker maker4 = maker2;
                            maker3 = maker4;
                            maker4.cleanerHackEnable();
                            break block13;
                        }
                        maker2.fileChannelEnable();
                    }
                    maker3 = maker2;
                }
                maker2 = maker3.make();
                StandardIndexManager a4 = maker2.hashMap(L, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.C()).createOrOpen();
                try {
                    a4.putAll(a3);
                    if (a4 == null) break block9;
                    maker = maker2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block10: {
                        if (a4 != null) {
                            try {
                                a4.close();
                                throwable2 = throwable;
                                break block10;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                a4.close();
                break block14;
            }
            maker = maker2;
        }
        maker.close();
        try {
            CopyOption[] copyOptionArray = new CopyOption[1];
            copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            Files.move(file.toPath(), storageProperties.index(standardIndexManager.g, (FileVersion)a2).toPath(), copyOptionArray);
        }
        catch (IOException a4) {
            throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to rename index file" + storageProperties.index(standardIndexManager.g, (FileVersion)a2), (Throwable)a4);
        }
        StandardIndexManager standardIndexManager2 = a4 = new PersistedBloomFilter(storageProperties.bloomFilter(standardIndexManager.g, (FileVersion)a2).getAbsolutePath(), a3.keySet().size(), storageProperties.getBloomIndexFpp());
        standardIndexManager2.I();
        standardIndexManager2.C(a3.keySet());
        standardIndexManager2.C();
        standardIndexManager.J.put(a2, a4);
        standardIndexManager.j.put(a2.C(), a2.C());
        standardIndexManager.I((FileVersion)a2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void C(Map map, String string2, List list) {
        void a2;
        List a3 = list;
        Map a4 = map;
        a4.computeIfAbsent(a2, string -> {
            String a2 = string;
            List a3 = a3;
            return new StandardIndexEntries(((IndexEntry)a3.get(0)).I());
        }).addAll(a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono<Void> C(FileVersion fileVersion, File file) {
        void a3;
        StandardIndexManager a4 = fileVersion;
        StandardIndexManager a5 = this;
        return Mono.fromSupplier(() -> a5.C((FileVersion)a4)).filter(a2 -> {
            if (!a2.exists()) {
                return true;
            }
            return false;
        }).flatMap(arg_0 -> StandardIndexManager.C((File)a3, arg_0)).doOnSuccess(arg_0 -> a5.C((FileVersion)a4, arg_0));
    }

    private static /* synthetic */ void C(Map.Entry a2) {
        ((a)a2.getValue()).close();
    }

    private /* synthetic */ void C(FileVersion fileVersion, Void void_) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        a3.j.put(a2.C(), a2.C());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ int C(long l2, long l3, SortedMap<FileVersion, IndexEntries> sortedMap, FileVersion fileVersion, IndexEntries indexEntries) {
        void a2;
        void a3;
        StandardIndexManager a4;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntries;
        StandardIndexManager a5 = standardIndexManager;
        if (!(a4 = a4.range((long)a3, (long)a2, EventType.j.equals((Object)a5.D))).isEmpty()) {
            void a6;
            void a7;
            a7.put(a6, a4);
        }
        return a4.size();
    }

    /*
     * WARNING - void declaration
     */
    public Optional<Long> getLastSequenceNumber(String string, EventStorageEngine.SearchHint searchHint, long l2) {
        void a2;
        void a3;
        StandardIndexManager a222 = searchHint;
        StandardIndexManager a4 = this;
        int a222 = a222.equals((Object)EventStorageEngine.SearchHint.j) ? ((StorageProperties)a4.m.get()).segmentsForSequenceNumberCheck() : Integer.MAX_VALUE;
        return a4.C((String)a3, a222, (long)a2);
    }

    public Mono<Void> activateVersion(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return Mono.defer(() -> a3.C((FileVersion)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Stream C(StorageProperties storageProperties, Map.Entry entry) {
        void a2;
        Map.Entry a3 = entry;
        StandardIndexManager a4 = this;
        File[] fileArray = new File[2];
        fileArray[0] = a2.index(a4.g, ((Long)a3.getKey()).longValue());
        fileArray[1] = a2.bloomFilter(a4.g, ((Long)a3.getKey()).longValue());
        return Stream.of(fileArray);
    }

    /*
     * WARNING - void declaration
     */
    public void addToActiveSegment(Long l2, Map<String, List<IndexEntry>> map) {
        void a2;
        Object a3 = l2;
        StandardIndexManager a4 = this;
        if (a4.j.containsKey(a3)) {
            throw new IndexNotFoundException((Long)a3 + ": already completed");
        }
        a2.forEach((arg_0, arg_1) -> a4.C((Long)a3, arg_0, arg_1));
    }

    public long size() {
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    public Optional<Long> C(String string, int n, long l2) {
        void a52222;
        void a52222;
        void a2;
        Map map;
        void a3;
        void a4;
        StandardIndexManager standardIndexManager = this;
        int n2 = 0;
        for (Long a52222 : standardIndexManager.k.descendingKeySet()) {
            if (n2 >= a4) {
                return Optional.empty();
            }
            if (a52222 > a3 || (map = (Map)standardIndexManager.k.get(a52222)) == null) continue;
            IndexEntries indexEntries = (IndexEntries)map.get(a2);
            if (indexEntries != null) {
                return Optional.of(indexEntries.lastSequenceNumber());
            }
            ++n2;
        }
        for (Map.Entry a52222 : standardIndexManager.j.entrySet()) {
            if (n2 >= a4) {
                return Optional.empty();
            }
            if ((Long)a52222.getKey() > a3) continue;
            map = standardIndexManager.C(new FileVersion(((Long)a52222.getKey()).longValue(), ((Integer)a52222.getValue()).intValue()), (String)a2);
            if (map != null) {
                return Optional.of(map.lastSequenceNumber());
            }
            ++n2;
        }
        Iterator<Object> iterator = (StandardIndexManager)standardIndexManager.b.get();
        Optional a52222 = Optional.empty();
        if (iterator != null) {
            Optional a52222 = iterator.C((String)a2, (int)(a4 - n2), (long)a3);
        }
        if (a52222.isEmpty() && standardIndexManager.E != null && n2 < a4 && !standardIndexManager.j.isEmpty()) {
            StandardIndexManager standardIndexManager2 = standardIndexManager;
            Optional a52222 = standardIndexManager2.E.getLastSequenceNumber(standardIndexManager2.e, (String)a2, (int)(a4 - n2), (Long)standardIndexManager.j.keySet().last() - 1L);
        }
        return a52222;
    }

    /*
     * WARNING - void declaration
     */
    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String string, long l2, long l3, long l4, long l5) {
        void a2;
        void a3;
        Iterator iterator;
        void a4;
        void a5;
        void a6;
        StandardIndexManager standardIndexManager = this;
        TreeMap a7 = new TreeMap();
        Object[] objectArray = new Object[4];
        objectArray[0] = standardIndexManager.e;
        objectArray[1] = a6;
        objectArray[2] = (long)a5;
        objectArray[3] = (long)a4;
        C.debug(RsocketEventPublishers.C((Object)"~\u0014?Ii\u0006j\u0002p\u0019D\u000eb\u001b`\u000ed\u001d`I~\u0014%\u0004l\u0007V\ft\u001c`\u0007f\fK\u001ch\u000b`\u001b%\u0012xE%\u0005d\u001aq:`\u0018p\fk\n`'p\u0004g\fwI~\u0014"), objectArray);
        long l6 = Long.MAX_VALUE;
        Iterator iterator2 = iterator = standardIndexManager.k.descendingKeySet().iterator();
        while (iterator2.hasNext()) {
            Long l7 = (Long)iterator.next();
            if (l6 < a3) {
                return a7;
            }
            IndexEntries indexEntries = (IndexEntries)standardIndexManager.k.getOrDefault(l7, Collections.emptyMap()).get(a6);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager2 = standardIndexManager;
                int n = standardIndexManager2.C((long)a5, (long)a4, (SortedMap)a7, new FileVersion(l7.longValue(), 0), indexEntries);
                if (standardIndexManager2.C((long)a5, (long)(a2 -= (long)n), indexEntries)) {
                    return a7;
                }
            }
            l6 = l7;
            iterator2 = iterator;
        }
        TreeMap treeMap = a7;
        treeMap.putAll(standardIndexManager.lookupAggregateInClosedSegments((String)a6, (long)a5, (long)a4, (long)a2, (long)a3, l6));
        return treeMap;
    }

    private /* synthetic */ File C(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return ((StorageProperties)a3.m.get()).index(a3.g, (FileVersion)a2);
    }

    private /* synthetic */ void I() {
        StandardIndexManager a2;
        StandardIndexManager standardIndexManager = a2;
        standardIndexManager.K.set(standardIndexManager.j.keySet().stream().skip(((StorageProperties)a2.m.get()).getMaxIndexesInMemory()).findFirst().orElse(-1L));
    }

    /*
     * WARNING - void declaration
     */
    public void cleanup(boolean bl) {
        void a3;
        StandardIndexManager standardIndexManager;
        StandardIndexManager standardIndexManager2 = standardIndexManager = this;
        standardIndexManager2.k.clear();
        standardIndexManager2.J.clear();
        standardIndexManager2.B.forEach((fileVersion, a2) -> {
            FileVersion a3 = a2;
            FileVersion a4 = fileVersion;
            a3.close();
        });
        StandardIndexManager standardIndexManager3 = standardIndexManager;
        standardIndexManager3.B.clear();
        if (standardIndexManager3.i != null && !standardIndexManager.i.isDone()) {
            standardIndexManager.i.cancel(true);
        }
        if (a3 != false) {
            standardIndexManager.j.keySet().forEach(arg_0 -> standardIndexManager.removeAllVersions(arg_0));
        }
        StandardIndexManager standardIndexManager4 = standardIndexManager;
        standardIndexManager4.j.clear();
        StandardIndexManager a4 = (IndexManager)standardIndexManager4.b.get();
        if (a4 != null) {
            a4.cleanup((boolean)a3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createIndex(FileVersion fileVersion, Map<String, List<IndexEntry>> map) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        Object a4 = new HashMap();
        a3.forEach((arg_0, arg_1) -> StandardIndexManager.C((Map)a4, arg_0, arg_1));
        standardIndexManager.C((FileVersion)a2, (Map)a4);
    }

    public Stream<AggregateIndexEntries> latestSequenceNumbers(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return a3.I((FileVersion)a2).C();
    }

    public void addExistingIndex(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        a3.j.put(a2.C(), a2.C());
        a3.I();
    }

    private /* synthetic */ boolean C(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return ((StorageProperties)a3.m.get()).dataFile(a3.g, (FileVersion)a2).exists();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ IndexEntries C(FileVersion fileVersion, String string) {
        int n;
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        if (standardIndexManager.C((FileVersion)a3, (String)a2)) {
            return null;
        }
        RuntimeException runtimeException = new RuntimeException();
        int n2 = n = 0;
        while (true) {
            if (n2 >= 3) break;
            try {
                StandardIndexManager a4 = standardIndexManager.I((FileVersion)a3);
                return a4.C((String)a2);
            }
            catch (IndexNotFoundException a4) {
                return null;
            }
            catch (Exception a4) {
                runtimeException = new RuntimeException("Error happened while trying get positions for " + a3.C() + " segment.", a4);
                n2 = ++n;
                continue;
            }
            break;
        }
        throw runtimeException;
    }

    /*
     * WARNING - void declaration
     */
    public void C(FileVersion fileVersion, Map<String, IndexEntries> map) {
        void a2;
        StandardIndexManager a3 = this;
        StandardIndexManager a4 = fileVersion;
        if (a3.C((FileVersion)a4)) {
            a3.I((FileVersion)a4, (Map)a2);
            return;
        }
        StandardIndexManager standardIndexManager = (StandardIndexManager)a3.b.get();
        if (standardIndexManager != null) {
            standardIndexManager.C((FileVersion)a4, (Map)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, MeterFactory meterFactory, Supplier<IndexManager> supplier2) {
        Object a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        StandardIndexManager standardIndexManager = object;
        Object object = supplier2;
        StandardIndexManager a8 = standardIndexManager;
        a8((String)a7, (Supplier)a6, (String)a5, (EventType)a4, null, (MeterFactory)a3, (Supplier)a2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAllVersions(long l2) {
        Integer n;
        void a2;
        StandardIndexManager standardIndexManager = this;
        StorageProperties storageProperties = (StorageProperties)standardIndexManager.m.get();
        if (standardIndexManager.k.remove((long)a2) == null && (n = (Integer)standardIndexManager.j.remove((long)a2)) != null) {
            FileVersion fileVersion;
            int a222;
            int n2 = a222 = 0;
            while (n2 < n) {
                fileVersion = new FileVersion((long)a2, a222);
                if (storageProperties.index(standardIndexManager.g, fileVersion).exists()) {
                    standardIndexManager.remove(fileVersion);
                }
                n2 = ++a222;
            }
            FileVersion a222 = new FileVersion((long)a2, n.intValue());
            fileVersion = (a)standardIndexManager.B.remove(a222);
            if (fileVersion != null) {
                fileVersion.close();
            }
            standardIndexManager.J.remove(a222);
        }
        if (FileUtils.C((File)storageProperties.index(standardIndexManager.g, (long)a2)) && FileUtils.C((File)storageProperties.bloomFilter(standardIndexManager.g, (long)a2))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean C(FileVersion fileVersion2, String string) {
        void a2;
        StandardIndexManager a3 = fileVersion2;
        StandardIndexManager a4 = this;
        if ((a3 = a4.J.computeIfAbsent(a3, fileVersion -> {
            StandardIndexManager a2 = fileVersion;
            StandardIndexManager a3 = this;
            C.debug(TagsConfiguration.C((Object)"\u0006\u0014GI\u0012\u0019\u0018\u0007]\u000b\u0011\u0006\u0012\u0004]\u000f\u0014\u0005\t\f\u000fI\u001b\u0006\u000fI\u0006\u0014"), (Object)a3.e, (Object)a2.C());
            StorageProperties storageProperties = (StorageProperties)a3.m.get();
            a2 = new PersistedBloomFilter(storageProperties.bloomFilter(a3.g, (FileVersion)a2).getAbsolutePath(), 0, 0.03f);
            if (!a2.C()) {
                return null;
            }
            a3.c.increment();
            StandardIndexManager standardIndexManager = a2;
            standardIndexManager.g();
            return standardIndexManager;
        })) != null && !a3.C((String)a2)) {
            return true;
        }
        return false;
    }

    public void complete(FileVersion fileVersion) {
        StandardIndexManager a2;
        StandardIndexManager a3 = fileVersion;
        StandardIndexManager standardIndexManager = a2 = this;
        standardIndexManager.I((FileVersion)a3, (Map)standardIndexManager.k.get(a3.C()));
        a2.k.remove(a3.C());
        a2.I();
    }

    public void init() {
        int n;
        StandardIndexManager standardIndexManager = this;
        StorageProperties storageProperties = (StorageProperties)standardIndexManager.m.get();
        String[] stringArray = FileUtils.C((File)new File(standardIndexManager.g), (String)storageProperties.getIndexSuffix());
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            StandardIndexManager a2 = FileUtils.C((String)stringArray[n]);
            if (storageProperties.dataFile(standardIndexManager.g, (FileVersion)a2).exists()) {
                standardIndexManager.j.compute(a2.C(), (arg_0, arg_1) -> StandardIndexManager.C((FileVersion)a2, arg_0, arg_1));
            } else {
                standardIndexManager.remove((FileVersion)a2);
            }
            n3 = ++n;
        }
        standardIndexManager.I();
    }

    private static /* synthetic */ Mono C(File file, File file2) {
        File a2 = file2;
        File a3 = file;
        return Mono.fromSupplier(() -> a3).filter(File::exists).switchIfEmpty(Mono.error((Throwable)new RuntimeException())).flatMap(file3 -> {
            File a2 = a2;
            File a3 = a3;
            return FileUtils.C((File)a3, (File)a2);
        });
    }

    public boolean remove(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        a a4 = (a)a3.B.remove(a2);
        if (a4 != null) {
            a4.close();
        }
        StandardIndexManager standardIndexManager = a3;
        standardIndexManager.J.remove(a2);
        if (FileUtils.C((File)((StorageProperties)standardIndexManager.m.get()).index(a3.g, (FileVersion)a2)) && FileUtils.C((File)((StorageProperties)a3.m.get()).bloomFilter(a3.g, (FileVersion)a2))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public SortedMap<FileVersion, IndexEntries> lookupAggregateInClosedSegments(String string, long l2, long l3, long l4, long l5, long l6) {
        void a2;
        void a3;
        void a4;
        void a5;
        long a6;
        IndexManager indexManager;
        StandardIndexManager standardIndexManager = this;
        TreeMap a7 = new TreeMap();
        IndexManager indexManager2 = indexManager = standardIndexManager.j.entrySet().iterator();
        while (indexManager2.hasNext()) {
            Map.Entry entry = indexManager.next();
            if (a6 < a5) {
                return a7;
            }
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            IndexEntries indexEntries = standardIndexManager.C(fileVersion, (String)a4);
            Object[] objectArray = new Object[4];
            objectArray[0] = standardIndexManager.e;
            objectArray[1] = a4;
            objectArray[2] = entry;
            objectArray[3] = indexEntries;
            C.debug(RsocketEventPublishers.C((Object)"\u0012xS%\u0005j\u0006n\u001cu(b\u000ew\fb\bq\f%\u0012xIl\u0007%\u001a`\u000eh\fk\u001d%\u0012xIc\u0006p\u0007aI~\u0014"), objectArray);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager2 = standardIndexManager;
                int n = standardIndexManager2.C((long)a3, (long)a2, (SortedMap)a7, fileVersion, indexEntries);
                if (standardIndexManager2.C((long)a3, (long)(a8 -= (long)n), indexEntries)) {
                    return a7;
                }
            }
            a6 = (Long)entry.getKey();
            indexManager2 = indexManager;
        }
        indexManager = (IndexManager)standardIndexManager.b.get();
        if (indexManager != null) {
            void a8;
            a7.putAll(indexManager.lookupAggregateInClosedSegments((String)a4, (long)a3, (long)a2, (long)a8, (long)a5, a6));
        }
        return a7;
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, MeterFactory meterFactory) {
        StandardIndexManager a2;
        void a3;
        void a4;
        void a5;
        void a6;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = meterFactory;
        StandardIndexManager a7 = standardIndexManager;
        a7((String)a6, (Supplier)a5, (String)a4, (EventType)a3, null, (MeterFactory)a2, () -> null);
    }

    public List<File> indexFiles(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        File[] fileArray = new File[2];
        fileArray[0] = ((StorageProperties)a3.m.get()).index(a3.g, (FileVersion)a2);
        fileArray[1] = ((StorageProperties)a3.m.get()).bloomFilter(a3.g, (FileVersion)a2);
        return Arrays.asList(fileArray);
    }

    /*
     * WARNING - void declaration
     */
    public Stream<File> getBackupFilenames(long l2, int n) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        StandardIndexManager a4 = (StorageProperties)standardIndexManager.m.get();
        return standardIndexManager.j.entrySet().stream().filter(arg_0 -> StandardIndexManager.C((long)a3, (int)a2, arg_0)).flatMap(arg_0 -> standardIndexManager.C((StorageProperties)a4, arg_0));
    }

    private /* synthetic */ a I(FileVersion fileVersion2) {
        StandardIndexManager a2 = fileVersion2;
        StandardIndexManager a3 = this;
        try {
            return a3.B.computeIfAbsent(a2, fileVersion -> {
                StandardIndexManager a2 = fileVersion;
                StandardIndexManager a3 = this;
                return new a(a3, (FileVersion)a2);
            }).C();
        }
        catch (IndexNotFoundException indexNotFoundException) {
            a2 = (a)a3.B.remove(a2);
            if (a2 != null) {
                a2.close();
            }
            throw indexNotFoundException;
        }
    }

    public boolean validIndex(FileVersion fileVersion) {
        block3: {
            boolean bl;
            StandardIndexManager a2;
            block4: {
                a2 = fileVersion;
                StandardIndexManager a3 = this;
                if (!a3.j.containsKey(a2.C()) || ((Integer)a3.j.get(a2.C())).intValue() != a2.C()) break block3;
                if (a3.C((FileVersion)a2) == null || a3.I((FileVersion)a2) == null) break block4;
                return true;
            }
            try {
                bl = false;
            }
            catch (Exception exception) {
                C.warn(TagsConfiguration.C((Object)";\b\u0014\u0005\u0018\r]\u001d\u0012I\u000b\b\u0011\u0000\u0019\b\t\f]\u0000\u0013\r\u0018\u0011]\u000f\u0012\u001b]\u001a\u0018\u000e\u0010\f\u0013\u001dGI\u0006\u0014"), (Object)a2, (Object)exception);
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void createNewVersion(long l2, int n, Map<String, List<IndexEntry>> map) {
        StandardIndexManager standardIndexManager;
        HTreeMap hTreeMap;
        Map<String, List> a2;
        FileVersion a222;
        StandardIndexManager standardIndexManager2;
        block12: {
            StandardIndexManager a3;
            block7: {
                StandardIndexManager standardIndexManager3;
                block11: {
                    block10: {
                        block9: {
                            void a222;
                            void a4;
                            standardIndexManager2 = this;
                            a222 = new FileVersion((long)a4, (int)a222);
                            if (a2 == null) {
                                a2 = Collections.emptyMap();
                            }
                            if (!FileUtils.C((File)(a4 = ((StorageProperties)standardIndexManager2.m.get()).transformedIndex(standardIndexManager2.g, a222)))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + a4);
                            }
                            a3 = DBMaker.fileDB((File)a4);
                            if (!((StorageProperties)standardIndexManager2.m.get()).isUseMmapIndex()) break block9;
                            a3.fileMmapEnable();
                            if (!((StorageProperties)standardIndexManager2.m.get()).isForceCleanMmapIndex()) break block10;
                            StandardIndexManager standardIndexManager4 = a3;
                            standardIndexManager3 = standardIndexManager4;
                            standardIndexManager4.cleanerHackEnable();
                            break block11;
                        }
                        a3.fileChannelEnable();
                    }
                    standardIndexManager3 = a3;
                }
                a3 = standardIndexManager3.make();
                hTreeMap = a3.hashMap(L, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.C()).createOrOpen();
                try {
                    a2.forEach((string, list) -> {
                        void a2;
                        int n;
                        List a3 = list;
                        HTreeMap a4 = hTreeMap;
                        IndexEntry indexEntry = (IndexEntry)a3.get(0);
                        Integer[] integerArray = new Integer[a3.size()];
                        int n2 = n = 0;
                        while (n2 < a3.size()) {
                            int n3 = n++;
                            integerArray[n3] = ((IndexEntry)a3.get(n3)).C();
                            n2 = n;
                        }
                        a4.put((Object)a2, (Object)new StandardIndexEntries(indexEntry.I(), integerArray));
                    });
                    if (hTreeMap == null) break block7;
                    standardIndexManager = a3;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block8: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block8;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block12;
            }
            standardIndexManager = a3;
        }
        standardIndexManager.close();
        HTreeMap hTreeMap2 = hTreeMap = new PersistedBloomFilter(((StorageProperties)standardIndexManager2.m.get()).bloomFilter(standardIndexManager2.g, a222).getAbsolutePath(), a2.keySet().size(), ((StorageProperties)standardIndexManager2.m.get()).getBloomIndexFpp());
        hTreeMap2.I();
        hTreeMap2.C(a2.keySet());
        hTreeMap2.C();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(Long l2, String string, List list) {
        void a3;
        void a4;
        Object a5 = list;
        StandardIndexManager a6 = this;
        a6.k.computeIfAbsent(a4, a2 -> new ConcurrentHashMap()).computeIfAbsent(a3, arg_0 -> StandardIndexManager.C((List)a5, arg_0)).addAll((List)a5);
    }

    private static /* synthetic */ boolean C(long l2, int n, Map.Entry entry) {
        long a2;
        Map.Entry a3 = entry;
        int a4 = n;
        if ((Long)a3.getKey() > a2 || (Integer)a3.getValue() > a4) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono C(FileVersion fileVersion) {
        void a2;
        StandardIndexManager standardIndexManager = this;
        Object a3 = ((StorageProperties)standardIndexManager.m.get()).transformedIndex(standardIndexManager.g, (FileVersion)a2);
        return standardIndexManager.activateVersion((FileVersion)a2, (File)a3);
    }

    /*
     * WARNING - void declaration
     */
    public SegmentIndexEntries lastIndexEntriesFromClosedSegments(String string, long l2, long l3) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        for (Map.Entry entry : standardIndexManager.j.entrySet()) {
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            StandardIndexManager a4 = standardIndexManager.C(fileVersion, (String)a3);
            if (a4 == null || a4.firstSequenceNumber() >= a2) continue;
            StandardIndexManager standardIndexManager2 = a4;
            return new SegmentIndexEntries(fileVersion, standardIndexManager2.range(standardIndexManager2.firstSequenceNumber(), (long)a2, EventType.j.equals((Object)standardIndexManager.D)));
        }
        IndexManager a5 = (IndexManager)standardIndexManager.b.get();
        if (a5 != null) {
            return a5.lastIndexEntriesFromClosedSegments((String)a3, (long)a2, (Long)standardIndexManager.j.keySet().last() - 1L);
        }
        return null;
    }

    private static /* synthetic */ IndexEntries C(List list, String string) {
        String a2 = string;
        List a3 = list;
        return new StandardIndexEntries(((IndexEntry)a3.get(0)).I());
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, RemoteAggregateSequenceNumberResolver remoteAggregateSequenceNumberResolver, MeterFactory meterFactory, Supplier<IndexManager> supplier2) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        StandardIndexManager a8;
        Object a9 = string;
        StandardIndexManager standardIndexManager = a8 = this;
        StandardIndexManager standardIndexManager2 = a8;
        StandardIndexManager standardIndexManager3 = a8;
        StandardIndexManager standardIndexManager4 = a8;
        a8.k = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager5 = a8;
        standardIndexManager4.J = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager6 = a8;
        a8.B = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager7 = a8;
        standardIndexManager3.j = new ConcurrentSkipListMap(Comparator.reverseOrder());
        StandardIndexManager standardIndexManager8 = a8;
        standardIndexManager3.K = new AtomicLong();
        standardIndexManager3.m = a7;
        standardIndexManager2.g = a6;
        standardIndexManager2.e = a9;
        standardIndexManager.D = a5;
        standardIndexManager.E = a4;
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a9;
        stringArray[2] = "type";
        stringArray[3] = a5.name();
        a9 = Tags.of((String[])stringArray);
        StandardIndexManager standardIndexManager9 = a8;
        void v10 = a3;
        a8.G = a3.rateMeter((MetricName)BaseMetricName.T, (Tags)a9);
        a8.d = v10.rateMeter((MetricName)BaseMetricName.za, (Tags)a9);
        standardIndexManager9.c = v10.counter((MetricName)BaseMetricName.D, (Tags)a9);
        standardIndexManager9.A = a3.counter((MetricName)BaseMetricName.ea, (Tags)a9);
        l.scheduleAtFixedRate(() -> {
            Object a2;
            StandardIndexManager standardIndexManager = this;
            StorageProperties storageProperties = (StorageProperties)standardIndexManager.m.get();
            StandardIndexManager standardIndexManager2 = standardIndexManager;
            while (standardIndexManager2.B.size() > storageProperties.getMaxIndexesInMemory()) {
                a2 = standardIndexManager.B.pollFirstEntry();
                C.debug(TagsConfiguration.C((Object)"\u0006\u0014GI>\u0005\u0012\u001a\u0014\u0007\u001aI\u0014\u0007\u0019\f\u0005I\u0006\u0014"), (Object)standardIndexManager.e, a2.getKey());
                standardIndexManager.i = l.schedule(() -> StandardIndexManager.C((Map.Entry)a2), 2L, TimeUnit.SECONDS);
                standardIndexManager2 = standardIndexManager;
            }
            StandardIndexManager standardIndexManager3 = standardIndexManager;
            while (standardIndexManager3.J.size() > storageProperties.getMaxBloomFiltersInMemory()) {
                StandardIndexManager standardIndexManager4 = standardIndexManager;
                standardIndexManager3 = standardIndexManager4;
                a2 = standardIndexManager4.J.pollFirstEntry();
                StandardIndexManager standardIndexManager5 = standardIndexManager;
                C.debug(RsocketEventPublishers.C((Object)"\u0012xS%;`\u0004j\u001f`\r%\u000bi\u0006j\u0004%\u000fl\u0005q\fwIc\u0006wI~\u0014%\u000fw\u0006hIh\fh\u0006w\u0010"), (Object)standardIndexManager5.e, a2.getKey());
                standardIndexManager5.A.increment();
            }
        }, 10L, 10L, TimeUnit.SECONDS);
        a8.b = a2;
    }

    /*
     * WARNING - void declaration
     */
    public void addToActiveSegment(long l2, String string, IndexEntry indexEntry) {
        StandardIndexManager a3;
        void a4;
        void a5;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntry;
        StandardIndexManager a6 = standardIndexManager;
        if (a6.j.containsKey((long)a5)) {
            throw new IndexNotFoundException((long)a5 + ": already completed");
        }
        a6.k.computeIfAbsent((long)a5, a2 -> new ConcurrentHashMap()).computeIfAbsent(a4, arg_0 -> StandardIndexManager.C((IndexEntry)a3, arg_0)).add((IndexEntry)a3);
    }

    private static /* synthetic */ IndexEntries C(IndexEntry indexEntry, String string) {
        Object a2 = string;
        IndexEntry a3 = indexEntry;
        return new StandardIndexEntries(a3.I());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean C(long l2, long l3, IndexEntries indexEntries) {
        void a2;
        void a3;
        StandardIndexManager a4;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntries;
        StandardIndexManager a5 = standardIndexManager;
        if (!a4.isEmpty() && a3 >= a4.firstSequenceNumber() || a2 <= 0L) {
            return true;
        }
        return false;
    }
}

