/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.transaction.PreparedTransaction;
import io.axoniq.axonserver.taskscheduler.task.AddNodeToContext;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

public class StorageProperties
implements Cloneable,
Serializable {
    private int flags;
    private long warnFreeSpace;
    private Duration[] retentionTime;
    private int readBufferSize;
    private Map<String, String> storages;
    private int memoryMappedSegments;
    private long forceInterval;
    private String storage;
    public static final String TRANSFORMED_SUFFIX = ".transformed";
    private final SystemInfoProvider systemInfoProvider;
    private GlobalIndexPreload globalIndexPreload;
    private Boolean forceCleanMmapIndex;
    private int globalIndexSegmentsCheck;
    private static final String PATH_FORMAT = "%s/%020d%s";
    private Duration globalIndexPreloadTimeout;
    private boolean bulkIndexAllowParallel;
    private String bloomIndexSuffix;
    private int segmentsForSequenceNumberCheck;
    private int primaryCleanupDelay;
    private String posIndexSuffix;
    private long syncInterval;
    private int sksMaxOpenedPositionIndexFiles;
    private static final String FILE_WITH_VERSION_FORMAT = "%020d_%05d%s";
    private String indexSuffix;
    private static final String OLD_PATH_FORMAT = "%s/%014d%s";
    private float bloomIndexFpp;
    private String newIndexSuffix;
    private Boolean forceClean;
    private long minFreeSpace;
    private static final String TEMP_PATH_FORMAT = "%s/%020d%s.temp";
    private String indexFormat;
    private int maxIndexesInMemory;
    private String sksPositionIndexFileSuffix;
    private String sksAggregateIdEncoder;
    public static final String PRIMARY_STORAGE_KEY = "primary";
    private int eventsPerSegmentPrefetch;
    private boolean useMmapIndex;
    private String eventsSuffix;
    private int entriesPerSegment;
    private int secondaryCleanupDelay;
    private int validationSegments;
    private String globalIndexSuffix;
    private int maxBloomFiltersInMemory;
    private boolean keepOldVersions;
    private static final String TRANSFORMED_PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s.transformed";
    private static final String FILE_FORMAT = "%020d%s";
    private static final int DEFAULT_READ_BUFFER_SIZE = 32768;
    private static final String TEMP_PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s.temp";
    private int sksRocksdbCacheSize;
    private int segmentSize;
    private static final String PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s";

    public int getEntriesPerSegment() {
        StorageProperties a2;
        return a2.entriesPerSegment;
    }

    /*
     * WARNING - void declaration
     */
    public String getStorage(String string, String string2) {
        void a2;
        Object a3 = string2;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[2];
        objectArray[0] = a4.getStorage((String)a2);
        objectArray[1] = a3;
        return String.format(PreparedTransaction.C((Object)"!p+&w"), objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public File newIndex(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.newIndexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public void setEventsSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.eventsSuffix = a2;
    }

    public String getNewIndexSuffix() {
        StorageProperties a2;
        return a2.newIndexSuffix;
    }

    /*
     * WARNING - void declaration
     */
    public File newTransformedIndex(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.C() == 0) {
            return a4.transformedIndex((String)a2, a3.C());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.C();
        objectArray[2] = a3.C();
        objectArray[3] = a4.newIndexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public String dataFile(long a2) {
        StorageProperties a3;
        Object[] objectArray = new Object[2];
        objectArray[0] = a2;
        objectArray[1] = a3.eventsSuffix;
        return String.format(FILE_FORMAT, objectArray);
    }

    public StorageProperties withIndexFormat(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.C().indexFormat = a2;
        return a3.C();
    }

    public void setPrimaryCleanupDelay(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.primaryCleanupDelay = a2;
    }

    public int getSegmentSize() {
        StorageProperties a2;
        return a2.segmentSize;
    }

    public void setSyncInterval(long a2) {
        a.syncInterval = a2;
    }

    public void setIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.indexSuffix = a2;
    }

    public GlobalIndexPreload getGlobalIndexPreload() {
        StorageProperties a2;
        return a2.globalIndexPreload;
    }

    public void setSksMaxOpenedPositionIndexFiles(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.sksMaxOpenedPositionIndexFiles = a2;
    }

    public void setSegmentsForSequenceNumberCheck(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.segmentsForSequenceNumberCheck = a2;
    }

    public StorageProperties(SystemInfoProvider systemInfoProvider) {
        StorageProperties a2;
        StorageProperties a3 = systemInfoProvider;
        StorageProperties storageProperties = a2 = this;
        StorageProperties storageProperties2 = a2;
        StorageProperties storageProperties3 = a2;
        StorageProperties storageProperties4 = a2;
        StorageProperties storageProperties5 = a2;
        StorageProperties storageProperties6 = a2;
        StorageProperties storageProperties7 = a2;
        StorageProperties storageProperties8 = a2;
        StorageProperties storageProperties9 = a2;
        StorageProperties storageProperties10 = a2;
        StorageProperties storageProperties11 = a2;
        a2.eventsSuffix = ".events";
        storageProperties11.indexSuffix = ".index";
        storageProperties11.newIndexSuffix = ".nindex";
        storageProperties10.globalIndexSuffix = ".xref";
        storageProperties10.bloomIndexSuffix = ".bloom";
        storageProperties9.segmentSize = 0x10000000;
        storageProperties9.storage = "./data";
        StorageProperties storageProperties12 = a2;
        storageProperties9.storages = new HashMap();
        storageProperties8.bloomIndexFpp = 0.03f;
        storageProperties8.forceInterval = 1000L;
        storageProperties7.validationSegments = 10;
        storageProperties7.memoryMappedSegments = 5;
        storageProperties6.primaryCleanupDelay = 0;
        storageProperties6.secondaryCleanupDelay = 0;
        storageProperties5.maxIndexesInMemory = 50;
        storageProperties5.maxBloomFiltersInMemory = 100;
        storageProperties4.syncInterval = 1000L;
        storageProperties4.useMmapIndex = true;
        storageProperties3.forceCleanMmapIndex = true;
        storageProperties3.eventsPerSegmentPrefetch = 10;
        storageProperties2.globalIndexSegmentsCheck = Integer.MAX_VALUE;
        storageProperties2.readBufferSize = 32768;
        storageProperties.keepOldVersions = false;
        Duration[] durationArray = new Duration[1];
        durationArray[0] = Duration.ofDays(7L);
        storageProperties.retentionTime = durationArray;
        StorageProperties storageProperties13 = a2;
        StorageProperties storageProperties14 = a2;
        StorageProperties storageProperties15 = a2;
        StorageProperties storageProperties16 = a2;
        StorageProperties storageProperties17 = a2;
        StorageProperties storageProperties18 = a2;
        storageProperties18.segmentsForSequenceNumberCheck = 10;
        storageProperties18.minFreeSpace = DataSize.ofMegabytes((long)512L).toBytes();
        storageProperties17.warnFreeSpace = DataSize.ofGigabytes((long)5L).toBytes();
        storageProperties17.entriesPerSegment = 1000000;
        storageProperties17.globalIndexPreload = GlobalIndexPreload.c;
        storageProperties16.globalIndexPreloadTimeout = Duration.ofSeconds(10L);
        storageProperties16.sksPositionIndexFileSuffix = ".rindex";
        storageProperties15.sksAggregateIdEncoder = "plain";
        storageProperties15.sksMaxOpenedPositionIndexFiles = 100;
        storageProperties14.sksRocksdbCacheSize = (int)DataSize.ofMegabytes((long)512L).toBytes();
        storageProperties14.posIndexSuffix = ".pos";
        storageProperties13.bulkIndexAllowParallel = false;
        storageProperties13.systemInfoProvider = a3;
    }

    /*
     * WARNING - void declaration
     */
    public File oldBloomFilter(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.bloomIndexSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    public void setForceInterval(long a2) {
        a.forceInterval = a2;
    }

    private /* synthetic */ StorageProperties C() {
        StorageProperties storageProperties = this;
        try {
            return (StorageProperties)storageProperties.clone();
        }
        catch (CloneNotSupportedException a2) {
            throw new RuntimeException(a2.getMessage(), a2);
        }
    }

    public int getMemoryMappedSegments() {
        StorageProperties a2;
        return a2.memoryMappedSegments;
    }

    public String getIndexFormat() {
        StorageProperties a2;
        return a2.indexFormat;
    }

    /*
     * WARNING - void declaration
     */
    public File newIndexTemp(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.newIndexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    public boolean isForceCleanMmapIndex() {
        StorageProperties a2;
        if (a2.forceCleanMmapIndex != null) {
            return a2.forceCleanMmapIndex;
        }
        return a2.systemInfoProvider.javaOnWindows();
    }

    public int getSksMaxOpenedPositionIndexFiles() {
        StorageProperties a2;
        return a2.sksMaxOpenedPositionIndexFiles;
    }

    public void setGlobalIndexPreloadTimeout(Duration duration) {
        Object a2 = duration;
        StorageProperties a3 = this;
        a3.globalIndexPreloadTimeout = a2;
    }

    public int getMaximumNumberOfPendingSegmentSeals() {
        return 3;
    }

    public void setBloomIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.bloomIndexSuffix = a2;
    }

    public void setGlobalIndexPreload(GlobalIndexPreload globalIndexPreload) {
        StorageProperties a2 = globalIndexPreload;
        StorageProperties a3 = this;
        a3.globalIndexPreload = a2;
    }

    public StorageProperties withSegmentSize(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.C().segmentSize = a2;
        return a3.C();
    }

    public int getSksRocksdbCacheSize() {
        StorageProperties a2;
        return a2.sksRocksdbCacheSize;
    }

    public StorageProperties withSksAggregateIdEncoder(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.C().sksAggregateIdEncoder = a2;
        return a3.C();
    }

    public void setNewIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.newIndexSuffix = a2;
    }

    public void setEntriesPerSegment(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.entriesPerSegment = a2;
    }

    public int globalIndexSegmentsCheck() {
        StorageProperties a2;
        return a2.globalIndexSegmentsCheck;
    }

    public int getEventsPerSegmentPrefetch() {
        StorageProperties a2;
        return a2.eventsPerSegmentPrefetch;
    }

    public void setIndexFormat(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.indexFormat = a2;
    }

    public int getSecondaryCleanupDelay() {
        StorageProperties a2;
        return a2.secondaryCleanupDelay;
    }

    public long minFreeSpace() {
        StorageProperties a2;
        return a2.minFreeSpace;
    }

    public void setBulkIndexAllowParallel(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.bulkIndexAllowParallel = a2;
    }

    public void setSksRocksdbCacheSize(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.sksRocksdbCacheSize = a2;
    }

    public StorageProperties withMaxIndexesInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.C().maxIndexesInMemory = a2;
        return a3.C();
    }

    /*
     * WARNING - void declaration
     */
    public File transformedDataFile(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.C() == 0) {
            throw new RuntimeException(PreparedTransaction.C((Object)"gbjmkw$wvbjpblvn$wk#rfvpmlj#4"));
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.C();
        objectArray[2] = a3.C();
        objectArray[3] = a4.eventsSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setBloomIndexFpp(float f2) {
        float a2 = f2;
        StorageProperties a3 = this;
        a3.bloomIndexFpp = a2;
    }

    public StorageProperties withGlobalIndexSegmentsCheck(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.C().globalIndexSegmentsCheck = a2;
        return a3.C();
    }

    public void setForceCleanMmapIndex(Boolean bl) {
        Object a2 = bl;
        StorageProperties a3 = this;
        a3.forceCleanMmapIndex = a2;
    }

    public String getStorage(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        String string2 = (String)a3.storages.get(a2);
        if (string2 == null) {
            if (PRIMARY_STORAGE_KEY.equals(a2)) {
                return a3.storage;
            }
            Object object = a2;
            throw new IllegalStateException("Storage " + (String)object + " not defined on this node.To define storage set property: axoniq.axonserver.event.storages." + (String)object);
        }
        return string2;
    }

    public float getBloomIndexFpp() {
        StorageProperties a2;
        return a2.bloomIndexFpp;
    }

    public boolean isCleanRequired() {
        StorageProperties a2;
        if (Boolean.TRUE.equals(a2.forceClean) || a2.systemInfoProvider.javaOnWindows()) {
            return true;
        }
        return false;
    }

    public StorageProperties withGlobalIndexPreloadTimeout(Duration duration) {
        Object a2 = duration;
        StorageProperties a3 = this;
        a3.C().globalIndexPreloadTimeout = a2;
        return a3.C();
    }

    public void setKeepOldVersions(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.keepOldVersions = a2;
    }

    public String getPrimaryStorage(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[2];
        objectArray[0] = a3.storages.getOrDefault(PRIMARY_STORAGE_KEY, a3.storage);
        objectArray[1] = a2;
        return String.format(AddNodeToContext.C((Object)"\u0017\u001b\u001dMA"), objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public File newIndex(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.C() == 0) {
            return a4.newIndex((String)a2, a3.C());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.C();
        objectArray[2] = a3.C();
        objectArray[3] = a4.newIndexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setStorages(Map<String, String> map) {
        Object a2 = map;
        StorageProperties a3 = this;
        if (a3.storages != null && a3.storages.containsKey(PRIMARY_STORAGE_KEY)) {
            a3.storages.putAll(a2);
            return;
        }
        a3.storages = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File indexTemp(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.C();
        objectArray[2] = a3.C();
        objectArray[3] = a4.indexSuffix;
        return new File(String.format(TEMP_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public boolean isKeepOldVersions() {
        StorageProperties a2;
        return a2.keepOldVersions;
    }

    public int getMaxBloomFiltersInMemory() {
        StorageProperties a2;
        return a2.maxBloomFiltersInMemory;
    }

    /*
     * WARNING - void declaration
     */
    public File oldIndex(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    public long getSyncInterval() {
        StorageProperties a2;
        return a2.syncInterval;
    }

    /*
     * WARNING - void declaration
     */
    public File dataFile(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        return a4.dataFile((String)a3, new FileVersion((long)a2, 0));
    }

    public StorageProperties withSegmentsForSequenceNumberCheck(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.C().segmentsForSequenceNumberCheck = a2;
        return a3.C();
    }

    public String getBloomIndexSuffix() {
        StorageProperties a2;
        return a2.bloomIndexSuffix;
    }

    public StorageProperties withSksMaxOpenedPositionIndexFiles(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.C().sksMaxOpenedPositionIndexFiles = a2;
        return a3.C();
    }

    public Boolean getForceClean() {
        StorageProperties a2;
        return a2.forceClean;
    }

    public String getSksPositionIndexFileSuffix() {
        StorageProperties a2;
        return a2.sksPositionIndexFileSuffix;
    }

    public boolean isBulkIndexAllowParallel() {
        StorageProperties a2;
        return a2.bulkIndexAllowParallel;
    }

    public int getPrimaryCleanupDelay() {
        StorageProperties a2;
        return a2.primaryCleanupDelay;
    }

    public void setStorage(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.storage = a2;
        if (a3.storages != null) {
            if (!a3.storages.containsKey(PRIMARY_STORAGE_KEY)) {
                a3.storages.put(PRIMARY_STORAGE_KEY, a2);
                return;
            }
        } else {
            a3.storages = new HashMap();
            a3.storages.put(PRIMARY_STORAGE_KEY, a2);
        }
    }

    public StorageProperties withGlobalIndexPreload(GlobalIndexPreload globalIndexPreload) {
        StorageProperties a2 = globalIndexPreload;
        StorageProperties a3 = this;
        a3.C().globalIndexPreload = a2;
        return a3.C();
    }

    public void setUseMmapIndex(Boolean bl) {
        Boolean a2 = bl;
        StorageProperties a3 = this;
        a3.useMmapIndex = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File transformedIndex(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.C() == 0) {
            return a4.transformedIndex((String)a2, a3.C());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.C();
        objectArray[2] = a3.C();
        objectArray[3] = a4.indexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setSegmentSize(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)PreparedTransaction.C((Object)"Wfcnamp#wj~f$nqpp#ff$oapw#pkem$15737<0273"));
        Assert.isTrue((a2.toBytes() > 0L ? 1 : 0) != 0, (String)AddNodeToContext.C((Object)"a\rU\u0005W\u0006FHA\u0001H\r\u0012\u0005G\u001bFHP\r\u0012\u000f@\rS\u001cW\u001a\u0012\u001cZ\t\\H\u0002"));
        a3.segmentSize = (int)a2.toBytes();
    }

    /*
     * WARNING - void declaration
     */
    public File newIndexTemp(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.C() == 0) {
            return a4.newIndexTemp((String)a2, a3.C());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.C();
        objectArray[2] = a3.C();
        objectArray[3] = a4.newIndexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public File index(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public Map<String, String> getAvailableStorages() {
        StorageProperties a2;
        return a2.storages;
    }

    public Duration getGlobalIndexPreloadTimeout() {
        StorageProperties a2;
        return a2.globalIndexPreloadTimeout;
    }

    public void setMaxBloomFiltersInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.maxBloomFiltersInMemory = a2;
    }

    public long getRetentionTime(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        if (a2 < 0 || a2 >= a3.retentionTime.length) {
            return System.currentTimeMillis();
        }
        return a3.retentionTime[a2].toMillis();
    }

    public int getMaxIndexesInMemory() {
        StorageProperties a2;
        return a2.maxIndexesInMemory;
    }

    /*
     * WARNING - void declaration
     */
    public File bloomFilter(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.bloomIndexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public void setWarnFreeSpace(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        a3.warnFreeSpace = a2.toBytes();
    }

    public void setGlobalIndexSegmentsCheck(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.globalIndexSegmentsCheck = a2;
    }

    public StorageProperties withBulkIndexAllowParallel(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.C().bulkIndexAllowParallel = a2;
        return a3.C();
    }

    public String getSksAggregateIdEncoder() {
        StorageProperties a2;
        return a2.sksAggregateIdEncoder;
    }

    public String getEventsSuffix() {
        StorageProperties a2;
        return a2.eventsSuffix;
    }

    public int segmentsForSequenceNumberCheck() {
        StorageProperties a2;
        return a2.segmentsForSequenceNumberCheck;
    }

    public void setMaxIndexesInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.maxIndexesInMemory = a2;
    }

    public Duration getSegmentSealingBlockInterval() {
        return Duration.ofSeconds(1L);
    }

    public void setSksAggregateIdEncoder(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.sksAggregateIdEncoder = a2;
    }

    public StorageProperties withSksRocksdbCacheSize(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.C().sksRocksdbCacheSize = a2;
        return a3.C();
    }

    public StorageProperties withRetentionTime(Duration[] durationArray) {
        Duration[] a2 = durationArray;
        Duration[] a3 = this;
        a3.C().retentionTime = a2;
        return a3.C();
    }

    public void setMemoryMappedSegments(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.memoryMappedSegments = a2;
    }

    public int getFlags() {
        StorageProperties a2;
        return a2.flags;
    }

    public void setSecondaryCleanupDelay(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.secondaryCleanupDelay = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File index(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.C() == 0) {
            return a4.index((String)a2, a3.C());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.C();
        objectArray[2] = a3.C();
        objectArray[3] = a4.indexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public long getForceInterval() {
        StorageProperties a2;
        return a2.forceInterval;
    }

    public void setEventsPerSegmentPrefetch(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.eventsPerSegmentPrefetch = a2;
    }

    public void setReadBufferSize(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.readBufferSize = a2;
    }

    public String dataFile(FileVersion fileVersion) {
        StorageProperties a2 = fileVersion;
        StorageProperties a3 = this;
        if (a2.C() == 0) {
            return a3.dataFile(a2.C());
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = a2.C();
        objectArray[1] = a2.C();
        objectArray[2] = a3.eventsSuffix;
        return String.format(FILE_WITH_VERSION_FORMAT, objectArray);
    }

    public long warnFreeSpace() {
        StorageProperties a2;
        return a2.warnFreeSpace;
    }

    public StorageProperties withKeepOldVersions(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.C().keepOldVersions = a2;
        return a3.C();
    }

    /*
     * WARNING - void declaration
     */
    public File indexTemp(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public StorageProperties(SystemInfoProvider systemInfoProvider, String string, String string2, String string3, String string4, String string5, String string6) {
        Object a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        StorageProperties a9;
        StorageProperties storageProperties = object;
        Object object = string6;
        StorageProperties storageProperties2 = a9 = storageProperties;
        StorageProperties storageProperties3 = a9;
        StorageProperties storageProperties4 = a9;
        a9((SystemInfoProvider)a8);
        storageProperties4.eventsSuffix = a7;
        storageProperties4.indexSuffix = a6;
        storageProperties3.bloomIndexSuffix = a5;
        storageProperties3.globalIndexSuffix = a4;
        storageProperties2.newIndexSuffix = a3;
        storageProperties2.sksPositionIndexFileSuffix = a2;
    }

    public void setMinFreeSpace(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        a3.minFreeSpace = a2.toBytes();
    }

    public void setSksPositionIndexFileSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.sksPositionIndexFileSuffix = a2;
    }

    public void setRetentionTime(Duration[] durationArray) {
        Duration[] a2 = durationArray;
        Duration[] a3 = this;
        a3.retentionTime = a2;
    }

    public void setForceClean(Boolean bl) {
        Object a2 = bl;
        StorageProperties a3 = this;
        a3.forceClean = a2;
    }

    public String getIndexSuffix() {
        StorageProperties a2;
        return a2.indexSuffix;
    }

    /*
     * WARNING - void declaration
     */
    public File posIndex(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.posIndexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public boolean isUseMmapIndex() {
        StorageProperties a2;
        return a2.useMmapIndex;
    }

    /*
     * WARNING - void declaration
     */
    public File transformedIndex(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    public StorageProperties withForceClean(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.C().forceClean = a2;
        return a3.C();
    }

    public int getReadBufferSize() {
        StorageProperties a2;
        return a2.readBufferSize;
    }

    public void setValidationSegments(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.validationSegments = a2;
    }

    public void setGlobalIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.globalIndexSuffix = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File oldDataFile(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.eventsSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    public void setFlags(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.flags = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File bloomFilter(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.C() == 0) {
            return a4.bloomFilter((String)a2, a3.C());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.C();
        objectArray[2] = a3.C();
        objectArray[3] = a4.bloomIndexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public File dataFile(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        return new File((String)a2 + File.separator + a4.dataFile((FileVersion)a3));
    }

    public StorageProperties withMaxBloomFiltersInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.C().maxBloomFiltersInMemory = a2;
        return a3.C();
    }

    public String getGlobalIndexSuffix() {
        StorageProperties a2;
        return a2.globalIndexSuffix;
    }

    public int getValidationSegments() {
        StorageProperties a2;
        return a2.validationSegments;
    }
}

