/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.file.AbstractFileStorageTier;
import io.axoniq.axonserver.localstorage.file.ByteBufferEventSource;
import io.axoniq.axonserver.localstorage.file.EventInformation;
import io.axoniq.axonserver.localstorage.file.EventSource;
import io.axoniq.axonserver.localstorage.file.FilePreparedTransaction;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.Segment;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.StorageTier;
import io.axoniq.axonserver.localstorage.file.Synchronizer;
import io.axoniq.axonserver.localstorage.file.WritableEventSource;
import io.axoniq.axonserver.localstorage.file.WritePosition;
import io.axoniq.axonserver.localstorage.file.m;
import io.axoniq.axonserver.localstorage.transformation.EventTransformer;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.localstorage.transformation.ProcessedEvent;
import io.axoniq.axonserver.localstorage.transformation.WrappedEvent;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.plugin.AdminPluginContextManager;
import io.axoniq.axonserver.rest.NodeAndRole;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WritableFileStorageTier
extends AbstractFileStorageTier {
    private final FileSystemMonitor d;
    private final Gauge L;
    private final EventTransformer G;
    protected final ConcurrentNavigableMap<Long, ByteBufferEventSource> A;
    private final MeterFactory B;
    protected final AtomicReference<WritePosition> C;
    protected final AtomicLong j;
    private static final Logger B = LoggerFactory.getLogger(WritableFileStorageTier.class);
    private final Synchronizer m;
    private Path c;

    /*
     * WARNING - void declaration
     */
    public void activateSegmentVersion(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        a4.C(arg_0 -> WritableFileStorageTier.C((long)a2, a3, arg_0));
    }

    public long g() {
        WritableFileStorageTier a2;
        return a2.j.get();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(Map map, ProcessedEvent processedEvent, long l2, int n) {
        void a2;
        void a3;
        void a4;
        void a5;
        int n2 = n;
        WritableFileStorageTier a6 = this;
        a6.C((ProcessedEvent)a5, (long)a4, (int)a3, (Map)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(long l2, Integer n) {
        void a2;
        Integer a3 = n;
        WritableFileStorageTier a4 = this;
        a4.C((long)a2, a3.intValue());
    }

    /*
     * WARNING - void declaration
     */
    public Integer currentSegmentVersion(Long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.A.get(a2);
        if (a3 != null) {
            return a3.C();
        }
        return (Integer)writableFileStorageTier.C(arg_0 -> WritableFileStorageTier.C((Long)a2, arg_0), (Object)0);
    }

    public long C(List<Event> list, int n) {
        FilePreparedTransaction a2;
        WritableFileStorageTier a3;
        int a222 = n;
        WritableFileStorageTier writableFileStorageTier = a3 = this;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.d.checkFreeSpace(writableFileStorageTier2.c);
        HashMap hashMap = new HashMap();
        a2 = writableFileStorageTier.C((List)a2, a222);
        WritePosition a222 = a2.C();
        writableFileStorageTier2.C(a222, a2.C(), hashMap);
        writableFileStorageTier.I.addToActiveSegment(a222.c, hashMap);
        writableFileStorageTier.j.set(a222.L + (long)a2.C().size() - 1L);
        writableFileStorageTier.m.I(a222);
        return a222.L;
    }

    private static /* synthetic */ Optional C(long a2, StorageTier a3) {
        return a3.eventSource(a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void g(long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)writableFileStorageTier.A.remove((long)a2);
        int a3 = 0;
        if (byteBufferEventSource != null) {
            ByteBufferEventSource byteBufferEventSource2 = byteBufferEventSource;
            a3 = byteBufferEventSource2.C();
            byteBufferEventSource2.C(0L);
        }
        writableFileStorageTier.C((long)a2, a3).forEach(arg_0 -> writableFileStorageTier.C((long)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public void C(long l2, long l3) {
        void a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a4 = (StorageProperties)writableFileStorageTier.b.get();
        File file = new File(writableFileStorageTier.E);
        FileUtils.C((File)file);
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
        writableFileStorageTier.I.init();
        writableFileStorageTier2.C((long)a3, file, (long)a2, (StorageProperties)a4);
        writableFileStorageTier2.c = file.toPath();
        writableFileStorageTier2.d.registerPath(writableFileStorageTier.C(), writableFileStorageTier.c, a4.minFreeSpace(), a4.warnFreeSpace());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(WritePosition writePosition, List<ProcessedEvent> list, Map<String, List<IndexEntry>> map) {
        void a2;
        void a3;
        WritableFileStorageTier a4 = writePosition;
        WritableFileStorageTier a5 = this;
        WritableFileStorageTier writableFileStorageTier = a4;
        a4.G.C((List)a3, writableFileStorageTier.m, writableFileStorageTier.L, (arg_0, arg_1, arg_2) -> a5.C((Map)a2, arg_0, arg_1, arg_2));
    }

    public long I() {
        WritableFileStorageTier a2;
        return ((WritePosition)a2.C.get()).L;
    }

    private /* synthetic */ String C() {
        WritableFileStorageTier a2;
        WritableFileStorageTier writableFileStorageTier = a2;
        return writableFileStorageTier.j + "-" + writableFileStorageTier.j.C().name().toLowerCase();
    }

    protected Optional<EventSource> C(long a2) {
        WritableFileStorageTier a3;
        if (a3.A.containsKey(a2)) {
            return Optional.of((EventSource)a3.A.get(a2));
        }
        return Optional.empty();
    }

    private static /* synthetic */ Flux C(String string, StorageTier storageTier) {
        String a2 = storageTier;
        String a3 = string;
        return a2.fileVersions(a3);
    }

    private static /* synthetic */ Stream I(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    public Stream<String> C(long l2, int n, boolean bl) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        if (a3 != false) {
            return Stream.concat(a5.A.entrySet().stream().map(entry -> {
                Map.Entry a2 = entry;
                Object a3 = this;
                return FileUtils.C((File)a3.C(new FileVersion(((Long)a2.getKey()).longValue(), ((ByteBufferEventSource)a2.getValue()).C())));
            }), (Stream)a5.C(arg_0 -> WritableFileStorageTier.I((long)a2, a4, arg_0), Stream.empty()));
        }
        return (Stream)a5.C(arg_0 -> WritableFileStorageTier.C((long)a2, a4, arg_0), Stream.empty());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void I(WritePosition writePosition) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.A.remove(a2.c);
        B.debug(AdminPluginContextManager.C((Object)"n\u0005H\u0000C\u0000\u0006\u000bP\u0001TD]\u0019\nDT\u0001K\u0005O\nO\nADU\u0001A\tC\nR\u0017\u001cD]\u0019"), (Object)a2.c, (Object)writableFileStorageTier.getSegments());
        if (a3 != null) {
            a3.C((long)((StorageProperties)writableFileStorageTier.b.get()).getPrimaryCleanupDelay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ FileVersion C(FileVersion fileVersion, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        WritableEventSource a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier2 = this;
        if (!writableFileStorageTier2.I.validIndex((FileVersion)a3)) {
            return a3;
        }
        a2 = writableFileStorageTier2.C((FileVersion)a3, a2.getSegmentSize(), false);
        long l2 = a3.C();
        try {
            WritableFileStorageTier a42222 = a2.createEventIterator(a3.C());
            try {
                while (a42222.hasNext()) {
                    a42222.C();
                    ++l2;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (a42222 != null) {
                    try {
                        a42222.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable a42222) {
                        throwable.addSuppressed(a42222);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
        catch (Throwable a42222) {
            writableFileStorageTier2.A.remove(a3.C());
            a2.C(0L);
            throw a42222;
        }
        if (a42222 != null) {
            writableFileStorageTier = writableFileStorageTier2;
            a42222.close();
        } else {
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.A.remove(a3.C());
        a2.C(0L);
        return new FileVersion(l2, 0);
    }

    public Flux<FileVersion> fileVersions(String string) {
        Object a2 = string;
        WritableFileStorageTier a3 = this;
        return (Flux)a3.C(arg_0 -> WritableFileStorageTier.C((String)a2, arg_0), (Object)Flux.empty());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(long l2, File file, long l3, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        int n;
        WritableFileStorageTier a3;
        HashMap<String, List> a222;
        WritableEventSource a4;
        FileVersion a5;
        long a6;
        WritableFileStorageTier writableFileStorageTier2;
        block10: {
            block8: {
                void a222;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier2 = this;
                a5 = writableFileStorageTier3.C(a6, (File)a5, new FileVersion((long)a222, 0), (StorageProperties)a4);
                writableFileStorageTier3.C(a5.C());
                a5 = writableFileStorageTier3.C(a5, (StorageProperties)a4);
                writableFileStorageTier3.C((T storageTier) -> {
                    FileVersion a2 = storageTier;
                    FileVersion a3 = a5;
                    a2.initSegments(a3.C());
                });
                WritableFileStorageTier writableFileStorageTier4 = writableFileStorageTier2;
                writableFileStorageTier4.I();
                a4 = writableFileStorageTier4.C(a5, a4.getSegmentSize(), false);
                writableFileStorageTier4.I.remove(a5);
                a6 = a5.C();
                a222 = new HashMap<String, List>();
                a3 = a4.createEventIterator();
                try {
                    WritableFileStorageTier writableFileStorageTier5 = a3;
                    while (writableFileStorageTier5.hasNext()) {
                        EventInformation eventInformation = a3.C();
                        if (eventInformation.C()) {
                            IndexEntry indexEntry = new IndexEntry(eventInformation.C().getAggregateSequenceNumber(), eventInformation.C(), a6);
                            a222.computeIfAbsent(eventInformation.C().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                        }
                        ++a6;
                        writableFileStorageTier5 = a3;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (a3 != null) {
                            try {
                                a3.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                n = a3.C();
                writableFileStorageTier2.j.set(a6 - 1L);
                if (a3 == null) break block8;
                writableFileStorageTier = writableFileStorageTier2;
                a3.close();
                break block10;
            }
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.I.addToActiveSegment(Long.valueOf(a5.C()), a222);
        a4.C(n, 0);
        a3 = new WritePosition(a6, n, a5.C(), a4, Long.valueOf(a5.C()), 0);
        WritableFileStorageTier writableFileStorageTier6 = writableFileStorageTier2;
        writableFileStorageTier6.C.set(a3);
        writableFileStorageTier6.m.C((WritePosition)a3);
        B.info(AdminPluginContextManager.C((Object)"]\u0019\u001cDu\u0001A\tC\nR\u0017\u0006\rH\rR\rG\bO\u001eC\u0000"), (Object)writableFileStorageTier2.j);
    }

    protected Optional<EventSource> C(FileVersion fileVersion) {
        WritableFileStorageTier a2 = fileVersion;
        WritableFileStorageTier a3 = this;
        return a3.C(a2.C());
    }

    public void handover(Segment segment, Runnable runnable) {
        Runnable a2 = runnable;
        WritableFileStorageTier a3 = this;
        a2.run();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean C(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.A.remove((long)a2);
        if (byteBufferEventSource != null) {
            byteBufferEventSource.C(0L);
        }
        if (a4.I.remove(a3 = new FileVersion((long)a2, a3)) && FileUtils.C((File)a4.C(a3))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ WritePosition C(int n, int n2, int n3, WritePosition writePosition) {
        void a2;
        void a3;
        WritePosition a4 = writePosition;
        int a5 = n;
        return a4.C(a5, (int)a3, (int)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(ProcessedEvent processedEvent, long l2, int n, Map<String, List<IndexEntry>> map) {
        WritableFileStorageTier a3 = processedEvent;
        WritableFileStorageTier a4 = this;
        if (a3.isDomainEvent()) {
            void a5;
            void a6;
            void a7;
            a7.computeIfAbsent(a3.getAggregateIdentifier(), a2 -> new ArrayList()).add(new IndexEntry(a3.getAggregateSequenceNumber(), (int)a6, (long)a5));
        }
    }

    private /* synthetic */ void C(SortedSet<FileVersion> sortedSet) {
        SortedSet<FileVersion> a2 = sortedSet;
        WritableFileStorageTier a3 = this;
        B.warn(AdminPluginContextManager.C((Object)"\u001f[^\u0006&S\bMIE\u0016C\u0005R\rH\u0003\u0006\rH\u0000C\u001c\u0006\u0001H\u0010T\rC\u0017\u0006\u0002I\u0016\u0006\u001f[DU\u0001A\tC\nR\u0017"), (Object)a3.j, (Object)a2.size());
        Instant instant = Instant.now();
        if (a3.I.canBatchIndexParallel() && ((StorageProperties)a3.b.get()).isBulkIndexAllowParallel()) {
            B.info(NodeAndRole.C((Object)"1\"p\u007f\u00031.:26$8j(#+\"\u007f:>8>&3/3j,?/:08+"), (Object)a3.j);
            a2.parallelStream().forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.C(arg_0 -> WritableFileStorageTier.I((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.C());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.C();
                        if (!eventInformation.C()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.C().getAggregateSequenceNumber(), eventInformation.C(), eventInformation.C());
                        hashMap.computeIfAbsent(eventInformation.C().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.I.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        } else {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.j;
            objectArray[1] = a3.I.canBatchIndexParallel();
            objectArray[2] = ((StorageProperties)a3.b.get()).isBulkIndexAllowParallel();
            B.info(AdminPluginContextManager.C((Object)"\u001f[^\u0006-H\u0000C\u001cO\nADU\u0001W\u0011C\nR\rG\bJ\u001d\u0006Lc\u0012G\bS\u0005R\rI\n\u0006\u000b@DV\u0005T\u0005J\bC\b\u0006\rH\u0000C\u001cO\nA^\u0006\rH\u0000C\u001ce\u0005V\u0005D\rJ\rR\rC\u0017\u001c\u001f[D\u0000B\u0006\u0007I\nR\u0001^\u0010u\u0001R\u0010O\nA\u0017\u001c\u001f[M"), objectArray);
            a2.forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.C(arg_0 -> WritableFileStorageTier.I((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.C());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.C();
                        if (!eventInformation.C()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.C().getAggregateSequenceNumber(), eventInformation.C(), eventInformation.C());
                        hashMap.computeIfAbsent(eventInformation.C().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.I.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        }
        B.warn(NodeAndRole.C((Object)"$7ej\u001d?3!r)-/>>6$8j6$;/'j+%0!\u007f1\""), (Object)a3.j, (Object)Duration.between(instant, Instant.now()));
    }

    private static /* synthetic */ Optional I(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }

    /*
     * WARNING - void declaration
     */
    public WritableFileStorageTier(EventTypeContext eventTypeContext, IndexManager indexManager, Supplier<StorageProperties> supplier, Supplier<StorageTier> supplier2, MeterFactory meterFactory, ScheduledExecutorService scheduledExecutorService, String string, EventTransformerFactory eventTransformerFactory, FileSystemMonitor fileSystemMonitor) {
        void a2;
        void a3;
        void a4;
        void a5;
        WritableFileStorageTier a6;
        void a7;
        void a8;
        void a9;
        void a10;
        WritableFileStorageTier a11;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = meterFactory;
        WritableFileStorageTier writableFileStorageTier3 = a11 = writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier4 = a11;
        super((EventTypeContext)a10, (IndexManager)a9, (Supplier)a8, (Supplier)a7, (MeterFactory)a6, (String)a5);
        WritableFileStorageTier writableFileStorageTier5 = a11;
        writableFileStorageTier5.C = new AtomicReference();
        WritableFileStorageTier writableFileStorageTier6 = a11;
        writableFileStorageTier4.j = new AtomicLong(-1L);
        WritableFileStorageTier writableFileStorageTier7 = a11;
        writableFileStorageTier4.A = new ConcurrentSkipListMap(Comparator.reverseOrder());
        writableFileStorageTier4.B = a6;
        writableFileStorageTier3.d = a4;
        writableFileStorageTier3.G = a3.get(((StorageProperties)a8.get()).getFlags());
        WritableFileStorageTier writableFileStorageTier8 = a11;
        writableFileStorageTier8.m = new Synchronizer((EventTypeContext)a10, (StorageProperties)a8.get(), (MeterFactory)a6, (ScheduledExecutorService)a2, writePosition -> {
            WritableFileStorageTier a2;
            WritableFileStorageTier a3 = writePosition;
            WritableFileStorageTier writableFileStorageTier = a2 = this;
            writableFileStorageTier.I.complete(new FileVersion(a3.c.longValue(), 0));
            writableFileStorageTier.C(arg_0 -> writableFileStorageTier.C((WritePosition)a3, arg_0));
        });
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a10.C();
        stringArray[2] = "type";
        stringArray[3] = a10.C().name();
        a11.L = a6.gauge((MetricName)BaseMetricName.ma, Tags.of((String[])stringArray), (Object)a11.m, synchronizer -> {
            WritableFileStorageTier a2 = synchronizer;
            WritableFileStorageTier a3 = this;
            return (double)a3.j.get() - (double)a2.C();
        });
    }

    public void close(boolean bl) {
        boolean a2 = bl;
        WritableFileStorageTier a3 = this;
        File file = new File(a3.E);
        WritableFileStorageTier writableFileStorageTier = a3;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.d.unregisterPath(writableFileStorageTier2.C());
        writableFileStorageTier.B.remove((Meter)a3.L);
        writableFileStorageTier2.m.I();
        writableFileStorageTier.A.forEach((l2, byteBufferEventSource) -> {
            void a2;
            WritableFileStorageTier a3 = byteBufferEventSource;
            WritableFileStorageTier a4 = this;
            a3.C(0L);
            if (a2 != false) {
                void a5;
                a4.g(a5.longValue());
            }
        });
        a3.C((T storageTier) -> {
            StorageTier a2 = storageTier;
            boolean a3 = a2;
            a2.close(a3);
        });
        boolean bl2 = a2;
        a3.I.cleanup(bl2);
        if (bl2) {
            FileUtils.C((File)file);
        }
    }

    private /* synthetic */ void I() {
        WritableFileStorageTier writableFileStorageTier = this;
        Object a2 = writableFileStorageTier.segmentsWithoutIndex();
        if (a2.size() > 0) {
            writableFileStorageTier.C((SortedSet)a2);
        }
        B.info(NodeAndRole.C((Object)"$7ej\u0016$;/'j0$\u007f.694j69\u007f?/j+%\u007f.>>:"), (Object)writableFileStorageTier.j);
    }

    /*
     * WARNING - void declaration
     */
    public void I(long l2) {
        void a22;
        WritableFileStorageTier writableFileStorageTier = this;
        if (!writableFileStorageTier.A.containsKey((long)a22)) {
            return;
        }
        if (a22 == ((Long)writableFileStorageTier.A.firstKey()).longValue()) {
            B.info(AdminPluginContextManager.C((Object)"]\u0019\u001cD`\u000bT\u0007O\nADH\u0001^\u0010\u0006\u0017C\u0003K\u0001H\u0010\u0006\u0010IDD\u0001\u0006\u0007T\u0001G\u0010C\u0000"), (Object)writableFileStorageTier.j);
            StorageProperties a22 = (StorageProperties)writableFileStorageTier.b.get();
            WritePosition writePosition2 = (WritePosition)writableFileStorageTier.C.getAndUpdate(writePosition -> {
                StorageProperties a2 = writePosition;
                StorageProperties a3 = a22;
                return a2.C(0, a3.getSegmentSize(), 0);
            });
            if (writePosition2.g(a22.getSegmentSize())) {
                B.debug(NodeAndRole.C((Object)"$7ej\u001c8:++#1-\u007f$:=\u007f9:-2/1>\u007f1\""), (Object)writableFileStorageTier.j, (Object)writePosition2.L);
                WritePosition writePosition3 = writePosition2;
                writePosition3.G.C(writePosition3.m, -1);
                WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier;
                WritableFileStorageTier a3 = writableFileStorageTier2.C(new FileVersion(writePosition2.L, 0), a22.getSegmentSize(), false);
                writableFileStorageTier.C.set(writePosition2.C((WritableEventSource)a3, 0));
                writableFileStorageTier2.m.I(new WritePosition(writePosition2.L, 0, 0, (WritableEventSource)a3, Long.valueOf(writePosition2.L), writePosition2.B));
            }
        }
        writableFileStorageTier.C();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FilePreparedTransaction C(List<Event> list, int n) {
        void a22;
        Object a3 = list;
        WritableFileStorageTier a4 = this;
        a3 = a3.stream().map(event -> {
            WritableFileStorageTier a2 = event;
            WritableFileStorageTier a3 = this;
            return new WrappedEvent((Event)a2, a3.G);
        }).collect(Collectors.toList());
        WritableFileStorageTier writableFileStorageTier = a4;
        int n2 = writableFileStorageTier.C((List)a3);
        WritePosition a22 = writableFileStorageTier.C(n2, a3.size(), (int)a22);
        return new FilePreparedTransaction(a22, n2, (List)a3);
    }

    public SortedSet<FileVersion> segmentsWithoutIndex() {
        WritableFileStorageTier a2;
        return (SortedSet)a2.C(StorageTier::segmentsWithoutIndex, Collections.emptySortedSet());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FileVersion C(long l2, File file, FileVersion fileVersion, StorageProperties storageProperties) {
        void a2;
        void a3;
        WritableFileStorageTier a4;
        void a5;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = storageProperties;
        WritableFileStorageTier a6 = writableFileStorageTier;
        return Arrays.stream(FileUtils.C((File)a5, (String)a4.getEventsSuffix())).map(FileUtils::C).filter(arg_0 -> WritableFileStorageTier.C((long)a3, arg_0)).max(FileVersion::C).orElse((FileVersion)a2);
    }

    public long C() {
        WritableFileStorageTier a3;
        return (Long)a3.C((T a2) -> a2.allSegments().findFirst().orElse(-1L), (Object)-1L);
    }

    private /* synthetic */ void C() {
        WritableFileStorageTier writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier = this;
        while (true) {
            if (writableFileStorageTier2.A.size() == 1) break;
            try {
                Thread.sleep(10L);
                writableFileStorageTier2 = writableFileStorageTier;
            }
            catch (InterruptedException a2) {
                Thread.currentThread().interrupt();
                throw new MessagingPlatformException(ErrorCode.OTHER, writableFileStorageTier.j + ": Interrupted while waiting for completion", (Throwable)a2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ WritePosition C(int n, int n2, int n3) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        int n4 = (int)Math.ceil((double)a3 / 32767.0);
        if ((n4 = a4 + n4 * 11) > 0x7FFFFFF6 || a4 <= 0) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a4;
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, String.format(AdminPluginContextManager.C((Object)"o\bJ\u0001A\u0005JDR\u0016G\nU\u0005E\u0010O\u000bHDU\r\\\u0001\u001cD\u0003\u0000"), objectArray));
        }
        do {
            if (!(a4 = (WritePosition)a5.C.getAndUpdate(arg_0 -> WritableFileStorageTier.C((int)a3, n4, (int)a2, arg_0))).g(n4) && !a4.C((int)a2)) continue;
            B.debug(NodeAndRole.C((Object)"$7ej\u001c8:++#1-\u007f$:=\u007f9:-2/1>\u007f1\""), (Object)a5.j, (Object)a4.L);
            WritePosition writePosition = a4;
            writePosition.G.C(writePosition.m, -1);
            WritableEventSource writableEventSource = a5.C(new FileVersion(a4.L, (int)a2), n4 + 5 + 4, true);
            a5.C.set(a4.C(writableEventSource, (int)a2));
        } while (!a4.I(n4) || a4.C((int)a2));
        return a4;
    }

    public SortedSet<Long> getSegments() {
        WritableFileStorageTier a2;
        return a2.A.keySet();
    }

    private static /* synthetic */ boolean C(long a2, FileVersion a3) {
        if (a3.C() < a2) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeSegment(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        if (a4.A.containsKey((long)a2)) {
            return a4.C((long)a2, a3);
        }
        return (Boolean)a4.C(arg_0 -> WritableFileStorageTier.C((long)a2, a3, arg_0), (Object)true);
    }

    private /* synthetic */ int C(List<ProcessedEvent> list) {
        Object a2 = list;
        WritableFileStorageTier a3 = this;
        long l2 = 0L;
        Object object = a2 = a2.iterator();
        while (object.hasNext()) {
            ProcessedEvent processedEvent = (ProcessedEvent)a2.next();
            l2 += (long)(4 + processedEvent.getSerializedSize());
            object = a2;
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, a3.j + ": Transaction size exceeds maximum size");
        }
        return (int)l2;
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.C((long)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.C(arg_0 -> WritableFileStorageTier.C((long)a2, arg_0), Optional.empty());
    }

    private static /* synthetic */ Boolean C(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.removeSegment(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(WritePosition writePosition, StorageTier storageTier) {
        void a2;
        WritableFileStorageTier a3 = writePosition;
        WritableFileStorageTier a4 = this;
        a2.handover((Segment)new m(a4, (WritePosition)a3), () -> a4.I((WritePosition)a3));
    }

    public int C() {
        WritableFileStorageTier a2;
        return a2.A.size();
    }

    private static /* synthetic */ Integer C(Long l2, StorageTier storageTier) {
        Long a2 = storageTier;
        Long a3 = l2;
        return a2.currentSegmentVersion(a3);
    }

    private static /* synthetic */ Stream C(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    protected WritableEventSource C(FileVersion fileVersion, int n, boolean bl) {
        WritableEventSource a2322;
        Object a32222;
        Object object;
        void a4;
        WritableFileStorageTier writableFileStorageTier;
        block21: {
            void a223322;
            writableFileStorageTier = this;
            StorageProperties storageProperties = (StorageProperties)writableFileStorageTier.b.get();
            File file = storageProperties.dataFile(writableFileStorageTier.E, (FileVersion)a4);
            int n2 = Math.max(storageProperties.getSegmentSize(), (int)a223322);
            if (file.exists()) {
                void a2322;
                if (a2322 != false && file.length() < (long)a223322) {
                    object = (ByteBufferEventSource)writableFileStorageTier.A.remove(a4.C());
                    if (object != null) {
                        object.C(0L);
                    }
                    FileUtils.C((File)file);
                } else {
                    n2 = (int)file.length();
                }
            } else if (a4.C() > 0) {
                object = storageProperties.dataFile(writableFileStorageTier.E, new FileVersion(a4.C(), 0));
                if (((File)object).exists()) {
                    a32222 = (ByteBufferEventSource)writableFileStorageTier.A.remove(a4.C());
                    if (a32222 != null) {
                        a32222.C(0L);
                    }
                    FileUtils.C((File)object);
                }
            }
            object = new RandomAccessFile(file, AdminPluginContextManager.C((Object)"T\u0013"));
            a32222 = ((RandomAccessFile)object).getChannel();
            B.info(NodeAndRole.C((Object)"$7ej\u0010::$6$8j9#3/\u007f1\""), (Object)writableFileStorageTier.j, (Object)file);
            MappedByteBuffer mappedByteBuffer = ((FileChannel)a32222).map(FileChannel.MapMode.READ_WRITE, 0L, n2);
            mappedByteBuffer.put((byte)2);
            mappedByteBuffer.putInt(storageProperties.getFlags());
            WritableEventSource a223322 = new WritableEventSource(file.getAbsolutePath(), (ByteBuffer)mappedByteBuffer, a4.C(), a4.C(), writableFileStorageTier.G, storageProperties);
            writableFileStorageTier.A.put(a4.C(), a223322);
            a2322 = a223322;
            if (a32222 == null) break block21;
            ((AbstractInterruptibleChannel)a32222).close();
        }
        ((RandomAccessFile)object).close();
        return a2322;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Throwable throwable2;
                        block22: {
                            if (a32222 != null) {
                                try {
                                    ((AbstractInterruptibleChannel)a32222).close();
                                    throwable2 = throwable;
                                    break block22;
                                }
                                catch (Throwable a223322) {
                                    throwable.addSuppressed(a223322);
                                }
                            }
                            throwable2 = throwable;
                        }
                        throw throwable2;
                    }
                    catch (Throwable a32222) {
                        Throwable throwable3;
                        try {
                            ((RandomAccessFile)object).close();
                            throwable3 = a32222;
                        }
                        catch (Throwable throwable4) {
                            Throwable throwable5 = a32222;
                            throwable3 = throwable5;
                            throwable5.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Exception exception) {
                    throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, writableFileStorageTier.j + ": Failed to create segment: " + (FileVersion)a4, (Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(FileVersion fileVersion) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.C((FileVersion)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.C(arg_0 -> WritableFileStorageTier.C((FileVersion)a2, arg_0), Optional.empty());
    }

    private static /* synthetic */ void C(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        a3.activateSegmentVersion(a2, a4);
    }

    public void initSegments(long a2) {
    }

    private static /* synthetic */ Optional C(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }

    public long size() {
        WritableFileStorageTier a3;
        return a3.A.values().stream().mapToLong(a2 -> a2.C.capacity()).sum() + (Long)a3.C(StorageTier::size, (Object)0L);
    }
}

