/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.config.KeyStoreWatcher;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="QueryCache")
public class QueryCache
implements NonReplacingConstraintCache<String, ActiveQuery> {
    private final long B;
    private final long C;
    private final Logger j;
    private final Map<String, ActiveQuery> m;
    private final int c = 25000;

    public int size() {
        QueryCache a2;
        return a2.m.size();
    }

    public QueryCache(@Value(value="${axoniq.axonserver.default-query-timeout:300000}") long defaultQueryTimeout, @Value(value="${axoniq.axonserver.query-cache-capacity:0}") long a2) {
        QueryCache queryCache = this;
        QueryCache queryCache2 = this;
        queryCache2.j = LoggerFactory.getLogger(QueryCache.class);
        queryCache2.c = 25000;
        QueryCache queryCache3 = this;
        queryCache.m = new ConcurrentHashMap();
        queryCache.C = defaultQueryTimeout;
        if (a2 > 0L) {
            this.B = a2;
            return;
        }
        defaultQueryTimeout = DataSize.ofBytes((long)Runtime.getRuntime().maxMemory()).toGigabytes();
        this.B = defaultQueryTimeout > 0L ? 25000L * defaultQueryTimeout : 25000L;
    }

    public boolean isEmpty() {
        QueryCache a2;
        return a2.m.isEmpty();
    }

    public ActiveQuery get(String string) {
        Object a2 = string;
        QueryCache a3 = this;
        return (ActiveQuery)a3.m.get(a2);
    }

    public Collection<Map.Entry<String, ActiveQuery>> entrySet() {
        QueryCache a2;
        return a2.m.entrySet();
    }

    private /* synthetic */ void C() {
        QueryCache a2;
        if ((long)a2.m.size() >= a2.B) {
            throw new InsufficientBufferCapacityException("Query buffer is full (" + a2.B + "/" + a2.B + ") Query handlers might be slow. Try increasing 'axoniq.axonserver.query-cache-capacity' property.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(ActiveQuery activeQuery, String string) {
        void a2;
        Object a3 = string;
        QueryCache a4 = this;
        a4.j.debug(KeyStoreWatcher.C((Object)"?H\u0011W\u0010B\bB\\V\tB\u000e^\\\\\u0001\u0007\u001aH\u000e\u0007\rR\u0019U\u0005\u0007\u0014F\u0012C\u0010B\u000e\u0007\u0015C\u0019I\bN\u001aN\u0019C\\E\u0005\u0007\u001fK\u0015B\u0012S/S\u000eB\u001dJ5C\\\\\u0001\t"), (Object)a2.g(), a3);
        if (a2.g((String)a3)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a3;
            if (a2.C((String)a3, ErrorCode.CONNECTION_TO_HANDLER_LOST, String.format(ActiveQuery.C((Object)"-f\u0000g\u000bj\u001a`\u0001gN}\u0001)\u0006h\u0000m\u0002l\u001c)KzNe\u0001z\u001a"), objectArray))) {
                a4.remove(a2.g());
            }
        }
    }

    public ActiveQuery remove(String string) {
        QueryCache a2;
        Object a3 = string;
        QueryCache queryCache = a2 = this;
        queryCache.j.debug(ActiveQuery.C((Object)"<l\u0003f\u0018lNd\u000bz\u001dh\tl'mNr\u0013"), a3);
        return (ActiveQuery)queryCache.m.remove(a3);
    }

    public Set<Map.Entry<String, ActiveQuery>> timedOut() {
        QueryCache a4;
        long l2 = System.currentTimeMillis() - a4.C;
        return a4.entrySet().stream().filter(a3 -> {
            if (((ActiveQuery)a3.getValue()).C() < l2) {
                return true;
            }
            return false;
        }).filter(a2 -> {
            if (!((ActiveQuery)a2.getValue()).I()) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected, String string, ActiveQuery activeQuery) {
        void a2;
        QueryCache a3 = activeQuery;
        QueryCache a4 = this;
        a4.C((ActiveQuery)a3, a2.I());
    }

    @EventListener
    public void on(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected) {
        QueryCache a2 = queryHandlerDisconnected;
        QueryCache a3 = this;
        a3.m.forEach((arg_0, arg_1) -> a3.C((TopologyEvents.QueryHandlerDisconnected)a2, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    public ActiveQuery putIfAbsent(String string, ActiveQuery activeQuery) {
        void a2;
        QueryCache a3;
        QueryCache a4 = activeQuery;
        QueryCache queryCache = a3 = this;
        queryCache.C();
        return (ActiveQuery)queryCache.m.putIfAbsent(a2, a4);
    }
}

