/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.ProcessingInstructionHelper;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.SerializedQuery;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.interceptor.DefaultExecutionContext;
import io.axoniq.axonserver.interceptor.QueryInterceptors;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.DispatchQueueMetrics;
import io.axoniq.axonserver.message.FlowControlQueues;
import io.axoniq.axonserver.message.QueueMetrics;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.message.query.QueryDefinition;
import io.axoniq.axonserver.message.query.QueryHandler;
import io.axoniq.axonserver.message.query.QueryInstruction;
import io.axoniq.axonserver.message.query.QueryMetricsRegistry;
import io.axoniq.axonserver.message.query.QueryRegistrationCache;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.plugin.ExecutionContext;
import io.axoniq.axonserver.plugin.PluginContextManager;
import io.axoniq.axonserver.rest.json.QueryResponseJson;
import io.axoniq.axonserver.util.ConstraintCache;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import io.axoniq.axonserver.util.StringUtils;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="QueryDispatcher")
public class QueryDispatcher {
    private final FlowControlQueues<QueryInstruction> L;
    private final Map<String, AtomicInteger> G;
    private final NonReplacingConstraintCache<String, ActiveQuery> A;
    private final Logger B;
    private final QueryRegistrationCache C;
    private final QueryInterceptors j;
    private final QueryMetricsRegistry m;
    private final DispatchQueueMetrics c;

    /*
     * WARNING - void declaration
     */
    public void handleResponse(QueryResponse queryResponse, String string, String string2) {
        void a2;
        void a3;
        QueryDispatcher queryDispatcher = this;
        Object a4 = a3.getRequestIdentifier();
        if ((a4 = queryDispatcher.C((String)a2, (String)a4)) != null) {
            ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a4.d(), (String)a2);
            long l2 = System.currentTimeMillis() - a4.C();
            if (a4.C()) {
                void a5;
                queryDispatcher.m.addEndToEndResponseTime(a4.C(), a4.I(), (String)a5, clientStreamIdentification.C(), a4.I(), l2);
            }
            if (a4.C((QueryResponse)a3, (String)a2) && a4.I()) {
                a4.C((String)a2);
                return;
            }
        } else {
            queryDispatcher.B.debug(PluginContextManager.C((Object)"IP'\u0017jPuZ.\u001fnQaPuRfKnPi\u001faPu\u001f|B"), (Object)a3.getRequestIdentifier());
        }
    }

    private /* synthetic */ boolean C(QueryRequest queryRequest) {
        QueryDispatcher a2 = queryRequest;
        QueryDispatcher a3 = this;
        return ProcessingInstructionHelper.C((List)a2.getProcessingInstructionsList());
    }

    /*
     * WARNING - void declaration
     */
    public void cancelProxied(String string, String string2) {
        void a2;
        QueryDispatcher a3;
        Object a4 = string2;
        QueryDispatcher queryDispatcher = a3 = this;
        queryDispatcher.cancel(queryDispatcher.C((String)a2, (String)a4));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(String string, String string2, Runnable runnable) {
        Runnable a22 = runnable;
        QueryDispatcher a3 = this;
        try {
            a22.run();
            return;
        }
        catch (MessagingPlatformException a22) {
            void a4;
            void a5;
            QueryDispatcher queryDispatcher = a3;
            queryDispatcher.B.debug(PluginContextManager.C((Object)"BMuPu\u001fcVtOfKdWnQ`\u001faShH'NrZuF'ViLsMr\\sVhQ'Kh\u001fs^uXbK'\\kVbQs\u001f|B"), (Object)a5);
            queryDispatcher.completeWithError((String)a4, (String)a5, a22.getErrorCode(), a22.getMessage());
            return;
        }
    }

    public void cancel(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        if ((a2 = (ActiveQuery)a3.A.remove(a2)) != null) {
            a2.I();
        }
    }

    public void deleteMetrics(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        a3.G.remove(a2);
        QueryDispatcher queryDispatcher = a3;
        queryDispatcher.m.remove((MetricName)BaseMetricName.Ha, (String)a2);
        queryDispatcher.m.removeForContext((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void dispatchProxied(SerializedQuery serializedQuery, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        void a2;
        void a3;
        Object a4 = consumer2;
        QueryDispatcher a5 = this;
        a5.dispatchProxied((SerializedQuery)a3, (Consumer)a2, (Consumer)a4, true);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Set<QueryHandler> C(String string, QueryRequest queryRequest) {
        void a2;
        QueryHandler queryHandler;
        void a3;
        QueryDispatcher queryDispatcher = this;
        Object a4 = ProcessingInstructionHelper.C((List)a3.getProcessingInstructionsList()) == 1 ? ((queryHandler = queryDispatcher.C.findOne((String)a2, (QueryRequest)a3)) == null ? Set.of() : Set.of(queryHandler)) : queryDispatcher.C.find((String)a2, (QueryRequest)a3);
        return a4;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void I(QueryHandler queryHandler, String string, String string2, long l2) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher a5 = queryHandler;
        QueryDispatcher a6 = this;
        void v0 = a4;
        a6.C((String)v0, a5.I(), () -> QueryDispatcher.C((QueryHandler)a5, (String)v0, (String)a3, (long)a2));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void C(QueryHandler queryHandler, String string, String string2, long l2) {
        void a2;
        void a3;
        Object a4 = string2;
        QueryHandler a5 = queryHandler;
        a5.C((String)a3, (String)a4, (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void flowControl(String string, long l2) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        if ((a2 = (ActiveQuery)a3.A.get(a2)) != null) {
            void a4;
            a2.I().forEach(arg_0 -> a3.C((ActiveQuery)a2, (long)a4, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void flowControlProxied(String string, String string2, long l2, String string3, String string4) {
        void a2;
        void a3;
        void a4;
        void a5;
        Object a6 = string2;
        QueryDispatcher a7 = this;
        a7.C((String)a5, (String)a6, (String)a4, arg_0 -> a7.C((String)a3, (String)a6, (long)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ActiveQuery C(String string, String string2) {
        Object a2 = string2;
        QueryDispatcher a3 = this;
        ActiveQuery activeQuery = (ActiveQuery)a3.A.get(a2);
        if (activeQuery == null) {
            void a4;
            a2 = (String)a2 + "/" + (String)a4;
            activeQuery = (ActiveQuery)a3.A.get(a2);
        }
        return activeQuery;
    }

    /*
     * WARNING - void declaration
     */
    public void completeWithError(String string, String string2, ErrorCode errorCode, String string3) {
        void a2;
        void a3;
        void a4;
        Object a5 = string;
        QueryDispatcher a6 = this;
        Object[] objectArray = new Object[4];
        objectArray[0] = a4;
        objectArray[1] = a5;
        objectArray[2] = a3.getCode();
        objectArray[3] = a2;
        a6.B.debug(PluginContextManager.C((Object)"|hRwSbKnQ`\u001fpVsW'ZuMhM'KoZ'\\hRjJiVd^sVhQ'HnKo\u001ff\u001ftOb\\nYn\\'WfQcSbM'ddSnZiKTKuZfRN[:Dzb+\u001faPu\u001fsWb\u001fvJbM~\u001f\\Vc\u0002|BZ\u0011'zuMhM'\\h[b\u0005'Dz\u0011'zuMhMJZtLfXb\u0005'Dz\u0011"), objectArray);
        ActiveQuery activeQuery = (ActiveQuery)a6.A.get(a5);
        if (activeQuery != null && activeQuery.C((String)a4, (ErrorCode)a3, (String)a2)) {
            a6.A.remove(a5);
        }
    }

    public MeterFactory.RateMeter queryRate(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        return a3.m.rateMeter((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String C(String string, String string2) {
        void a2;
        Object a3 = string2;
        QueryDispatcher a4 = this;
        return (String)a2 + "/" + (String)a3;
    }

    /*
     * WARNING - void declaration
     */
    public QueryDispatcher(QueryRegistrationCache queryRegistrationCache, NonReplacingConstraintCache<String, ActiveQuery> nonReplacingConstraintCache, QueryMetricsRegistry queryMetricsRegistry, QueryInterceptors queryInterceptors, MeterFactory meterFactory, ClientIdRegistry clientIdRegistry, @Value(value="${axoniq.axonserver.query-queue-capacity-per-client:10000}") int n) {
        void a2;
        void clientIdRegistry2;
        void meterFactory2;
        void queryInterceptors2;
        void queryCache;
        void registrationCache;
        QueryDispatcher queryMetricsRegistry2;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryMetricsRegistry;
        QueryDispatcher queryDispatcher3 = queryMetricsRegistry2 = queryDispatcher;
        QueryDispatcher queryDispatcher4 = queryMetricsRegistry2;
        queryMetricsRegistry2.B = LoggerFactory.getLogger(QueryDispatcher.class);
        QueryDispatcher queryDispatcher5 = queryMetricsRegistry2;
        queryMetricsRegistry2.G = new ConcurrentHashMap();
        queryDispatcher4.C = registrationCache;
        queryDispatcher4.m = queryDispatcher2;
        queryDispatcher3.A = queryCache;
        queryDispatcher3.j = queryInterceptors2;
        QueryDispatcher queryDispatcher6 = queryMetricsRegistry2;
        queryDispatcher3.c = new DispatchQueueMetrics((MeterFactory)meterFactory2, (MetricName)BaseMetricName.X, (MetricName)BaseMetricName.H, (ClientIdRegistry)clientIdRegistry2);
        QueryDispatcher queryDispatcher7 = queryMetricsRegistry2;
        queryDispatcher6.L = new FlowControlQueues(Comparator.comparing(QueryInstruction::C).reversed(), (int)a2, (QueueMetrics)queryMetricsRegistry2.c, ErrorCode.TOO_MANY_REQUESTS);
        queryDispatcher2.gauge((MetricName)BaseMetricName.da, (Object)queryCache, ConstraintCache::size);
    }

    /*
     * WARNING - void declaration
     */
    public void handleComplete(String string, String string2, String string3) {
        void a2;
        void a3;
        QueryDispatcher queryDispatcher = this;
        QueryDispatcher a4 = queryDispatcher.C((String)a3, (String)a2);
        if (a4 != null) {
            if (a4.I((String)a3)) {
                queryDispatcher.A.remove((Object)a4.g());
            }
            long l2 = System.currentTimeMillis() - a4.C();
            if (a4.C()) {
                void a5;
                queryDispatcher.m.addHandlerResponseTime(a4.C(), a4.I(), (String)a5, a4.d(), l2);
                return;
            }
        } else {
            queryDispatcher.B.debug(QueryResponseJson.C((Object)"u\u0001\u001bFV\u0001I\u000b\u0012NR\u0000]\u0001I\u0003Z\u001aR\u0001UN]\u0001IN@\u0013\u001b\u0001UNX\u0001V\u001eW\u000bO\u000b_"), (Object)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(Consumer consumer, String string, String string2) {
        void a2;
        void a3;
        Object a4 = string2;
        QueryDispatcher a5 = this;
        a3.accept(a4);
        ((AtomicInteger)a5.G.get(a2)).decrementAndGet();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(DefaultExecutionContext defaultExecutionContext, QueryResponse queryResponse, Consumer<QueryResponse> consumer) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher queryDispatcher = this;
        try {
            a4.accept(queryDispatcher.j.queryResponse((QueryResponse)a3, (ExecutionContext)a2));
            return;
        }
        catch (Exception a5) {
            queryDispatcher.B.warn(PluginContextManager.C((Object)"Dz\u0005'z\u007f\\bOsVhQ'Vi\u001fuZtOhQtZ'ViKbMdZwKhM"), (Object)a2.contextName(), (Object)a5);
            Exception exception = a5;
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.EXCEPTION_IN_INTERCEPTOR.getCode()).setRequestIdentifier(a3.getRequestIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.C((String)exception.getMessage())).build());
            a2.compensate((Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(String string, ActiveQuery activeQuery) {
        void a2;
        QueryDispatcher queryDispatcher = this;
        try {
            queryDispatcher.B.trace(PluginContextManager.C((Object)"{nLw^s\\oViX'NrZuF'Dz\u0011)\u0011"), (Object)a2.g());
            a2.C();
            return;
        }
        catch (MessagingPlatformException a3) {
            void a4;
            QueryDispatcher queryDispatcher2 = queryDispatcher;
            queryDispatcher2.B.debug(QueryResponseJson.C((Object)"+I\u001cT\u001c\u001b\nN\u001cR\u0000\\N_\u0007H\u001eZ\u001aX\u0006R\u0000\\NT\b\u001b\u001fN\u000bI\u0017\u001b\u0015F@\u001b-Z\u0000X\u000bW\u0002R\u0000\\NL\u0007O\u0006\u001b\u000bI\u001cT\u001c\u0015"), (Object)a2.g(), (Object)a3);
            a2.C(a3.getErrorCode(), a3.getMessage());
            queryDispatcher2.A.remove((Object)a4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dispatchProxied(SerializedQuery serializedQuery, Consumer<QueryResponse> consumer, Consumer<String> consumer2, boolean bl) {
        void a22;
        void a3;
        void a4;
        void a322;
        QueryDispatcher queryDispatcher = this;
        void v0 = a322;
        QueryRequest queryRequest = v0.query();
        String string = v0.context();
        Object a5 = v0.clientStreamId();
        if ((string = queryDispatcher.C.find(string, queryRequest, (String)a5)) == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a5;
            objectArray[1] = queryRequest.getQuery();
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.CLIENT_DISCONNECTED.getCode()).setRequestIdentifier(queryRequest.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.C((String)String.format(QueryResponseJson.C((Object)"-W\u0007^\u0000ON\u001e\u001d\u001b\u0000T\u001a\u001b\bT\u001bU\n\u001b\u0019S\u0007W\u000b\u001b\u001eI\u0001X\u000bH\u001dR\u0000\\T\u001bKH"), objectArray))).build());
            a3.accept(a5);
            return;
        }
        a5 = queryDispatcher.C(queryRequest.getMessageIdentifier(), a322.clientStreamId());
        ActiveQuery a22 = new ActiveQuery((String)a5, (SerializedQuery)a322, false, (Consumer)a4, (Consumer)a3, Collections.singleton(string), a22 != false && queryDispatcher.C(queryRequest));
        try {
            if (queryDispatcher.A.putIfAbsent(a5, (Object)a22) != null) {
                a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a322.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.C((String)PluginContextManager.C((Object)"VJbM~\u001fpVsW'LrOwSnZc\u001fN{'^kMb^cF'OuZtZiK"))).build());
                a3.accept(QueryResponseJson.C((Object)"\u007f\u001bK\u0002R\rZ\u001a^'_"));
                return;
            }
            queryDispatcher.C((String)a5, a22);
            return;
        }
        catch (InsufficientBufferCapacityException a322) {
            a22.C(string.I(), ErrorCode.QUERY_DISPATCH_ERROR, a322.getMessage());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(DefaultExecutionContext defaultExecutionContext, Consumer consumer, QueryResponse queryResponse) {
        void a2;
        void a3;
        QueryDispatcher a4 = queryResponse;
        QueryDispatcher a5 = this;
        a5.C((DefaultExecutionContext)a3, (QueryResponse)a4, (Consumer)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(String string, String string2, long l2, QueryHandler queryHandler) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher a5;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryHandler;
        QueryDispatcher a6 = queryDispatcher;
        a6.I((QueryHandler)a5, (String)a4, (String)a3, (long)a2);
    }

    public FlowControlQueues<QueryInstruction> getQueryQueue() {
        QueryDispatcher a2;
        return a2.L;
    }

    private /* synthetic */ boolean C(QueryResponse queryResponse) {
        QueryDispatcher a2 = queryResponse;
        QueryDispatcher a3 = this;
        if (ErrorCode.NO_HANDLER_FOR_QUERY.getCode().equals(a2.getErrorCode()) || ErrorCode.TOO_MANY_REQUESTS.getCode().equals(a2.getErrorCode()) || ErrorCode.OTHER.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_REJECTED_BY_INTERCEPTOR.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_TIMEOUT.getCode().equals(a2.getErrorCode()) || ErrorCode.CONNECTION_TO_HANDLER_LOST.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_DUPLICATED.getCode().equals(a2.getErrorCode())) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void query(SerializedQuery serializedQuery, Authentication authentication, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        void a2;
        Consumer<String> a3;
        Consumer<QueryResponse> a4;
        void a5;
        QueryDispatcher queryDispatcher = this;
        Object a6 = a5.context();
        a4 = arg_0 -> queryDispatcher.C(a4, (SerializedQuery)a5, (String)a6, arg_0);
        a3 = arg_0 -> queryDispatcher.C(a3, (String)a6, arg_0);
        QueryDispatcher queryDispatcher2 = queryDispatcher;
        queryDispatcher2.queryRate((String)a6).C();
        queryDispatcher2.G.computeIfAbsent(a6, string -> {
            void a2;
            QueryDispatcher queryDispatcher = this;
            Object a3 = new AtomicInteger();
            queryDispatcher.m.gauge((MetricName)BaseMetricName.Ha, Tags.of((String)"context", (String)a2), ((AtomicInteger)a3)::get);
            return a3;
        }).incrementAndGet();
        queryDispatcher.C((SerializedQuery)a5, (String)a6, (Authentication)a2, a4, a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(ActiveQuery activeQuery, long l2, QueryHandler queryHandler) {
        void a2;
        void a3;
        QueryDispatcher a4 = activeQuery;
        QueryDispatcher a5 = this;
        a5.I((QueryHandler)a3, a4.g(), a4.C(), (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(String string, String string2, String string3, Consumer<QueryHandler> consumer) {
        void a2;
        void a3;
        Object a4 = string;
        QueryDispatcher a5 = this;
        a4 = new QueryDefinition((String)a4, (String)a3);
        if ((a4 = a5.C.find((QueryDefinition)a4, (String)a2)) != null) {
            void a6;
            a6.accept(a4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(SerializedQuery serializedQuery, String string, Authentication authentication, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        Set set;
        QueryDispatcher a2;
        QueryDispatcher queryDispatcher;
        block5: {
            void a3;
            SerializedQuery serializedQuery2;
            void a4;
            Consumer<QueryResponse> consumer3;
            void a5;
            block4: {
                DefaultExecutionContext a6;
                void a7;
                queryDispatcher = this;
                a6 = new DefaultExecutionContext((String)a7, (Authentication)a6);
                consumer3 = arg_0 -> queryDispatcher.C(a6, (Consumer)a5, arg_0);
                try {
                    QueryDispatcher queryDispatcher2 = queryDispatcher;
                    serializedQuery2 = queryDispatcher2.j.queryRequest((SerializedQuery)a4, (ExecutionContext)a6);
                    a2 = serializedQuery2.query();
                    set = queryDispatcher2.C((String)a7, (QueryRequest)a2);
                    if (!set.isEmpty()) break block4;
                    consumer3.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.NO_HANDLER_FOR_QUERY.getCode()).setRequestIdentifier(a2.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.C((String)("No handler for query: " + a2.getQuery()))).build());
                    a3.accept(QueryResponseJson.C((Object)" T-W\u0007^\u0000O"));
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a7;
                    objectArray[1] = a4.query().getQuery();
                    objectArray[2] = exception;
                    queryDispatcher.B.warn(PluginContextManager.C((Object)"Dz\u0005'YfVkZc\u001fsP'[nLw^s\\o\u001fvJbM~\u001f|B"), objectArray);
                    a2 = ErrorCode.fromException((Throwable)exception);
                    consumer3.accept(QueryResponse.newBuilder().setErrorCode(a2.getCode()).setRequestIdentifier(a4.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.C((String)StringUtils.getOrDefault((String)a2.getCode(), (String)exception.getClass().getName()))).build());
                    a3.accept(QueryResponseJson.C((Object)"(Z\u0007W\u000b_"));
                    a6.compensate((Throwable)exception);
                    return;
                }
            }
            set = new ActiveQuery(a2.getMessageIdentifier(), serializedQuery2, true, consumer3, (Consumer)a3, set, queryDispatcher.C((QueryRequest)a2));
            if (queryDispatcher.A.putIfAbsent((Object)a2.getMessageIdentifier(), (Object)set) == null) break block5;
            a5.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a4.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.C((String)PluginContextManager.C((Object)"VJbM~\u001fpVsW'LrOwSnZc\u001fN{'^kMb^cF'OuZtZiK"))).build());
            a3.accept(QueryResponseJson.C((Object)"\u007f\u001bK\u0002R\rZ\u001a^'_"));
            return;
        }
        queryDispatcher.C(a2.getMessageIdentifier(), (ActiveQuery)set);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(Consumer consumer, SerializedQuery serializedQuery, String string, QueryResponse queryResponse) {
        void a2;
        QueryDispatcher a3;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryResponse;
        QueryDispatcher a4 = queryDispatcher;
        QueryDispatcher queryDispatcher3 = a3;
        a2.accept(queryDispatcher3);
        if (a4.C((QueryResponse)queryDispatcher3)) {
            void a5;
            void a6;
            a4.m.error(a6.query().getQuery(), (String)a5, a3.getErrorCode());
        }
    }
}

