/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.SnapshotDataProviders;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.managed.ManagedAxonServerDiskStatusService;
import io.axoniq.axonserver.rest.ClusterRestController;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin
@RestController(value="ClusterRestController")
@RequestMapping(value={"/v1/cluster"})
public class ClusterRestController {
    private final ClusterController K;
    private final DistributeLicenseService J;
    private final ClusterTopology d;
    private final ClusterTemplateController L;
    private final Predicate<String> G;
    private static final Logger A = AuditLog.getLogger();
    public static final String B = "_none";
    private final RaftConfigServiceFactory C;
    private final ApplicationEventPublisher j;
    private static final Logger m = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final FeatureChecker c;

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/upload-license"})
    public void C(@RequestParam(value="licenseFile") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        void a2;
        ClusterRestController clusterRestController = this;
        A.info(ManagedAxonServerDiskStatusService.C((Object)"xU^s\u0003|F_VKPZ\u0003BJMF@PK\u0003[SJBZF\u0000"), (Object)AuditLog.username((Principal)a2));
        m.info(SnapshotDataProviders.C((Object)"S&jcq*~&s0xch3q,|'x'1cm&o%r1p*s$=/t x-n&=6m'|7xm3m"));
        try {
            void licenseFile;
            clusterRestController.J.distributeLicense(licenseFile.getBytes());
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            if (ErrorCode.NO_LEADER_AVAILABLE.equals((Object)messagingPlatformException.getErrorCode())) {
                throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, ManagedAxonServerDiskStatusService.C((Object)"`L\u000eOKBJF\\\u0003HL\\\u0003qBJNGM\u0000\u0003kM]V\\F\u000eWFBZ\u0003ZKK\u0003qBJNGM\u000eQKSBJMBZJAM\u000eD\\L[S\u000eJ]\u0003MQKBZFJ\u0003LFHL\\F\u000eV^OABJJ@D\u000eB\u000eOG@KM]F\u0000"));
            }
            throw messagingPlatformException;
        }
        catch (LicenseException messagingPlatformException) {
            throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, messagingPlatformException.getMessage());
        }
    }

    @PostMapping
    public ResponseEntity<RestResponse> C(@Valid @RequestBody ClusterJoinRequest clusterJoinRequest, @Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController;
        NodeInfo.Builder a2;
        ClusterRestController clusterRestController2 = clusterRestController3;
        ClusterRestController clusterRestController3 = clusterJoinRequest;
        ClusterRestController jsonClusterNode = clusterRestController2;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = clusterRestController3.getInternalHostName();
        objectArray[2] = clusterRestController3.internalGrpcPort;
        A.info(ManagedAxonServerDiskStatusService.C((Object)"xU^s\u0003|F_VKPZ\u0003ZL\u000eIAJ@\u0003MO[PZF\\\u0003OW\u000eXS\u0019U^\u0000"), objectArray);
        a2 = NodeInfo.newBuilder((NodeInfo)jsonClusterNode.K.getMe().toNodeInfo());
        String string = clusterRestController3.getContext();
        if (string != null && !string.isEmpty()) {
            if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, SnapshotDataProviders.C((Object)"\u0000|-s,ic~,p!t-xcw,t-t-zc~,s7x;icj*i+=-r\u0000r-i&e7nm"));
            }
            if (!RaftAdminGroup.C((String)string) && !jsonClusterNode.G.test(string)) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
            }
            m.debug(ManagedAxonServerDiskStatusService.C((Object)"BJG\u0006\n\u0014\u0003|FIJ]WKQGMI\u0003CZ]FBE\u000eB@G\u000eBJGGMI\u0003CF\u000eWA\u0003ML@WK[Z\u0003\fXS\u0001\u0000"), (Object)string);
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName(string).build());
        } else if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
            m.debug(SnapshotDataProviders.C((Object)"\"y'5j'cO&z*n7x1t-zcp:n&q%=\"s'=\"y't-zcp&=7rcs,= r-i&e7nm"));
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName("_none").build());
        } else {
            m.debug(ManagedAxonServerDiskStatusService.C((Object)"BJG\u0006\n\u0014\u0003|FIJ]WKQGMI\u0003CZ]FBE\u000eB@G\u000eBJGGMI\u0003CF\u000eWA\u0003OOB\u0003ML@WK[ZP\u0000"));
            clusterRestController = jsonClusterNode;
        }
        if (clusterRestController.K.nodes().count() > 1L) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new RestResponse(false, SnapshotDataProviders.C((Object)"S,y&=\"q1x\"y:=1x$t0i&o&yct-=\"= q6n7x1")));
        }
        try {
            ClusterRestController clusterRestController4 = jsonClusterNode;
            ClusterRestController clusterRestController5 = clusterRestController3;
            clusterRestController3 = clusterRestController4.C.getRaftConfigServiceStub(clusterRestController5.internalHostName, clusterRestController5.internalGrpcPort.intValue()).joinCluster(a2.build());
            clusterRestController4.j.publishEvent((Object)new ClusterEvents.LicenseUpdated(clusterRestController3.getLicense().toByteArray()));
            return ResponseEntity.accepted().body((Object)new RestResponse(true, ManagedAxonServerDiskStatusService.C((Object)"bM@KSZFJ\u0003DLGM\u000eQKR[F]W\u0002\u0003CBW\u0003ZBEF\u000eB\u000eTFJBF\u000eWA\u0003^QA@KP]")));
        }
        catch (Exception this2) {
            return new RestResponse(false, this2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)this2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"{name}"})
    public void C(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        A.info(SnapshotDataProviders.C((Object)"\u0018f>@cO&l6x0ici,='x/x7xcs,y&=8`m"), (Object)AuditLog.username((Principal)a2), object);
        name.C.getRaftConfigService().deleteNode((String)object);
    }

    @GetMapping(path={"{name}"})
    public JsonClusterNode C(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        ClusterNode a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        A.info(SnapshotDataProviders.C((Object)"\u0018f>@cO&l6x0ics,y&='x7|*q0=%r1=8`m"), (Object)AuditLog.username((Principal)a2), object);
        a2 = name.K.getNode((String)object);
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, "Node " + (String)object + " not found");
        }
        return JsonClusterNode.from((ClusterNode)a2, (boolean)name.K.isActive((String)object));
    }

    @GetMapping
    public List<JsonClusterNode> C(@Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        A.info(ManagedAxonServerDiskStatusService.C((Object)"uXS~\u000eqKR[F]W\u000eWA\u0003BJ]W\u000eMAGKP\u0000"), (Object)AuditLog.username((Principal)object));
        return a2.K.nodes().map(clusterNode -> {
            ClusterRestController a2 = clusterNode;
            ClusterRestController a3 = this;
            ClusterRestController clusterRestController = a2;
            return JsonClusterNode.from((ClusterNode)clusterRestController, (boolean)a3.K.isActive(clusterRestController.getName()));
        }).collect(Collectors.toList());
    }

    @GetMapping(value={"/download-template"})
    @ResponseBody
    public void C(HttpServletResponse httpServletResponse, @Parameter(hidden=true) Principal principal) throws IOException {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        A.info(SnapshotDataProviders.C((Object)"\u0018f>@cO&l6x0ic~/h0i&oci&p3q\"i&='r4s/r\"ym"), (Object)AuditLog.username((Principal)object));
        if (a2.d.isAdminNode()) {
            ServletOutputStream resp;
            object = ManagedAxonServerDiskStatusService.C((Object)"@BV]WKQ\u0003WKN^OOWK\rWNB");
            String string = a2.L.buildYamlTemplate();
            void v1 = resp;
            resp = v1.getOutputStream();
            v1.setContentType(SnapshotDataProviders.C((Object)"7x;ilm/|*sx= u\"o0x7 6i%0{"));
            v1.addHeader(ManagedAxonServerDiskStatusService.C((Object)"mL@WKMZ\u000ejJ]SAPGWGL@"), "attachment; filename=\"" + (String)object + "\"");
            ServletOutputStream servletOutputStream = resp;
            servletOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            servletOutputStream.flush();
            servletOutputStream.close();
            return;
        }
        throw new RuntimeException(SnapshotDataProviders.C((Object)"\u001ar6= |-=6n&=7u*nc{6s i*r-|/t7dcr-q:=%o,pc|'p*scs,y&"));
    }

    /*
     * WARNING - void declaration
     */
    public ClusterRestController(ClusterController clusterController, RaftConfigServiceFactory raftConfigServiceFactory, FeatureChecker featureChecker, DistributeLicenseService distributeLicenseService, ApplicationEventPublisher applicationEventPublisher, ClusterTopology clusterTopology, ClusterTemplateController clusterTemplateController) {
        ClusterRestController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        ClusterRestController a9;
        ClusterRestController clusterRestController = clusterRestController2;
        ClusterRestController clusterRestController2 = clusterTemplateController;
        ClusterRestController clusterRestController3 = a9 = clusterRestController;
        ClusterRestController clusterRestController4 = a9;
        ClusterRestController clusterRestController5 = a9;
        ClusterRestController clusterRestController6 = a9;
        a9.G = new ContextNameValidation();
        a9.K = a8;
        clusterRestController5.C = a7;
        clusterRestController5.c = a6;
        clusterRestController4.J = a5;
        clusterRestController4.j = a4;
        clusterRestController3.d = a3;
        clusterRestController3.L = a2;
    }
}

