/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.enterprise.replication.admin.ReplicationGroupChangesHandler;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.plugin.PluginController;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.plugin.SimplePluginKey;
import io.axoniq.axonserver.rest.PluginConfigurationJSON;
import io.axoniq.axonserver.rest.PluginPropertyGroup;
import io.axoniq.axonserver.taskscheduler.task.AddNodeToContext;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"v1/plugins"})
@CrossOrigin
public class PluginsRestController {
    private final FeatureChecker A;
    private final boolean B;
    private final PluginController C;
    private static final Logger j = AuditLog.getLogger();
    private final Logger m;
    public static final String c = "Plugins disabled";

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"configuration"})
    public Iterable<PluginPropertyGroup> C(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = this;
        if (!pluginsRestController.B || !pluginsRestController.A.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, c);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        j.info(AddNodeToContext.C((Object)"i\u0013O5\u0012:W\u0019G\rA\u001c\u0012\u000e]\u001a\u0012\u000b]\u0006T\u0001U\u001d@\tF\u0001]\u0006\u0012\u0007THI\u0015\u001d\u0013OF\u0012"), objectArray);
        try {
            void context;
            return pluginsRestController.C.listProperties((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = name;
            objectArray2[1] = version;
            objectArray2[2] = runtimeException;
            pluginsRestController.m.warn(ReplicationGroupChangesHandler.C((Object)"\u0015\f:\u00016\ts\u0019<M!\b'\u001f:\b%\bs\u001d!\u0002#\b!\u0019:\b M5\u0002!M(\u0010i\u0016."), objectArray2);
            throw runtimeException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"status"})
    public void C(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @RequestParam(value="active") boolean bl, @Parameter(hidden=true) Principal principal) {
        void context;
        void version;
        void name;
        void a2;
        boolean bl2 = bl;
        PluginsRestController active = this;
        if (!active.B || !active.A.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, c);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = this != false ? ReplicationGroupChangesHandler.C((Object)" \u00192\u001f'") : AddNodeToContext.C((Object)"\u001bF\u0007B");
        objectArray[2] = StringUtils.sanitize((String)name);
        objectArray[3] = StringUtils.sanitize((String)version);
        j.info(AddNodeToContext.C((Object)"i\u0013O5\u0012:W\u0019G\rA\u001c\u0012\u001c]HI\u0015\u0012\u0018^\u001dU\u0001\\HI\u0015\u001d\u0013OF\u0012"), objectArray);
        active.C.updatePluginStatus((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context, (boolean)this);
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"context"})
    public void C(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string3;
        PluginsRestController context = pluginsRestController;
        if (!context.B || !context.A.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, c);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        objectArray[3] = StringUtils.sanitize((String)object);
        j.info(ReplicationGroupChangesHandler.C((Object)"\b\u0016.0s?6\u001c&\b \u0019s\u0019<M&\u0003!\b4\u0004 \u00196\u001fs\u001d?\u00184\u0004=M(\u0010|\u0016.M5\u0002!M0\u0002=\u00196\u0015'M(\u0010}"), objectArray);
        context.C.unregisterPluginForContext((PluginKey)new SimplePluginKey((String)name, (String)version), (String)object);
    }

    private /* synthetic */ String C(String string) {
        String a2 = string;
        PluginsRestController a3 = this;
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.OTHER, ReplicationGroupChangesHandler.C((Object)"#<M#\u0001&\n:\u0003s\u001d2\u000e8\f4\bs\u001d!\u0002%\u00047\b7"));
        }
        if (a2.contains(File.separator)) {
            throw new MessagingPlatformException(ErrorCode.OTHER, AddNodeToContext.C((Object)"t\u0001^\r\\\t_\r\u0012\u001bZ\u0007G\u0004VH\\\u0007FHQ\u0007\\\u001cS\u0001\\HV\u0001@\rQ\u001c]\u001aKHA\rB\t@\tF\u0007@"));
        }
        int n = a2.lastIndexOf(46);
        if (n > 0) {
            return a2.substring(0, n) + "-" + System.currentTimeMillis() + a2.substring(n);
        }
        return (String)a2 + "-" + System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping
    public void C(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @Parameter(hidden=true) Principal principal) {
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string2;
        PluginsRestController version = pluginsRestController;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)object);
        j.info(ReplicationGroupChangesHandler.C((Object)"6(\u0010\u000eM\u0001\b\"\u00186\u001e'M'\u0002s\u0018=\u0004=\u001e'\f?\u0001s\u001d?\u00184\u0004=M(\u0010|\u0016.Cs"), objectArray);
        version.C.uninstallPlugin((PluginKey)new SimplePluginKey((String)name, (String)object));
    }

    /*
     * WARNING - void declaration
     */
    public PluginsRestController(PluginController pluginController, MessagingPlatformConfiguration messagingPlatformConfiguration, FeatureChecker featureChecker) {
        void a2;
        void a3;
        PluginsRestController a4;
        PluginsRestController a5 = featureChecker;
        PluginsRestController pluginsRestController = a4 = this;
        PluginsRestController pluginsRestController2 = a4;
        pluginsRestController2.m = LoggerFactory.getLogger(PluginsRestController.class);
        pluginsRestController2.B = a3.isPluginsEnabled();
        pluginsRestController.C = a2;
        pluginsRestController.A = a5;
    }

    @PostMapping(consumes={"multipart/form-data"})
    public PluginKey C(@RequestPart(value="bundle") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        PluginKey pluginBundle2;
        block6: {
            PluginsRestController pluginsRestController = object;
            Object object = principal;
            PluginsRestController a2 = pluginsRestController;
            if (!a2.B || !a2.A.plugins()) {
                throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, c);
            }
            j.info(AddNodeToContext.C((Object)"i\u0013O5\u0012:W\u0019G\rA\u001c\u0012\u001c]H[\u0006A\u001cS\u0004^HB\u0004G\u000f[\u0006\u0012\u0013OF\u0012"), (Object)AuditLog.username((Principal)object), (Object)StringUtils.sanitize((String)pluginBundle2.getOriginalFilename()));
            object = pluginBundle2.getInputStream();
            try {
                PluginsRestController pluginsRestController2 = a2;
                String string = pluginsRestController2.C(pluginBundle2.getOriginalFilename());
                pluginBundle2 = pluginsRestController2.C.addPlugin(string, (InputStream)object);
                if (object == null) break block6;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block7: {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                            throwable2 = throwable;
                            break block7;
                        }
                        catch (Throwable pluginBundle2) {
                            throwable.addSuppressed(pluginBundle2);
                        }
                    }
                    throwable2 = throwable;
                }
                throw throwable2;
            }
            ((InputStream)object).close();
        }
        return pluginBundle2;
    }

    @GetMapping
    public Iterable<PluginInfo> C(@Parameter(hidden=true) Principal principal) {
        PluginsRestController pluginsRestController = object;
        Object object = principal;
        PluginsRestController a2 = pluginsRestController;
        j.info(AddNodeToContext.C((Object)"3I\u0015oH`\rC\u001dW\u001bFHF\u0007\u0012\u0004[\u001bFHQ\u001d@\u001aW\u0006FHB\u0004G\u000f[\u0006AF\u0012"), (Object)AuditLog.username((Principal)object));
        return a2.C.listPlugins();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"configuration"})
    public void C(@RequestBody PluginConfigurationJSON pluginConfigurationJSON, @Parameter(hidden=true) Principal principal) {
        void a2;
        PluginsRestController pluginsRestController = pluginsRestController2;
        PluginsRestController pluginsRestController2 = pluginConfigurationJSON;
        PluginsRestController configurationJSON = pluginsRestController;
        if (!configurationJSON.B || !configurationJSON.A.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, c);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)pluginsRestController2.getName());
        objectArray[2] = StringUtils.sanitize((String)pluginsRestController2.getVersion());
        j.info(ReplicationGroupChangesHandler.C((Object)"\b\u0016.0s?6\u001c&\b \u0019s\u0019<M&\u001d7\f'\bs\u000e<\u00035\u00044\u0018!\f'\u0004<\u0003s\u00025M(\u0010|\u0016.Cs"), objectArray);
        configurationJSON.C.updateConfiguration((PluginKey)new SimplePluginKey(pluginsRestController2.getName(), pluginsRestController2.getVersion()), pluginsRestController2.getContext(), pluginsRestController2.getProperties());
    }
}

