/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.integration.config.IntegrationConfiguration;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.message.event.EventDispatcher;
import io.axoniq.axonserver.message.query.QueryDispatcher;
import io.axoniq.axonserver.message.query.subscription.metric.HubSubscriptionMetrics;
import io.axoniq.axonserver.message.query.subscription.metric.SubscriptionQueryMetricRegistry;
import io.axoniq.axonserver.rest.LicenseInfo;
import io.axoniq.axonserver.rest.PublicRestController;
import io.axoniq.axonserver.rest.json.NodeConfiguration;
import io.axoniq.axonserver.rest.json.StatusInfo;
import io.axoniq.axonserver.rest.json.UserInfo;
import io.axoniq.axonserver.rest.svg.mapping.AxonServer;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.version.VersionInfo;
import io.axoniq.axonserver.version.VersionInfoProvider;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@CrossOrigin
@RestController(value="PublicRestController")
@RequestMapping(value={"/v1/public"})
public class PublicRestController {
    private final FeatureChecker E;
    private final SubscriptionQueryMetricRegistry l;
    private final Topology K;
    @Value(value="${axoniq.axonserver.devmode.enabled:false}")
    private boolean J;
    private final VersionInfoProvider d;
    private final CommandDispatcher L;
    private final SslConfiguration G;
    private final Map<String, Boolean> A;
    private final AccessControlConfiguration B;
    private final Function<Predicate<String>, Stream<AxonServer>> C;
    private final QueryDispatcher j;
    private final boolean m;
    private final EventDispatcher c;

    @GetMapping(path={"version"})
    @Operation(summary="Retrieves version information of the product")
    public VersionInfo C() {
        PublicRestController a2;
        return a2.d.get();
    }

    /*
     * WARNING - void declaration
     */
    public PublicRestController(Function<Predicate<String>, Stream<AxonServer>> function, Topology topology, CommandDispatcher commandDispatcher, QueryDispatcher queryDispatcher, EventDispatcher eventDispatcher, FeatureChecker featureChecker, MessagingPlatformConfiguration messagingPlatformConfiguration, VersionInfoProvider versionInfoProvider, SubscriptionQueryMetricRegistry subscriptionQueryMetricRegistry) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        PublicRestController a10;
        PublicRestController a11;
        PublicRestController publicRestController = publicRestController2;
        PublicRestController publicRestController2 = messagingPlatformConfiguration;
        PublicRestController publicRestController3 = a11 = publicRestController;
        PublicRestController publicRestController4 = a11;
        PublicRestController publicRestController5 = a10;
        PublicRestController publicRestController6 = a11;
        PublicRestController publicRestController7 = a11;
        PublicRestController publicRestController8 = a11;
        a11.C = a9;
        publicRestController8.K = a8;
        publicRestController8.L = a7;
        publicRestController7.j = a6;
        publicRestController7.c = a5;
        publicRestController6.E = a4;
        publicRestController6.G = a10.getSsl();
        a11.B = publicRestController5.getAccesscontrol();
        publicRestController4.m = publicRestController5.isPluginsEnabled();
        publicRestController4.d = a3;
        publicRestController3.l = a2;
        publicRestController3.A = a10.getPreview();
    }

    @GetMapping(path={"me"})
    @Operation(summary="Retrieves general information on the configuration of the current node, including hostnames and ports for the gRPC and HTTP connections and contexts")
    public NodeConfiguration C() {
        PublicRestController a2;
        PublicRestController publicRestController = this;
        PublicRestController publicRestController2 = a2 = new NodeConfiguration(publicRestController.K.getMe());
        PublicRestController publicRestController3 = publicRestController;
        PublicRestController publicRestController4 = a2;
        PublicRestController publicRestController5 = publicRestController;
        a2.setAuthentication(publicRestController.B.isEnabled());
        a2.setSsl(publicRestController5.G.isEnabled());
        publicRestController4.setAdminNode(publicRestController5.K.isAdminNode());
        publicRestController4.setDevelopmentMode(publicRestController.J);
        a2.setContextNames(publicRestController3.K.getMyContextNames());
        publicRestController2.setStorageContextNames(publicRestController3.K.getMyStorageContextNames());
        publicRestController2.setPluginsEnabled(publicRestController.m && publicRestController.E.plugins());
        PublicRestController publicRestController6 = a2;
        PublicRestController publicRestController7 = publicRestController;
        a2.setInitialized(publicRestController.K.initialized());
        a2.setMaxApplications(publicRestController7.E.getMaxApplications());
        publicRestController6.setMaxConnections(publicRestController7.E.maxConnections());
        publicRestController6.setMaxContexts(publicRestController.E.getMaxContexts().orElse(Integer.MAX_VALUE).intValue());
        a2.setMaxReplicationGroups(publicRestController.E.getMaxReplicationGroups().orElse(Integer.MAX_VALUE).intValue());
        PublicRestController publicRestController8 = a2;
        publicRestController8.setMaxUsers(publicRestController.E.getMaxUsers());
        return publicRestController8;
    }

    @GetMapping(path={"mycontexts"})
    @Operation(summary="Retrieves names for all storage (non admin) contexts for the current node")
    public Iterable<String> C() {
        PublicRestController a2;
        return a2.K.getMyStorageContextNames();
    }

    @GetMapping(path={"user"})
    @Operation(summary="Retrieves information on the user logged in in the current Http Session")
    public UserInfo C(HttpServletRequest httpServletRequest) {
        PublicRestController a2 = httpServletRequest;
        PublicRestController a3 = this;
        if (a2.getUserPrincipal() instanceof Authentication) {
            a2 = (Authentication)a2.getUserPrincipal();
            return new UserInfo(a2.getName(), a2.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet()));
        }
        return null;
    }

    @GetMapping
    @Operation(summary="Retrieves all nodes in the cluster that the current node knows about.", description="For _admin nodes the result contains all nodes, for non _admin nodes theresult only contains nodes from contexts available on this node and the _admin nodes.")
    public List<JsonServerNode> C() {
        PublicRestController a2;
        return ((Stream)a2.C.apply(null)).map(JsonServerNode::new).sorted(Comparator.comparing(JsonServerNode::getName)).collect(Collectors.toList());
    }

    public static String C(Object object) {
        Object object2 = object;
        object2 = (String)object2;
        int n = ((String)object2).length();
        int a2 = n - 1;
        char[] cArray = new char[n];
        int n2 = (3 ^ 5) << 3 ^ 2;
        int cfr_ignored_0 = (2 ^ 5) << 4 ^ 3;
        int n3 = a2;
        int n4 = 3 << 3 ^ 4;
        while (n3 >= 0) {
            int n5 = a2--;
            cArray[n5] = (char)(((String)object2).charAt(n5) ^ n4);
            if (a2 < 0) break;
            int n6 = a2--;
            cArray[n6] = (char)(((String)object2).charAt(n6) ^ n2);
            n3 = a2;
        }
        return new String(cArray);
    }

    @GetMapping(path={"license"})
    @Operation(summary="Retrieves license information")
    public LicenseInfo C() {
        PublicRestController a2;
        PublicRestController publicRestController = this;
        PublicRestController publicRestController2 = a2 = new LicenseInfo();
        PublicRestController publicRestController3 = publicRestController;
        a2.setExpiryDate(publicRestController.E.getExpiryDate());
        a2.setEdition(publicRestController3.E.getEdition());
        publicRestController2.setLicensee(publicRestController3.E.getLicensee());
        publicRestController2.setFeatureList(publicRestController.E.getFeatureList());
        return publicRestController2;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(path={"status"})
    @Operation(summary="Retrieves status information, used by UI")
    public StatusInfo C(@RequestParam(value="context", defaultValue="default", required=false) String string) {
        void a2;
        PublicRestController publicRestController = this;
        HubSubscriptionMetrics hubSubscriptionMetrics = publicRestController.l.get((String)a2);
        PublicRestController publicRestController2 = this = new StatusInfo();
        publicRestController2.setCommandRate(publicRestController.L.commandRate((String)a2));
        publicRestController2.setQueryRate(publicRestController.j.queryRate((String)a2));
        if (!a2.startsWith(IntegrationConfiguration.C((Object)"f"))) {
            PublicRestController publicRestController3 = this;
            PublicRestController publicRestController4 = publicRestController;
            this.setEventRate(publicRestController.c.eventRate((String)a2));
            this.setSnapshotRate(publicRestController4.c.snapshotRate((String)a2));
            publicRestController3.setNrOfEvents(publicRestController4.c.getNrOfEvents((String)a2));
            publicRestController3.setEventTrackers(publicRestController.c.eventTrackerStatus((String)a2));
        }
        PublicRestController publicRestController5 = this;
        HubSubscriptionMetrics hubSubscriptionMetrics2 = hubSubscriptionMetrics;
        this.setNrOfActiveSubscriptionQueries(hubSubscriptionMetrics2.activesCount().longValue());
        publicRestController5.setNrOfSubscriptionQueries(hubSubscriptionMetrics2.totalCount().longValue());
        publicRestController5.setNrOfSubscriptionQueriesUpdates(hubSubscriptionMetrics.updatesCount().longValue());
        return this;
    }
}

