/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.api.IntegrationAPI;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.runtime.CommandHandler;
import io.axoniq.axonserver.configuration.runtime.CommandHandlers;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.Action;
import io.axoniq.axonserver.grpc.internal.AppendEntryResponse;
import io.axoniq.axonserver.grpc.internal.HandlerLogMessage;
import io.axoniq.axonserver.integration.logconsumer.AdminCommandHandlerLogConsumer;
import io.axoniq.axonserver.localstorage.IndexBackup;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.transport.rest.v2.ResourcesRestControllerV2;
import io.axoniq.axonserver.transport.rest.v2.URIUtils;
import io.axoniq.axonserver.transport.rest.v2.ValidationUtils;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.security.Principal;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@Tag(name="Integration Command Handlers", description="Operations to manage command handlers for integration endpoints")
public class IntegrationCommandHandlerControllerV2 {
    private static final Integer B = 100;
    private final RaftGroupServiceFactory C;
    private final CommandHandlers j;
    private final ObjectMapper m;
    private static final Logger c = AuditLog.getLogger();

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"v2/endpoints/{endpoint}/commandHandlers/{handler}"})
    @Operation(summary="Delete a command handler", description="Remove a command handler from a specific endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Deletion request accepted"), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Command handler or endpoint not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public CompletableFuture<ResponseEntity<Object>> C(@PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid") String string, @PathVariable(value="handler") @Schema(description="Handler UUID", format="uuid") String string2, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = object;
        Object object = principal;
        IntegrationCommandHandlerControllerV2 principal2 = integrationCommandHandlerControllerV2;
        try {
            void request;
            void a2;
            void handlerId;
            HandlerLogMessage endpoint;
            ValidationUtils.C((String)endpoint);
            ValidationUtils.C((String)handlerId);
            object = (Principal)ObjectUtils.C((Object)object, (Object)GrpcContextAuthenticationProvider.j);
            if (c.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)object.getName());
                objectArray[1] = StringUtils.sanitize((String)handlerId);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                c.info(IndexBackup.C((Object)".W\bqU~\u0010]\u0000I\u0006XUX\u001a\f\u0011I\u0019I\u0001IUO\u001aA\u0018M\u001bHUD\u0014B\u0011@\u0010^UW\b\f\u001cBUI\u001bH\u0005C\u001cB\u0001\f\u000eQ["), objectArray);
            }
            endpoint = HandlerLogMessage.newBuilder().setId((String)handlerId).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.DELETE).build();
            return ((CompletableFuture)principal2.C.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminCommandHandlerLogConsumer.class.getSimpleName(), endpoint.toByteArray()).thenApply(arg_0 -> IntegrationCommandHandlerControllerV2.I((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::C);
        }
        catch (MessagingPlatformException this2) {
            return CompletableFuture.completedFuture(ValidationUtils.C((Throwable)this2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"v2/endpoints/{endpoint}/commandHandlers/{handler}"})
    @Operation(summary="Update a command handler", description="Update an existing command handler for a specific endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Update request accepted"), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Command handler or endpoint not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public CompletableFuture<ResponseEntity<Object>> C(@RequestBody @Schema(description="Updated command handler details", implementation=IntegrationAPI.CommandHandler.class) IntegrationAPI.CommandHandler commandHandler, @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid") String string, @PathVariable(value="handler") @Schema(description="Handler UUID", format="uuid") String string2, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = object;
        Object object = commandHandler;
        IntegrationCommandHandlerControllerV2 commandHandler2 = integrationCommandHandlerControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void handlerId;
            void endpoint;
            ValidationUtils.C((String)endpoint);
            ValidationUtils.C((String)handlerId);
            IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV22 = object;
            ValidationUtils.C((String)integrationCommandHandlerControllerV22.name(), (String)IndexBackup.C((Object)"B\u0014A\u0010"));
            ValidationUtils.C((String)integrationCommandHandlerControllerV22.name(), (int)200, (String)ResourcesRestControllerV2.C((Object)"\u0019|\u001ax"));
            ValidationUtils.C((String)object.commandUrl(), (int)2000, (String)IndexBackup.C((Object)"O\u001aA\u0018M\u001bH ^\u0019"));
            if (integrationCommandHandlerControllerV22.loadFactor() != null && object.loadFactor() < 0) {
                throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, ResourcesRestControllerV2.C((Object)"Q\u0018|\u0013=\u0011|\u0014i\u0018oWp\u0002n\u0003=\u0015xW-Wr\u0005=\u001b|\u0005z\u0012o"));
            }
            principal2 = (Principal)ObjectUtils.C((Object)principal2, (Object)GrpcContextAuthenticationProvider.j);
            if (c.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                c.info(IndexBackup.C((Object)".W\bqU~\u0010]\u0000I\u0006XUX\u001a\f\u0000\\\u0011M\u0001IUO\u001aA\u0018M\u001bHUD\u0014B\u0011@\u0010^UW\b\f\u001cBUI\u001bH\u0005C\u001cB\u0001\f\u000eQ["), objectArray);
            }
            if (object.loadFactor() == null) {
                object = new IntegrationAPI.CommandHandler(object.name(), B, object.commandUrl());
            }
            IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV23 = commandHandler2;
            object = integrationCommandHandlerControllerV23.m.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId((String)handlerId).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.UPDATE).build();
            return ((CompletableFuture)integrationCommandHandlerControllerV23.C.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminCommandHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationCommandHandlerControllerV2.C((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::C);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.C((Throwable)principal2));
        }
    }

    private static /* synthetic */ ResponseEntity C(HttpServletRequest httpServletRequest, HandlerLogMessage handlerLogMessage, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = handlerLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ResponseEntity.created((URI)URIUtils.C((StringBuffer)a3.getRequestURL(), (String)a2.getId())).body((Object)new IntegrationAPI.Id(a2.getId()));
    }

    /*
     * WARNING - void declaration
     */
    public IntegrationCommandHandlerControllerV2(ObjectMapper objectMapper, CommandHandlers commandHandlers, RaftGroupServiceFactory raftGroupServiceFactory) {
        void a2;
        void a3;
        IntegrationCommandHandlerControllerV2 a4;
        IntegrationCommandHandlerControllerV2 a5 = raftGroupServiceFactory;
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = a4 = this;
        a4.m = a3;
        integrationCommandHandlerControllerV2.j = a2;
        integrationCommandHandlerControllerV2.C = a5;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"v2/endpoints/{endpoint}/commandHandlers"})
    @Operation(summary="Register a command handler", description="Register a new command handler for a specific endpoint. Command handlers process commands sent to the endpoint.")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Command handler successfully registered", content={@Content(schema=@Schema(implementation=IntegrationAPI.Id.class), mediaType="application/json")}), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Endpoint not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public CompletableFuture<ResponseEntity<Object>> C(@RequestBody @Schema(description="Command handler details", implementation=IntegrationAPI.CommandHandler.class) IntegrationAPI.CommandHandler commandHandler, @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid") String string, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", requiredMode=Schema.RequiredMode.REQUIRED, example="default") String string2) {
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = object;
        Object object = commandHandler;
        IntegrationCommandHandlerControllerV2 commandHandler2 = integrationCommandHandlerControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.C((String)endpoint);
            IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV22 = object;
            ValidationUtils.C((String)integrationCommandHandlerControllerV22.name(), (String)ResourcesRestControllerV2.C((Object)"9|\u001ax"));
            ValidationUtils.C((String)integrationCommandHandlerControllerV22.name(), (int)200, (String)IndexBackup.C((Object)"B\u0014A\u0010"));
            ValidationUtils.C((String)integrationCommandHandlerControllerV22.commandUrl(), (int)2000, (String)ResourcesRestControllerV2.C((Object)"\u0014r\u001ap\u0016s\u0013H\u0005q"));
            if (integrationCommandHandlerControllerV22.loadFactor() != null && object.loadFactor() < 0) {
                throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, IndexBackup.C((Object)"9C\u0014HUJ\u0014O\u0001C\u0007\f\u0018Y\u0006XUN\u0010\fE\f\u001a^U@\u0014^\u0012I\u0007"));
            }
            principal2 = (Principal)ObjectUtils.C((Object)principal2, (Object)GrpcContextAuthenticationProvider.j);
            if (c.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                c.info(ResourcesRestControllerV2.C((Object)"F\f`*=%x\u0006h\u0012n\u0003=\u0003rWo\u0012z\u001en\u0003x\u0005=\u0014r\u001ap\u0016s\u0013=\u001f|\u0019y\u001bx\u0005=\f`Wt\u0019=\u0012s\u0013m\u0018t\u0019iWf\n3"), objectArray);
            }
            if (object.loadFactor() == null) {
                object = new IntegrationAPI.CommandHandler(object.name(), B, object.commandUrl());
            }
            IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV23 = commandHandler2;
            object = integrationCommandHandlerControllerV23.m.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId(UUID.randomUUID().toString()).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.ADD).build();
            return ((CompletableFuture)integrationCommandHandlerControllerV23.C.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminCommandHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationCommandHandlerControllerV2.C((HttpServletRequest)request, (HandlerLogMessage)object, arg_0))).exceptionally(ValidationUtils::C);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.C((Throwable)principal2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/endpoints/{endpoint}/commandHandlers/{handler}"})
    @Operation(responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=IntegrationAPI.CommandHandler.class), mediaType="application/json")}), @ApiResponse(responseCode="400", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public ResponseEntity<Object> C(@PathVariable(value="endpoint") String string, @PathVariable(value="handler") String string2, @Parameter(hidden=true) Principal principal, @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) @RequestParam(value="context") String string3) {
        IntegrationCommandHandlerControllerV2 integrationCommandHandlerControllerV2 = object;
        Object object = string2;
        IntegrationCommandHandlerControllerV2 handlerId = integrationCommandHandlerControllerV2;
        try {
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.C((String)endpoint);
            ValidationUtils.C((String)object);
            principal2 = (Principal)ObjectUtils.C((Object)principal2, (Object)GrpcContextAuthenticationProvider.j);
            if (c.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                c.info(ResourcesRestControllerV2.C((Object)",f\n@WO\u0012l\u0002x\u0004iWi\u0018=\u0010x\u0003=\u0014r\u001ap\u0016s\u0013=\u001f|\u0019y\u001bx\u0005=\f`Wt\u0019=\u0012s\u0013m\u0018t\u0019iWf\n3"), objectArray);
            }
            if (!(object = (CommandHandler)handlerId.j.findById(UUID.fromString((String)object)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, ResourcesRestControllerV2.C((Object)"U\u0016s\u0013q\u0012oWs\u0018iW{\u0018h\u0019y")))).getEndpoint().getId().toString().equals(endpoint)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, IndexBackup.C((Object)"=M\u001bH\u0019I\u0007\f\u001bC\u0001\f\u0013C\u0000B\u0011\f\u001cBUI\u001bH\u0005C\u001cB\u0001"));
            }
            if (!object.getEndpoint().getContext().equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, ResourcesRestControllerV2.C((Object)"?|\u0019y\u001bx\u0005=\u0019r\u0003=\u0011r\u0002s\u0013=\u001esW~\u0018s\u0003x\u000fi"));
            }
            return ResponseEntity.ok((Object)new IntegrationAPI.CommandHandler(object.getName(), Integer.valueOf(object.getLoadFactor()), object.getCommandUrl()));
        }
        catch (MessagingPlatformException principal2) {
            return ValidationUtils.C((Throwable)principal2);
        }
    }

    private static /* synthetic */ ResponseEntity I(HttpServletRequest httpServletRequest, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = appendEntryResponse;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.C((HttpServletRequest)a3);
    }

    private static /* synthetic */ ResponseEntity C(HttpServletRequest httpServletRequest, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = appendEntryResponse;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.C((HttpServletRequest)a3);
    }
}

