/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.PrincipalAuthentication;
import io.axoniq.axonserver.accesscontrol.VisibleContexts;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.UpdateReplicationGroupPayload;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.api.IntegrationAPI;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.processor.balancing.strategy.MergedProcessorLoadBalancingService;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.admin.AdminEndpoint;
import io.axoniq.axonserver.configuration.admin.AdminEndpoints;
import io.axoniq.axonserver.configuration.runtime.Endpoint;
import io.axoniq.axonserver.configuration.runtime.Endpoints;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.Action;
import io.axoniq.axonserver.grpc.internal.AppendEntryResponse;
import io.axoniq.axonserver.grpc.internal.EndpointLogMessage;
import io.axoniq.axonserver.integration.EndpointFactory;
import io.axoniq.axonserver.integration.WrappingTypes;
import io.axoniq.axonserver.integration.logconsumer.AdminEndpointLogConsumer;
import io.axoniq.axonserver.integration.logconsumer.AdminPatchEndpointLogConsumer;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.transport.rest.v2.ValidationUtils;
import io.axoniq.axonserver.util.MapCodec;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.springframework.context.event.EventListener;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@Tag(name="Integration Endpoints", description="Operations for managing integration endpoints")
public class IntegrationEndpointRestControllerV2 {
    private static final Logger L = AuditLog.getLogger();
    private final EndpointFactory G;
    private final RaftGroupServiceFactory A;
    private final VisibleContexts B;
    private final Map<UUID, Set<String>> C;
    private final ObjectMapper j;
    private final Endpoints m;
    private final AdminEndpoints c;

    /*
     * WARNING - void declaration
     */
    public IntegrationEndpointRestControllerV2(ObjectMapper objectMapper, RaftGroupServiceFactory raftGroupServiceFactory, AdminEndpoints adminEndpoints, Endpoints endpoints, VisibleContexts visibleContexts, EndpointFactory endpointFactory) {
        IntegrationEndpointRestControllerV2 a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        IntegrationEndpointRestControllerV2 a8;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = integrationEndpointRestControllerV22;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV22 = endpointFactory;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV23 = a8 = integrationEndpointRestControllerV2;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV24 = a8;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV25 = a8;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV26 = a8;
        integrationEndpointRestControllerV26.C = new ConcurrentHashMap();
        integrationEndpointRestControllerV25.j = a7;
        integrationEndpointRestControllerV25.A = a6;
        integrationEndpointRestControllerV24.c = a5;
        integrationEndpointRestControllerV24.m = a4;
        integrationEndpointRestControllerV23.B = a3;
        integrationEndpointRestControllerV23.G = a2;
    }

    private static /* synthetic */ boolean C(Set set, Endpoint endpoint) {
        Set a2 = endpoint;
        Set a3 = set;
        return a3.contains(a2.getContext());
    }

    private static /* synthetic */ ResponseEntity I(HttpServletRequest httpServletRequest, EndpointLogMessage endpointLogMessage, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = endpointLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.C((HttpServletRequest)a3, (String)a2.getId());
    }

    private static /* synthetic */ boolean C(Set set, AdminEndpoint adminEndpoint) {
        Set a2 = adminEndpoint;
        Set a3 = set;
        return a3.contains(a2.getContext());
    }

    private /* synthetic */ void C(IntegrationAPI.Endpoint endpoint) {
        IntegrationEndpointRestControllerV2 a2 = endpoint;
        IntegrationEndpointRestControllerV2 a3 = this;
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = a2;
        ValidationUtils.C((String)integrationEndpointRestControllerV2.name(), (String)MergedProcessorLoadBalancingService.C((Object)"8\u001b;\u001f"));
        ValidationUtils.C((String)integrationEndpointRestControllerV2.baseUrl(), (String)UpdateReplicationGroupPayload.C((Object)"\b'\u0019#?4\u0006"));
        ValidationUtils.C((String)integrationEndpointRestControllerV2.type(), (String)"type");
        ValidationUtils.C((String)integrationEndpointRestControllerV2.wrappingType(), (String)MergedProcessorLoadBalancingService.C((Object)"!\b7\n&\u00138\u001d\u0002\u0003&\u001f"));
        ValidationUtils.C((String)integrationEndpointRestControllerV2.contentType(), (String)UpdateReplicationGroupPayload.C((Object)"\t)\u00042\u000f(\u001e\u0012\u00136\u000f"));
        ValidationUtils.C((String)integrationEndpointRestControllerV2.type(), (String)"type", (Collection)a3.C());
        ValidationUtils.C((String)integrationEndpointRestControllerV2.wrappingType(), (String)MergedProcessorLoadBalancingService.C((Object)"!\b7\n&\u00138\u001d\u0002\u0003&\u001f"), (Collection)a3.C());
        ValidationUtils.I((String)integrationEndpointRestControllerV2.contentType(), (String)UpdateReplicationGroupPayload.C((Object)"\t)\u00042\u000f(\u001e\u0012\u00136\u000f"));
        ValidationUtils.C((String)integrationEndpointRestControllerV2.name(), (int)200, (String)MergedProcessorLoadBalancingService.C((Object)"8\u001b;\u001f"));
        ValidationUtils.C((String)integrationEndpointRestControllerV2.baseUrl(), (int)2000, (String)UpdateReplicationGroupPayload.C((Object)"\b'\u0019#?4\u0006"));
        ValidationUtils.C((String)integrationEndpointRestControllerV2.healthUrl(), (int)2000, (String)MergedProcessorLoadBalancingService.C((Object)"\u00123\u001b:\u000e>/$\u0016"));
        ValidationUtils.C((String)integrationEndpointRestControllerV2.commandUrl(), (int)2000, (String)UpdateReplicationGroupPayload.C((Object)"%\u0005+\u0007'\u0004\"?4\u0006"));
        ValidationUtils.C((String)integrationEndpointRestControllerV2.queryUrl(), (int)2000, (String)MergedProcessorLoadBalancingService.C((Object)"'\u000f3\b//$\u0016"));
        ValidationUtils.C((String)integrationEndpointRestControllerV2.eventUrl(), (int)2000, (String)UpdateReplicationGroupPayload.C((Object)"#\u001c#\u00042?4\u0006"));
        ValidationUtils.C((String)integrationEndpointRestControllerV2.contentType(), (int)200, (String)MergedProcessorLoadBalancingService.C((Object)"\u00199\u0014\"\u001f8\u000e\u0002\u0003&\u001f"));
        ValidationUtils.C((String)MapCodec.encode((Map)integrationEndpointRestControllerV2.metaData()), (int)4000, (String)"metaData");
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"v2/endpoints/{endpointId}"})
    @Operation(summary="Update an endpoint", description="Updates an existing integration endpoint with the provided configuration")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Update request accepted"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="404", description="Endpoint not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public CompletableFuture<ResponseEntity<Object>> C(@RequestBody @Schema(description="Updated endpoint configuration", implementation=IntegrationAPI.Endpoint.class) IntegrationAPI.Endpoint endpoint, @PathVariable(value="endpointId") @Schema(description="Endpoint UUID", format="uuid") String string, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = endpoint;
        IntegrationEndpointRestControllerV2 endpoint2 = integrationEndpointRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void endpointId;
            ValidationUtils.C((String)endpointId);
            endpoint2.C((IntegrationAPI.Endpoint)object);
            principal2 = (Principal)ObjectUtils.C((Object)principal2, (Object)GrpcContextAuthenticationProvider.j);
            if (L.isInfoEnabled()) {
                L.info(UpdateReplicationGroupPayload.C((Object)"1=\u0017\u001bJ\u0014\u000f7\u001f#\u00192J2\u0005f\u001f6\u000e'\u001e#J#\u0004\"\u001a)\u0003(\u001ef\u0011;D"), (Object)AuditLog.username((String)principal2.getName()), (Object)StringUtils.sanitize((String)object.name()));
            }
            IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV22 = endpoint2;
            object = integrationEndpointRestControllerV22.j.writeValueAsString(object);
            object = EndpointLogMessage.newBuilder().setId((String)endpointId).setData((String)object).setContext((String)a2).setAction(Action.UPDATE).build();
            return ((CompletableFuture)integrationEndpointRestControllerV22.A.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEndpointLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationEndpointRestControllerV2.C((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::C);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.C((Throwable)principal2));
        }
    }

    @GetMapping(value={"v2/wrappingTypes"})
    @Operation(summary="Get available wrapping types", description="Retrieves all available wrapping types that can be used when creating an integration endpoint")
    @ApiResponse(responseCode="200", description="List of wrapping types retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(type="string")))})
    public List<String> C() {
        return List.of(WrappingTypes.m.C(), WrappingTypes.j.C());
    }

    @GetMapping(value={"v2/endpointTypes"})
    @Operation(summary="Get available endpoint types", description="Retrieves all available endpoint types that can be used when creating an integration endpoint")
    @ApiResponse(responseCode="200", description="List of endpoint types retrieved successfully", content={@Content(schema=@Schema(implementation=Set.class))})
    public Set<IntegrationAPI.EndpointType> I() {
        IntegrationEndpointRestControllerV2 a2;
        return a2.G.types();
    }

    @GetMapping(value={"internal/raft/endpoints"})
    @Transactional(readOnly=true)
    @Operation(summary="List internal endpoints", description="Internal API to list all endpoints for Raft synchronization (not for public use)")
    @ApiResponse(responseCode="200", description="List of internal endpoints retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=IntegrationAPI.EndpointOverview.class)))})
    public List<IntegrationAPI.EndpointOverview> I(@Parameter(hidden=true) Principal principal) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = principal;
        IntegrationEndpointRestControllerV2 a2 = integrationEndpointRestControllerV2;
        object = new PrincipalAuthentication((Principal)ObjectUtils.C((Object)object, (Object)GrpcContextAuthenticationProvider.j));
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV22 = a2;
        object = integrationEndpointRestControllerV22.B.visibleContexts(false, (Authentication)object);
        return integrationEndpointRestControllerV22.m.findAll().stream().filter(arg_0 -> IntegrationEndpointRestControllerV2.C((Set)object, arg_0)).map(endpoint -> {
            IntegrationEndpointRestControllerV2 a2 = endpoint;
            IntegrationEndpointRestControllerV2 a3 = this;
            LinkedList linkedList = new LinkedList();
            LinkedList linkedList2 = new LinkedList();
            LinkedList linkedList3 = new LinkedList();
            a2.getCommandHandlers().forEach(commandHandler -> {
                List a2 = commandHandler;
                List a3 = linkedList;
                a3.add(new IntegrationAPI.CommandHandlerOverview(a2.getId().toString(), a2.getName(), a2.getLoadFactor(), a2.getCommandUrl()));
            });
            a2.getEventHandlers().forEach(eventHandler -> {
                List a2 = eventHandler;
                List a3 = linkedList2;
                a3.add(new IntegrationAPI.EventHandlerOverview(a2.getId().toString(), a2.getName(), a2.getBatchSize(), a2.getFilter(), a2.getSequencingPolicy(), a2.getSequencingPolicyParameters(), a2.getEventUrl()));
            });
            a2.getQueryHandlers().forEach(queryHandler -> {
                List a2 = queryHandler;
                List a3 = linkedList3;
                a3.add(new IntegrationAPI.QueryHandlerOverview(a2.getId().toString(), a2.getName(), a2.getQueryUrl()));
            });
            return new IntegrationAPI.EndpointOverview(a2.getContext(), a2.getId().toString(), a2.getName(), a2.getType(), a2.getBaseUrl(), a2.getCommandUrl(), a2.getQueryUrl(), a2.getEventUrl(), a2.getHealthUrl(), a2.getWrappingType(), a2.getContentType(), a2.isActive(), a2.getMetaData(), linkedList, linkedList2, linkedList3, a3.C.getOrDefault(a2.getId(), Collections.emptySet()).size());
        }).toList();
    }

    private /* synthetic */ Set<String> C() {
        IntegrationEndpointRestControllerV2 a2;
        return a2.G.typeNames();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"v2/endpoints"})
    @Operation(summary="Register a new endpoint", description="Creates a new integration endpoint with the provided configuration")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Endpoint successfully created"), @ApiResponse(responseCode="400", description="Invalid request parameters"), @ApiResponse(responseCode="500", description="Internal server error")})
    public CompletableFuture<ResponseEntity<Object>> C(@RequestBody @Schema(description="Endpoint configuration details", implementation=IntegrationAPI.Endpoint.class) IntegrationAPI.Endpoint endpoint, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = endpoint;
        IntegrationEndpointRestControllerV2 endpoint2 = integrationEndpointRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            endpoint2.C((IntegrationAPI.Endpoint)object);
            principal2 = (Principal)ObjectUtils.C((Object)principal2, (Object)GrpcContextAuthenticationProvider.j);
            if (L.isInfoEnabled()) {
                L.info(MergedProcessorLoadBalancingService.C((Object)"!-\u0007\u000bZ\u0004\u001f'\u000f3\t\"Z\"\u0015v\b3\u001d?\t\"\u001f$Z3\u00142\n9\u00138\u000ev\u0001+T"), (Object)AuditLog.username((String)principal2.getName()), (Object)StringUtils.sanitize((String)object.name()));
            }
            IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV22 = endpoint2;
            object = integrationEndpointRestControllerV22.j.writeValueAsString(object);
            object = EndpointLogMessage.newBuilder().setId(UUID.randomUUID().toString()).setData((String)object).setContext((String)a2).setAction(Action.ADD).build();
            return ((CompletableFuture)integrationEndpointRestControllerV22.A.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEndpointLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationEndpointRestControllerV2.I((HttpServletRequest)request, (EndpointLogMessage)object, arg_0))).exceptionally(ValidationUtils::C);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.C((Throwable)principal2));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PatchMapping(value={"v2/endpoints/{endpointId}"})
    @Operation(summary="Change endpoint active state", description="Activates or deactivates an integration endpoint. When deactivated, the endpoint will not process messages.")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="State change request accepted"), @ApiResponse(responseCode="400", description="Invalid endpoint ID format"), @ApiResponse(responseCode="404", description="Endpoint not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public CompletableFuture<ResponseEntity<Object>> C(@PathVariable(value="endpointId") @Schema(description="Endpoint UUID", format="uuid") String string, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="active") @Schema(description="Activation state: true to activate, false to deactivate") boolean bl, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2) {
        void var1_3;
        void this_2 = var1_3;
        IntegrationEndpointRestControllerV2 endpointId = this;
        try {
            void request;
            void a2;
            void active;
            Principal principal2;
            ValidationUtils.C((String)this_2);
            principal2 = (Principal)ObjectUtils.C((Object)principal2, (Object)GrpcContextAuthenticationProvider.j);
            if (L.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = active != false ? UpdateReplicationGroupPayload.C((Object)"4\u000f5\u001f+\u000f") : MergedProcessorLoadBalancingService.C((Object)"\n7\u000f%\u001f");
                objectArray[2] = StringUtils.sanitize((String)this_2);
                L.info(MergedProcessorLoadBalancingService.C((Object)"!-\u0007\u000bZ\u0004\u001f'\u000f3\t\"Z\"\u0015v\u0001+Z3\u00142\n9\u00138\u000ev\u0001+T"), objectArray);
            }
            EndpointLogMessage this_2 = EndpointLogMessage.newBuilder().setId((String)this_2).setData(String.valueOf((boolean)active)).setContext((String)a2).setAction(Action.UPDATE).build();
            return ((CompletableFuture)endpointId.A.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminPatchEndpointLogConsumer.class.getSimpleName(), this_2.toByteArray()).thenApply(arg_0 -> IntegrationEndpointRestControllerV2.C((HttpServletRequest)request, this_2, arg_0))).exceptionally(ValidationUtils::C);
        }
        catch (MessagingPlatformException principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.C((Throwable)principal2));
        }
    }

    @EventListener
    public void C(TopologyEvents.EndpointConnected endpointConnected) {
        IntegrationEndpointRestControllerV2 a3 = endpointConnected;
        IntegrationEndpointRestControllerV2 a4 = this;
        a4.C.computeIfAbsent(a3.C(), a2 -> new CopyOnWriteArraySet()).add(a3.I());
    }

    @EventListener
    public void C(TopologyEvents.EndpointDisconnected endpointDisconnected) {
        IntegrationEndpointRestControllerV2 a2 = endpointDisconnected;
        IntegrationEndpointRestControllerV2 a3 = this;
        a3.C.getOrDefault(a2.C(), Collections.emptySet()).remove(a2.C());
    }

    @GetMapping(value={"v2/endpoints"})
    @Transactional(readOnly=true)
    @Operation(summary="List all endpoints", description="Retrieves all integration endpoints with their handlers and connection status")
    @ApiResponse(responseCode="200", description="List of endpoints retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=IntegrationAPI.EndpointOverview.class)))})
    public List<IntegrationAPI.EndpointOverview> C(@Parameter(hidden=true) Principal principal) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = principal;
        IntegrationEndpointRestControllerV2 a2 = integrationEndpointRestControllerV2;
        object = new PrincipalAuthentication((Principal)ObjectUtils.C((Object)object, (Object)GrpcContextAuthenticationProvider.j));
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV22 = a2;
        object = integrationEndpointRestControllerV22.B.visibleContexts(false, (Authentication)object);
        return integrationEndpointRestControllerV22.c.findAll().stream().filter(arg_0 -> IntegrationEndpointRestControllerV2.C((Set)object, arg_0)).map(adminEndpoint -> {
            IntegrationEndpointRestControllerV2 a3 = adminEndpoint;
            IntegrationEndpointRestControllerV2 a4 = this;
            return new IntegrationAPI.EndpointOverview(a3.getContext(), a3.getId().toString(), a3.getName(), a3.getType(), a3.getBaseUrl(), a3.getCommandUrl(), a3.getQueryUrl(), a3.getEventUrl(), a3.getHealthUrl(), a3.getWrappingType(), a3.getContentType(), a3.isActive(), a3.getMetaData(), a3.getCommandHandlers().stream().map(a2 -> new IntegrationAPI.CommandHandlerOverview(a2.getId().toString(), a2.getName(), a2.getLoadFactor(), a2.getCommandUrl())).toList(), a3.getEventHandlers().stream().map(a2 -> new IntegrationAPI.EventHandlerOverview(a2.getId().toString(), a2.getName(), a2.getBatchSize(), a2.getFilter(), a2.getSequencingPolicy(), a2.getSequencingPolicyParameters(), a2.getEventUrl())).toList(), a3.getQueryHandlers().stream().map(a2 -> new IntegrationAPI.QueryHandlerOverview(a2.getId().toString(), a2.getName(), a2.getQueryUrl())).toList(), a4.C.getOrDefault(a3.getId(), Collections.emptySet()).size());
        }).toList();
    }

    private static /* synthetic */ ResponseEntity C(HttpServletRequest httpServletRequest, EndpointLogMessage endpointLogMessage, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = endpointLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.C((HttpServletRequest)a3, (String)a2.getId());
    }

    private static /* synthetic */ ResponseEntity C(HttpServletRequest httpServletRequest, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = appendEntryResponse;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.C((HttpServletRequest)a3);
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"v2/endpoints/{endpointId}"})
    @Operation(summary="Delete an endpoint", description="Removes an integration endpoint and all its associated handlers")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Endpoint successfully deleted"), @ApiResponse(responseCode="400", description="Invalid endpoint ID format"), @ApiResponse(responseCode="404", description="Endpoint not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public CompletableFuture<ResponseEntity<Object>> C(@PathVariable(value="endpointId") @Schema(description="Endpoint UUID", format="uuid") String string, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = principal;
        IntegrationEndpointRestControllerV2 principal2 = integrationEndpointRestControllerV2;
        try {
            void a3;
            EndpointLogMessage endpointId;
            ValidationUtils.C((String)endpointId);
            object = (Principal)ObjectUtils.C((Object)object, (Object)GrpcContextAuthenticationProvider.j);
            if (L.isInfoEnabled()) {
                L.info(UpdateReplicationGroupPayload.C((Object)"1=\u0017\u001bJ\u0014\u000f7\u001f#\u00192J2\u0005f\u000e#\u0006#\u001e#J#\u0004\"\u001a)\u0003(\u001ef\u0011;D"), (Object)AuditLog.username((String)object.getName()), (Object)StringUtils.sanitize((String)endpointId));
            }
            endpointId = EndpointLogMessage.newBuilder().setId((String)endpointId).setContext((String)a3).setAction(Action.DELETE).build();
            return ((CompletableFuture)principal2.A.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEndpointLogConsumer.class.getSimpleName(), endpointId.toByteArray()).thenApply(a2 -> ValidationUtils.C())).exceptionally(ValidationUtils::C);
        }
        catch (MessagingPlatformException this2) {
            return CompletableFuture.completedFuture(ValidationUtils.C((Throwable)this2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/endpoints/{endpointId}"})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=IntegrationAPI.Endpoint.class), mediaType="application/json")}), @ApiResponse(responseCode="400", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public ResponseEntity<Object> C(@PathVariable(value="endpointId") String string, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") String string2) {
        IntegrationEndpointRestControllerV2 integrationEndpointRestControllerV2 = object;
        Object object = string;
        IntegrationEndpointRestControllerV2 endpointId = integrationEndpointRestControllerV2;
        try {
            void a2;
            Principal principal2;
            ValidationUtils.C((String)object);
            principal2 = (Principal)ObjectUtils.C((Object)principal2, (Object)GrpcContextAuthenticationProvider.j);
            if (L.isInfoEnabled()) {
                L.info(UpdateReplicationGroupPayload.C((Object)"\u001d\u0011;7f8#\u001b3\u000f5\u001ef\u001e)J#\u0004\"\u001a)\u0003(\u001ef\u0011;D"), (Object)AuditLog.username((String)principal2.getName()), (Object)StringUtils.sanitize((String)object));
            }
            if (!(object = (Endpoint)endpointId.m.findById(UUID.fromString((String)object)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, UpdateReplicationGroupPayload.C((Object)"\u0003\u0004\"\u001a)\u0003(\u001ef\u0004)\u001ef\f)\u001f(\u000e")))).getContext().equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, MergedProcessorLoadBalancingService.C((Object)"?8\u001e&\u0015?\u0014\"Z8\u0015\"Z0\u0015#\u00142Z?\u0014v\u00199\u0014\"\u001f.\u000e"));
            }
            return ResponseEntity.ok((Object)new IntegrationAPI.Endpoint(object.getName(), object.getType(), object.getBaseUrl(), object.getCommandUrl(), object.getQueryUrl(), object.getEventUrl(), object.getHealthUrl(), object.getWrappingType(), object.getContentType(), object.getMetaData()));
        }
        catch (MessagingPlatformException principal2) {
            return ValidationUtils.C((Throwable)principal2);
        }
    }
}

