/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.access.roles.RoleController;
import io.axoniq.axonserver.api.IntegrationAPI;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.runtime.EventHandler;
import io.axoniq.axonserver.configuration.runtime.EventHandlers;
import io.axoniq.axonserver.enterprise.cluster.AutoRebalancing;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.eventstore.EventStoreTokenSupplier;
import io.axoniq.axonserver.eventstore.EventSupplier;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.Action;
import io.axoniq.axonserver.grpc.internal.AppendEntryResponse;
import io.axoniq.axonserver.grpc.internal.HandlerLogMessage;
import io.axoniq.axonserver.integration.logconsumer.AdminEventHandlerLogConsumer;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.streams.SequencingPolicyDefinition;
import io.axoniq.axonserver.streams.cluster.DefaultSequencingPolicyDefinition;
import io.axoniq.axonserver.streams.sequencing.SequencingPolicy;
import io.axoniq.axonserver.streams.sequencing.SequencingPolicyProvider;
import io.axoniq.axonserver.transport.rest.v2.ValidationUtils;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.invoke.LambdaMetafactory;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@Tag(name="Integration Event Handlers", description="API endpoints for managing integration event handlers")
public class IntegrationEventHandlerRestControllerV2 {
    private final EventStoreTokenSupplier G;
    private final EventHandlers A;
    private final EventSupplier B;
    private final RaftGroupServiceFactory C;
    private final SequencingPolicyProvider j;
    private final ObjectMapper m;
    private static final Logger c = AuditLog.getLogger();

    /*
     * WARNING - void declaration
     */
    public IntegrationEventHandlerRestControllerV2(EventStoreTokenSupplier eventStoreTokenSupplier, ObjectMapper objectMapper, RaftGroupServiceFactory raftGroupServiceFactory, EventHandlers eventHandlers, SequencingPolicyProvider sequencingPolicyProvider, EventSupplier eventSupplier) {
        IntegrationEventHandlerRestControllerV2 a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        IntegrationEventHandlerRestControllerV2 a8;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV2 = integrationEventHandlerRestControllerV22;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV22 = eventSupplier;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV23 = a8 = integrationEventHandlerRestControllerV2;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV24 = a8;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV25 = a8;
        integrationEventHandlerRestControllerV25.G = a7;
        integrationEventHandlerRestControllerV25.m = a6;
        integrationEventHandlerRestControllerV24.C = a5;
        integrationEventHandlerRestControllerV24.A = a4;
        integrationEventHandlerRestControllerV23.j = a3;
        integrationEventHandlerRestControllerV23.B = a2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Operation(summary="Register a new event handler", description="Registers a new event handler for an integration endpoint. The handler will process events according to the specified sequencing policy.")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Event handler successfully registered", content={@Content(schema=@Schema(implementation=IntegrationAPI.Id.class))}), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))})})
    @PostMapping(value={"v2/endpoints/{endpoint}/eventHandlers"})
    public CompletableFuture<ResponseEntity<Object>> C(@Parameter(description="Event handler configuration") @RequestBody @Schema(description="Event handler configuration details") IntegrationAPI.EventHandler var1_1, @Parameter(description="UUID of the integration endpoint", required=true) @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String var2_2, @Parameter(hidden=true) Principal var3_3, @Parameter(hidden=true) HttpServletRequest var4_4, @Parameter(description="Context name") @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String var5_5) {
        block8: {
            block7: {
                v0 = this /* !! */ ;
                this /* !! */  = var1_1;
                eventHandler = v0;
                ValidationUtils.C((String)endpoint);
                v1 = this /* !! */ ;
                eventHandler.C((IntegrationAPI.EventHandler)v1);
                if (v1.startPosition() != null && !this /* !! */ .startPosition().isEmpty() && !this /* !! */ .startPosition().equalsIgnoreCase(AutoRebalancing.C((Object)"\u0013x\u000eu"))) break block7;
                var6_6 = eventHandler.G.firstToken((String)a);
                this /* !! */  = this /* !! */ .withStartPosition((Long)var6_6);
                v2 = principal;
                ** GOTO lbl25
            }
            if (!this /* !! */ .startPosition().equalsIgnoreCase(RoleController.C((Object)"&r/s"))) break block8;
            var6_6 = eventHandler.G.lastToken((String)a);
            this /* !! */  = this /* !! */ .withStartPosition((Long)var6_6);
            v2 = principal;
            ** GOTO lbl25
        }
        if (Long.parseLong(this /* !! */ .startPosition()) >= 0L) ** GOTO lbl-1000
        throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, AutoRebalancing.C((Object)"J3X5M\u0017V4P3P(WgT2J3\u0019%\\g\tgV5\u0019+X5^\"K"));
        {
            catch (Exception var6_8) {
                return CompletableFuture.completedFuture(ValidationUtils.C((Throwable)var6_8));
            }
lbl-1000:
            // 1 sources

            {
                v2 = principal;
lbl25:
                // 3 sources

                var6_6 = (Principal)ObjectUtils.C((Object)v2, (Object)GrpcContextAuthenticationProvider.j);
                if (IntegrationEventHandlerRestControllerV2.c.isInfoEnabled()) {
                    v3 = new Object[3];
                    v3[0] = AuditLog.username((String)var6_6.getName());
                    v3[1] = StringUtils.sanitize((String)this /* !! */ .name());
                    v3[2] = StringUtils.sanitize((String)endpoint);
                    IntegrationEventHandlerRestControllerV2.c.info(AutoRebalancing.C((Object)"b<D\u001a\u0019\u0015\\6L\"J3\u00193VgK\"^.J3\\5\u0019\"O\"W3\u0019/X)]+\\5\u0019<DgP)\u0019\"W#I(P)MgB:\u0017"), v3);
                }
                v4 = eventHandler;
                this /* !! */  = v4.m.writeValueAsString((Object)this /* !! */ );
                this /* !! */  = HandlerLogMessage.newBuilder().setId(UUID.randomUUID().toString()).setData((String)this /* !! */ ).setContext((String)a).setEndpointId((String)endpoint).setAction(Action.ADD).build();
                return v4.C.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEventHandlerLogConsumer.class.getSimpleName(), this /* !! */ .toByteArray()).thenApply((Function<AppendEntryResponse, ResponseEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, C(jakarta.servlet.http.HttpServletRequest io.axoniq.axonserver.grpc.internal.HandlerLogMessage io.axoniq.axonserver.grpc.internal.AppendEntryResponse ), (Lio/axoniq/axonserver/grpc/internal/AppendEntryResponse;)Lorg/springframework/http/ResponseEntity;)((HttpServletRequest)request, (HandlerLogMessage)this /* !! */ )).exceptionally((Function<Throwable, ResponseEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, C(java.lang.Throwable ), (Ljava/lang/Throwable;)Lorg/springframework/http/ResponseEntity;)());
            }
        }
    }

    private static /* synthetic */ ResponseEntity C(HttpServletRequest httpServletRequest, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = appendEntryResponse;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.C((HttpServletRequest)a3);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/endpoints/{endpoint}/eventHandlers/{handler}"})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=IntegrationAPI.EventHandler.class), mediaType="application/json")}), @ApiResponse(responseCode="400", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public ResponseEntity<Object> C(@PathVariable(value="endpoint") String string, @PathVariable(value="handler") String string2, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") String string3) {
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV2 = object;
        Object object = string2;
        IntegrationEventHandlerRestControllerV2 handlerId = integrationEventHandlerRestControllerV2;
        try {
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.C((String)endpoint);
            ValidationUtils.C((String)object);
            principal2 = (Principal)ObjectUtils.C((Object)principal2, (Object)GrpcContextAuthenticationProvider.j);
            if (c.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                c.info(AutoRebalancing.C((Object)"\u001cB:dgk\"H2\\4MgM(\u0019 \\3\u0019\"O\"W3\u0019/X)]+\\5\u0019<DgP)\u0019\"W#I(P)MgB:\u0017"), objectArray);
            }
            if (!(object = (EventHandler)handlerId.A.findById(UUID.fromString((String)object)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, AutoRebalancing.C((Object)"q&W#U\"KgW(Mg_(L)]")))).getEndpoint().getId().toString().equals(endpoint)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, RoleController.C((Object)"\u007f\u000fY\n[\u000bENY\u0001CNQ\u0001B\u0000SN^\u0000\u0017\u000bY\nG\u0001^\u0000C"));
            }
            if (!object.getEndpoint().getContext().equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, AutoRebalancing.C((Object)"\u000fX)]+\\5\u0019)V3\u0019!V2W#\u0019.WgZ(W3\\?M"));
            }
            return ResponseEntity.ok((Object)new IntegrationAPI.EventHandler(object.getName(), object.getBatchSize(), object.getFilter(), object.getSequencingPolicy(), object.getSequencingPolicyParameters(), object.getSegments(), "", object.getEventUrl()));
        }
        catch (MessagingPlatformException principal2) {
            return ValidationUtils.C((Throwable)principal2);
        }
    }

    private static /* synthetic */ ResponseEntity C(HttpServletRequest httpServletRequest, HandlerLogMessage handlerLogMessage, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = handlerLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.C((HttpServletRequest)a3, (String)a2.getId());
    }

    private /* synthetic */ void C(IntegrationAPI.EventHandler eventHandler) {
        IntegrationEventHandlerRestControllerV2 a2 = eventHandler;
        IntegrationEventHandlerRestControllerV2 a3 = this;
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV2 = a2;
        ValidationUtils.C((String)integrationEventHandlerRestControllerV2.name(), (String)AutoRebalancing.C((Object)")X*\\"));
        ValidationUtils.C((String)integrationEventHandlerRestControllerV2.sequencingPolicy(), (String)RoleController.C((Object)"\u001dR\u001fB\u000bY\r^\u0000P>X\u0002^\rN"));
        ValidationUtils.C((String)integrationEventHandlerRestControllerV2.sequencingPolicy(), (String)AutoRebalancing.C((Object)"4\\6L\"W$P)^\u0017V+P$@"), (Collection)a3.C());
        ValidationUtils.C((String)integrationEventHandlerRestControllerV2.name(), (int)200, (String)RoleController.C((Object)"\u0000V\u0003R"));
        ValidationUtils.C((String)integrationEventHandlerRestControllerV2.eventUrl(), (int)2000, (String)AutoRebalancing.C((Object)"\"O\"W3l5U"));
        ValidationUtils.C((String)integrationEventHandlerRestControllerV2.sequencingPolicyParameters(), (int)2000, (String)RoleController.C((Object)"\u001dR\u001fB\u000bY\r^\u0000P>X\u0002^\rN>V\u001cV\u0003R\u001aR\u001cD"));
        ValidationUtils.C((String)integrationEventHandlerRestControllerV2.filter(), (int)4000, (String)AutoRebalancing.C((Object)"!P+M\"K"));
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV22 = a3;
        integrationEventHandlerRestControllerV22.B.validateFilter(a2.filter());
        integrationEventHandlerRestControllerV22.C(integrationEventHandlerRestControllerV2.sequencingPolicy(), a2.sequencingPolicyParameters());
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Update an existing event handler", description="Updates the configuration of an existing event handler for an integration endpoint.")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Event handler update accepted"), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Event handler not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))})})
    @PutMapping(value={"v2/endpoints/{endpoint}/eventHandlers/{handler}"})
    public CompletableFuture<ResponseEntity<Object>> C(@Parameter(description="Updated event handler configuration", required=true) @RequestBody @Schema(description="Updated event handler details", requiredMode=Schema.RequiredMode.REQUIRED) IntegrationAPI.EventHandler eventHandler, @Parameter(description="UUID of the integration endpoint", required=true) @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @Parameter(description="UUID of the event handler to update", required=true) @PathVariable(value="handler") @Schema(description="Event handler UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @Parameter(description="Context name") @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV2 = object;
        Object object = eventHandler;
        IntegrationEventHandlerRestControllerV2 eventHandler2 = integrationEventHandlerRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void handlerId;
            void endpoint;
            ValidationUtils.C((String)endpoint);
            ValidationUtils.C((String)handlerId);
            eventHandler2.C((IntegrationAPI.EventHandler)object);
            principal2 = (Principal)ObjectUtils.C((Object)principal2, (Object)GrpcContextAuthenticationProvider.j);
            if (c.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                c.info(RoleController.C((Object)"l\u0015J3\u0017<R\u001fB\u000bD\u001a\u0017\u001aXNB\u001eS\u000fC\u000b\u0017\u000bA\u000bY\u001a\u0017\u0006V\u0000S\u0002R\u001c\u0017\u0015JN^\u0000\u0017\u000bY\nG\u0001^\u0000CNL\u0013\u0019"), objectArray);
            }
            IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV22 = eventHandler2;
            object = integrationEventHandlerRestControllerV22.m.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId((String)handlerId).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.UPDATE).build();
            return ((CompletableFuture)integrationEventHandlerRestControllerV22.C.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEventHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationEventHandlerRestControllerV2.C((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::C);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.C((Throwable)principal2));
        }
    }

    private /* synthetic */ void C(String string, String string2) {
        SequencingPolicy a22;
        String a32 = string2;
        IntegrationEventHandlerRestControllerV2 a4 = this;
        if (a22 != null) {
            String[] stringArray = StringUtils.isEmpty((String)a32) ? new String[]{} : a32.split(RoleController.C((Object)"\u001b"));
            int n = a32 = 0;
            while (n < stringArray.length) {
                stringArray[++a32] = stringArray[a32].trim();
                n = a32;
            }
            List<String> a32 = Arrays.asList(stringArray);
            a22 = a4.j.get((SequencingPolicyDefinition)new DefaultSequencingPolicyDefinition((String)a22, a32));
            try {
                Integer[] integerArray = new Integer[1];
                integerArray[0] = 0;
                a22.sequencer(a32, 0, integerArray);
                return;
            }
            catch (Exception a22) {
                throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, "sequencingPolicy: " + a22.getMessage());
            }
        }
    }

    @Operation(summary="Get available sequencing policies", description="Retrieves the list of available sequencing policies that can be used for event handlers")
    @ApiResponse(responseCode="200", description="Successfully retrieved sequencing policies", content={@Content(array=@ArraySchema(schema=@Schema(type="string")))})
    @GetMapping(value={"v2/sequencingPolicies"})
    public Set<String> C() {
        IntegrationEventHandlerRestControllerV2 a2;
        return a2.j.sequencingPolicies();
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Delete an event handler", description="Removes an event handler from an integration endpoint.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Event handler successfully deleted"), @ApiResponse(responseCode="400", description="Invalid request parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Event handler not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class))})})
    @DeleteMapping(value={"v2/endpoints/{endpoint}/eventHandlers/{handler}"})
    public CompletableFuture<ResponseEntity<Object>> C(@Parameter(description="UUID of the integration endpoint", required=true) @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @Parameter(description="UUID of the event handler to delete", required=true) @PathVariable(value="handler") @Schema(description="Event handler UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @Parameter(hidden=true) Principal principal, @Parameter(description="Context name") @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationEventHandlerRestControllerV2 integrationEventHandlerRestControllerV2 = object;
        Object object = principal;
        IntegrationEventHandlerRestControllerV2 principal2 = integrationEventHandlerRestControllerV2;
        try {
            void a3;
            void handlerId;
            HandlerLogMessage endpoint;
            ValidationUtils.C((String)endpoint);
            ValidationUtils.C((String)handlerId);
            object = (Principal)ObjectUtils.C((Object)object, (Object)GrpcContextAuthenticationProvider.j);
            if (c.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)object.getName());
                objectArray[1] = StringUtils.sanitize((String)handlerId);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                c.info(RoleController.C((Object)"l\u0015J3\u0017<R\u001fB\u000bD\u001a\u0017\u001aXNS\u000b[\u000bC\u000b\u0017\u000bA\u000bY\u001a\u0017\u0006V\u0000S\u0002R\u001c\u0017\u0015JN^\u0000\u0017\u000bY\nG\u0001^\u0000CNL\u0013\u0019"), objectArray);
            }
            endpoint = HandlerLogMessage.newBuilder().setId((String)handlerId).setContext((String)a3).setEndpointId((String)endpoint).setAction(Action.DELETE).build();
            return ((CompletableFuture)principal2.C.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminEventHandlerLogConsumer.class.getSimpleName(), endpoint.toByteArray()).thenApply(a2 -> ValidationUtils.C())).exceptionally(ValidationUtils::C);
        }
        catch (MessagingPlatformException this2) {
            return CompletableFuture.completedFuture(ValidationUtils.C((Throwable)this2));
        }
    }
}

