/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.api.IntegrationAPI;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.runtime.QueryHandler;
import io.axoniq.axonserver.configuration.runtime.QueryHandlers;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.Action;
import io.axoniq.axonserver.grpc.internal.AppendEntryResponse;
import io.axoniq.axonserver.grpc.internal.HandlerLogMessage;
import io.axoniq.axonserver.integration.logconsumer.AdminQueryHandlerLogConsumer;
import io.axoniq.axonserver.licensing.LicenseConfiguration;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.transport.rest.v2.ValidationUtils;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@Tag(name="Integration Query Handlers", description="Operations to manage query handlers for integration endpoints")
public class IntegrationQueryHandlerRestControllerV2 {
    private final ObjectMapper C;
    private final RaftGroupServiceFactory j;
    private static final Logger m = AuditLog.getLogger();
    private final QueryHandlers c;

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Delete a query handler", description="Remove a query handler from a specific endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Query handler successfully deleted"), @ApiResponse(responseCode="400", description="Invalid input parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Query handler not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    @DeleteMapping(value={"v2/endpoints/{endpoint}/queryHandlers/{handler}"})
    public CompletableFuture<ResponseEntity<Object>> C(@PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @PathVariable(value="handler") @Schema(description="Handler UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = object;
        Object object = principal;
        IntegrationQueryHandlerRestControllerV2 principal2 = integrationQueryHandlerRestControllerV2;
        try {
            void a3;
            void handlerId;
            HandlerLogMessage endpoint;
            ValidationUtils.C((String)endpoint);
            ValidationUtils.C((String)handlerId);
            object = (Principal)ObjectUtils.C((Object)object, (Object)GrpcContextAuthenticationProvider.j);
            if (m.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)object.getName());
                objectArray[1] = StringUtils.sanitize((String)handlerId);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                m.info(MeterFactory.C((Object)"/!\t\u0007T\b\u0011+\u0001?\u0007.T.\u001bz\u0010?\u0018?\u0000?T+\u0001?\u0006#T2\u00154\u00106\u0011(T!\tz\u001d4T?\u001a>\u00045\u001d4\u0000z\u000f'Z"), objectArray);
            }
            endpoint = HandlerLogMessage.newBuilder().setId((String)handlerId).setContext((String)a3).setEndpointId((String)endpoint).setAction(Action.DELETE).build();
            return ((CompletableFuture)principal2.j.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminQueryHandlerLogConsumer.class.getSimpleName(), endpoint.toByteArray()).thenApply(a2 -> ValidationUtils.C())).exceptionally(ValidationUtils::C);
        }
        catch (MessagingPlatformException this2) {
            return CompletableFuture.completedFuture(ValidationUtils.C((Throwable)this2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public IntegrationQueryHandlerRestControllerV2(ObjectMapper objectMapper, QueryHandlers queryHandlers, RaftGroupServiceFactory raftGroupServiceFactory) {
        void a2;
        void a3;
        IntegrationQueryHandlerRestControllerV2 a4;
        IntegrationQueryHandlerRestControllerV2 a5 = raftGroupServiceFactory;
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = a4 = this;
        a4.C = a3;
        integrationQueryHandlerRestControllerV2.c = a2;
        integrationQueryHandlerRestControllerV2.j = a5;
    }

    private static /* synthetic */ ResponseEntity C(HttpServletRequest httpServletRequest, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = appendEntryResponse;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.C((HttpServletRequest)a3);
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Update a query handler", description="Update an existing query handler for a specific endpoint")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Update request accepted"), @ApiResponse(responseCode="400", description="Invalid input parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Query handler not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    @PutMapping(value={"v2/endpoints/{endpoint}/queryHandlers/{handler}"})
    public CompletableFuture<ResponseEntity<Object>> C(@RequestBody @Schema(description="Updated query handler details", requiredMode=Schema.RequiredMode.REQUIRED, implementation=IntegrationAPI.QueryHandler.class) IntegrationAPI.QueryHandler queryHandler, @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @PathVariable(value="handler") @Schema(description="Handler UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string2, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string3) {
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = object;
        Object object = queryHandler;
        IntegrationQueryHandlerRestControllerV2 queryHandler2 = integrationQueryHandlerRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void handlerId;
            void endpoint;
            ValidationUtils.C((String)endpoint);
            ValidationUtils.C((String)handlerId);
            IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV22 = object;
            ValidationUtils.C((String)integrationQueryHandlerRestControllerV22.name(), (String)MeterFactory.C((Object)"4\u00157\u0011"));
            ValidationUtils.C((String)object.name(), (int)200, (String)LicenseConfiguration.C((Object)"3;0?"));
            ValidationUtils.C((String)integrationQueryHandlerRestControllerV22.queryUrl(), (int)2000, (String)MeterFactory.C((Object)"+\u0001?\u0006#!(\u0018"));
            principal2 = (Principal)ObjectUtils.C((Object)principal2, (Object)GrpcContextAuthenticationProvider.j);
            if (m.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                m.info(LicenseConfiguration.C((Object)"\u0001&'\u0000z\u000f?,/8))z)5}/-><.8z,/8($z5;3>1?/z&'}33z849*233.}! t"), objectArray);
            }
            IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV23 = queryHandler2;
            object = integrationQueryHandlerRestControllerV23.C.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId((String)handlerId).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.UPDATE).build();
            return ((CompletableFuture)integrationQueryHandlerRestControllerV23.j.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminQueryHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationQueryHandlerRestControllerV2.C((HttpServletRequest)request, arg_0))).exceptionally(ValidationUtils::C);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.C((Throwable)principal2));
        }
    }

    private static /* synthetic */ ResponseEntity C(HttpServletRequest httpServletRequest, HandlerLogMessage handlerLogMessage, AppendEntryResponse appendEntryResponse) {
        HttpServletRequest a2 = handlerLogMessage;
        HttpServletRequest a3 = httpServletRequest;
        return ValidationUtils.C((HttpServletRequest)a3, (String)a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Register a query handler", description="Register a new query handler for a specific endpoint to handle incoming query requests")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Query handler successfully registered", content={@Content(schema=@Schema(implementation=IntegrationAPI.Id.class), mediaType="application/json")}), @ApiResponse(responseCode="400", description="Invalid input parameters", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="Endpoint not found", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    @PostMapping(value={"v2/endpoints/{endpoint}/queryHandlers"})
    public CompletableFuture<ResponseEntity<Object>> C(@RequestBody @Schema(description="Query handler details", requiredMode=Schema.RequiredMode.REQUIRED, implementation=IntegrationAPI.QueryHandler.class) IntegrationAPI.QueryHandler queryHandler, @PathVariable(value="endpoint") @Schema(description="Endpoint UUID", format="uuid", requiredMode=Schema.RequiredMode.REQUIRED) String string, @Parameter(hidden=true) Principal principal, @Parameter(hidden=true) HttpServletRequest httpServletRequest, @RequestParam(value="context") @Schema(description="Context name", example="default", requiredMode=Schema.RequiredMode.REQUIRED) String string2) {
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = object;
        Object object = queryHandler;
        IntegrationQueryHandlerRestControllerV2 queryHandler2 = integrationQueryHandlerRestControllerV2;
        try {
            void request;
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.C((String)endpoint);
            IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV22 = object;
            ValidationUtils.C((String)integrationQueryHandlerRestControllerV22.name(), (String)MeterFactory.C((Object)"4\u00157\u0011"));
            ValidationUtils.C((String)integrationQueryHandlerRestControllerV22.name(), (int)200, (String)LicenseConfiguration.C((Object)"3;0?"));
            ValidationUtils.C((String)integrationQueryHandlerRestControllerV22.queryUrl(), (int)2000, (String)MeterFactory.C((Object)"+\u0001?\u0006#!(\u0018"));
            principal2 = (Principal)ObjectUtils.C((Object)principal2, (Object)GrpcContextAuthenticationProvider.j);
            if (m.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object.name());
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                m.info(LicenseConfiguration.C((Object)"\u0001&'\u0000z\u000f?,/8))z)5}(8=4))?/z,/8($z5;3>1?/z&'}33z849*233.}! t"), objectArray);
            }
            IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV23 = queryHandler2;
            object = integrationQueryHandlerRestControllerV23.C.writeValueAsString(object);
            object = HandlerLogMessage.newBuilder().setId(UUID.randomUUID().toString()).setData((String)object).setContext((String)a2).setEndpointId((String)endpoint).setAction(Action.ADD).build();
            return ((CompletableFuture)integrationQueryHandlerRestControllerV23.j.getRaftGroupService(AdminUtils.getAdmin()).appendEntry(AdminUtils.getAdmin(), AdminQueryHandlerLogConsumer.class.getSimpleName(), object.toByteArray()).thenApply(arg_0 -> IntegrationQueryHandlerRestControllerV2.C((HttpServletRequest)request, (HandlerLogMessage)object, arg_0))).exceptionally(ValidationUtils::C);
        }
        catch (Exception principal2) {
            return CompletableFuture.completedFuture(ValidationUtils.C((Throwable)principal2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"v2/endpoints/{endpoint}/queryHandlers/{handler}"})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=IntegrationAPI.QueryHandler.class), mediaType="application/json")}), @ApiResponse(responseCode="400", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="404", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")}), @ApiResponse(responseCode="500", content={@Content(schema=@Schema(implementation=IntegrationAPI.ErrorResponse.class), mediaType="application/json")})})
    public ResponseEntity<Object> C(@PathVariable(value="endpoint") String string, @PathVariable(value="handler") String string2, @Parameter(hidden=true) Principal principal, @RequestParam(value="context") String string3) {
        IntegrationQueryHandlerRestControllerV2 integrationQueryHandlerRestControllerV2 = object;
        Object object = string2;
        IntegrationQueryHandlerRestControllerV2 handlerId = integrationQueryHandlerRestControllerV2;
        try {
            void a2;
            Principal principal2;
            void endpoint;
            ValidationUtils.C((String)endpoint);
            ValidationUtils.C((String)object);
            principal2 = (Principal)ObjectUtils.C((Object)principal2, (Object)GrpcContextAuthenticationProvider.j);
            if (m.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)principal2.getName());
                objectArray[1] = StringUtils.sanitize((String)object);
                objectArray[2] = StringUtils.sanitize((String)endpoint);
                m.info(LicenseConfiguration.C((Object)"\u0006! \u0007}\b8+(?..}.2z:?)z,/8($z5;3>1?/z&'}33z849*233.}! t"), objectArray);
            }
            if (!(object = (QueryHandler)handlerId.c.findById(UUID.fromString((String)object)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, MeterFactory.C((Object)"<;\u001a>\u0018?\u0006z\u001a5\u0000z\u00125\u00014\u0010")))).getEndpoint().getId().toString().equals(endpoint)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, MeterFactory.C((Object)"<;\u001a>\u0018?\u0006z\u001a5\u0000z\u00125\u00014\u0010z\u001d4T?\u001a>\u00045\u001d4\u0000"));
            }
            if (!object.getEndpoint().getContext().equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.HANDLER_NOT_FOUND, LicenseConfiguration.C((Object)"\u0015;3>1?/z35)z;5(49z44}924)?%."));
            }
            return ResponseEntity.ok((Object)new IntegrationAPI.QueryHandler(object.getName(), object.getQueryUrl()));
        }
        catch (MessagingPlatformException principal2) {
            return ValidationUtils.C((Throwable)principal2);
        }
    }
}

