/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.ui;

import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.TransactionWithTokenUtils;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.ui.ClusterUpdatesService;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;

@Service
public class ClusterUpdatesService {
    private final Logger j = LoggerFactory.getLogger(ClusterUpdatesService.class);
    private static final Logger m = AuditLog.getLogger();
    private final Sinks.Many<SimpleUpdate> c = Sinks.many().multicast().onBackpressureBuffer();

    @EventListener
    public void on(ContextEvents.ContextUpdatedInAdmin contextUpdatedInAdmin) {
        ClusterUpdatesService a2 = contextUpdatedInAdmin;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.j, a2.C(), SimpleUpdateState.C);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected applicationConnected) {
        ClusterUpdatesService a2 = applicationConnected;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.A, a2.M(), SimpleUpdateState.A);
    }

    @EventListener
    public void on(ContextEvents.ContextRegisteredInAdmin contextRegisteredInAdmin) {
        ClusterUpdatesService a2 = contextRegisteredInAdmin;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.j, a2.context(), SimpleUpdateState.j);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupDeleted replicationGroupDeleted) {
        ClusterUpdatesService a2 = replicationGroupDeleted;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.c, a2.replicationGroup(), SimpleUpdateState.c);
    }

    @EventListener
    public void on(ClusterEvents.BecomeLeader becomeLeader) {
        ClusterUpdatesService a2 = becomeLeader;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.m, a2.replicationGroup(), SimpleUpdateState.C);
    }

    public ClusterUpdatesService() {
        ClusterUpdatesService a2;
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated replicationGroupUpdated) {
        ClusterUpdatesService a2 = replicationGroupUpdated;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.c, a2.replicationGroup(), SimpleUpdateState.C);
    }

    private static /* synthetic */ void C(Authentication a2) {
        m.info(TransactionWithTokenUtils.C((Object)"\u0007\u0007!!|/)\u001e/\u001f.\u0015>\u00198\\(\u0013|\u001f3\u0012(\u0019$\b|\t,\u0018=\b9\u000fr"), (Object)AuditLog.username((String)a2.username()));
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceConnected axonServerInstanceConnected) {
        ClusterUpdatesService a2 = axonServerInstanceConnected;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.G, a2.getNodeName(), SimpleUpdateState.A);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeDeleted axonServerNodeDeleted) {
        ClusterUpdatesService a2 = axonServerNodeDeleted;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.B, a2.node(), SimpleUpdateState.c);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupCreated replicationGroupCreated) {
        ClusterUpdatesService a2 = replicationGroupCreated;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.c, a2.replicationGroup(), SimpleUpdateState.j);
    }

    @EventListener
    public void on(ContextEvents.ContextUnregisteredInAdmin contextUnregisteredInAdmin) {
        ClusterUpdatesService a2 = contextUnregisteredInAdmin;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.j, a2.context(), SimpleUpdateState.c);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void C(UpdateType updateType, String string, SimpleUpdateState simpleUpdateState) {
        void a2;
        void a3;
        ClusterUpdatesService a4 = simpleUpdateState;
        ClusterUpdatesService a5 = this;
        a5.c.emitNext((Object)new SimpleUpdate((UpdateType)a3, (String)a2 + ":" + a4.name()), (signalType, emitResult) -> {
            SignalType a2 = emitResult;
            SignalType a3 = signalType;
            if (a2 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceDisconnected axonServerInstanceDisconnected) {
        ClusterUpdatesService a2 = axonServerInstanceDisconnected;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.G, a2.getNodeName(), SimpleUpdateState.m);
    }

    public Flux<SimpleUpdate> subscribeToUpdates(@Nonnull Authentication authentication) {
        ClusterUpdatesService clusterUpdatesService = clusterUpdatesService2;
        ClusterUpdatesService clusterUpdatesService2 = authentication;
        ClusterUpdatesService a2 = clusterUpdatesService;
        return a2.c.asFlux().publish().autoConnect().doFirst(() -> ClusterUpdatesService.C((Authentication)clusterUpdatesService2));
    }

    @EventListener
    public void on(TopologyEvents.EndpointConnected endpointConnected) {
        ClusterUpdatesService a2 = endpointConnected;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.d, a2.C().toString(), SimpleUpdateState.A);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeConnected axonServerNodeConnected) {
        ClusterUpdatesService a2 = axonServerNodeConnected;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.B, a2.getNodeInfo().getHostName(), SimpleUpdateState.A);
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation leaderConfirmation) {
        ClusterUpdatesService a2 = leaderConfirmation;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.m, a2.replicationGroup(), SimpleUpdateState.C);
    }

    @EventListener
    public void on(TopologyEvents.EndpointDisconnected endpointDisconnected) {
        ClusterUpdatesService a2 = endpointDisconnected;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.d, a2.C().toString(), SimpleUpdateState.m);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        ClusterUpdatesService a2 = applicationDisconnected;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.A, a2.g(), SimpleUpdateState.m);
    }

    @EventListener
    public void on(ClusterEvents.LeaderStepDown leaderStepDown) {
        ClusterUpdatesService a2 = leaderStepDown;
        ClusterUpdatesService a3 = this;
        a3.C(UpdateType.m, a2.replicationGroup(), SimpleUpdateState.C);
    }
}

