/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.cli;

import io.axoniq.cli.AxonIQCliUtil;
import io.axoniq.cli.CommandOptions;
import io.axoniq.tools.ToolResult;
import io.axoniq.tools.http.NodeTool;
import io.axoniq.tools.http.json.ClusterNode;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;

public class RegisterNode {
    private RegisterNode() {
    }

    public static void run(String[] args) throws Throwable {
        Number port;
        CommandLine commandLine = AxonIQCliUtil.processCommandLine((String)args[0], (String[])args, (Option[])new Option[]{CommandOptions.INTERNALHOST, CommandOptions.INTERNALPORT, CommandOptions.CONTEXT_TO_REGISTER_IN, CommandOptions.DONT_REGISTER_IN_CONTEXTS, CommandOptions.TOKEN});
        try {
            port = (Number)commandLine.getParsedOptionValue(CommandOptions.INTERNALPORT.getOpt());
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid value for option " + CommandOptions.INTERNALPORT);
        }
        if (port == null) {
            port = 8224;
        }
        if (commandLine.hasOption(CommandOptions.DONT_REGISTER_IN_CONTEXTS.getLongOpt()) && (commandLine.hasOption(CommandOptions.CONTEXT_TO_REGISTER_IN.getOpt()) || commandLine.hasOption(CommandOptions.CONTEXT_TO_REGISTER_IN.getLongOpt()))) {
            throw new RuntimeException("Cannot specify a context when also using \"" + CommandOptions.DONT_REGISTER_IN_CONTEXTS.getLongOpt() + "\"");
        }
        ClusterNode clusterNode = new ClusterNode(commandLine.getOptionValue(CommandOptions.INTERNALHOST.getOpt().charAt(0)), Integer.valueOf(port.intValue()));
        if (commandLine.hasOption(CommandOptions.CONTEXT_TO_REGISTER_IN.getOpt())) {
            String context = commandLine.getOptionValue(CommandOptions.CONTEXT_TO_REGISTER_IN.getOpt());
            if (!context.isEmpty()) {
                clusterNode.setContext(context);
            }
        } else if (commandLine.hasOption(CommandOptions.DONT_REGISTER_IN_CONTEXTS.getLongOpt())) {
            clusterNode.setNoContexts(Boolean.valueOf(true));
        }
        String serverHttpAddress = AxonIQCliUtil.getServerHttpAddress((CommandLine)commandLine);
        boolean connectInsecure = AxonIQCliUtil.getConnectInsecure((CommandLine)commandLine);
        String token = AxonIQCliUtil.getToken((CommandLine)commandLine);
        ToolResult result = NodeTool.registerNode((ClusterNode)clusterNode, (String)serverHttpAddress, (boolean)connectInsecure, (String)token);
        if (result.isFailure()) {
            throw result.getFailure();
        }
    }
}

