/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.component.processor.ProcessorEventPublisher;
import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.EventTransformationConfiguration;
import io.axoniq.axonserver.config.ReplicationGroupConfiguration;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.replication.ServerProperties;
import io.axoniq.axonserver.util.StringUtils;
import jakarta.annotation.PostConstruct;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

@Configuration
@ConfigurationProperties(prefix="axoniq.axonserver")
public class MessagingPlatformConfiguration
implements ServerProperties {
    private static final Logger logger = LoggerFactory.getLogger(MessagingPlatformConfiguration.class);
    private int httpPort;
    private String webSocketAllowedOrigins;
    private Duration keepAliveTimeout;
    private int maxMessageSize;
    private String pluginCleanPolicy;
    private static final Logger auditLog = AuditLog.getLogger();
    private int clusterExecutorThreadCount;
    private boolean setWebSocketAllowedOrigins;
    private static final int RESERVED = 10000;
    @Value(value="${spring.datasource.url:#{null}}")
    private String datasourceUrl;
    private String pluginPackageDirectory;
    private String name;
    private Duration metricsInterval;
    @NestedConfigurationProperty
    private SslConfiguration ssl;
    private int grpcBufferedMessages;
    private Duration minKeepAliveTime;
    @NestedConfigurationProperty
    private AccessControlConfiguration accesscontrol;
    private String pluginCacheDirectory;
    private int executorThreadCount;
    private int eventStoreBackgroundThreadCount;
    private int internalPort;
    public static final int DEFAULT_INTERNAL_GRPC_PORT = 8224;
    private String controldbBackupLocation;
    private String pidFileLocation;
    private int metricsSynchronizationRate;
    private String domain;
    private String internalHostname;
    private final SystemInfoProvider systemInfoProvider;
    private String hostname;
    private int eventStoreProcessorsThreadCount;
    private final Map<String, Boolean> preview;
    private static final int DEFAULT_MAX_TRANSACTION_SIZE = 4184304;
    private int port;
    private String internalDomain;
    private boolean forceConnectionToPrimaryOrMessagingNode;
    private boolean pluginsEnabled;
    private Duration keepAliveTime;
    @NestedConfigurationProperty
    private EventTransformationConfiguration eventTransformation;

    public Map<String, Boolean> getPreview() {
        MessagingPlatformConfiguration a2;
        return a2.preview;
    }

    public String getPidFileLocation() {
        MessagingPlatformConfiguration a2;
        return a2.pidFileLocation;
    }

    public void setMinKeepAliveTime(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.minKeepAliveTime = a2;
    }

    public boolean isPluginsEnabled() {
        MessagingPlatformConfiguration a2;
        return a2.pluginsEnabled;
    }

    public int getPort() {
        MessagingPlatformConfiguration a2;
        return a2.port;
    }

    public void setKeepAliveTime(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.keepAliveTime = a2;
    }

    public void setEventStoreBackgroundThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.eventStoreBackgroundThreadCount = a2;
    }

    public void setHostname(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.hostname = a2;
    }

    public void setGrpcBufferedMessages(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.grpcBufferedMessages = a2;
    }

    public void setPluginsEnabled(boolean bl) {
        boolean a2 = bl;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginsEnabled = a2;
    }

    public String getWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a2;
        return a2.webSocketAllowedOrigins;
    }

    public void setPidFileLocation(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pidFileLocation = a2;
    }

    public int getMaxTransactionSize() {
        MessagingPlatformConfiguration a2;
        if (a2.maxMessageSize == 0) {
            return 4184304;
        }
        return a2.maxMessageSize - 10000;
    }

    public int getInternalPort() {
        MessagingPlatformConfiguration a2;
        return a2.internalPort;
    }

    public void setClusterExecutorThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.clusterExecutorThreadCount = a2;
    }

    public String getPluginPackageDirectory() {
        MessagingPlatformConfiguration a2;
        return a2.pluginPackageDirectory;
    }

    public void setPluginCleanPolicy(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginCleanPolicy = a2;
    }

    public void setMetricsSynchronizationRate(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.metricsSynchronizationRate = a2;
    }

    public void setInternalPort(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.internalPort = a2;
    }

    public int getClusterExecutorThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.clusterExecutorThreadCount;
    }

    public void setEventStoreProcessorsThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.eventStoreProcessorsThreadCount = a2;
    }

    public int getEventStoreProcessorsThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.eventStoreProcessorsThreadCount;
    }

    public String getName() {
        MessagingPlatformConfiguration a2;
        if (a2.name == null) {
            a2.name = a2.getHostname();
        }
        return a2.name;
    }

    public void setAccesscontrol(AccessControlConfiguration accessControlConfiguration) {
        MessagingPlatformConfiguration a2;
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a3;
            block1: {
                block2: {
                    a2 = accessControlConfiguration;
                    a3 = this;
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a2 != null) break block2;
                    if (a3.accesscontrol == null) break block1;
                    auditLog.info(ProcessorEventPublisher.H((Object)"[[y]iK:[uVnJuT:[uV|Q}MhYnQuV:j_uUn_|4"));
                    messagingPlatformConfiguration = a3;
                    break block3;
                }
                if (a3.accesscontrol == null || a2.isEnabled() != a3.accesscontrol.isEnabled()) {
                    auditLog.info(ReplicationGroupConfiguration.H((Object)"\u0004\u001a&\u001c6\ne\u001a*\u00171\u000b*\u0015e\u00106Y+\u00162Y>\u0004k"), (Object)AuditLog.enablement((boolean)a2.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a3;
        }
        messagingPlatformConfiguration.accesscontrol = a2;
    }

    public EventTransformationConfiguration getEventTransformation() {
        MessagingPlatformConfiguration a2;
        return a2.eventTransformation;
    }

    public void setName(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.name = a2;
    }

    public void setSsl(SslConfiguration sslConfiguration) {
        MessagingPlatformConfiguration a2;
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a3;
            block1: {
                block2: {
                    a2 = sslConfiguration;
                    a3 = this;
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a2 != null) break block2;
                    if (a3.ssl == null) break block1;
                    auditLog.info(ProcessorEventPublisher.H((Object)"kIt:[uV|Q}MhYnQuV:j_uUn_|4"));
                    messagingPlatformConfiguration = a3;
                    break block3;
                }
                if (a3.ssl == null || a2.isEnabled() != a3.ssl.isEnabled()) {
                    auditLog.info(ReplicationGroupConfiguration.H((Object)"*\u00165e\u00106Y+\u00162Y>\u0004k"), (Object)AuditLog.enablement((boolean)a2.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a3;
        }
        messagingPlatformConfiguration.ssl = a2;
    }

    public String getHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        if (StringUtils.isEmpty((String)messagingPlatformConfiguration.hostname)) {
            try {
                MessagingPlatformConfiguration messagingPlatformConfiguration2 = messagingPlatformConfiguration;
                messagingPlatformConfiguration2.hostname = messagingPlatformConfiguration2.systemInfoProvider.getHostName();
                if (!StringUtils.isEmpty((String)messagingPlatformConfiguration2.domain)) {
                    MessagingPlatformConfiguration messagingPlatformConfiguration3 = messagingPlatformConfiguration;
                    if (messagingPlatformConfiguration3.hostname.endsWith("." + messagingPlatformConfiguration3.domain)) {
                        messagingPlatformConfiguration.hostname = messagingPlatformConfiguration.hostname.substring(0, messagingPlatformConfiguration.hostname.length() - messagingPlatformConfiguration.domain.length() - 1);
                    }
                }
            }
            catch (UnknownHostException a2) {
                logger.warn(ProcessorEventPublisher.H((Object)"{uMv\\:VuL:\\\u007fL\u007fJwQt]:PuKnV{U\u007f\u0018|JuU:Qt]n\u0018{\\~J\u007fKi\u0002:Cg"), (Object)a2.getMessage());
            }
        }
        return messagingPlatformConfiguration.hostname;
    }

    public void setPort(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.port = a2;
    }

    public int getHttpPort() {
        MessagingPlatformConfiguration a2;
        if (a2.httpPort == 0) {
            a2.httpPort = a2.systemInfoProvider.getPort();
        }
        return a2.httpPort;
    }

    public void setExecutorThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.executorThreadCount = a2;
    }

    public long getMinKeepAliveTime() {
        MessagingPlatformConfiguration a2;
        return a2.minKeepAliveTime.toMillis();
    }

    public AccessControlConfiguration getAccesscontrol() {
        MessagingPlatformConfiguration a2;
        return a2.accesscontrol;
    }

    public MessagingPlatformConfiguration(SystemInfoProvider systemInfoProvider) {
        MessagingPlatformConfiguration a2;
        MessagingPlatformConfiguration a3 = systemInfoProvider;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a2 = this;
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration3 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration4 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration5 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration6 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration7 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration8 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration9 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration10 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration11 = a2;
        a2.port = 8124;
        messagingPlatformConfiguration11.internalPort = 8224;
        messagingPlatformConfiguration11.keepAliveTimeout = Duration.ofMillis(5000L);
        messagingPlatformConfiguration10.keepAliveTime = Duration.ofMillis(2500L);
        messagingPlatformConfiguration10.minKeepAliveTime = Duration.ofMillis(1000L);
        messagingPlatformConfiguration9.setWebSocketAllowedOrigins = false;
        messagingPlatformConfiguration9.webSocketAllowedOrigins = "*";
        MessagingPlatformConfiguration messagingPlatformConfiguration12 = a2;
        messagingPlatformConfiguration9.ssl = new SslConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration13 = a2;
        messagingPlatformConfiguration8.accesscontrol = new AccessControlConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration14 = a2;
        messagingPlatformConfiguration8.eventTransformation = new EventTransformationConfiguration();
        messagingPlatformConfiguration8.forceConnectionToPrimaryOrMessagingNode = true;
        messagingPlatformConfiguration7.metricsInterval = Duration.ofMinutes(15L);
        messagingPlatformConfiguration7.controldbBackupLocation = ".";
        messagingPlatformConfiguration6.maxMessageSize = 0x400000;
        messagingPlatformConfiguration6.pidFileLocation = ".";
        messagingPlatformConfiguration5.grpcBufferedMessages = 500;
        messagingPlatformConfiguration5.executorThreadCount = 4;
        messagingPlatformConfiguration4.clusterExecutorThreadCount = 4;
        messagingPlatformConfiguration4.eventStoreBackgroundThreadCount = 8;
        messagingPlatformConfiguration3.eventStoreProcessorsThreadCount = 8;
        messagingPlatformConfiguration3.pluginsEnabled = true;
        messagingPlatformConfiguration2.pluginCacheDirectory = "plugins/cache";
        messagingPlatformConfiguration2.pluginPackageDirectory = "plugins/bundles";
        messagingPlatformConfiguration.pluginCleanPolicy = "onFirstInit";
        MessagingPlatformConfiguration messagingPlatformConfiguration15 = a2;
        messagingPlatformConfiguration.preview = new HashMap();
        messagingPlatformConfiguration.systemInfoProvider = a3;
    }

    public String getInternalHostname() {
        MessagingPlatformConfiguration a2;
        if (StringUtils.isEmpty((String)a2.internalHostname)) {
            a2.internalHostname = a2.getHostname();
        }
        return a2.internalHostname;
    }

    public Duration getMetricsInterval() {
        MessagingPlatformConfiguration a2;
        return a2.metricsInterval;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, String string2, boolean bl, BiConsumer<String, String> biConsumer) {
        void a2;
        boolean a3 = bl;
        MessagingPlatformConfiguration a4 = this;
        String string3 = a3 = a3 ? ReplicationGroupConfiguration.H((Object)",\u00171\u001c7\u0017$\u0015e") : "";
        if (StringUtils.isEmpty((String)a2)) {
            logger.error(ProcessorEventPublisher.H((Object)"YWoT~\u0018tWn\u0018~]n]hUsV\u007f\u0018{\u0018lYvQ~\u0018aErWiLtYw]4"), (Object)a3);
            throw new MessagingPlatformException(ErrorCode.VALIDATION_FAILED, "No " + a3 + "hostname set and system could not provide one.");
        }
        if (Character.isDigit(a2.charAt(0))) {
            logger.warn(ReplicationGroupConfiguration.H((Object)"--\u001ce\u00028\u0011*\n1\u0017$\u0014 Y-\u00186Y'\u001c \u0017e\n \re\u00186Y$\u0017e0\u0015Y$\u001d!\u000b \n6We--\u00106Y(\u0018<Y5\u000b*\u001d0\u001a Y0\u00172\u0018+\r \u001de\u000b \n0\u00151\nk"), (Object)a3);
            return;
        }
        int n = a2.indexOf(46);
        if (n != -1) {
            void a5;
            void a6;
            void v1 = a2;
            String string4 = v1.substring(0, n);
            String string5 = v1.substring(n + 1);
            if (StringUtils.isEmpty((String)a6)) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a3;
                objectArray[1] = string4;
                objectArray[2] = string5;
                logger.info(ProcessorEventPublisher.H((Object)"YWt^s_oJsV}\u0018~WwYsV:^hWw\u0018aErWiLtYw]:HhWj]hLc\u0002:PuKnV{U\u007f\u0005aE6\u0018~WwYsV'Cg"), objectArray);
                a5.accept(string4, string5);
                return;
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = a3;
            objectArray[1] = a2;
            objectArray[2] = string4;
            objectArray[3] = a6;
            logger.warn(ReplicationGroupConfiguration.H((Object)"\f\u001e+\u00167\u0010+\u001ee\u001d*\u0014$\u0010+Y5\u00187\re\u0016#Y1\u0011 Y>\u0004-\u00166\r+\u0018(\u001ce^>\u0004bCe\u0011*\n1\u0017$\u0014 D>\u0004iY!\u0016(\u0018,\u0017x\u00028"), objectArray);
            a5.accept(string4, a6);
        }
    }

    public String getInternalDomain() {
        MessagingPlatformConfiguration a2;
        if (a2.internalDomain == null) {
            a2.internalDomain = a2.getDomain();
        }
        return a2.internalDomain;
    }

    public long getKeepAliveTimeout() {
        MessagingPlatformConfiguration a2;
        return a2.keepAliveTimeout.toMillis();
    }

    public String getFullyQualifiedInternalHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        Object a2 = messagingPlatformConfiguration.getInternalDomain();
        if (!StringUtils.isEmpty((String)a2)) {
            return messagingPlatformConfiguration.getInternalHostname() + "." + (String)a2;
        }
        return messagingPlatformConfiguration.getInternalHostname();
    }

    public void setInternalHostname(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.internalHostname = a2;
    }

    public String getPluginCacheDirectory() {
        MessagingPlatformConfiguration a2;
        return a2.pluginCacheDirectory;
    }

    public String getPluginCleanPolicy() {
        MessagingPlatformConfiguration a2;
        return a2.pluginCleanPolicy;
    }

    private /* synthetic */ void G() {
        MessagingPlatformConfiguration a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a2;
        messagingPlatformConfiguration.H(a2.getHostname(), messagingPlatformConfiguration.getDomain(), false, (string, string2) -> {
            void a2;
            MessagingPlatformConfiguration a3;
            Object a4 = string2;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a3 = this;
            messagingPlatformConfiguration.setHostname((String)a2);
            messagingPlatformConfiguration.setDomain((String)a4);
        });
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a2;
        messagingPlatformConfiguration2.H(a2.getInternalHostname(), messagingPlatformConfiguration2.getInternalDomain(), true, (string, string2) -> {
            void a2;
            MessagingPlatformConfiguration a3;
            Object a4 = string2;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a3 = this;
            messagingPlatformConfiguration.setInternalHostname((String)a2);
            messagingPlatformConfiguration.setInternalDomain((String)a4);
        });
    }

    public void setMetricsInterval(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.metricsInterval = a2;
    }

    public SslConfiguration getSsl() {
        MessagingPlatformConfiguration a2;
        return a2.ssl;
    }

    public int getEventStoreBackgroundThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.eventStoreBackgroundThreadCount;
    }

    public void setControldbBackupLocation(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.controldbBackupLocation = a2;
    }

    public void setWebSocketAllowedOrigins(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.webSocketAllowedOrigins = a2;
    }

    public boolean isSetWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a2;
        return a2.setWebSocketAllowedOrigins;
    }

    private /* synthetic */ void E() {
        MessagingPlatformConfiguration a2;
        if (a2.datasourceUrl != null && !a2.datasourceUrl.contains(ReplicationGroupConfiguration.H((Object)"\u007f\u0014 \u0014\u007f")) && !a2.datasourceUrl.contains(ProcessorEventPublisher.H((Object)"{@uVi]hN\u007fJ7[uV|Q}\\x"))) {
            throw new FailedToStartException(ReplicationGroupConfiguration.H((Object)"\u0011\u0011 Y!\u00181\u0018'\u00186\u001ce\u0017$\u0014 Y#\u00167Y\u0004\u0001*\u0017e* \u000b3\u001c7Y(\f6\re\u001b Yb\u0018=\u0016+\n \u000b3\u001c7T&\u0016+\u001f,\u001e!\u001bbWe0#Y<\u00160Y$\u000b Y(\u0010\"\u000b$\r,\u0017\"Y#\u000b*\u0014e\u0018+Y*\u0015!\u001c7Y3\u001c7\n,\u0016+Y \u00176\f7\u001ce\r-\u00181Y1\u0011 Y\u0006\u0016+\r7\u0016)Y\u0001;e\u00106Y,\u0017e^$\u0001*\u00176\u001c7\u000f \u000bh\u001a*\u00171\u000b*\u0015!\u001bbY$\u0017!Y0\t!\u00181\u001ce\r-\u001ce\n5\u000b,\u0017\"W!\u00181\u00186\u00160\u000b&\u001ck\f7\u0015e\t7\u00165\u001c7\r<Y1\u0016e\f6\u001ce\u001d$\r$\u001b$\n Y+\u0018(\u001ce^$\u0001*\u00176\u001c7\u000f \u000bh\u001a*\u0017#\u0010\"\u001d'^k"));
        }
    }

    public boolean isForceConnectionToPrimaryOrMessagingNode() {
        MessagingPlatformConfiguration a2;
        return a2.forceConnectionToPrimaryOrMessagingNode;
    }

    public void setSetWebSocketAllowedOrigins(boolean bl) {
        boolean a2 = bl;
        MessagingPlatformConfiguration a3 = this;
        a3.setWebSocketAllowedOrigins = a2;
    }

    public void setKeepAliveTimeout(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.keepAliveTimeout = a2;
    }

    public int getExecutorThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.executorThreadCount;
    }

    public String getControldbBackupLocation() {
        MessagingPlatformConfiguration a2;
        return a2.controldbBackupLocation;
    }

    public String getDomain() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        if (messagingPlatformConfiguration.domain == null) {
            block4: {
                String a2 = messagingPlatformConfiguration.systemInfoProvider.getHostName();
                int n = a2.indexOf(46);
                if (n == -1) break block4;
                messagingPlatformConfiguration.domain = a2.substring(n + 1);
            }
            try {
                messagingPlatformConfiguration.domain = "";
            }
            catch (UnknownHostException a2) {
                logger.warn(ReplicationGroupConfiguration.H((Object)":*\f)\u001de\u0017*\re\u001d \r \u000b(\u0010+\u001ce\u0011*\n1\u0017$\u0014 Y#\u000b*\u0014e\u0010+\u001c1Y$\u001d!\u000b \n6Ce\u00028"), (Object)a2.getMessage());
            }
        }
        return messagingPlatformConfiguration.domain;
    }

    public int getMaxMessageSize() {
        MessagingPlatformConfiguration a2;
        return a2.maxMessageSize;
    }

    private /* synthetic */ void H() {
        if (auditLog.isInfoEnabled()) {
            MessagingPlatformConfiguration a2;
            a2.preview.forEach((string, bl) -> {
                Boolean a2 = bl;
                String a3 = string;
                if (Boolean.TRUE.equals(a2)) {
                    auditLog.info(ProcessorEventPublisher.H((Object)"hh]lQ\u007fO:W|\u0018|]{LoJ\u007f\u0018aE:]tYxT\u007f\\4"), (Object)a3);
                }
            });
            auditLog.info(ProcessorEventPublisher.H((Object)"{uV|Q}MhYnQuV:QtQnQ{TsB\u007f\\:OsLr\u0018IkV\u0018aE:Yt\\:Yy[\u007fKi\u0018yWtLhWv\u0018aE4"), (Object)AuditLog.enablement((boolean)a2.ssl.isEnabled()), (Object)AuditLog.enablement((boolean)a2.accesscontrol.isEnabled()));
        }
    }

    public String getFullyQualifiedHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        Object a2 = messagingPlatformConfiguration.getDomain();
        if (!StringUtils.isEmpty((String)a2)) {
            return messagingPlatformConfiguration.getHostname() + "." + (String)a2;
        }
        return messagingPlatformConfiguration.getHostname();
    }

    public void setDomain(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.domain = a2;
    }

    public void setMaxMessageSize(DataSize dataSize) {
        MessagingPlatformConfiguration a2 = dataSize;
        MessagingPlatformConfiguration a3 = this;
        Assert.isTrue((a2.toBytes() >= 0L ? 1 : 0) != 0, (String)ProcessorEventPublisher.H((Object)"WYb\u0018w]iK{_\u007f\u0018iQ`]:UoKn\u0018x]:_h]{L\u007fJ:LrYt\u0018*"));
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)ReplicationGroupConfiguration.H((Object)"\b\u0018=Y(\u001c6\n$\u001e Y6\u0010?\u001ce\u00140\n1Y'\u001ce\u0015 \n6Y1\u0011$\u0017eKtMrM}JsMr"));
        a3.maxMessageSize = (int)a2.toBytes();
    }

    public void setPluginCacheDirectory(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginCacheDirectory = a2;
    }

    public void setPluginPackageDirectory(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginPackageDirectory = a2;
    }

    @PostConstruct
    public void postConstruct() {
        MessagingPlatformConfiguration a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a2;
        messagingPlatformConfiguration.H();
        messagingPlatformConfiguration.G();
        messagingPlatformConfiguration.E();
    }

    public int getGrpcBufferedMessages() {
        MessagingPlatformConfiguration a2;
        return a2.grpcBufferedMessages;
    }

    public void setEventTransformation(EventTransformationConfiguration eventTransformationConfiguration) {
        MessagingPlatformConfiguration a2 = eventTransformationConfiguration;
        MessagingPlatformConfiguration a3 = this;
        a3.eventTransformation = a2;
    }

    public long getKeepAliveTime() {
        MessagingPlatformConfiguration a2;
        return a2.keepAliveTime.toMillis();
    }

    public boolean isExperimentalFeatureEnabled(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        return a3.preview.getOrDefault(a2, false);
    }

    public void setForceConnectionToPrimaryOrMessagingNode(boolean bl) {
        boolean a2 = bl;
        MessagingPlatformConfiguration a3 = this;
        a3.forceConnectionToPrimaryOrMessagingNode = a2;
    }

    public void setInternalDomain(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.internalDomain = a2;
    }
}

