/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.cluster.replication.file.StorageProperties;
import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.localstorage.file.EmbeddedDBProperties;
import io.axoniq.axonserver.util.ObjectUtils;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="axoniq.axonserver.replication")
@Configuration
public class RaftProperties
extends StorageProperties {
    private int logRetentionHours;
    private int maxEntriesPerBatch;
    private int snapshotFlowBuffer;
    private boolean forceSnapshotOnJoin;
    private int heartbeatTimeout;
    private int minElectionTimeout;
    private final SystemInfoProvider systemInfoProvider;
    private boolean logCompactionEnabled;
    private int maxReplicationRound;
    private int waitForLeaderTimeout;
    private int initialElectionTimeout;
    private int maxElectionTimeout;
    private int maxSnapshotChunksPerBatch;
    private int flowBuffer;

    public void setLogRetentionHours(int n) {
        int a2 = n;
        RaftProperties a3 = this;
        a3.logRetentionHours = Math.max(a2, 1);
    }

    public void setFlowBuffer(int n) {
        int a2 = n;
        RaftProperties a3 = this;
        a3.flowBuffer = a2;
    }

    public int getFlowBuffer() {
        RaftProperties a2;
        return a2.flowBuffer;
    }

    public void setMaxElectionTimeout(Duration duration) {
        Duration a2 = duration;
        RaftProperties a3 = this;
        a3.maxElectionTimeout = (int)a2.toMillis();
    }

    public int getMaxReplicationRound() {
        RaftProperties a2;
        return a2.maxReplicationRound;
    }

    @PostConstruct
    public void validate() {
        RaftProperties a2;
        RaftProperties raftProperties = a2;
        Assert.isTrue((raftProperties.maxElectionTimeout > raftProperties.minElectionTimeout ? 1 : 0) != 0, (String)EmbeddedDBProperties.H((Object)"\u0000q50(|(s9y\"~md$}(\u007f8dm}8c90/umw?u,d(bmd%q#0 y#0(|(s9y\"~md$}(\u007f8d"));
    }

    public int getMaxElectionTimeout() {
        RaftProperties a2;
        return a2.maxElectionTimeout;
    }

    public int getMaxEntriesPerBatch() {
        RaftProperties a2;
        return a2.maxEntriesPerBatch;
    }

    public int getMinElectionTimeout() {
        RaftProperties a2;
        return a2.minElectionTimeout;
    }

    public void setMinElectionTimeout(Duration duration) {
        Duration a2 = duration;
        RaftProperties a3 = this;
        a3.minElectionTimeout = (int)a2.toMillis();
    }

    public int getWaitForLeaderTimeout() {
        RaftProperties a2;
        if (a2.waitForLeaderTimeout == -1) {
            a2.waitForLeaderTimeout = a2.maxElectionTimeout;
        }
        return a2.waitForLeaderTimeout;
    }

    public void setWaitForLeaderTimeout(int n) {
        int a2 = n;
        RaftProperties a3 = this;
        a3.waitForLeaderTimeout = a2;
    }

    public int getSnapshotFlowBuffer() {
        RaftProperties a2;
        return a2.snapshotFlowBuffer;
    }

    public boolean isUseMmapIndex() {
        RaftProperties a2;
        return (Boolean)ObjectUtils.H((Object)a2.useMmapIndex, (Object)true);
    }

    public void setHeartbeatTimeout(Duration duration) {
        Duration a2 = duration;
        RaftProperties a3 = this;
        a3.heartbeatTimeout = (int)a2.toMillis();
    }

    public void setForceSnapshotOnJoin(boolean bl) {
        boolean a2 = bl;
        RaftProperties a3 = this;
        a3.forceSnapshotOnJoin = a2;
    }

    public void setSnapshotFlowBuffer(int n) {
        int a2 = n;
        RaftProperties a3 = this;
        a3.snapshotFlowBuffer = a2;
    }

    public int getMaxSnapshotChunksPerBatch() {
        RaftProperties a2;
        return a2.maxSnapshotChunksPerBatch;
    }

    public RaftProperties(SystemInfoProvider systemInfoProvider) {
        RaftProperties a2;
        RaftProperties a3 = systemInfoProvider;
        RaftProperties raftProperties = a2 = this;
        RaftProperties raftProperties2 = a2;
        RaftProperties raftProperties3 = a2;
        RaftProperties raftProperties4 = a2;
        RaftProperties raftProperties5 = a2;
        RaftProperties raftProperties6 = a2;
        RaftProperties raftProperties7 = a2;
        raftProperties7.initialElectionTimeout = 0;
        raftProperties7.minElectionTimeout = 1000;
        raftProperties6.maxElectionTimeout = 2500;
        raftProperties6.heartbeatTimeout = 300;
        raftProperties5.maxEntriesPerBatch = 10;
        raftProperties5.flowBuffer = 1000;
        raftProperties4.snapshotFlowBuffer = 50;
        raftProperties4.maxSnapshotChunksPerBatch = 1000;
        raftProperties3.maxReplicationRound = 10;
        raftProperties3.logCompactionEnabled = true;
        raftProperties2.logRetentionHours = 1;
        raftProperties2.forceSnapshotOnJoin = true;
        raftProperties.waitForLeaderTimeout = -1;
        raftProperties.systemInfoProvider = a3;
    }

    public int getInitialElectionTimeout() {
        RaftProperties a2;
        return a2.initialElectionTimeout;
    }

    public void setInitialElectionTimeout(Duration duration) {
        Duration a2 = duration;
        RaftProperties a3 = this;
        a3.initialElectionTimeout = (int)a2.toMillis();
    }

    public void setLogCompactionEnabled(boolean bl) {
        boolean a2 = bl;
        RaftProperties a3 = this;
        a3.logCompactionEnabled = a2;
    }

    public int getLogRetentionHours() {
        RaftProperties a2;
        return a2.logRetentionHours;
    }

    public boolean isLogCompactionEnabled() {
        RaftProperties a2;
        return a2.logCompactionEnabled;
    }

    public boolean isForceCleanMmapIndex() {
        RaftProperties a2;
        if (a2.forceCleanMmapIndex != null) {
            return a2.forceCleanMmapIndex;
        }
        return a2.systemInfoProvider.javaOnWindows();
    }

    public void setMaxReplicationRound(int n) {
        int a2 = n;
        RaftProperties a3 = this;
        a3.maxReplicationRound = a2;
    }

    public void setMaxEntriesPerBatch(int n) {
        int a2 = n;
        RaftProperties a3 = this;
        a3.maxEntriesPerBatch = a2;
    }

    public boolean isForceSnapshotOnJoin() {
        RaftProperties a2;
        return a2.forceSnapshotOnJoin;
    }

    public int getHeartbeatTimeout() {
        RaftProperties a2;
        return a2.heartbeatTimeout;
    }

    public void setMaxSnapshotChunksPerBatch(int n) {
        int a2 = n;
        RaftProperties a3 = this;
        a3.maxSnapshotChunksPerBatch = a2;
    }
}

