/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.admin.user.requestprocessor.UserController;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.tags.ClientTagsCache;
import io.axoniq.axonserver.enterprise.cluster.NodeAllowsConnectionCheck;
import io.axoniq.axonserver.enterprise.cluster.NodeSelector;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.ReadyForConnections;
import io.axoniq.axonserver.grpc.PlatformService;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AutoRebalancing {
    private final PlatformService B;
    private final NodeSelector e;
    private final NavigableSet<PlatformService.ClientComponent> A;
    private final ClientTagsCache h;
    private final boolean L;
    private final Logger G;

    /*
     * WARNING - void declaration
     */
    public AutoRebalancing(PlatformService platformService, ClientTagsCache clientTagsCache, NodeSelector nodeSelector, @Value(value="${axoniq.axonserver.cluster.auto-balancing:true}") boolean bl) {
        void nodeSelector2;
        void clientsTags;
        void platformService2;
        AutoRebalancing a2;
        boolean bl2 = bl;
        AutoRebalancing autoRebalancing = a2 = this;
        AutoRebalancing autoRebalancing2 = a2;
        a2.G = LoggerFactory.getLogger(AutoRebalancing.class);
        AutoRebalancing autoRebalancing3 = a2;
        a2.A = new ConcurrentSkipListSet();
        autoRebalancing2.B = platformService2;
        autoRebalancing2.h = clientsTags;
        autoRebalancing.e = nodeSelector2;
        autoRebalancing.L = this;
    }

    @EventListener
    public void on(ReadyForConnections readyForConnections) {
        AutoRebalancing a2 = readyForConnections;
        AutoRebalancing a3 = this;
        if (a2.ready()) {
            AutoRebalancing autoRebalancing = a3;
            autoRebalancing.A.clear();
            autoRebalancing.A.addAll(a3.B.getConnectedClients());
        }
    }

    private /* synthetic */ Map<String, String> H(String string, String string2) {
        Object a2 = string2;
        AutoRebalancing a3 = this;
        return a3.h.apply((String)a2);
    }

    private /* synthetic */ void H(PlatformService.ClientComponent clientComponent) {
        AutoRebalancing a2;
        AutoRebalancing a3 = clientComponent;
        AutoRebalancing autoRebalancing = a2 = this;
        autoRebalancing.G.info(NodeAllowsConnectionCheck.H((Object)"j?I/])L3V=\u0018(]9W4V?[.\u0018<W(\u0018!E"), (Object)a3.getClientStreamId());
        autoRebalancing.B.requestReconnect((PlatformService.ClientComponent)a3, UserController.H((Object)"dwu}x|sqb2dwggsabwr2tk6scfy2tszsxq\u007f|q"));
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeHealthChanged axonServerNodeHealthChanged) {
        AutoRebalancing a2;
        AutoRebalancing a3 = axonServerNodeHealthChanged;
        AutoRebalancing autoRebalancing = a2 = this;
        autoRebalancing.G.debug(NodeAllowsConnectionCheck.H((Object)"\b]9]3N?\\zP?Y6L2\u00189P;V=]>\u0018<W(\u0018!E"), (Object)a3.getNode());
        autoRebalancing.A.clear();
        autoRebalancing.A.addAll(a2.B.getConnectedClients());
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        AutoRebalancing a2;
        AutoRebalancing a3 = applicationDisconnected;
        AutoRebalancing autoRebalancing = a2 = this;
        autoRebalancing.G.debug(UserController.H((Object)"Sfbz{usb{y|6V\u007fau}x|sqbwr(6ik"), (Object)a3.B());
        a3 = new PlatformService.ClientComponent(a3.B(), a3.g(), a3.E(), a3.H());
        autoRebalancing.A.remove(a3);
        a2.G.debug(NodeAllowsConnectionCheck.H((Object)"o2Q.]6Q)L`\u0018!E"), (Object)a2.A);
    }

    @Scheduled(fixedRateString="${axoniq.axonserver.cluster.balancing-rate:15000}")
    protected void H() {
        boolean bl;
        AutoRebalancing autoRebalancing = this;
        if (!autoRebalancing.L) {
            return;
        }
        autoRebalancing.G.debug(UserController.H((Object)"Dwtszsxqs(6ik"), (Object)autoRebalancing.A);
        do {
            boolean bl2;
            AutoRebalancing a2;
            if ((a2 = (PlatformService.ClientComponent)autoRebalancing.A.pollFirst()) != null && autoRebalancing.e.canRebalance(a2.getClientId(), a2.getComponent(), a2.getContext(), autoRebalancing.H(a2.getContext(), a2.getClientStreamId()))) {
                autoRebalancing.H((PlatformService.ClientComponent)a2);
                bl = bl2 = false;
                continue;
            }
            bl = bl2 = a2 != null;
        } while (bl);
    }
}

