/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.ReplicationGroupConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.NodeAddress;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.transport.rest.v2.ComponentRestControllerV2;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class ClusterController
implements SmartLifecycle {
    private final ApplicationEventPublisher f;
    private final Limits D;
    private final RemoteConnections i;
    private final CurrentNodeProvider a;
    private final AdminNodes B;
    private volatile boolean e;
    private final Logger A;
    private final MessagingPlatformConfiguration h;
    private final AdminConfigurationFactory L;
    private final ClusterTagsCache G;

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        ClusterController clusterController = a2;
        a3.H(clusterController.getNodeName());
        if (clusterController.getNodeName().equals(a3.h.getName())) {
            ClusterController clusterController2 = a3;
            clusterController2.A.info(ComponentRestControllerV2.H((Object)"\u0010:=!*/d<+h.'-&d?-<,h'=6:!&0h*' -d&%%!rd39"), (Object)a2.getNodeName());
            return clusterController2.getMe();
        }
        if (a2.getInternalHostName().equals(a3.h.getInternalHostname()) && a2.getGrpcInternalPort() == a3.h.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, ReplicationGroupConfiguration.H((Object)":$\u0017+\u00161Y/\u0016,\u0017e\u001a)\f6\r \u000be\u000e,\r-Y6\u0018(\u001ce\u0011*\n1\u0017$\u0014 Y$\u0017!Y,\u00171\u001c7\u0017$\u0015e\t*\u000b1"));
        }
        ClusterNode clusterNode = a3.B.findById(a2.getNodeName()).orElseGet(() -> a3.H((NodeInfo)a2));
        if (!a3.i.contains(a2.getNodeName())) {
            a3.H((NodeInfo)a2);
        }
        return clusterNode;
    }

    private /* synthetic */ void H() {
        Object a2;
        ClusterController clusterController;
        ClusterController clusterController2 = clusterController = this;
        Object object = clusterController2.B.findById(clusterController2.h.getName());
        if (((Optional)object).isEmpty()) {
            if (clusterController.B.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = clusterController.h.getName();
                a2 = String.format(ComponentRestControllerV2.H((Object)"\u000b1:6-*<d&+,!h*))-d %;d+,)*/!,hh*-3h*))-dm7fd\u001b0)6<d\t<'*\u001b!:2-6h3!0 d:!++>!:=h\"!(-j"), objectArray);
                throw new FailedToStartException((String)a2);
            }
            ClusterController clusterController3 = clusterController;
            a2 = clusterController3.L.clusterNode(clusterController3.h.getName(), clusterController.h.getFullyQualifiedHostname(), clusterController.h.getFullyQualifiedInternalHostname(), clusterController.h.getPort(), clusterController.h.getInternalPort(), clusterController.h.getHttpPort());
            clusterController3.B.save((ClusterNode)a2);
            return;
        }
        a2 = (ClusterNode)((Optional)object).get();
        if (!a2.getInternalHostName().equals(clusterController.h.getFullyQualifiedInternalHostname()) || !a2.getGrpcInternalPort().equals(clusterController.h.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getInternalHostName();
            objectArray[1] = a2.getGrpcInternalPort();
            objectArray[2] = clusterController.h.getFullyQualifiedInternalHostname();
            objectArray[3] = clusterController.h.getInternalPort();
            object = String.format(ReplicationGroupConfiguration.H((Object)":0\u000b7\u001c+\re\u0017*\u001d ^6Y,\u00171\u001c7\u0017$\u0015e\u0011*\n1\u0017$\u0014 V5\u00167\reQ`\n\u007f\\!Pe\u0011$\ne\u001a-\u0018+\u001e \u001diYe\u0017 \u000ee\u000f$\u00150\u001c6Y`\n\u007f\\!We*1\u00187\re8=\u0016+* \u000b3\u001c7Y2\u00101\u0011e\u000b \u001a*\u000f \u000b<Y#\u0010)\u001ck"), objectArray);
            throw new FailedToStartException((String)object);
        }
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a2;
        return a2.B.findAll().peek(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            if (a2 == null) {
                return null;
            }
            a2.setTags(a3.G.getClusterTags().getOrDefault(a2.getName(), Collections.emptyMap()));
            return a2;
        });
    }

    private /* synthetic */ void H(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if (a3.i.contains((String)a2) || a3.h.getName().equals(a2)) {
            return;
        }
        a3.D.getMaxClusterSize().ifPresent(arg_0 -> a3.H((String)a2, arg_0));
    }

    public boolean isActive(String string) {
        String a2 = string;
        ClusterController a3 = this;
        if (a2.equals(a3.h.getName()) || a3.i.get(a2) != null && a3.i.get(a2).isConnected()) {
            return true;
        }
        return false;
    }

    public void closeConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.i.disconnect((String)a2);
    }

    @Transactional
    public synchronized void deleteNode(String string) {
        ClusterController clusterController;
        ClusterController a2;
        Object a3 = string;
        ClusterController clusterController2 = a2 = this;
        clusterController2.A.info(ReplicationGroupConfiguration.H((Object)"\u0001\u001c)\u001c1\u001ce\u0017*\u001d Ce\u00028"), a3);
        clusterController2.f.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested((String)a3));
        if (clusterController2.h.getName().equals(a3)) {
            ClusterController clusterController3 = a2;
            clusterController = clusterController3;
            clusterController3.B.deleteAllByNameNot((String)a3);
            clusterController3.i.closeAll();
        } else {
            a2.B.findById((String)a3).ifPresent(arg_0 -> a2.H((String)a3, arg_0));
            clusterController = a2;
        }
        clusterController.f.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted((String)a3));
        a2.i.sync();
    }

    /*
     * WARNING - void declaration
     */
    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, AdminNodes adminNodes, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, RemoteConnections remoteConnections, CurrentNodeProvider currentNodeProvider) {
        void remoteConnections2;
        void limits2;
        void applicationEventPublisher2;
        void clusterTagsCache2;
        void adminConfigurationFactory2;
        void clusterNodeRepository;
        void messagingPlatformConfiguration2;
        ClusterController a2;
        ClusterController clusterController = clusterController2;
        ClusterController clusterController2 = currentNodeProvider;
        ClusterController clusterController3 = a2 = clusterController;
        ClusterController clusterController4 = a2;
        ClusterController clusterController5 = a2;
        ClusterController clusterController6 = a2;
        a2.A = LoggerFactory.getLogger(ClusterController.class);
        clusterController6.h = messagingPlatformConfiguration2;
        clusterController6.B = clusterNodeRepository;
        clusterController5.L = adminConfigurationFactory2;
        clusterController5.G = clusterTagsCache2;
        clusterController4.f = applicationEventPublisher2;
        clusterController4.D = limits2;
        clusterController3.i = remoteConnections2;
        clusterController3.a = clusterController2;
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a2;
        return a2.i.connections();
    }

    private /* synthetic */ ClusterNode H(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.A.info(ComponentRestControllerV2.H((Object)"\u0005, h*' -d39"), (Object)a3);
        a3 = clusterController.L.clusterNode((NodeInfo)a3);
        return clusterController.B.save((ClusterNode)a3);
    }

    public Stream<ClusterNode> activeNodes() {
        ClusterController a2;
        return a2.nodes().filter(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            return a3.isActive(a2.getName());
        });
    }

    public synchronized void handleRemoteConnection(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.H((NodeInfo)a3);
        clusterController.i.updateNodeInfo((NodeInfo)a3);
        clusterController.f.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected((NodeInfo)a3));
    }

    public void publishEvent(Object object) {
        Object a2 = object;
        ClusterController a3 = this;
        a3.f.publishEvent(a2);
    }

    public void deleteOtherNodes() {
        ClusterController a2;
        ClusterController clusterController = a2;
        a2.B.deleteAllByNameNot(clusterController.getName());
        clusterController.i.sync();
    }

    private /* synthetic */ void H(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        if (a2.getNodeName().equals(a3.h.getName())) {
            return;
        }
        a3.i.connect((NodeInfo)a2, true);
    }

    public int getPhase() {
        return 50;
    }

    public boolean isRunning() {
        ClusterController a2;
        return a2.e;
    }

    public Set<String> remoteNodeNames() {
        ClusterController a2;
        return a2.i.nodes();
    }

    public Optional<RemoteConnection> getRemoteConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        return Optional.ofNullable(a3.i.get((String)a2));
    }

    public boolean isAdminNode() {
        ClusterController a2;
        return a2.a.isAdmin();
    }

    Stream<RemoteConnection> activeConnections() {
        ClusterController a2;
        return a2.i.activeConnections();
    }

    @Transactional
    public void start() {
        ClusterController a2;
        a2.H();
        a2.e = true;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, Integer n) {
        Integer a2 = n;
        ClusterController a3 = this;
        if (a3.i.size() + 1 >= a2) {
            void a4;
            throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + (String)a4);
        }
    }

    public String getName() {
        ClusterController a2;
        return a2.getMe().getName();
    }

    public ClusterNode getMe() {
        ClusterController a2;
        ClusterController clusterController = a2;
        return clusterController.H((ClusterNode)clusterController.a.get());
    }

    /*
     * WARNING - void declaration
     */
    public NodeAddress nodeAddress(String string) {
        ClusterController a2;
        void a3;
        ClusterController clusterController = this;
        if (a3.equals(clusterController.getName())) {
            return new NodeAddress(clusterController.getMe());
        }
        RemoteConnection remoteConnection = clusterController.i.get((String)a3);
        ClusterNode clusterNode = a2 = remoteConnection == null ? (ClusterNode)clusterController.B.findById((String)a3).orElse(null) : remoteConnection.getClusterNode();
        if (a2 == null) {
            return null;
        }
        return new NodeAddress((ClusterNode)a2);
    }

    public void stop() {
        a.e = false;
    }

    private /* synthetic */ ClusterNode H(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if ((a2 = a3.i.get((String)a2)) == null) {
            return null;
        }
        return a2.getClusterNode();
    }

    public ClusterNode getNode(String string) {
        Object a2 = string;
        Object a3 = this;
        if (((String)a2).equals(a3.getName())) {
            return a3.getMe();
        }
        a2 = a3.B.findById((String)a2).orElseGet(() -> ((ClusterController)a3).H((String)a2));
        return a3.H((ClusterNode)a2);
    }

    private /* synthetic */ void H(String string, ClusterNode clusterNode) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.B.deleteById((String)a2);
    }
}

