/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.config.HealthStatus;
import io.axoniq.axonserver.config.TagsConfiguration;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.licensing.LicenseManager;
import io.axoniq.axonserver.localstorage.file.AggregateWithoutSnapshotException;
import java.time.Clock;
import java.time.LocalDate;
import java.util.Objects;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.stereotype.Component;

@Component
public class LicenseHealthIndicator
extends AbstractHealthIndicator {
    private final LicenseManager h;
    private Clock L;
    private final ClusterController G;

    protected void doHealthCheck(Health.Builder builder) {
        LicenseHealthIndicator a2;
        LicenseHealthIndicator a3;
        block6: {
            a3 = builder;
            a2 = this;
            if (a2.G.nodes().count() <= 1L) {
                a3.up();
                return;
            }
            try {
                if (a2.h.getClusterNodes() != 1) break block6;
                a3.up();
                return;
            }
            catch (Exception exception) {
                a3.status(HealthStatus.G);
                a3.withDetail(TagsConfiguration.H((Object)"#S5A%"), (Object)exception.getMessage());
                return;
            }
        }
        LicenseHealthIndicator licenseHealthIndicator = a2;
        LocalDate localDate = licenseHealthIndicator.h.getGraceDate();
        LocalDate localDate2 = licenseHealthIndicator.h.getExpiryDate();
        a3.withDetail(TagsConfiguration.H((Object)"'@!Q%v!F%"), (Object)localDate.toString());
        a3.withDetail(AggregateWithoutSnapshotException.H((Object)">'+6)&\u001f>/:"), (Object)localDate2.toString());
        if (LocalDate.now(licenseHealthIndicator.L).isAfter(Objects.requireNonNull(localDate2))) {
            LicenseHealthIndicator licenseHealthIndicator2 = a3;
            if (LocalDate.now(a2.L).isBefore(Objects.requireNonNull(localDate))) {
                licenseHealthIndicator2.status(HealthStatus.G);
                return;
            }
            licenseHealthIndicator2.down();
            return;
        }
        a3.up();
    }

    /*
     * WARNING - void declaration
     */
    public LicenseHealthIndicator(ClusterController clusterController, LicenseManager licenseManager) {
        void a2;
        LicenseHealthIndicator a3;
        LicenseHealthIndicator a4 = licenseManager;
        LicenseHealthIndicator licenseHealthIndicator = a3 = this;
        a3.L = Clock.systemDefaultZone();
        licenseHealthIndicator.G = a2;
        licenseHealthIndicator.h = a4;
    }

    public void setClock(Clock clock) {
        Object a2 = clock;
        LicenseHealthIndicator a3 = this;
        a3.L = a2;
    }
}

