/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.admin;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.access.application.ApplicationRolesProvider;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.util.RoleUtils;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftController;
import io.axoniq.axonserver.enterprise.replication.admin.AdminReplicationGroupController;
import io.axoniq.axonserver.enterprise.replication.admin.DeleteReplicationGroupPayload;
import io.axoniq.axonserver.enterprise.replication.admin.DeleteReplicationGroupTask;
import io.axoniq.axonserver.enterprise.replication.admin.LeaderElectionCheck;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.grpc.internal.AppendEntryResponse;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.grpc.internal.NodeInfoWithLabel;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupConfiguration;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupMember;
import io.axoniq.axonserver.rest.RoleRestController;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.util.CompetableFutureUtils;
import io.grpc.Status;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
public class ReplicationGroupChangesHandler {
    private final Logger i;
    private final RaftGroupServiceFactory a;
    private final int B = 1;
    private final AdminReplicationGroupController e;
    private final GrpcRaftController A;
    private final FeatureChecker h;
    private final ClusterController L;
    private final TaskPublisher G;

    public void init(List<String> list) {
        List<String> a2 = list;
        Object a3 = this;
        if (!a3.H()) {
            throw new MessagingPlatformException(ErrorCode.ALREADY_MEMBER_OF_CLUSTER, ApplicationRolesProvider.H((Object)"i'C-\u0007!ThF$U-F,^hJ-J*B:\u0007'AhD$R;S-UhH:\u0007!I!S!F$N2B,\u0007*B.H:B"));
        }
        ReplicationGroupChangesHandler replicationGroupChangesHandler = a3;
        replicationGroupChangesHandler.i.info(RoleRestController.H((Object)"\"&\u0002<\u0002)\u0007!\u0011)\u001f!\u0004&K'\rh\u001f \u0002;K&\u0004,\u000eh\u001c!\u001f K.\u0004$\u0007'\u001c!\u0005/K+\u0004&\u001f-\u0013<\u0018rK3\u0016"), (Object)a2);
        replicationGroupChangesHandler.E(RaftAdminGroup.H());
        a2.forEach(string -> {
            ReplicationGroupConfiguration a2;
            ReplicationGroupChangesHandler replicationGroupChangesHandler;
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = replicationGroupChangesHandler = this;
            ReplicationGroupChangesHandler a3 = replicationGroupChangesHandler2.L.getMe();
            String string2 = replicationGroupChangesHandler2.H(a3.getName());
            RaftGroup raftGroup = replicationGroupChangesHandler2.A.initRaftGroup((String)a2, string2, a3.getName());
            a3 = a3.toNodeInfo();
            a2 = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName((String)a2).addNodes(NodeInfoWithLabel.newBuilder().setNode((NodeInfo)a3).setRole(Role.PRIMARY).setLabel(string2)).build();
            CompetableFutureUtils.H((CompletableFuture)replicationGroupChangesHandler2.A.waitForLeader(replicationGroupChangesHandler.A.getRaftGroup(RaftAdminGroup.H())).H(ReplicationGroupConfiguration.class.getName(), a2.toByteArray()));
            replicationGroupChangesHandler.A.waitForLeader(raftGroup);
        });
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(RaftNode raftNode, AdminReplicationGroup adminReplicationGroup) {
        ReplicationGroupChangesHandler a2 = adminReplicationGroup;
        ReplicationGroupChangesHandler a3 = this;
        if (a2.isChangePending()) {
            void a4;
            a2 = a3.H((AdminReplicationGroup)a2).setPending(false).build();
            a4.H(ReplicationGroupConfiguration.class.getName(), a2.toByteArray());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ CompletionStage H(int n, String string, String string2, String string3, boolean bl, Throwable throwable) {
        void a2;
        Object a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = object;
        Object object = throwable;
        ReplicationGroupChangesHandler a4 = replicationGroupChangesHandler;
        if (ErrorCode.fromException((Throwable)a3).equals((Object)ErrorCode.CONCURRENT_MODIFICATIONS) && a2 > 0) {
            void a5;
            void a6;
            void a7;
            void a8;
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = a4;
            replicationGroupChangesHandler2.i.warn(RoleRestController.H((Object)"3\u0016rK:\u000e<\u00191K,\u000e$\u000e<\u0002&\fh\u0005'\u000f-K3\u0016"), (Object)a8, (Object)a7);
            return replicationGroupChangesHandler2.H((String)a8, (String)a7, (String)a6, (boolean)a5, (int)(a2 - true));
        }
        return CompletableFuture.failedFuture((Throwable)a3);
    }

    /*
     * WARNING - void declaration
     */
    public void deleteReplicationGroup(String string, boolean bl) {
        Iterator iterator;
        void a2;
        Object a3 = string;
        ReplicationGroupChangesHandler a4 = this;
        Object object = a3;
        a4.i.info(ApplicationRolesProvider.H((Object)"\fB$B<BhU-W$N+F<N'Ih@:H=Wr\u00073Z"), object);
        if (RaftAdminGroup.H((String)object)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a3;
            throw new MessagingPlatformException(ErrorCode.CANNOT_DELETE_INTERNAL_CONTEXT, String.format(RoleRestController.H((Object)"/-\u0007-\u001f!\u0004&K'\rh\u0002&\u001f-\u0019&\n$K:\u000e8\u0007!\b)\u001f!\u0004&K/\u0019'\u001e8Km\u0018h\u0005'\u001fh\n$\u0007'\u001c-\u000f"), objectArray));
        }
        AdminReplicationGroup adminReplicationGroup = a4.e.findByName((String)a3).orElse(null);
        if (adminReplicationGroup == null) {
            ReplicationGroupChangesHandler replicationGroupChangesHandler = a4;
            replicationGroupChangesHandler.i.warn(ApplicationRolesProvider.H((Object)"\u000bH=K,\u0007&H<\u0007.N&ChU-W$N+F<N'Ih@:H=Wh\\5\u0007!IhF,J!IhS)E$B;\u000bhT-I,N&@hC-K-S-u-W$N+F<N'I\u000fU'R8\u0007<HhF$KhI'C-T"), a3);
            replicationGroupChangesHandler.L.remoteNodeNames().forEach(arg_0 -> a4.H((String)a3, (boolean)a2, arg_0));
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = a4;
            replicationGroupChangesHandler2.a.getRaftGroupServiceForNode(replicationGroupChangesHandler2.L.getName()).deleteReplicationGroup((String)a3, (boolean)a2);
            return;
        }
        Collection collection = adminReplicationGroup.getMemberNames();
        CompletableFuture[] completableFutureArray = new CompletableFuture[collection.size()];
        int n = 0;
        Iterator iterator2 = iterator = new HashSet(collection).iterator();
        while (iterator2.hasNext()) {
            String string2 = (String)iterator.next();
            completableFutureArray[n] = a4.a.getRaftGroupServiceForNode(string2).deleteReplicationGroup((String)a3, (boolean)a2).exceptionally(arg_0 -> a4.H(string2, (String)a3, (boolean)a2, arg_0));
            CompletableFuture completableFuture = completableFutureArray[n];
            ++n;
            completableFuture.thenAccept(void_ -> {
                String a2 = string2;
                Collection a3 = collection;
                a3.remove(a2);
            });
            iterator2 = iterator;
        }
        CompetableFutureUtils.H((CompletableFuture)CompletableFuture.allOf(completableFutureArray).whenComplete((arg_0, arg_1) -> a4.H((String)a3, collection, adminReplicationGroup, arg_0, arg_1)));
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<AppendEntryResponse> addNodeToReplicationGroup(String string, String string2, Role role) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler a4;
        Object a5 = string2;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = a4 = this;
        replicationGroupChangesHandler.i.info(RoleRestController.H((Object)"*,\u000fh\u0005'\u000f-K:\u000e9\u001e-\u0018<K!\u0005>\u0004#\u000e,K.\u0004:K&\u0004,\u000erK3\u0016hFh\n&\u000fh\b'\u0005<\u000e0\u001frK3\u0016"), a5, (Object)a3);
        if (!replicationGroupChangesHandler.L.isActive((String)a5)) {
            throw new MessagingPlatformException(ErrorCode.AXONSERVER_NODE_NOT_CONNECTED, (String)a5 + ": cannot add node to a replication group when it is not active");
        }
        if (a4.a.getLeader((String)a3) == null) {
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, (String)a3 + ": cannot add node to a replication group when it does not have a leader");
        }
        ClusterNode clusterNode = a4.L.getNode((String)a5);
        if (clusterNode == null) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a5;
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, String.format(ApplicationRolesProvider.H((Object)"i'C-\u0007mThI'ShA'R&C"), objectArray));
        }
        Object object = a5;
        a4.H(Collections.singleton(object), (Role)a2);
        return a4.H((String)object, (Role)a2, (String)a3, clusterNode, 1);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(Set<String> set, Role role) {
        void a2;
        ReplicationGroupChangesHandler a3 = role;
        ReplicationGroupChangesHandler a4 = this;
        a4.h.getNrOfNodes((Role)a3).ifPresent(arg_0 -> a4.H((Role)a3, (Set)a2, arg_0));
    }

    private static /* synthetic */ MessagingPlatformException G(String a2) {
        Object[] objectArray = new Object[1];
        objectArray[0] = a2;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, String.format(RoleRestController.H((Object)"\u001a\u000e8\u0007!\b)\u001f!\u0004&K/\u0019'\u001e8Km\u0018h\u0005'\u001fh\r'\u001e&\u000f"), objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(AdminReplicationGroup adminReplicationGroup, String string) throws InterruptedException, ExecutionException {
        void a2;
        void a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        Object a4 = replicationGroupChangesHandler.a.getLeader(a3.getName());
        if (a3.getMembers().size() > 1 && a2.equals(a4)) {
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = replicationGroupChangesHandler;
            replicationGroupChangesHandler2.i.info(RoleRestController.H((Object)"3\u0016rK$\u000e)\u000f-\u0019h\u0002;K3\u0016"), (Object)a3, a4);
            replicationGroupChangesHandler2.a.getRaftGroupService(a3.getName()).transferLeadership(a3.getName()).get();
            a4 = replicationGroupChangesHandler.a.getLeader(a3.getName());
            Object object = a4;
            for (int j = 25; (object == null || ((String)a4).equals(a2)) && j > 0; --j) {
                Thread.sleep(250L);
                object = a4 = replicationGroupChangesHandler.a.getLeader(a3.getName());
            }
            if (a4 == null || ((String)a4).equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.OTHER, ApplicationRolesProvider.H((Object)"\u0005H>N&@hK-F,B:\u0007<HhH<O-UhI'C-\u0007.F!K-C"));
            }
            replicationGroupChangesHandler.i.info(RoleRestController.H((Object)"3\u0016rK$\u000e)\u000f-\u0019h\b \n&\f-\u000fh\u001f'K3\u0016"), (Object)a3, a4);
        }
    }

    @EventListener
    @Order(value=5)
    public void on(ClusterEvents.BecomeLeader becomeLeader) {
        ReplicationGroupChangesHandler a2 = becomeLeader;
        ReplicationGroupChangesHandler a3 = this;
        a3.A.currentTerm(a2.replicationGroup()).ifPresent(arg_0 -> a3.H((ClusterEvents.BecomeLeader)a2, arg_0));
    }

    private static /* synthetic */ MessagingPlatformException E(String a2) {
        Object[] objectArray = new Object[1];
        objectArray[0] = a2;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, String.format(RoleRestController.H((Object)"\u001a\u000e8\u0007!\b)\u001f!\u0004&K/\u0019'\u001e8Km\u0018h\u0005'\u001fh\r'\u001e&\u000f"), objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public ReplicationGroupChangesHandler(AdminReplicationGroupController adminReplicationGroupController, ClusterController clusterController, RaftGroupServiceFactory raftGroupServiceFactory, FeatureChecker featureChecker, TaskPublisher taskPublisher, GrpcRaftController grpcRaftController) {
        ReplicationGroupChangesHandler a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ReplicationGroupChangesHandler a8;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = replicationGroupChangesHandler2;
        ReplicationGroupChangesHandler replicationGroupChangesHandler2 = grpcRaftController;
        ReplicationGroupChangesHandler replicationGroupChangesHandler3 = a8 = replicationGroupChangesHandler;
        ReplicationGroupChangesHandler replicationGroupChangesHandler4 = a8;
        ReplicationGroupChangesHandler replicationGroupChangesHandler5 = a8;
        ReplicationGroupChangesHandler replicationGroupChangesHandler6 = a8;
        replicationGroupChangesHandler6.B = 1;
        replicationGroupChangesHandler6.i = LoggerFactory.getLogger(ReplicationGroupChangesHandler.class);
        replicationGroupChangesHandler5.e = a7;
        replicationGroupChangesHandler5.L = a6;
        replicationGroupChangesHandler4.a = a5;
        replicationGroupChangesHandler4.h = a4;
        replicationGroupChangesHandler3.G = a3;
        replicationGroupChangesHandler3.A = a2;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Node H(ClusterNode clusterNode, String string, Role role) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler a4 = clusterNode;
        ReplicationGroupChangesHandler a5 = this;
        return Node.newBuilder().setNodeId((String)a3).setHost(a4.getInternalHostName()).setPort(a4.getGrpcInternalPort().intValue()).setNodeName(a4.getName()).setRole(RoleUtils.H((Role)a2)).build();
    }

    public static String H(Object object) {
        Object object2 = object;
        object2 = (String)object2;
        int n = ((String)object2).length();
        int a2 = n - 1;
        char[] cArray = new char[n];
        int n2 = (3 ^ 5) << 4 ^ (2 << 2 ^ 3);
        int cfr_ignored_0 = 1 << 3;
        int n3 = a2;
        int n4 = (2 ^ 5) << 3 ^ 2;
        while (n3 >= 0) {
            int n5 = a2--;
            cArray[n5] = (char)(((String)object2).charAt(n5) ^ n4);
            if (a2 < 0) break;
            int n6 = a2--;
            cArray[n6] = (char)(((String)object2).charAt(n6) ^ n2);
            n3 = a2;
        }
        return new String(cArray);
    }

    private static /* synthetic */ boolean H(String string, NodeInfoWithLabel nodeInfoWithLabel) {
        String a2 = nodeInfoWithLabel;
        String a3 = string;
        if (!a2.getLabel().equals(a3)) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> joinReplicationGroups(NodeInfo nodeInfo, List<String> list) {
        void a2;
        List<String> a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        Object a4 = new LinkedList();
        if (a3.isEmpty()) {
            a3 = replicationGroupChangesHandler.e.findAll().map(AdminReplicationGroup::getName).toList();
        }
        ClusterNode clusterNode = replicationGroupChangesHandler.L.getNode(a2.getNodeName());
        a3.forEach(arg_0 -> replicationGroupChangesHandler.H((NodeInfo)a2, clusterNode, (List)a4, arg_0));
        return a4;
    }

    private static /* synthetic */ MessagingPlatformException H(String string, String string2) {
        String a2 = string2;
        String a3 = string;
        Object[] objectArray = new Object[2];
        objectArray[0] = a3;
        objectArray[1] = a2;
        return new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, String.format(ApplicationRolesProvider.H((Object)"\u0006H,Bh\u0002;\u0007&H<\u0007.H=I,\u0007!IhU-W$N+F<N'I\u000fU'R8\u0007mT"), objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string) {
        block3: {
            ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
            try {
                ReplicationGroupChangesHandler a2 = replicationGroupChangesHandler.A.getRaftNode(RaftAdminGroup.H());
                if (a2.E()) {
                    void a3;
                    replicationGroupChangesHandler.e.findByName((String)a3).ifPresent(arg_0 -> replicationGroupChangesHandler.H((RaftNode)a2, arg_0));
                    return;
                }
            }
            catch (MessagingPlatformException a2) {
                if (ErrorCode.REPLICATION_GROUP_NOT_FOUND.equals((Object)a2.getErrorCode())) break block3;
                replicationGroupChangesHandler.i.warn(ApplicationRolesProvider.H((Object)"\rU:H:\u0007+O-D#N&@hW-I,N&@hD F&@-T"), (Throwable)a2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createReplicationGroup(String string, Collection<ReplicationGroupMember> collection) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        replicationGroupChangesHandler.H((String)a3, (Collection)a2);
        ArrayList arrayList = new ArrayList();
        AtomicReference a4 = new AtomicReference();
        a2.forEach(replicationGroupMember -> {
            void a2;
            void a3;
            ReplicationGroupChangesHandler a4;
            ReplicationGroupChangesHandler a5 = replicationGroupMember;
            ReplicationGroupChangesHandler replicationGroupChangesHandler = a4 = this;
            ClusterNode clusterNode = replicationGroupChangesHandler.L.getNode(a5.getNodeName());
            String string = replicationGroupChangesHandler.H(a5.getNodeName());
            a5 = replicationGroupChangesHandler.H(clusterNode, string, a5.getRole());
            if (a3.get() == null && Role.PRIMARY.equals((Object)a5.getRole())) {
                a3.set(a5);
            }
            a2.add(a5);
        });
        CompetableFutureUtils.H((CompletableFuture)((CompletableFuture)replicationGroupChangesHandler.a.getRaftGroupServiceForNode(((Node)a4.get()).getNodeName()).initReplicationGroup((String)a3, arrayList).thenAccept(replicationGroupConfiguration -> {
            ReplicationGroupChangesHandler a2 = replicationGroupConfiguration;
            ReplicationGroupChangesHandler a3 = this;
            a2 = a2.toBuilder().setPending(false).build();
            a3.a.appendToAdminAndWait(ReplicationGroupConfiguration.class.getName(), a2.toByteArray());
        })).exceptionally(arg_0 -> replicationGroupChangesHandler.H((String)a3, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    public void deleteNodeFromReplicationGroup(String string, String string2, boolean bl) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler a4;
        Object a5 = string;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = a4 = this;
        replicationGroupChangesHandler.i.info(ApplicationRolesProvider.H((Object)"c-K-S-\u0007&H,BhA:H%\u0007:B8K!D)S!H&\u0007/U'R8\u0007!I>H#B,\u0007.H:\u0007:B8K!D)S!H&\u0007/U'R8\u001dh\\5\u0007e\u0007)I,\u0007&H,Br\u00073Z"), a5, (Object)a3);
        if (replicationGroupChangesHandler.a.getLeader((String)a5) == null) {
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, (String)a5 + ": cannot delete node from a replication group when it does not have a leader");
        }
        AdminReplicationGroup adminReplicationGroup = (AdminReplicationGroup)a4.e.findByName((String)a5).orElseThrow(() -> ReplicationGroupChangesHandler.G((String)a5));
        String string3 = (String)adminReplicationGroup.getNodeLabel((String)a3).orElseThrow(() -> ReplicationGroupChangesHandler.H((String)a3, (String)a5));
        if (adminReplicationGroup.getMembers().size() == 1) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a3;
            objectArray[1] = a5;
            throw new MessagingPlatformException(ErrorCode.CANNOT_REMOVE_LAST_NODE, String.format(RoleRestController.H((Object)"\u0006\u0004,\u000ehN;K!\u0018h\u0007)\u0018<K&\u0004,\u000eh\u0002&K:\u000e8\u0007!\b)\u001f!\u0004&K/\u0019'\u001e8Km\u0018dK<\u0004h\u000f-\u0007-\u001f-K<\u0003-K:\u000e8\u0007!\b)\u001f!\u0004&K/\u0019'\u001e8K=\u0018-K=\u0005:\u000e/\u0002;\u001f-\u0019h\b'\u0005<\u000e0\u001f"), objectArray));
        }
        if (!LeaderElectionCheck.H((ClusterController)a4.L, (AdminReplicationGroup)adminReplicationGroup, (String)a3)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a3;
            objectArray[1] = a5;
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, String.format(ApplicationRolesProvider.H((Object)"s BhI'C-\u0007mThD)I&H<\u0007*BhC-K-S-ChA:H%\u0007<O-\u0007:B8K!D)S!H&\u0007/U'R8\u0007mThF<\u0007<O!ThJ'J-I<\u000bhU-J)N&N&@hI'C-ThD)I&H<\u0007-K-D<\u0007)\u0007&B?\u0007$B)C-U"), objectArray));
        }
        void v3 = a3;
        a4.H(adminReplicationGroup, (String)v3);
        CompetableFutureUtils.H((CompletableFuture)a4.H((String)a5, (String)v3, string3, (boolean)a2, 1), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, boolean bl, String string2) {
        void a2;
        void a3;
        Object a4 = string2;
        ReplicationGroupChangesHandler a5 = this;
        a5.a.getRaftGroupServiceForNode((String)a4).deleteReplicationGroup((String)a3, (boolean)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, Collection collection, AdminReplicationGroup adminReplicationGroup, Void void_, Throwable throwable) {
        void a2;
        void a3;
        Object a222 = collection;
        ReplicationGroupChangesHandler a4 = this;
        ReplicationGroupConfiguration.Builder a5 = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName((String)a3);
        if (a2 != null) {
            void a6;
            Object[] objectArray = new Object[3];
            objectArray[0] = a3;
            objectArray[1] = String.join((CharSequence)RoleRestController.H((Object)"G"), (Iterable<? extends CharSequence>)a222);
            objectArray[2] = a2;
            a4.i.warn(ApplicationRolesProvider.H((Object)"3Zr\u0007\u000bH=K,\u0007&H<\u0007,B$B<BhU-W$N+F<N'Ih@:H=WhA:H%\u00073Z"), objectArray);
            a6.getMembers().stream().filter(arg_0 -> ReplicationGroupChangesHandler.H((Collection)a222, arg_0)).forEach(adminReplicationGroupMember -> {
                ReplicationGroupConfiguration.Builder a2 = adminReplicationGroupMember;
                ReplicationGroupConfiguration.Builder a3 = a5;
                a3.addNodes(NodeInfoWithLabel.newBuilder().setLabel(a2.getClusterNodeLabel()).setNode(a2.getClusterNode().toNodeInfo()));
            });
        }
        try {
            a4.a.appendToAdminAndWait(ReplicationGroupConfiguration.class.getName(), a5.build().toByteArray());
            return;
        }
        catch (Exception a222) {
            a4.i.debug(ApplicationRolesProvider.H((Object)"\\5\u001dhb:U'UhP N$BhR8C)S!I/\u0007+H&A!@=U)S!H&\u00073Z"), (Object)a3, (Object)a222.getMessage());
            return;
        }
    }

    private /* synthetic */ void E() {
        ReplicationGroupChangesHandler a2;
        a2.h.getMaxReplicationGroups().ifPresent(n -> {
            Integer a2 = n;
            ReplicationGroupChangesHandler a3 = this;
            if (a3.e.count() > a2) {
                throw new MessagingPlatformException(ErrorCode.LICENSE_ERROR, ApplicationRolesProvider.H((Object)"\u0005F0N%R%\u0007&R%E-UhH.\u0007:B8K!D)S!H&\u0007/U'R8ThU-F+O-C"));
            }
        });
        a2.H();
    }

    private /* synthetic */ boolean H() {
        ReplicationGroupChangesHandler a2;
        if (a2.e.findAll().findAny().isEmpty() && a2.L.getRemoteConnections().isEmpty()) {
            return true;
        }
        return false;
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation leaderConfirmation) {
        ReplicationGroupChangesHandler a2 = leaderConfirmation;
        ReplicationGroupChangesHandler a3 = this;
        long l2 = a3.A.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l2) {
            return;
        }
        try {
            a3.H(a2.replicationGroup());
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string2, Collection<ReplicationGroupMember> collection) {
        void a3;
        Object a4 = string2;
        ReplicationGroupChangesHandler a5 = this;
        a5.e.findByName((String)a4).ifPresent(arg_0 -> ReplicationGroupChangesHandler.H((String)a4, arg_0));
        a5.E();
        a4 = new EnumMap(Role.class);
        a3.forEach(arg_0 -> ReplicationGroupChangesHandler.H((Map)a4, arg_0));
        a4.forEach((role, set) -> {
            void a2;
            Object a3 = set;
            ReplicationGroupChangesHandler a4 = this;
            a4.H((Set)a3, (Role)a2);
        });
        a4 = a3.stream().map(ReplicationGroupMember::getNodeName).filter(string -> {
            Object a2 = string;
            ReplicationGroupChangesHandler a3 = this;
            if (a3.L.getNode((String)a2) == null) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
        if (!a4.isEmpty()) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a4;
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, String.format(ApplicationRolesProvider.H((Object)"\u0006H,B`Ta\u0007mThI'ShA'R&C"), objectArray));
        }
        if (a3.stream().noneMatch(a2 -> a2.getRole().equals((Object)Role.PRIMARY))) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, RoleRestController.H((Object)"%'K8\u0019!\u0006)\u00191K&\u0004,\u000e;K8\u0019'\u001d!\u000f-\u000f"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void H(ReplicationGroupConfiguration.Builder builder, AdminReplicationGroup adminReplicationGroup, AdminReplicationGroupMember adminReplicationGroupMember) {
        void a2;
        ReplicationGroupConfiguration.Builder a3 = adminReplicationGroupMember;
        ReplicationGroupConfiguration.Builder a4 = builder;
        a4.setPending(a2.isChangePending()).addNodes(NodeInfoWithLabel.newBuilder().setNode(a3.getClusterNode().toNodeInfo()).setLabel(a3.getClusterNodeLabel()).setRole(a3.getRole()).build());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(ClusterEvents.BecomeLeader becomeLeader, Long l2) {
        void a2;
        ReplicationGroupChangesHandler a3 = becomeLeader;
        ReplicationGroupChangesHandler a4 = this;
        if (a3.term() < a2.longValue()) {
            return;
        }
        a4.H(a3.replicationGroup());
    }

    private static /* synthetic */ boolean H(Collection collection, AdminReplicationGroupMember adminReplicationGroupMember) {
        Collection a2 = adminReplicationGroupMember;
        Collection a3 = collection;
        return a3.contains(a2.getClusterNode().getName());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(NodeInfo nodeInfo, ClusterNode clusterNode, List list, String string) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler a4 = nodeInfo;
        ReplicationGroupChangesHandler a5 = this;
        AdminReplicationGroup adminReplicationGroup = a5.e.findByName((String)a3).orElse(null);
        if (adminReplicationGroup != null) {
            void a6;
            if (adminReplicationGroup.getMemberNames().contains(a4.getNodeName())) {
                a5.i.info(RoleRestController.H((Object)"\u00105Qh%'\u000f-K3\u0016h\u0002;K)\u0007:\u000e)\u000f1K%\u000e%\t-\u0019"), (Object)adminReplicationGroup, (Object)a4.getNodeName());
                return;
            }
            CompetableFutureUtils.H((CompletableFuture)a5.H(a4.getNodeName(), Role.PRIMARY, (String)a3, (ClusterNode)a6, 1));
            return;
        }
        a5.createReplicationGroup((String)a3, List.of(ReplicationGroupMember.newBuilder().setNodeName(a4.getNodeName()).setPort(a4.getGrpcInternalPort()).setHost(a4.getInternalHostName()).setRole(Role.PRIMARY).build()));
        a2.add(a3);
    }

    private static /* synthetic */ void H(Map map, ReplicationGroupMember replicationGroupMember) {
        Map a3 = replicationGroupMember;
        Map a4 = map;
        a4.computeIfAbsent(a3.getRole(), a2 -> new HashSet()).add(a3.getNodeName());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, String string2, String string3) {
        void a2;
        void a3;
        Object a4 = string3;
        ReplicationGroupChangesHandler a5 = this;
        try {
            CompetableFutureUtils.H((CompletableFuture)a5.a.getRaftGroupServiceForNode((String)a3).prepareDeleteNodeFromReplicationGroup((String)a2, (String)a4), (long)1L, (TimeUnit)TimeUnit.SECONDS);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a4;
            objectArray[1] = a2;
            objectArray[2] = a3;
            a5.i.info(RoleRestController.H((Object)"\u000e\n!\u0007-\u000fh\u001f'K;\u000e&\u000fh\u001b:\u000ee\u000f-\u0007-\u001f-K3\u0016h\r:\u0004%K3\u0016h\u001f'K3\u0016"), objectArray);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ CompletableFuture<AppendEntryResponse> H(String string, String string2, String string3, boolean bl, int n) {
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        try {
            void a2;
            void a3;
            void a4;
            void a5;
            void a6;
            ReplicationGroupChangesHandler a7 = (AdminReplicationGroup)replicationGroupChangesHandler.e.findByName((String)a6).orElseThrow(() -> ReplicationGroupChangesHandler.H((String)a6));
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = replicationGroupChangesHandler;
            replicationGroupChangesHandler2.E((AdminReplicationGroup)a7, (String)a5);
            ReplicationGroupConfiguration.Builder builder = replicationGroupChangesHandler2.H((AdminReplicationGroup)a7);
            List<NodeInfoWithLabel> list = builder.getNodesList().stream().filter(arg_0 -> ReplicationGroupChangesHandler.H((String)a4, arg_0)).toList();
            builder.clearNodes();
            builder.addAllNodes(list);
            builder.setPreserveEventstore((boolean)a3);
            return replicationGroupChangesHandler.a.appendToAdmin(ReplicationGroupConfiguration.class.getName(), builder.build().toByteArray()).exceptionallyCompose(arg_0 -> replicationGroupChangesHandler.H((int)a2, (String)a6, (String)a5, (String)a4, (boolean)a3, arg_0));
        }
        catch (InterruptedException a7) {
            Thread.currentThread().interrupt();
            return CompletableFuture.failedFuture(a7);
        }
        catch (Exception a7) {
            return CompletableFuture.failedFuture(a7);
        }
    }

    private /* synthetic */ String H(String string) {
        Object a2 = string;
        ReplicationGroupChangesHandler a3 = this;
        return (String)a2 + "-" + UUID.randomUUID();
    }

    private static /* synthetic */ MessagingPlatformException H(String a2) {
        Object[] objectArray = new Object[1];
        objectArray[0] = a2;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, String.format(ApplicationRolesProvider.H((Object)"\u001aB8K!D)S!H&\u0007/U'R8\u0007mThI'ShA'R&C"), objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(AdminReplicationGroup adminReplicationGroup, String string, String string2) {
        void a2;
        void a3;
        Object a4 = string2;
        ReplicationGroupChangesHandler a5 = this;
        a5.H((String)a4, a3.getName(), (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ CompletionStage H(int n, String string, String string2, Role role, ClusterNode clusterNode, Throwable throwable) {
        void a2;
        Object a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = object;
        Object object = throwable;
        ReplicationGroupChangesHandler a4 = replicationGroupChangesHandler;
        if (ErrorCode.fromException((Throwable)a3).equals((Object)ErrorCode.CONCURRENT_MODIFICATIONS) && a2 > 0) {
            void a5;
            void a6;
            void a7;
            void a8;
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = a4;
            replicationGroupChangesHandler2.i.warn(ApplicationRolesProvider.H((Object)"3Zr\u0007:B<U1\u0007)C,N&@hI'C-\u00073Z"), (Object)a8, (Object)a7);
            return replicationGroupChangesHandler2.H((String)a7, (Role)a6, (String)a8, (ClusterNode)a5, (int)(a2 - true));
        }
        return CompletableFuture.failedFuture((Throwable)a3);
    }

    private static /* synthetic */ void H(String string, AdminReplicationGroup adminReplicationGroup) {
        String a2 = adminReplicationGroup;
        String a3 = string;
        Object[] objectArray = new Object[1];
        objectArray[0] = a3;
        throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_EXISTS, String.format(RoleRestController.H((Object)"9-\u001b$\u0002+\n<\u0002'\u0005h\f:\u0004=\u001bhN;K)\u0007:\u000e)\u000f1K-\u0013!\u0018<\u0018"), objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(Role role, Set set, Integer n) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler a4;
        Set a5 = set;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = a4 = this;
        int n2 = replicationGroupChangesHandler.e.nrOfNodesInRole((Role)a3, a5);
        Object[] objectArray = new Object[4];
        objectArray[0] = n2;
        objectArray[1] = a3;
        objectArray[2] = a5;
        objectArray[3] = a2;
        replicationGroupChangesHandler.i.debug(ApplicationRolesProvider.H((Object)"\\5\u0007&H,B;\u0007?N<OhU'K-\u00073ZhA'R&ChP N$BhS:^!I/\u0007<HhF,Ch\\5\u000bhJ)_hF$K'P-ChN;\u00073Z"), objectArray);
        if (n2 + a5.size() > a2.intValue()) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = a5.size();
            objectArray2[1] = a3;
            throw new MessagingPlatformException(ErrorCode.LICENSE_ERROR, String.format(RoleRestController.H((Object)"'!\b-\u0005;\u000eh\u000f'\u000e;K&\u0004<K)\u0007$\u0004?K)\u000f,\u0002&\fhN,K%\u0004:\u000eh\u0005'\u000f-C;Bh\u001c!\u001f K:\u0004$\u000erKm\u0018"), objectArray2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ReplicationGroupConfiguration.Builder H(AdminReplicationGroup adminReplicationGroup) {
        void a2;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        ReplicationGroupChangesHandler a3 = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName(a2.getName());
        a2.getMembers().forEach(arg_0 -> ReplicationGroupChangesHandler.H((ReplicationGroupConfiguration.Builder)a3, (AdminReplicationGroup)a2, arg_0));
        return a3;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ CompletableFuture<AppendEntryResponse> H(String string, Role role, String string2, ClusterNode clusterNode, int n) {
        void a2;
        void a3;
        void a4;
        void a5;
        ReplicationGroupChangesHandler a62;
        void a7;
        ReplicationGroupChangesHandler replicationGroupChangesHandler;
        block3: {
            replicationGroupChangesHandler = this;
            try {
                a62 = (AdminReplicationGroup)replicationGroupChangesHandler.e.findByName((String)a7).orElseThrow(() -> ReplicationGroupChangesHandler.E((String)a7));
                if (!a62.getMemberNames().contains(a5)) break block3;
                replicationGroupChangesHandler.i.info(RoleRestController.H((Object)"3\u0016h\n$\u0019-\n,\u0012h\b'\u0005<\n!\u0005;K&\u0004,\u000erK3\u0016"), (Object)a7, (Object)a5);
                return CompletableFuture.completedFuture(null);
            }
            catch (MessagingPlatformException a62) {
                return CompletableFuture.failedFuture(a62);
            }
        }
        ReplicationGroupChangesHandler replicationGroupChangesHandler2 = replicationGroupChangesHandler;
        ReplicationGroupConfiguration.Builder builder = replicationGroupChangesHandler2.H((AdminReplicationGroup)a62);
        String string3 = replicationGroupChangesHandler2.H((String)a5);
        builder.addNodes(NodeInfoWithLabel.newBuilder().setNode(a4.toNodeInfo()).setLabel(string3).setRole((Role)a3));
        return replicationGroupChangesHandler2.a.appendToAdmin(ReplicationGroupConfiguration.class.getName(), builder.build().toByteArray()).exceptionallyCompose(arg_0 -> replicationGroupChangesHandler.H((int)a2, (String)a7, (String)a5, (Role)a3, (ClusterNode)a4, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Void H(String string, Throwable throwable) {
        void a2;
        Object a3 = throwable;
        ReplicationGroupChangesHandler a4 = this;
        a4.deleteReplicationGroup((String)a2, false);
        throw MessagingPlatformException.create((Throwable)a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Void E(String string, String string2, boolean bl, Throwable throwable) {
        void a2;
        void a3;
        void a4;
        Throwable a5;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = throwable2;
        Throwable throwable2 = throwable;
        ReplicationGroupChangesHandler a6 = replicationGroupChangesHandler;
        if (!Status.UNAVAILABLE.getCode().equals((Object)Status.fromThrowable((Throwable)a5).getCode())) {
            if (a5 instanceof RuntimeException) {
                throw (RuntimeException)a5;
            }
            throw new MessagingPlatformException(ErrorCode.OTHER, a5.getMessage(), a5);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = a4;
        objectArray[1] = a3;
        objectArray[2] = Status.fromThrowable((Throwable)a5);
        a6.i.warn(RoleRestController.H((Object)"\u000b\u0004=\u0007,K&\u0004<K,\u000e$\u000e<\u000eh\u0019-\u001b$\u0002+\n<\u0002'\u0005h\f:\u0004=\u001bh\u00105K.\u0019'\u0006h\u00105K;\u001f)\u001f=\u0018h\u00105Gh\u001b=\t$\u0002;\u0003!\u0005/K:\u000e<\u00191K<\n;\u0000"), objectArray);
        a6.G.publishScheduledTask(RaftAdminGroup.H(), DeleteReplicationGroupTask.class.getName(), (Object)new DeleteReplicationGroupPayload((String)a3, (String)a4, (boolean)a2), Duration.ofSeconds(1L));
        return null;
    }

    private /* synthetic */ void H() {
        ReplicationGroupChangesHandler a2;
        if (a2.L.nodes().count() > (long)a2.h.getMaxClusterSize().orElse(1).intValue()) {
            throw new MessagingPlatformException(ErrorCode.LICENSE_ERROR, ApplicationRolesProvider.H((Object)"s'HhJ)I1\u0007&H,B;\u0007!IhD$R;S-U"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Void H(String string, String string2, boolean bl, Throwable throwable) {
        Object a2;
        void a3;
        void a4;
        void a5;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = object;
        Object object = throwable;
        ReplicationGroupChangesHandler a6 = replicationGroupChangesHandler;
        return a6.E((String)a5, (String)a4, (boolean)a3, (Throwable)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(AdminReplicationGroup adminReplicationGroup, String string) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        Object a4 = a3.getMemberNames();
        Collection collection = replicationGroupChangesHandler.e.getNodeNames(RaftAdminGroup.H());
        Object object = a4 = new HashSet(a4);
        object.addAll(collection);
        object.forEach(arg_0 -> replicationGroupChangesHandler.H((AdminReplicationGroup)a3, (String)a2, arg_0));
    }
}

