/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.eventstore.disruptor.engine;

import io.axoniq.axonserver.eventstore.api.Event;
import io.axoniq.axonserver.eventstore.api.RegularSequence;
import io.axoniq.axonserver.eventstore.api.Sequence;
import io.axoniq.axonserver.eventstore.api.SequencedEvent;
import io.axoniq.axonserver.eventstore.disruptor.EventStorageEngine;
import io.axoniq.axonserver.eventstore.disruptor.engine.segment.EventNotFoundException;
import io.axoniq.axonserver.eventstore.disruptor.engine.segment.codec.TransactionCodec;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;

public class InMemoryEventStorageEngine
implements EventStorageEngine {
    private NavigableMap<Long, Event> G;

    public EventStorageEngine.SequencedEventSubscription sequencedEvents(EventStorageEngine.SequencedEventConsumer sequencedEventConsumer) {
        InMemoryEventStorageEngine a2 = sequencedEventConsumer;
        InMemoryEventStorageEngine a3 = this;
        return arg_0 -> a3.H((EventStorageEngine.SequencedEventConsumer)a2, arg_0);
    }

    public CompletableFuture<Void> drop() {
        InMemoryEventStorageEngine a2;
        a2.G.clear();
        return CompletableFuture.completedFuture(null);
    }

    public Sequence head() {
        InMemoryEventStorageEngine a2;
        if (a2.G.isEmpty()) {
            return RegularSequence.seq((int)0);
        }
        return RegularSequence.seq((long)((Long)a2.G.lastKey() + 1L));
    }

    public void updateImmutabilityMarker(Sequence sequence) {
        InMemoryEventStorageEngine a2 = sequence;
        sequence = this;
    }

    public InMemoryEventStorageEngine() {
        InMemoryEventStorageEngine a2;
        InMemoryEventStorageEngine inMemoryEventStorageEngine = a2;
        inMemoryEventStorageEngine.G = new TreeMap();
    }

    public CompletableFuture<Void> advanceTailTo(Sequence sequence) {
        Object a2 = sequence;
        InMemoryEventStorageEngine a3 = this;
        if (a2.value() < a3.tail().value()) {
            throw new IllegalArgumentException(EventNotFoundException.H((Object)"!~\fq\rkB~\u0006i\u0003q\u0001zB}\u0003|\th\u0003m\u0006l"));
        }
        TreeMap treeMap = new TreeMap();
        a2 = a3.G.subMap(a2.value(), true, (Long)a3.G.lastKey(), true);
        TreeMap treeMap2 = treeMap;
        treeMap2.putAll(a2);
        a3.G = treeMap2;
        return CompletableFuture.completedFuture(null);
    }

    public SequencedEvent sequencedEvent(Sequence sequence) {
        InMemoryEventStorageEngine a2 = sequence;
        InMemoryEventStorageEngine a3 = this;
        Event event = (Event)a3.G.get(a2.value());
        if (event == null) {
            throw new IllegalArgumentException("No event found for sequence " + a2.value());
        }
        return new SequencedEvent.SimpleSequencedEvent((Sequence)a2, event);
    }

    public long size() {
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(EventStorageEngine.SequencedEventConsumer sequencedEventConsumer, List list) {
        Iterator a2;
        InMemoryEventStorageEngine inMemoryEventStorageEngine = this;
        Iterator iterator = a2 = a2.iterator();
        while (iterator.hasNext()) {
            void a3;
            InMemoryEventStorageEngine a4 = (Sequence)a2.next();
            Event event = (Event)inMemoryEventStorageEngine.G.get(a4.value());
            if (event == null) {
                a3.onError((Throwable)new IllegalArgumentException("No event for sequence " + a4.value()));
                return;
            }
            a3.onNext((SequencedEvent)new SequencedEvent.SimpleSequencedEvent((Sequence)a4, event));
            iterator = a2;
        }
    }

    public Sequence tail() {
        InMemoryEventStorageEngine a2;
        if (a2.G.isEmpty()) {
            return RegularSequence.seq((int)0);
        }
        return RegularSequence.seq((long)((Long)a2.G.firstKey()));
    }

    private /* synthetic */ boolean H() {
        InMemoryEventStorageEngine a2;
        return a2.G.isEmpty();
    }

    public void appendFrom(Sequence sequence, List<Event> list) {
        Event a2;
        Object a3 = sequence;
        InMemoryEventStorageEngine a4 = this;
        if (a2 == null || a2.isEmpty() || a3 == null) {
            throw new IllegalArgumentException(TransactionCodec.H((Object)"A\"xjbmw=f(x)6,xms f9omz$e96\"pms;s#b>"));
        }
        InMemoryEventStorageEngine inMemoryEventStorageEngine = a3;
        long l2 = inMemoryEventStorageEngine.value();
        if (inMemoryEventStorageEngine.value() < 0L) {
            throw new IllegalArgumentException("Event store needs to start at 0 instead of " + a3.value());
        }
        if (!a4.H() && a4.head().value() < a3.value()) {
            throw new IllegalArgumentException(EventNotFoundException.H((Object)"K\nz\u0010zElB~Bx\u0003o"));
        }
        a3 = a2.iterator();
        Iterator iterator = a3;
        while (iterator.hasNext()) {
            a2 = (Event)a3.next();
            Event event = (Event)a4.G.get(l2);
            if (event != null && !Objects.equals(event.identifier(), a2.identifier())) {
                throw new IllegalArgumentException(TransactionCodec.H((Object)"\u0000c>bmx\"bmy;s?a?\u007f9sms;s#bma$b%6>w sme(g8s#u(6,x)6)\u007f+p(d(x96.y#b(x9"));
            }
            System.out.println("Appending to event store with seq " + l2);
            iterator = a3;
            a4.G.put(l2, a2);
            ++l2;
        }
    }
}

