/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.config.AxonServerRoutingConfiguration;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.CommandService;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcCommandDispatcherListener;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.grpc.SerializedCommandProviderInbound;
import io.axoniq.axonserver.grpc.SerializedCommandResponse;
import io.axoniq.axonserver.grpc.command.CommandProviderOutbound;
import io.axoniq.axonserver.grpc.command.CommandServiceGrpc;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.interceptor.InterceptorTimer;
import io.axoniq.axonserver.localstorage.file.AggregateWithoutSnapshotException;
import io.axoniq.axonserver.message.ByteStringMarshaller;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.topology.Topology;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.PreDestroy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service(value="CommandService")
public class CommandService
implements AxonServerClientService {
    private final MeterFactory d;
    private final Map<ClientStreamIdentification, GrpcCommandDispatcherListener> C;
    private final Topology E;
    private final Logger l;
    private final ClientIdRegistry f;
    private static final MethodDescriptor<CommandProviderOutbound, SerializedCommandProviderInbound> D;
    private final ContextProvider i;
    private final InstructionAckSource<SerializedCommandProviderInbound> a;
    private final AxonServerRoutingConfiguration B;
    private static final MethodDescriptor<ByteString, SerializedCommandResponse> e;
    private final CommandDispatcher A;
    private final AuthenticationProvider h;
    @Value(value="${axoniq.axonserver.command-threads:1}")
    private int L;
    private final ApplicationEventPublisher G;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, SerializedCommandResponse serializedCommandResponse, StreamObserver<SerializedCommandResponse> streamObserver) {
        CommandService a22 = serializedCommandResponse;
        CommandService a3 = this;
        try {
            void a4;
            void v0 = a4;
            v0.onNext((Object)a22);
            v0.onCompleted();
            return;
        }
        catch (RuntimeException a22) {
            void a5;
            a3.l.debug(AggregateWithoutSnapshotException.H((Object)"\t:(/41(:{+4\u007f832:5+{$&\u007f=>23>;"), (Object)a5, (Object)a22);
            return;
        }
    }

    @PreDestroy
    public void cleanup() {
        CommandService a2;
        a2.C.forEach((clientStreamIdentification, grpcCommandDispatcherListener) -> {
            ClientStreamIdentification a2 = grpcCommandDispatcherListener;
            ClientStreamIdentification a3 = clientStreamIdentification;
            a2.cancel();
        });
        a2.C.clear();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, StreamObserver streamObserver, SerializedCommandResponse serializedCommandResponse) {
        void a2;
        void a3;
        CommandService a4 = serializedCommandResponse;
        CommandService a5 = this;
        a5.H((String)a3, (SerializedCommandResponse)a4, (StreamObserver)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void dispatch(ByteString byteString, StreamObserver<SerializedCommandResponse> streamObserver) {
        void a2;
        CommandService a222 = byteString;
        CommandService a3 = this;
        a222 = new SerializedCommand((ByteString)a222);
        String string = a222.wrapped().getClientId();
        if (a3.l.isTraceEnabled()) {
            a3.l.trace(AggregateWithoutSnapshotException.H((Object)" \"a\u007f\t:8:2)>;{<426>5;a\u007f \""), (Object)string, (Object)a222.wrapped().getName());
        }
        try {
            CommandService commandService = a3;
            commandService.A.dispatch(commandService.i.getContext(), (Authentication)a3.h.get(), (SerializedCommand)a222, arg_0 -> a3.H(string, (StreamObserver)a2, arg_0));
            return;
        }
        catch (Exception a222) {
            Exception exception = a222;
            a3.l.warn(InterceptorTimer.H((Object)"LB{[i_kCaEo\u000bnJaGmO(\\a_`\u000b}EmSxNk_mO(NzYgY"), (Throwable)exception);
            a2.onError((Throwable)GrpcExceptionBuilder.build((Throwable)exception));
            return;
        }
    }

    static {
        e = CommandServiceGrpc.getDispatchMethod().toBuilder((MethodDescriptor.Marshaller)ByteStringMarshaller.H(), ProtoUtils.marshaller((Message)SerializedCommandResponse.getDefaultInstance())).build();
        D = CommandServiceGrpc.getOpenStreamMethod().toBuilder(ProtoUtils.marshaller((Message)CommandProviderOutbound.getDefaultInstance()), ProtoUtils.marshaller((Message)SerializedCommandProviderInbound.getDefaultInstance())).build();
    }

    public Set<GrpcCommandDispatcherListener> listeners() {
        CommandService a2;
        return new HashSet<GrpcCommandDispatcherListener>(a2.C.values());
    }

    /*
     * WARNING - void declaration
     */
    public StreamObserver<CommandProviderOutbound> openStream(StreamObserver<SerializedCommandProviderInbound> streamObserver) {
        void a2;
        CommandService commandService = this;
        String string = commandService.i.getContext();
        Object a3 = new ConcurrentHashMap();
        1 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        CommandService commandService2 = commandService;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private /* synthetic */ boolean H(InstructionAck instructionAck) {
        CommandService a2 = instructionAck;
        CommandService a3 = this;
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }

    public final ServerServiceDefinition bindService() {
        CommandService a2;
        return ServerServiceDefinition.builder((String)InterceptorTimer.H((Object)"aD&JpDfBy\u0005iSgE{Nz]mY&Lz[k\u0005kDeFiEl\u0005KDeFiElxmY~BkN")).addMethod(D, ServerCalls.asyncBidiStreamingCall(arg_0 -> a2.openStream(arg_0))).addMethod(e, ServerCalls.asyncUnaryCall((arg_0, arg_1) -> a2.dispatch(arg_0, arg_1))).build();
    }

    /*
     * WARNING - void declaration
     */
    public void completeStreamForInactivity(String string, ClientStreamIdentification clientStreamIdentification) {
        CommandService a2 = clientStreamIdentification;
        CommandService a3 = this;
        if (a3.C.containsKey(a2)) {
            void a4;
            String string2 = "Command stream inactivity for " + a2.E();
            string2 = new ApplicationInactivityException(string2);
            ((GrpcCommandDispatcherListener)a3.C.remove(a2)).cancelAndCompleteStreamExceptionally((Throwable)((Object)string2));
            CommandService commandService = a3;
            commandService.l.debug(InterceptorTimer.H((Object)"KDeFiEl\u000b[_zNiF(HdD{Nl\u000bnDz\u000bkGaNf_2\u000bsV"), (Object)a2);
            commandService.G.publishEvent((Object)new TopologyEvents.CommandHandlerDisconnected(a2.G(), (String)a4, a2.E()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public CommandService(Topology topology, CommandDispatcher commandDispatcher, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, MeterFactory meterFactory, ApplicationEventPublisher applicationEventPublisher, @Qualifier(value="commandInstructionAckSource") InstructionAckSource<SerializedCommandProviderInbound> instructionAckSource, AxonServerRoutingConfiguration axonServerRoutingConfiguration) {
        void instructionAckSource2;
        void eventPublisher;
        void meterFactory2;
        void clientIdRegistry2;
        void authenticationProvider2;
        void contextProvider2;
        void commandDispatcher2;
        void topology2;
        CommandService a2;
        CommandService commandService = commandService2;
        CommandService commandService2 = axonServerRoutingConfiguration;
        CommandService commandService3 = a2 = commandService;
        CommandService commandService4 = a2;
        CommandService commandService5 = a2;
        CommandService commandService6 = a2;
        CommandService commandService7 = a2;
        a2.l = LoggerFactory.getLogger(CommandService.class);
        CommandService commandService8 = a2;
        a2.C = new ConcurrentHashMap();
        commandService7.L = 1;
        commandService7.E = topology2;
        commandService6.A = commandDispatcher2;
        commandService6.i = contextProvider2;
        commandService5.h = authenticationProvider2;
        commandService5.f = clientIdRegistry2;
        commandService4.d = meterFactory2;
        commandService4.G = eventPublisher;
        commandService3.a = instructionAckSource2;
        commandService3.B = commandService2;
    }
}

