/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.AxonServerAccessController;
import io.axoniq.axonserver.LicenseAccessController;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AuthenticationInterceptor;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.grpc.LicenseInterceptor;
import io.axoniq.axonserver.integration.CommandHandlerController;
import io.axoniq.axonserver.localstorage.file.EventSourceNotFoundException;
import io.axoniq.axonserver.metric.MeterFactory;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerTransportFilter;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component(value="Gateway")
public class Gateway
implements SmartLifecycle {
    private final AxonServerAccessController E;
    private Server l;
    private boolean f;
    private final List<AxonServerClientService> D;
    private final List<ServerTransportFilter> i;
    private final ExecutorService a;
    private AdvancedTlsX509KeyManager.Closeable B;
    private final LicenseAccessController e;
    private final MeterFactory A;
    private final MessagingPlatformConfiguration h;
    private final Supplier<ScheduledExecutorService> L;
    private final Logger G;

    public void stop() {
        Gateway gateway = this;
        if (gateway.B != null) {
            gateway.B.close();
        }
        Gateway gateway2 = gateway;
        gateway2.a.shutdown();
        if (gateway2.f) {
            try {
                if (!gateway.l.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                    Gateway gateway3 = gateway;
                    gateway3.G.debug(EventSourceNotFoundException.H((Object)"\",\u0016 \u0001%\u0011/\b:D0\u0010,\u00143\r-\u0003c'/\u00110\u0010&\u0016c7&\u00165\u00011"));
                    gateway3.l.shutdownNow();
                }
            }
            catch (InterruptedException a2) {
                gateway.G.debug(CommandHandlerController.H((Object)"i)T\"R5U7T\"DgD2R.N \u00004H2T#O0NgO!\u0000\u0000r\u0017cgS\"R1E5"), (Throwable)a2);
                Thread.currentThread().interrupt();
            }
        }
        gateway.f = false;
        gateway.G.info(EventSourceNotFoundException.H((Object)"\u0002\u001c,\nc7&\u00165\u00011D\u0004\u00057\u00014\u0005:D0\u0010,\u00143\u0001'"));
    }

    public boolean isAutoStartup() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway a8 = gateway;
        a8((MessagingPlatformConfiguration)a7, (List)a6, (List)a5, (AxonServerAccessController)a4, (LicenseAccessController)a3, Executors::newSingleThreadScheduledExecutor, (MeterFactory)a2);
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, Supplier<ScheduledExecutorService> supplier, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        Gateway a9;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway gateway3 = a9 = gateway;
        Gateway gateway4 = a9;
        Gateway gateway5 = a9;
        Gateway gateway6 = a9;
        gateway6.G = LoggerFactory.getLogger(Gateway.class);
        gateway6.h = a8;
        gateway5.D = a7;
        gateway5.i = a6;
        gateway4.E = a5;
        gateway4.e = a4;
        a9.L = a3;
        gateway3.A = a2;
        gateway3.a = Executors.newFixedThreadPool(a9.h.getExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(CommandHandlerController.H((Object)"G5P$\r\"X\"C2T(Rj")));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        Gateway gateway = this;
        String string = CommandHandlerController.H((Object)"N(\u0000\u0014s\u000b");
        try {
            Gateway a2;
            Gateway gateway2;
            if (gateway.h.getSsl() != null && gateway.h.getSsl().isEnabled()) {
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                gateway.B = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile(new File(gateway.h.getSsl().getPrivateKeyFile()), new File(gateway.h.getSsl().getCertChainFile()), 1L, TimeUnit.MINUTES, (ScheduledExecutorService)gateway.L.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                ServerCredentials serverCredentials = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                string = EventSourceNotFoundException.H((Object)"\u00107\u000fD&\n\"\u0006/\u0001'");
                Gateway gateway3 = gateway;
                gateway2 = gateway3;
                a2 = NettyServerBuilder.forPort((int)gateway3.h.getPort(), (ServerCredentials)serverCredentials);
            } else {
                Gateway gateway4 = gateway;
                gateway2 = gateway4;
                a2 = NettyServerBuilder.forPort((int)gateway4.h.getPort());
            }
            if (gateway2.h.getMaxMessageSize() > 0) {
                a2.maxInboundMessageSize(gateway.h.getMaxMessageSize());
            }
            a2.permitKeepAliveWithoutCalls(true).permitKeepAliveTime(gateway.h.getMinKeepAliveTime(), TimeUnit.MILLISECONDS);
            gateway.D.forEach(arg_0 -> ((NettyServerBuilder)a2).addService(arg_0));
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(gateway.h.getGrpcBufferedMessages()));
            if (gateway.h.getAccesscontrol().isEnabled()) {
                Gateway gateway5 = gateway;
                a2.intercept((ServerInterceptor)new AuthenticationInterceptor(gateway5.E, gateway5.A));
            }
            a2.intercept((ServerInterceptor)new LicenseInterceptor(gateway.e));
            a2.intercept((ServerInterceptor)new ContextInterceptor());
            if (gateway.h.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(gateway.h.getKeepAliveTime(), TimeUnit.MILLISECONDS).keepAliveTimeout(gateway.h.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.executor((Executor)gateway.a);
            gateway.i.forEach(arg_0 -> ((NettyServerBuilder)a2).addTransportFilter(arg_0));
            gateway.l = a2.build();
            gateway.l.start();
            gateway.G.info(CommandHandlerController.H((Object)"a?O)\u0000\u0014E5V\"Rgg&T\"W&YgS3A5T\"DgO)\u00007O5T}\u0000<]g\rg[:"), (Object)gateway.h.getPort(), (Object)string);
            gateway.f = true;
            return;
        }
        catch (Exception exception) {
            throw new FailedToStartException(EventSourceNotFoundException.H((Object)"\u0010\u0010\"\u00167\r-\u0003c%;\u000b-D\u0010\u00011\u0012&\u0016c#\"\u0010&\u0013\"\u001dc\u0002\"\r/\u0001'"), (Throwable)exception);
        }
    }

    public int getPhase() {
        return 200;
    }

    public boolean isRunning() {
        Gateway a2;
        return a2.f;
    }
}

