/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc.heartbeat;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.Publisher;
import io.axoniq.axonserver.grpc.control.Heartbeat;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatPublisher;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.ContextClusterMetrics;
import io.axoniq.axonserver.rest.RestResponse;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.axonserver.heartbeat.enabled"}, matchIfMissing=true)
public class HeartbeatMonitor {
    private final ApplicationEventPublisher a;
    private final long B;
    private final Clock e;
    private final Map<ClientStreamIdentification, Instant> A;
    private final Logger h;
    private final Publisher<PlatformOutboundInstruction> L;
    private final Map<ClientStreamIdentification, ClientInformation> G;

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-initial-delay:5000}", fixedRateString="${axoniq.axonserver.client-heartbeat-frequency:1000}")
    public void sendHeartbeat() {
        HeartbeatMonitor a2;
        a2.L.publish((Object)PlatformOutboundInstruction.newBuilder().setHeartbeat(Heartbeat.newBuilder()).build());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(Instant instant, ClientStreamIdentification clientStreamIdentification, Instant instant2) {
        void a2;
        void a3;
        HeartbeatMonitor a4 = clientStreamIdentification;
        HeartbeatMonitor a5 = this;
        if (a3.isBefore((Instant)a2) && a5.G.containsKey(a4)) {
            ClientInformation clientInformation = (ClientInformation)a5.G.get(a4);
            String string = clientInformation.h;
            String string2 = clientInformation.G;
            Object[] objectArray = new Object[4];
            objectArray[0] = a5.B;
            objectArray[1] = a4;
            objectArray[2] = a3;
            objectArray[3] = a2;
            a5.h.info(RestResponse.H((Object)"eLOEHT\u0006IHAETOVOT_\u0000BEREETCD\u0006FIR\u0006MIRC\u0000RHGN\u0006[[\u0000KIJLOSCCINBS\b\u0000eLOEHT\u001c\u0000]]\n\u0000JAUTgCRIPIRY\u001c\u0000]]\n\u0000RIKEIUR\u001a\u0006[[\u000e\u0006"), objectArray);
            a5.a.publishEvent((Object)new TopologyEvents.ApplicationInactivityTimeout((ClientStreamIdentification)a4, string, new ClientContext(string2, clientInformation.L)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void H(BiConsumer biConsumer, PlatformService.ClientComponent clientComponent, PlatformInboundInstruction platformInboundInstruction) {
        void a2;
        BiConsumer a3 = clientComponent;
        BiConsumer a4 = biConsumer;
        a4.accept(new ClientStreamIdentification(a3.getContext(), a3.getClientStreamId()), a2);
    }

    public static String H(Object object) {
        Object object2 = object;
        object2 = (String)object2;
        int n = ((String)object2).length();
        int a2 = n - 1;
        char[] cArray = new char[n];
        int n2 = 1 << 3 ^ 3;
        int cfr_ignored_0 = (3 ^ 5) << 4 ^ (2 << 2 ^ 1);
        int n3 = a2;
        int n4 = 1;
        while (n3 >= 0) {
            int n5 = a2--;
            cArray[n5] = (char)(((String)object2).charAt(n5) ^ n4);
            if (a2 < 0) break;
            int n6 = a2--;
            cArray[n6] = (char)(((String)object2).charAt(n6) ^ n2);
            n3 = a2;
        }
        return new String(cArray);
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-check-initial-delay:10000}", fixedRateString="${axoniq.axonserver.client-heartbeat-check-rate:1000}")
    public void checkClientsStillAlive() {
        HeartbeatMonitor heartbeatMonitor;
        HeartbeatMonitor heartbeatMonitor2 = heartbeatMonitor = this;
        heartbeatMonitor2.h.debug(RestResponse.H((Object)"eHCCMIHG\u0006CINHEETCD\u0006CJICNRS\u0006ATE\u0006SRIJL\u0006AJIPE\b\u000e\b"));
        HeartbeatMonitor heartbeatMonitor3 = heartbeatMonitor;
        Object a2 = Instant.now(heartbeatMonitor2.e).minus(heartbeatMonitor3.B, ChronoUnit.MILLIS);
        heartbeatMonitor3.A.forEach((arg_0, arg_1) -> heartbeatMonitor.H((Instant)a2, arg_0, arg_1));
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        HeartbeatMonitor a2 = applicationDisconnected;
        HeartbeatMonitor a3 = this;
        a2 = new ClientStreamIdentification(a2.H(), a2.B());
        a3.A.remove(a2);
        a3.G.remove(a2);
        a3.h.debug(ContextClusterMetrics.H((Object)"z\u0007F\u0003\t\u001eF\u001d@\u0007F\u0001@\u001dNSA\u0016H\u0001]\u0011L\u0012]SO\u001c[SJ\u001f@\u0016G\u0007\t\bT]"), (Object)a2);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected applicationConnected) {
        HeartbeatMonitor a2 = applicationConnected;
        HeartbeatMonitor a3 = this;
        ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a2.E(), a2.H());
        a3.G.put(clientStreamIdentification, new ClientInformation(a2.B(), a2.g(), a2.E()));
    }

    private static /* synthetic */ void H(PlatformService platformService, BiConsumer biConsumer) {
        Object a2 = biConsumer;
        PlatformService a3 = platformService;
        a3.onInboundInstruction(PlatformInboundInstruction.RequestCase.HEARTBEAT, (arg_0, arg_1) -> HeartbeatMonitor.H((BiConsumer)a2, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    public HeartbeatMonitor(Consumer<BiConsumer<ClientStreamIdentification, PlatformInboundInstruction>> consumer, ApplicationEventPublisher applicationEventPublisher, Publisher<PlatformOutboundInstruction> publisher, long l2, Clock clock) {
        void a2;
        void a3;
        void a4;
        Object a5;
        void a6;
        HeartbeatMonitor heartbeatMonitor = object;
        Object object = clock;
        HeartbeatMonitor a7 = heartbeatMonitor;
        a7.h = LoggerFactory.getLogger(HeartbeatMonitor.class);
        HeartbeatMonitor heartbeatMonitor2 = a7;
        a7.G = new ConcurrentHashMap();
        HeartbeatMonitor heartbeatMonitor3 = a7;
        heartbeatMonitor2.A = new ConcurrentHashMap();
        a6.accept((clientStreamIdentification, platformInboundInstruction) -> {
            HeartbeatMonitor a2;
            HeartbeatMonitor a3 = clientStreamIdentification;
            HeartbeatMonitor heartbeatMonitor = a2 = this;
            heartbeatMonitor.h.trace(ContextClusterMetrics.H((Object)"a\u0016H\u0001]1L\u0012]S[\u0016J\u0016@\u0005L\u0017\t\u0015[\u001cDSR\u000e"), (Object)a3);
            heartbeatMonitor.A.put(a3, Instant.now(a2.e));
        });
        HeartbeatMonitor heartbeatMonitor4 = a7;
        HeartbeatMonitor heartbeatMonitor5 = a7;
        heartbeatMonitor5.e = a5;
        heartbeatMonitor5.a = a4;
        heartbeatMonitor4.B = a3;
        heartbeatMonitor4.L = a2;
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public HeartbeatMonitor(PlatformService platformService, HeartbeatPublisher heartbeatPublisher, ApplicationEventPublisher applicationEventPublisher, @Value(value="${axoniq.axonserver.client-heartbeat-timeout:5000}") long l2) {
        void a2;
        void heartbeatPublisher2;
        void platformService2;
        HeartbeatMonitor heartbeatMonitor = heartbeatMonitor2;
        HeartbeatMonitor heartbeatMonitor2 = applicationEventPublisher;
        HeartbeatMonitor eventPublisher = heartbeatMonitor;
        eventPublisher(arg_0 -> HeartbeatMonitor.H((PlatformService)platformService2, arg_0), (ApplicationEventPublisher)heartbeatMonitor2, (Publisher)heartbeatPublisher2, (long)a2, Clock.systemUTC());
    }
}

