/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage;

import io.axoniq.axonserver.admin.application.api.ClientApplication;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.event.multicontext.ContextRegistration;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.grpc.event.EventWithToken;
import io.axoniq.axonserver.grpc.event.GetAggregateEventsRequest;
import io.axoniq.axonserver.grpc.event.GetAggregateSnapshotsRequest;
import io.axoniq.axonserver.grpc.event.GetEventsRequest;
import io.axoniq.axonserver.grpc.event.GetTokenAtRequest;
import io.axoniq.axonserver.grpc.event.QueryEventsRequest;
import io.axoniq.axonserver.grpc.event.QueryEventsResponse;
import io.axoniq.axonserver.grpc.event.ReadHighestSequenceNrRequest;
import io.axoniq.axonserver.grpc.event.ReadHighestSequenceNrResponse;
import io.axoniq.axonserver.grpc.event.TrackingToken;
import io.axoniq.axonserver.interceptor.DefaultExecutionContext;
import io.axoniq.axonserver.interceptor.EventInterceptors;
import io.axoniq.axonserver.localstorage.A;
import io.axoniq.axonserver.localstorage.B;
import io.axoniq.axonserver.localstorage.DataFetcherSchedulerProvider;
import io.axoniq.axonserver.localstorage.DefaultEventDecorator;
import io.axoniq.axonserver.localstorage.EventDecorator;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventStoreFactory;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.G;
import io.axoniq.axonserver.localstorage.I;
import io.axoniq.axonserver.localstorage.IndexBackup;
import io.axoniq.axonserver.localstorage.J;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.localstorage.SerializedTransactionWithToken;
import io.axoniq.axonserver.localstorage.a;
import io.axoniq.axonserver.localstorage.file.AggregateWithoutSnapshotException;
import io.axoniq.axonserver.localstorage.file.EventStoreSchedulers;
import io.axoniq.axonserver.localstorage.h;
import io.axoniq.axonserver.localstorage.m;
import io.axoniq.axonserver.localstorage.query.QueryEventsRequestStreamObserver;
import io.axoniq.axonserver.localstorage.transaction.StorageTransactionManagerFactory;
import io.axoniq.axonserver.localstorage.transformation.EventStoreTransformer;
import io.axoniq.axonserver.message.event.EventStore;
import io.axoniq.axonserver.metric.DefaultMetricCollector;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricCollector;
import io.axoniq.axonserver.plugin.ExecutionContext;
import io.axoniq.axonserver.plugin.RequestRejectedException;
import io.grpc.stub.StreamObserver;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.EventListener;
import org.springframework.data.util.CloseableIterator;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Signal;
import reactor.core.scheduler.Schedulers;

@Component
public class LocalEventStore
implements EventStore,
EventStoreTransformer,
SmartLifecycle {
    private final ExecutorService M;
    private static final String j = "local_event_store";
    private final int K;
    private final EventStoreFactory k;
    private static final String m = "origin";
    private final Logger J;
    private static final String d = "stream";
    private final EventDecorator C;
    private final EventStoreSchedulers E;
    @Value(value="${axoniq.axonserver.new-permits-timeout:120000}")
    private long l;
    private final StorageTransactionManagerFactory f;
    private final ExecutorService D;
    private final EventInterceptors i;
    private final Map<String, J> a;
    private final MeterFactory B;
    @Value(value="${axoniq.axonserver.query.limit:200}")
    private long e;
    @Value(value="${axoniq.axonserver.check-sequence-nr-for-snapshots:true}")
    private boolean A;
    private static final String h = "context";
    @Value(value="${axoniq.axonserver.query.timeout:300000}")
    private long L;
    private volatile boolean G;

    public IndexBackup.BackupIndexResult backupIndex(IndexBackup.BackupIndexConfig backupIndexConfig) {
        LocalEventStore a2 = backupIndexConfig;
        LocalEventStore a3 = this;
        J j = a3.H(a2.context());
        if (a2.type() == EventType.L) {
            return j.d.backupIndex((IndexBackup.BackupIndexConfig)a2);
        }
        return j.J.backupIndex((IndexBackup.BackupIndexConfig)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, String string2, MonoSink monoSink) {
        void a2;
        void a3;
        LocalEventStore a4 = monoSink;
        LocalEventStore a5 = this;
        a5.H((String)a3, ReadHighestSequenceNrRequest.newBuilder().setAggregateId((String)a2).build(), (StreamObserver)new G(a5, (MonoSink)a4));
    }

    private static /* synthetic */ void H(IntConsumer intConsumer, Signal signal) {
        IntConsumer a2 = signal;
        IntConsumer a3 = intConsumer;
        if (a2.isOnNext()) {
            AtomicInteger atomicInteger = (AtomicInteger)a2.getContextView().get((Object)AggregateWithoutSnapshotException.H((Object)"\u0000\u0004\u001c\u0014\n\u0015\u000b\u001e\r"));
            atomicInteger.incrementAndGet();
            return;
        }
        if (a2.isOnComplete()) {
            AtomicInteger atomicInteger = (AtomicInteger)a2.getContextView().get((Object)ClientApplication.H((Object)"\u001f\u001d\u0003\r\u0015\f\u0014\u0007\u0012"));
            a3.accept(atomicInteger.get());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(GetAggregateSnapshotsRequest getAggregateSnapshotsRequest, String string, Authentication authentication, StreamObserver streamObserver) {
        void a2;
        LocalEventStore a3 = getAggregateSnapshotsRequest;
        LocalEventStore a4 = this;
        if (a3.getMaxSequence() >= 0L) {
            void a5;
            void a6;
            EventDecorator eventDecorator = a4.i.noSnapshotReadInterceptors((String)a6) ? a4.C : new I(a4, (String)a6, (Authentication)a5);
            a4.H((String)a6).f.H(a3.getAggregateId(), a3.getInitialSequence(), a3.getMaxSequence(), a3.getMaxResults(), arg_0 -> LocalEventStore.H((StreamObserver)a2, eventDecorator, arg_0));
        }
        a2.onCompleted();
    }

    /*
     * WARNING - void declaration
     */
    public Flux<Long> transformEvents(String string, int n, Flux<EventWithToken> flux) {
        void a2;
        void a3;
        Flux<EventWithToken> a4 = flux;
        Flux<EventWithToken> a5 = this;
        return ((J)a5.a.get((Object)a3)).J.transformContents((int)a2, a4).subscribeOn(Schedulers.fromExecutorService((ExecutorService)a5.M));
    }

    @Scheduled(fixedRateString="${axoniq.axonserver.event-processor-permits-check:2000}")
    public void checkPermits() {
        LocalEventStore a2;
        a2.a.forEach((string, j) -> {
            String a2 = j;
            String a3 = string;
            a2.G();
        });
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, Authentication authentication, GetAggregateSnapshotsRequest getAggregateSnapshotsRequest, StreamObserver<SerializedEvent> streamObserver) {
        StreamObserver<SerializedEvent> a2;
        void a3;
        void a4;
        void a5;
        StreamObserver<SerializedEvent> a6;
        StreamObserver<SerializedEvent> streamObserver2 = streamObserver3;
        StreamObserver<SerializedEvent> streamObserver3 = streamObserver;
        StreamObserver<SerializedEvent> streamObserver4 = a6 = streamObserver2;
        streamObserver4.H(() -> streamObserver4.H((GetAggregateSnapshotsRequest)a5, (String)a4, (Authentication)a3, a2), arg_0 -> a6.H((String)a4, (GetAggregateSnapshotsRequest)a5, a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ <T> Publisher<T> H(Flux<T> flux, IntConsumer intConsumer) {
        void a3;
        Object a4 = intConsumer;
        LocalEventStore a5 = this;
        ClientApplication.H((Object)"\u001f\u001d\u0003\r\u0015\f\u0014\u0007\u0012");
        return a3.doOnEach(arg_0 -> LocalEventStore.H((IntConsumer)a4, arg_0)).contextWrite(a2 -> a2.put((Object)ClientApplication.H((Object)"\u001f\u001d\u0003\r\u0015\f\u0014\u0007\u0012"), (Object)new AtomicInteger()));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(ExecutorService executorService, Runnable runnable, Consumer<Exception> consumer) {
        void a2;
        ExecutorService a222 = executorService;
        LocalEventStore a3 = this;
        try {
            void a4;
            a222.submit(() -> a3.H((Consumer)a2, (Runnable)a4));
            return;
        }
        catch (Exception a222) {
            a2.accept(a222);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleteContext(String string, boolean bl) {
        void a2;
        Object a3 = string;
        LocalEventStore a4 = this;
        if ((a3 = (J)a4.a.remove(a3)) == null) {
            return;
        }
        a3.H(a2 == false);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Publisher E(String string, DefaultExecutionContext defaultExecutionContext, Flux flux) {
        void a2;
        void a3;
        LocalEventStore a4 = flux;
        LocalEventStore a5 = this;
        return a5.E((String)a3, (DefaultExecutionContext)a2, (Flux)a4);
    }

    public Mono<Void> compact(String string) {
        Object a2 = string;
        LocalEventStore a3 = this;
        return a3.H((String)a2).H();
    }

    public int getPhase() {
        return 0;
    }

    public void deleteContext(String string) {
        Object a2 = string;
        LocalEventStore a3 = this;
        a3.deleteContext((String)a2, false);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, GetAggregateEventsRequest getAggregateEventsRequest, int n) {
        int a2 = n;
        LocalEventStore a3 = this;
        if (a2 == 0) {
            void a4;
            void a5;
            a3.J.debug(AggregateWithoutSnapshotException.H((Object)"$&e{\u001e<8):<>/:{14+{94*5;a\u007f \""), (Object)a5, (Object)a4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(DefaultExecutionContext defaultExecutionContext, List list) {
        void a2;
        Object a3 = list;
        LocalEventStore a4 = this;
        a4.i.interceptEventsPreCommit((List)a3, (ExecutionContext)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ StreamObserver<QueryEventsRequest> H(String string, Authentication authentication, StreamObserver<QueryEventsResponse> streamObserver) {
        void a2;
        void a3;
        void a4;
        LocalEventStore localEventStore;
        LocalEventStore localEventStore2 = localEventStore = this;
        LocalEventStore a5 = localEventStore2.H((String)a4);
        EventDecorator eventDecorator = localEventStore2.i.noEventReadInterceptors((String)a4) ? localEventStore.C : new I(localEventStore, (String)a4, (Authentication)a3);
        LocalEventStore localEventStore3 = a5;
        return new QueryEventsRequestStreamObserver(localEventStore3.J, localEventStore3.f, localEventStore.e, localEventStore.L, eventDecorator, (StreamObserver)a2, a5.d);
    }

    public long firstToken(String string) {
        Object a2 = string;
        LocalEventStore a3 = this;
        return a3.H((String)a2).J.getFirstToken();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(String string, GetTokenAtRequest getTokenAtRequest, StreamObserver streamObserver) {
        void a2;
        void a3;
        LocalEventStore a4 = streamObserver;
        LocalEventStore a5 = this;
        long l2 = a5.H((String)a3).A.H(a2.getInstant());
        a4.onNext((Object)TrackingToken.newBuilder().setToken(l2).build());
        a4.onCompleted();
    }

    public Mono<Void> deleteAllEventData(String string) {
        Object a2 = string;
        LocalEventStore a3 = this;
        return Mono.create(arg_0 -> a3.H((String)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono E(String string, Event event) {
        void a2;
        LocalEventStore a3 = event;
        LocalEventStore a4 = this;
        return a4.H((String)a2, (Event)a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, Throwable throwable) {
        void a2;
        Throwable a3 = throwable;
        LocalEventStore a4 = this;
        if (MessagingPlatformException.isClientException((Throwable)a3)) {
            a4.J.info(ClientApplication.H((Object)"9=x`\u000302%,$b3,!23*/6`$!+,'$b$7%b4-`!,+%,4b%:#'06)-.x`9="), (Object)a2, (Object)a3.getMessage());
            return;
        }
        a4.J.error(AggregateWithoutSnapshotException.H((Object)" \"a\u007f\u001a/+:5;{,5>+,30/\u007f=>23>;"), (Object)a2, (Object)a3);
    }

    /*
     * WARNING - void declaration
     */
    public Mono<Void> appendSnapshot(String string, Event event, Authentication authentication) {
        void a2;
        void a3;
        LocalEventStore a4 = authentication;
        LocalEventStore a5 = this;
        a4 = new DefaultExecutionContext((String)a3, (Authentication)a4);
        return Mono.just((Object)a2).publishOn(Schedulers.fromExecutorService((ExecutorService)a5.D)).doFirst(() -> a5.H((String)a3, (Event)a2)).map(arg_0 -> a5.H((Event)a2, (DefaultExecutionContext)a4, arg_0)).flatMap(arg_0 -> a5.E((String)a3, arg_0)).doOnSuccess(arg_0 -> a5.H((DefaultExecutionContext)a4, arg_0)).transform(arg_0 -> a5.H((String)a3, (DefaultExecutionContext)a4, arg_0)).transform(arg_0 -> a5.H((String)a3, arg_0)).then();
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    private /* synthetic */ Flux<Void> E(String string, DefaultExecutionContext defaultExecutionContext, Flux<Event> flux) {
        void a2;
        void a3;
        Flux<Event> a4 = flux;
        Flux<Event> a5 = this;
        return a4.buffer().transform(arg_0 -> a5.H((String)a3, (DefaultExecutionContext)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(String string, ReadHighestSequenceNrRequest readHighestSequenceNrRequest, StreamObserver streamObserver) {
        void a2;
        void a3;
        LocalEventStore a4 = streamObserver;
        LocalEventStore a5 = this;
        long l2 = a5.H((String)a3).f.H(a2.getAggregateId());
        a4.onNext((Object)ReadHighestSequenceNrResponse.newBuilder().setToSequenceNr(l2).build());
        a4.onCompleted();
    }

    /*
     * WARNING - void declaration
     */
    public void syncSnapshots(String string, long l2, int n, List<Event> list) {
        Object a2;
        void a3;
        void a4;
        void a5;
        LocalEventStore localEventStore = object;
        Object object = list;
        LocalEventStore a6 = localEventStore;
        a6.H((String)a5).D.H((long)a4, (int)a3, (List)a2);
    }

    /*
     * WARNING - void declaration
     */
    public Mono<Void> appendEvents(String string, Flux<SerializedEvent> flux, Authentication authentication) {
        void a2;
        void a3;
        LocalEventStore a4 = authentication;
        LocalEventStore a5 = this;
        a4 = new DefaultExecutionContext((String)a3, (Authentication)a4);
        return a2.publishOn(Schedulers.fromExecutorService((ExecutorService)a5.D)).map(SerializedEvent::H).map(arg_0 -> a5.H((DefaultExecutionContext)a4, arg_0)).transform(arg_0 -> a5.E((String)a3, (DefaultExecutionContext)a4, arg_0)).transform(arg_0 -> a5.H((DefaultExecutionContext)a4, arg_0)).transform(arg_0 -> a5.H((String)a3, arg_0)).then();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Event H(Event event, DefaultExecutionContext defaultExecutionContext, Event event2) {
        void a2;
        LocalEventStore a3 = defaultExecutionContext;
        LocalEventStore a4 = this;
        return a4.i.interceptSnapshot((Event)a2, (ExecutionContext)a3);
    }

    /*
     * WARNING - void declaration
     */
    public Stream<String> getBackupFilenames(String string, EventType eventType, long l2, int n, boolean bl) {
        void a2;
        void a3;
        void a4;
        LocalEventStore a52;
        block3: {
            void a6;
            LocalEventStore localEventStore = this;
            try {
                void a7;
                a52 = localEventStore.H((String)a6);
                if (a7 != EventType.L) break block3;
                return a52.d.getBackupFilenames((long)a4, (int)a3, (boolean)a2);
            }
            catch (Exception a52) {
                localEventStore.J.warn(AggregateWithoutSnapshotException.H((Object)" \"a\u007f\u001d>23>;{+4\u007f<:/\u007f9>84./{923>1:2>,"), (Object)a6, (Object)a52);
                return Stream.empty();
            }
        }
        return a52.J.getBackupFilenames((long)a4, (int)a3, (boolean)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, Authentication authentication, Flux flux, FluxSink fluxSink) {
        void a2;
        void a3;
        void a4;
        Object a5 = string;
        LocalEventStore a6 = this;
        a5 = a6.H((String)a5, (Authentication)a4, (StreamObserver)new B(a6, (FluxSink)a3));
        a2.subscribeOn(Schedulers.fromExecutorService((ExecutorService)a6.M)).subscribe(arg_0 -> ((StreamObserver)a5).onNext(arg_0), arg_0 -> ((StreamObserver)a5).onError(arg_0), () -> ((StreamObserver)a5).onCompleted());
    }

    /*
     * WARNING - void declaration
     */
    public CloseableIterator<SerializedTransactionWithToken> snapshotTransactionsIterator(String string, long l2, long l3) {
        void a2;
        void a3;
        Object a4 = string;
        LocalEventStore a5 = this;
        return ((J)a5.a.get((Object)a4)).d.transactionIterator((long)a3, (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    private /* synthetic */ Flux<Void> H(DefaultExecutionContext defaultExecutionContext, Flux<Void> flux) {
        void a3;
        LocalEventStore a4 = defaultExecutionContext;
        LocalEventStore a5 = this;
        return a3.doOnError(arg_0 -> a5.H((DefaultExecutionContext)a4, arg_0)).doOnError(arg_0 -> ((DefaultExecutionContext)a4).compensate(arg_0)).onErrorMap(RequestRejectedException.class, a2 -> new MessagingPlatformException(ErrorCode.EVENT_REJECTED_BY_INTERCEPTOR, ClientApplication.H((Object)"\u00054%,4b2'*'#6%&` 9b),4'2!%24-2"), (Throwable)a2)).onErrorMap(a2 -> {
            if (!a2.getClass().isAssignableFrom(MessagingPlatformException.class)) {
                return true;
            }
            return false;
        }, MessagingPlatformException::create);
    }

    /*
     * WARNING - void declaration
     */
    public Flux<QueryEventsResponse> queryEvents(String string, Flux<QueryEventsRequest> flux, Authentication authentication) {
        void a2;
        void a3;
        LocalEventStore a4 = authentication;
        LocalEventStore a5 = this;
        return Flux.create(arg_0 -> a5.H((String)a3, (Authentication)a4, (Flux)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, GetTokenAtRequest getTokenAtRequest, StreamObserver<TrackingToken> streamObserver) {
        void a2;
        void a3;
        StreamObserver<TrackingToken> a4;
        StreamObserver<TrackingToken> a5 = streamObserver;
        StreamObserver<TrackingToken> streamObserver2 = a4 = this;
        streamObserver2.H(() -> streamObserver2.E((String)a3, (GetTokenAtRequest)a2, a5), arg_0 -> a5.onError(arg_0));
    }

    public EventStorageEngine getSnapshotStorage(String string) {
        Object a2 = string;
        LocalEventStore a3 = this;
        return a3.H((String)a2).d;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Flux<Void> H(String string, Flux<Void> flux) {
        void a2;
        Flux<Void> a3 = flux;
        Flux<Void> a4 = this;
        return a3.name(ClientApplication.H((Object)"!20'.&\u001f140%#-")).tag(h, (String)a2).tag(d, AggregateWithoutSnapshotException.H((Object)">)>1/,")).tag(m, j).metrics();
    }

    public long size(String string) {
        Object a2 = string;
        LocalEventStore a3 = this;
        return a3.H((String)a2).H();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Publisher H(String string, Flux flux) {
        void a2;
        LocalEventStore a3 = flux;
        LocalEventStore a4 = this;
        return a4.H((String)a2, (Flux)a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(DefaultExecutionContext defaultExecutionContext, Event event) {
        void a2;
        LocalEventStore a3 = event;
        LocalEventStore a4 = this;
        a4.i.interceptSnapshotPostCommit((Event)a3, (ExecutionContext)a2);
    }

    public long firstSnapshotToken(String string) {
        Object a2 = string;
        LocalEventStore a3 = this;
        return a3.H((String)a2).d.getFirstToken();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void H(StreamObserver streamObserver, EventDecorator eventDecorator, SerializedEvent serializedEvent) {
        void a2;
        StreamObserver a3 = serializedEvent;
        StreamObserver a4 = streamObserver;
        a4.onNext((Object)a2.decorateEvent((SerializedEvent)a3));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Publisher H(String string, DefaultExecutionContext defaultExecutionContext, Flux flux) {
        void a2;
        void a3;
        LocalEventStore a4 = flux;
        LocalEventStore a5 = this;
        return a5.H((String)a3, (DefaultExecutionContext)a2, (Flux)a4);
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<Long> getHighestSequenceNr(String string, String string2, int n, long l2) {
        void a2;
        void a3;
        void a4;
        void a5;
        LocalEventStore localEventStore = this;
        Object a6 = new CompletableFuture();
        LocalEventStore localEventStore2 = localEventStore;
        localEventStore2.H(() -> localEventStore2.H((CompletableFuture)a6, (String)a5, (String)a4, (int)a3, (long)a2), ((CompletableFuture)a6)::completeExceptionally);
        return a6;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, Authentication authentication, boolean bl, Flux flux, FluxSink fluxSink) {
        void a2;
        void a3;
        void a4;
        void a5;
        Object a6 = string;
        LocalEventStore a7 = this;
        a6 = a7.H((String)a6, (Authentication)a5, (boolean)a4, (StreamObserver)new a(a7, (FluxSink)a3));
        a2.subscribeOn(Schedulers.fromExecutorService((ExecutorService)a7.M)).subscribe(arg_0 -> ((StreamObserver)a6).onNext(arg_0), arg_0 -> ((StreamObserver)a6).onError(arg_0), () -> ((StreamObserver)a6).onCompleted());
    }

    public long getLastEvent(String string) {
        Object a2 = string;
        LocalEventStore a3 = this;
        return a3.H((String)a2).J.getLastToken();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ J H(String string) {
        void a2;
        LocalEventStore localEventStore = this;
        LocalEventStore a3 = (J)localEventStore.a.get(a2);
        if (a3 == null) {
            throw new MessagingPlatformException(ErrorCode.NO_EVENTSTORE, "Missing worker for context: " + (String)a2);
        }
        return a3;
    }

    public boolean isRunning() {
        LocalEventStore a2;
        return a2.G;
    }

    /*
     * WARNING - void declaration
     */
    public Mono<Long> highestSequenceNumber(String string, String string2) {
        void a2;
        Object a3 = string2;
        LocalEventStore a4 = this;
        return Mono.create(arg_0 -> a4.H((String)a2, (String)a3, arg_0));
    }

    public long getWaitingSnapshotTransactions(String string) {
        Object a2 = string;
        LocalEventStore a3 = this;
        return a3.H((String)a2).C.H();
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    private /* synthetic */ Mono<Event> H(String string, Event event) {
        void a2;
        LocalEventStore a3 = event;
        LocalEventStore a4 = this;
        return a4.H((String)a2).C.H((Event)a3).thenReturn((Object)a3);
    }

    public boolean activeContext(String string) {
        Object a2 = string;
        LocalEventStore a3 = this;
        if (a3.a.containsKey(a2) && ((J)a3.a.get((Object)a2)).a) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public CloseableIterator<SerializedTransactionWithToken> eventTransactionsIterator(String string, long l2, long l3) {
        void a2;
        void a3;
        Object a4 = string;
        LocalEventStore a5 = this;
        return a5.H((String)a4).J.transactionIterator((long)a3, (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(Runnable runnable, Consumer<Exception> consumer) {
        void a2;
        LocalEventStore a3;
        Object a4 = consumer;
        LocalEventStore localEventStore = a3 = this;
        localEventStore.H(localEventStore.M, (Runnable)a2, (Consumer)a4);
    }

    public Mono<Long> lastEventToken(String string) {
        Object a2 = string;
        LocalEventStore a3 = this;
        return Mono.just((Object)a3.H((String)a2).J.getLastToken());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Publisher H(String string, DefaultExecutionContext defaultExecutionContext, Mono mono) {
        void a2;
        void a3;
        LocalEventStore a4 = mono;
        LocalEventStore a5 = this;
        return a5.H((String)a3, (DefaultExecutionContext)a2, (Mono)a4);
    }

    /*
     * WARNING - void declaration
     */
    public LocalEventStore(EventStoreFactory eventStoreFactory, MeterRegistry meterRegistry, StorageTransactionManagerFactory storageTransactionManagerFactory, EventInterceptors eventInterceptors, ContextRegistration contextRegistration, EventStoreSchedulers eventStoreSchedulers) {
        LocalEventStore a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        LocalEventStore localEventStore = localEventStore2;
        LocalEventStore localEventStore2 = eventStoreSchedulers;
        LocalEventStore a8 = localEventStore;
        a8((EventStoreFactory)a7, new MeterFactory((MeterRegistry)a6, (MetricCollector)new DefaultMetricCollector()), (StorageTransactionManagerFactory)a5, (EventInterceptors)a4, (ContextRegistration)a3, (EventDecorator)new DefaultEventDecorator(), 1000, 24, 8, (EventStoreSchedulers)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono<Event> H(String string, Mono<Event> mono) {
        void a2;
        Mono<Event> a3 = mono;
        Mono<Event> a4 = this;
        return a3.name(ClientApplication.H((Object)"!20'.&\u001f140%#-")).tag(h, (String)a2).tag(d, AggregateWithoutSnapshotException.H((Object)",5>+,30/,")).tag(m, j).metrics();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, ReadHighestSequenceNrRequest readHighestSequenceNrRequest, StreamObserver<ReadHighestSequenceNrResponse> streamObserver) {
        void a2;
        void a3;
        StreamObserver<ReadHighestSequenceNrResponse> a4;
        StreamObserver<ReadHighestSequenceNrResponse> a5 = streamObserver;
        StreamObserver<ReadHighestSequenceNrResponse> streamObserver2 = a4 = this;
        streamObserver2.H(() -> streamObserver2.E((String)a3, (ReadHighestSequenceNrRequest)a2, a5), arg_0 -> a5.onError(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, GetAggregateSnapshotsRequest getAggregateSnapshotsRequest, StreamObserver streamObserver, Exception exception) {
        void a2;
        Object a3;
        void a4;
        void a5;
        LocalEventStore localEventStore = object;
        Object object = exception;
        LocalEventStore a6 = localEventStore;
        Object[] objectArray = new Object[3];
        objectArray[0] = a5;
        objectArray[1] = a4.getAggregateId();
        objectArray[2] = a3;
        a6.J.warn(ClientApplication.H((Object)";?zb\u00100/ ,'-b%,#-5,4'2'$b7*).%b2'!&),'b3,!23*/6`$/0`#'%2''#4'`9="), objectArray);
        a2.onError((Throwable)a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Event H(DefaultExecutionContext defaultExecutionContext, Event event) {
        void a2;
        LocalEventStore a3 = event;
        LocalEventStore a4 = this;
        return a4.i.interceptEvent((Event)a3, (ExecutionContext)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Publisher H(String string, Mono mono) {
        void a2;
        LocalEventStore a3 = mono;
        LocalEventStore a4 = this;
        return a4.H((String)a2, (Mono)a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(String string, Event event) {
        void a2;
        long l2;
        LocalEventStore a3 = event;
        LocalEventStore a4 = this;
        if (a4.A && (l2 = a4.H((String)a2).f.H(a3.getAggregateIdentifier())) < a3.getAggregateSequenceNumber()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.getAggregateIdentifier();
            objectArray[1] = l2;
            objectArray[2] = a3.getAggregateSequenceNumber();
            throw new MessagingPlatformException(ErrorCode.INVALID_SEQUENCE, String.format(AggregateWithoutSnapshotException.H((Object)"\u00165):32;{,>..:5<>\u007f5*6=>-{(367:{,/0)658{,5>+,30/q{\u0017283:(+{><8):<>/:{z(\u007f(:**>18:{1.29:)e{z?s{,5>+,30/\u007f(:**>18:{z?q"), objectArray));
        }
    }

    public long getLastSnapshot(String string) {
        Object a2 = string;
        LocalEventStore a3 = this;
        return a3.H((String)a2).d.getLastToken();
    }

    /*
     * WARNING - void declaration
     */
    public long getFirstCompletedSegment(String string, EventType eventType) {
        void a2;
        Object a3 = string;
        LocalEventStore a4 = this;
        if (EventType.h.equals((Object)a2)) {
            return a4.H((String)a3).J.getFirstCompletedSegment();
        }
        return a4.H((String)a3).d.getFirstCompletedSegment();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, Authentication authentication, GetAggregateSnapshotsRequest getAggregateSnapshotsRequest, FluxSink fluxSink) {
        LocalEventStore a2;
        void a3;
        void a4;
        void a5;
        LocalEventStore localEventStore = localEventStore2;
        LocalEventStore localEventStore2 = fluxSink;
        LocalEventStore a6 = localEventStore;
        a6.H((String)a5, (Authentication)a4, (GetAggregateSnapshotsRequest)a3, (StreamObserver)new h(a6, (FluxSink)a2));
    }

    /*
     * WARNING - void declaration
     */
    public Flux<SerializedEventWithToken> events(String string, Authentication authentication, boolean bl, Flux<GetEventsRequest> flux) {
        Flux<GetEventsRequest> a2;
        void a3;
        void a4;
        void a5;
        Flux<GetEventsRequest> flux2 = flux3;
        Flux<GetEventsRequest> flux3 = flux;
        Flux<GetEventsRequest> a6 = flux2;
        return Flux.create(arg_0 -> a6.H((String)a5, (Authentication)a4, (boolean)a3, a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public void syncEvents(String string, long l2, int n, List<Event> list) {
        Object a2;
        void a3;
        void a4;
        void a5;
        LocalEventStore localEventStore = object;
        Object object = list;
        LocalEventStore a6 = localEventStore;
        J j = a6.H((String)a5);
        j.i.H((long)a4, (int)a3, (List)a2);
        j.H();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(DefaultExecutionContext defaultExecutionContext, Throwable throwable) {
        void a2;
        Throwable a3 = throwable;
        LocalEventStore a4 = this;
        if (MessagingPlatformException.isClientException((Throwable)a3)) {
            a4.J.info(AggregateWithoutSnapshotException.H((Object)"$&e{\u001a)-4-{08<.-):?\u007f?*)658{,/0):{=:+87{0+:)>/641{;.:{+4\u007f832:5+{:#<>//641a\u007f \""), (Object)a2.contextName(), (Object)a3.getMessage());
            return;
        }
        a4.J.error(ClientApplication.H((Object)";?zb\u000502-2b/!#720%&`&50),'b36/0%b\"#4!(b/2%0!6)-.x`"), (Object)a2.contextName(), (Object)a3);
    }

    /*
     * WARNING - void declaration
     */
    public Mono<Long> eventTokenAt(String string, Instant instant) {
        void a2;
        Object a3 = instant;
        LocalEventStore a4 = this;
        return Mono.create(arg_0 -> a4.H((String)a2, (Instant)a3, arg_0));
    }

    public Mono<Long> firstEventToken(String string) {
        Object a2 = string;
        LocalEventStore a3 = this;
        return Mono.just((Object)a3.H((String)a2).A.H());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono<Event> H(String string, DefaultExecutionContext defaultExecutionContext, Mono<Event> mono) {
        void a3;
        void a4;
        Mono<Event> a5 = mono;
        Mono<Event> a6 = this;
        return a5.doOnError(arg_0 -> a6.H((String)a4, arg_0)).doOnError(arg_0 -> ((DefaultExecutionContext)a3).compensate(arg_0)).onErrorMap(RequestRejectedException.class, a2 -> new MessagingPlatformException(ErrorCode.SNAPSHOT_REJECTED_BY_INTERCEPTOR, AggregateWithoutSnapshotException.H((Object)"\b1:/(74+{->5></:?\u007f9&{65+>-8:++4-"), (Throwable)a2)).onErrorMap(a2 -> {
            if (!a2.getClass().isAssignableFrom(MessagingPlatformException.class)) {
                return true;
            }
            return false;
        }, MessagingPlatformException::create);
    }

    /*
     * WARNING - void declaration
     */
    public CloseableIterator<SerializedEventWithToken> eventIterator(String string, long l2) {
        void a2;
        Object a3 = string;
        LocalEventStore a4 = this;
        return a4.H((String)a3).J.getGlobalIterator((long)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(List list, DefaultExecutionContext defaultExecutionContext, Void void_) {
        void a2;
        LocalEventStore a3 = defaultExecutionContext;
        LocalEventStore a4 = this;
        a4.i.interceptEventsPostCommit((List)a2, (ExecutionContext)a3);
    }

    /*
     * WARNING - void declaration
     */
    public void initContext(String string2, boolean bl, long l2, long l3) {
        void a2;
        LocalEventStore localEventStore = this;
        try {
            void a3;
            void a4;
            void a5;
            LocalEventStore a6 = localEventStore.a.computeIfAbsent(a2, string -> {
                Object a2 = string;
                LocalEventStore a3 = this;
                return new J(a3, (String)a2);
            });
            a6.H((boolean)a5, (long)a4, (long)a3);
            return;
        }
        catch (IllegalArgumentException a6) {
            return;
        }
        catch (RuntimeException a6) {
            localEventStore.a.remove(a2);
            throw a6;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Publisher H(DefaultExecutionContext defaultExecutionContext, Flux flux) {
        void a2;
        LocalEventStore a3 = flux;
        LocalEventStore a4 = this;
        return a4.H((DefaultExecutionContext)a2, (Flux)a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, MonoSink monoSink) {
        void a2;
        LocalEventStore localEventStore = this;
        try {
            void a3;
            LocalEventStore a4 = (J)localEventStore.a.remove(a3);
            if (a4 != null) {
                a4.H(true);
                localEventStore.initContext((String)a3, false, 0L, 0L);
            }
            a2.success();
            return;
        }
        catch (Exception a4) {
            a2.error((Throwable)a4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Publisher H(String string, DefaultExecutionContext defaultExecutionContext, List list) {
        void a2;
        void a3;
        Object a4 = list;
        LocalEventStore a5 = this;
        return a5.H((String)a3).E.H((List)a4).doOnSuccess(arg_0 -> a5.H((List)a4, (DefaultExecutionContext)a2, arg_0));
    }

    public void stop() {
        LocalEventStore a2;
        LocalEventStore localEventStore = a2;
        localEventStore.G = false;
        localEventStore.M.shutdown();
        localEventStore.D.shutdown();
        localEventStore.a.forEach((string, j) -> {
            String a2 = j;
            String a3 = string;
            a2.H(false);
        });
        try {
            LocalEventStore localEventStore2 = a2;
            localEventStore2.D.awaitTermination(10L, TimeUnit.SECONDS);
            localEventStore2.M.awaitTermination(10L, TimeUnit.SECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(Consumer consumer, Runnable runnable) {
        void a2;
        Runnable a222 = runnable;
        LocalEventStore a3 = this;
        if (!a3.G) {
            a2.accept(new RejectedExecutionException(AggregateWithoutSnapshotException.H((Object)"\u001c:150/\u007f70:;{:-:5+(q{\u001e#05\f>--:)\u007f2,{,3*/+21<\u007f?0,1")));
            return;
        }
        try {
            a222.run();
            return;
        }
        catch (Exception a222) {
            a2.accept(a222);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Flux<SerializedEvent> aggregateEvents(String string, Authentication authentication, GetAggregateEventsRequest getAggregateEventsRequest) {
        void a2;
        void a3;
        LocalEventStore a4 = getAggregateEventsRequest;
        LocalEventStore a5 = this;
        EventDecorator eventDecorator = a5.i.noReadInterceptors((String)a3) ? a5.C : new I(a5, (String)a3, (Authentication)a2);
        return a5.H((String)a3).f.H(a4.getAggregateId(), a4.getAllowSnapshots(), a4.getInitialSequence(), a5.H((GetAggregateEventsRequest)a4), a4.getMinToken()).map(arg_0 -> ((EventDecorator)eventDecorator).decorateEvent(arg_0)).subscribeOn(Schedulers.fromExecutorService((ExecutorService)a5.M)).transform(arg_0 -> a5.H((String)a3, (GetAggregateEventsRequest)a4, arg_0)).name(ClientApplication.H((Object)"'6'.6\u001f140%#-")).tag(h, (String)a3).tag(d, AggregateWithoutSnapshotException.H((Object)":8<->8:+>\u0000>)>1/,")).tag(m, j).metrics();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, Event event) {
        void a2;
        LocalEventStore a3 = event;
        LocalEventStore a4 = this;
        a4.E((String)a2, (Event)a3);
    }

    public long getWaitingEventTransactions(String string) {
        Object a2 = string;
        LocalEventStore a3 = this;
        return a3.H((String)a2).E.H();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ StreamObserver<GetEventsRequest> H(String string, Authentication authentication, boolean bl, StreamObserver<SerializedEventWithToken> streamObserver) {
        StreamObserver<SerializedEventWithToken> a2;
        void a3;
        void a4;
        void a5;
        StreamObserver<SerializedEventWithToken> streamObserver2 = streamObserver3;
        StreamObserver<SerializedEventWithToken> streamObserver3 = streamObserver;
        StreamObserver<SerializedEventWithToken> a6 = streamObserver2;
        return new A(a6, (String)a5, (Authentication)a4, (boolean)a3, a2);
    }

    /*
     * WARNING - void declaration
     */
    public Flux<SerializedEvent> aggregateSnapshots(String string, Authentication authentication, GetAggregateSnapshotsRequest getAggregateSnapshotsRequest) {
        void a2;
        void a3;
        LocalEventStore a4 = getAggregateSnapshotsRequest;
        LocalEventStore a5 = this;
        return Flux.create(arg_0 -> a5.H((String)a3, (Authentication)a2, (GetAggregateSnapshotsRequest)a4, arg_0));
    }

    private /* synthetic */ long H(GetAggregateEventsRequest getAggregateEventsRequest) {
        LocalEventStore a2 = getAggregateEventsRequest;
        LocalEventStore a3 = this;
        if (a2.getMaxSequence() > 0L) {
            return a2.getMaxSequence();
        }
        return Long.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    private /* synthetic */ Flux<Void> H(String string, DefaultExecutionContext defaultExecutionContext, Flux<List<Event>> flux) {
        void a2;
        void a3;
        LocalEventStore a4 = defaultExecutionContext;
        LocalEventStore a5 = this;
        return a3.doOnNext(arg_0 -> a5.H((DefaultExecutionContext)a4, arg_0)).concatMap(arg_0 -> a5.H((String)a2, (DefaultExecutionContext)a4, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public LocalEventStore(EventStoreFactory eventStoreFactory, MeterFactory meterFactory, StorageTransactionManagerFactory storageTransactionManagerFactory, EventInterceptors eventInterceptors, ContextRegistration contextRegistration, EventDecorator eventDecorator, @Value(value="${axoniq.axonserver.blacklisted-send-after:1000}") int n, @Value(value="${axoniq.axonserver.data-fetcher-threads:24}") int n2, @Value(value="${axoniq.axonserver.data-writer-threads:8}") int n3, EventStoreSchedulers eventStoreSchedulers) {
        void eventDecorator2;
        void writerThreads;
        void a2;
        void fetcherThreads;
        void blacklistedSendAfter;
        void eventInterceptors2;
        void storageTransactionManagerFactory2;
        void meterFactory2;
        void eventStoreFactory2;
        LocalEventStore eventStoreManager;
        LocalEventStore localEventStore = localEventStore2;
        LocalEventStore localEventStore2 = contextRegistration;
        LocalEventStore localEventStore3 = eventStoreManager = localEventStore;
        LocalEventStore localEventStore4 = eventStoreManager;
        LocalEventStore localEventStore5 = eventStoreManager;
        LocalEventStore localEventStore6 = eventStoreManager;
        eventStoreManager.J = LoggerFactory.getLogger(LocalEventStore.class);
        LocalEventStore localEventStore7 = eventStoreManager;
        eventStoreManager.a = new ConcurrentHashMap();
        localEventStore6.e = 200L;
        localEventStore6.L = 300000L;
        localEventStore5.l = 120000L;
        localEventStore5.A = true;
        localEventStore4.k = eventStoreFactory2;
        localEventStore4.B = meterFactory2;
        localEventStore3.f = storageTransactionManagerFactory2;
        localEventStore3.i = eventInterceptors2;
        localEventStore3.K = blacklistedSendAfter;
        eventStoreManager.M = Executors.newFixedThreadPool((int)fetcherThreads, (ThreadFactory)new CustomizableThreadFactory(AggregateWithoutSnapshotException.H((Object)";:+:r=:/<3:)r")));
        eventStoreManager.E = a2;
        DataFetcherSchedulerProvider.H((ExecutorService)eventStoreManager.M);
        eventStoreManager.D = Executors.newFixedThreadPool((int)writerThreads, (ThreadFactory)new CustomizableThreadFactory(ClientApplication.H((Object)"&!6!o70)6%0m")));
        eventStoreManager.C = eventDecorator2;
        localEventStore2.onContextRegistered((context, initOptions) -> {
            void a2;
            LocalEventStore a3 = initOptions;
            LocalEventStore a4 = this;
            if (!a2.isDcbContext()) {
                a4.initContext(a2.getName(), a3.validating(), a3.firstEventToken(), a3.firstSnapshotToken());
            }
        });
        localEventStore2.onContextDeregistered((context, bl) -> {
            void a2;
            Boolean a3 = bl;
            LocalEventStore a4 = this;
            a4.deleteContext(a2.getName(), a3.booleanValue());
        });
        localEventStore2.onContextPurged(arg_0 -> eventStoreManager.deleteAllEventData(arg_0));
    }

    @EventListener
    public void on(ClusterEvents.ContextLeaderStepDown contextLeaderStepDown) {
        LocalEventStore a2 = contextLeaderStepDown;
        LocalEventStore a3 = this;
        if ((a2 = (J)a3.a.get(a2.context())) == null) {
            return;
        }
        a2.E();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(CompletableFuture completableFuture, String string, String string2, int n, long l2) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        int n2 = n;
        LocalEventStore a7 = this;
        a6.complete(a7.H((String)a5).f.H((String)a4, (int)a3, (long)a2));
    }

    public void start() {
        a.G = true;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Publisher H(String string, GetAggregateEventsRequest getAggregateEventsRequest, Flux flux) {
        void a2;
        void a3;
        LocalEventStore a4;
        LocalEventStore a5 = flux;
        LocalEventStore localEventStore = a4 = this;
        return localEventStore.H((Flux)a5, arg_0 -> localEventStore.H((String)a3, (GetAggregateEventsRequest)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(String string, Instant instant, MonoSink monoSink) {
        void a2;
        void a3;
        LocalEventStore a4 = monoSink;
        LocalEventStore a5 = this;
        a5.H((String)a3, GetTokenAtRequest.newBuilder().setInstant(a2.toEpochMilli()).build(), (StreamObserver)new m(a5, (MonoSink)a4));
    }
}

