/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.IndexBackup;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.stream.Stream;
import reactor.core.publisher.Mono;

public interface IndexManager {
    public long size();

    public boolean removeAllVersions(long var1);

    default public IndexBackup.BackupIndexResult backupIndex(IndexBackup.BackupIndexConfig backupIndexConfig) {
        IndexManager a2 = backupIndexConfig;
        IndexManager a3 = this;
        throw new UnsupportedOperationException("Backing up the index via this method is not supported for " + a3.getClass().getSimpleName());
    }

    public List<File> indexFiles(FileVersion var1);

    public void addExistingIndex(FileVersion var1);

    public void addToActiveSegment(long var1, String var3, IndexEntry var4);

    public void complete(FileVersion var1);

    public void addToActiveSegment(Long var1, Map<String, List<IndexEntry>> var2);

    default public boolean canBatchIndexParallel() {
        return false;
    }

    default public void complete(long a2) {
        IndexManager a3;
        a3.complete(new FileVersion(a2, 0));
    }

    public void createIndex(FileVersion var1, Map<String, List<IndexEntry>> var2);

    public SegmentIndexEntries lastIndexEntries(String var1, long var2);

    public boolean validIndex(FileVersion var1);

    public boolean remove(FileVersion var1);

    public Stream<File> getBackupFilenames(long var1, int var3);

    public Mono<Void> activateVersion(FileVersion var1);

    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String var1, long var2, long var4, long var6, long var8, long var10);

    @Nonnull
    public SortedMap<FileVersion, IndexEntries> lookupAggregateInClosedSegments(String var1, long var2, long var4, long var6, long var8, long var10);

    public Optional<Long> getLastSequenceNumber(String var1, EventStorageEngine.SearchHint var2, long var3);

    /*
     * WARNING - void declaration
     */
    default public SortedMap<FileVersion, IndexEntries> lookupAggregate(String string, long l2, long l3, long l4, long l5) {
        void a2;
        void a3;
        void a4;
        void a5;
        Object a6 = string;
        IndexManager a7 = this;
        return a7.lookupAggregate((String)a6, (long)a5, (long)a4, (long)a3, (long)a2, 0L);
    }

    public Mono<Void> activateVersion(FileVersion var1, File var2);

    public Stream<AggregateIndexEntries> latestSequenceNumbers(FileVersion var1);

    public SegmentIndexEntries lastIndexEntriesFromClosedSegments(String var1, long var2, long var4);

    public void createNewVersion(long var1, int var3, Map<String, List<IndexEntry>> var4);

    public void cleanup(boolean var1);

    default public void removeFromGlobalIndex(long a2) {
    }

    default public boolean limitedSegmentChecks() {
        return false;
    }

    public void init();
}

