/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.config.AxonServerEnterpriseConfiguration;
import io.axoniq.axonserver.enterprise.ContextResourceCleaner;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.I;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.localstorage.file.PersistedBloomFilter;
import io.axoniq.axonserver.localstorage.file.RemoteAggregateSequenceNumberResolver;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntriesSerializer;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class StandardIndexManager
implements IndexManager {
    private ScheduledFuture<?> j;
    private final RemoteAggregateSequenceNumberResolver K;
    protected final Supplier<StorageProperties> k;
    private final ConcurrentSkipListMap<FileVersion, I> m;
    protected final String J;
    private static final String d = "aggregateMap";
    private final Counter C;
    private final MeterFactory.RateMeter E;
    private static final ScheduledExecutorService l;
    private static final Logger f;
    private final String D;
    private final ConcurrentNavigableMap<Long, Map<String, IndexEntries>> i;
    private final ConcurrentNavigableMap<Long, Integer> a;
    private final Counter B;
    private final MeterFactory.RateMeter e;
    private final EventType A;
    private final Supplier<IndexManager> h;
    private final ConcurrentNavigableMap<FileVersion, PersistedBloomFilter> L;
    private final AtomicLong G;

    /*
     * WARNING - void declaration
     */
    public Optional<Long> H(String string, int n, long l2) {
        void a52222;
        void a52222;
        void a2;
        Map map;
        void a3;
        void a4;
        StandardIndexManager standardIndexManager = this;
        int n2 = 0;
        for (Long a52222 : standardIndexManager.i.descendingKeySet()) {
            if (n2 >= a4) {
                return Optional.empty();
            }
            if (a52222 > a3 || (map = (Map)standardIndexManager.i.get(a52222)) == null) continue;
            IndexEntries indexEntries = (IndexEntries)map.get(a2);
            if (indexEntries != null) {
                return Optional.of(indexEntries.lastSequenceNumber());
            }
            ++n2;
        }
        for (Map.Entry a52222 : standardIndexManager.a.entrySet()) {
            if (n2 >= a4) {
                return Optional.empty();
            }
            if ((Long)a52222.getKey() > a3) continue;
            map = standardIndexManager.H(new FileVersion(((Long)a52222.getKey()).longValue(), ((Integer)a52222.getValue()).intValue()), (String)a2);
            if (map != null) {
                return Optional.of(map.lastSequenceNumber());
            }
            ++n2;
        }
        Iterator<Object> iterator = (StandardIndexManager)standardIndexManager.h.get();
        Optional a52222 = Optional.empty();
        if (iterator != null) {
            Optional a52222 = iterator.H((String)a2, (int)(a4 - n2), (long)a3);
        }
        if (a52222.isEmpty() && standardIndexManager.K != null && n2 < a4 && !standardIndexManager.a.isEmpty()) {
            StandardIndexManager standardIndexManager2 = standardIndexManager;
            Optional a52222 = standardIndexManager2.K.getLastSequenceNumber(standardIndexManager2.J, (String)a2, (int)(a4 - n2), (Long)standardIndexManager.a.keySet().last() - 1L);
        }
        return a52222;
    }

    private /* synthetic */ I E(FileVersion fileVersion2) {
        StandardIndexManager a2 = fileVersion2;
        StandardIndexManager a3 = this;
        try {
            return a3.m.computeIfAbsent(a2, fileVersion -> {
                StandardIndexManager a2 = fileVersion;
                StandardIndexManager a3 = this;
                return new I(a3, (FileVersion)a2);
            }).H();
        }
        catch (IndexNotFoundException indexNotFoundException) {
            a2 = (I)a3.m.remove(a2);
            if (a2 != null) {
                a2.close();
            }
            throw indexNotFoundException;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void H(Map map, String string2, List list) {
        void a2;
        List a3 = list;
        Map a4 = map;
        a4.computeIfAbsent(a2, string -> {
            String a2 = string;
            List a3 = a3;
            return new StandardIndexEntries(((IndexEntry)a3.get(0)).H());
        }).addAll(a3);
    }

    /*
     * WARNING - void declaration
     */
    public SegmentIndexEntries lastIndexEntries(String string, long l2) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        for (Long l3 : standardIndexManager.i.descendingKeySet()) {
            StandardIndexManager a4 = (IndexEntries)((Map)standardIndexManager.i.get(l3)).get(a3);
            if (a4 == null || a4.firstSequenceNumber() >= a2) continue;
            StandardIndexManager standardIndexManager2 = a4;
            return new SegmentIndexEntries(new FileVersion(l3.longValue(), 0), standardIndexManager2.range(standardIndexManager2.firstSequenceNumber(), (long)a2, EventType.L.equals((Object)standardIndexManager.A)));
        }
        if (!standardIndexManager.a.isEmpty()) {
            return standardIndexManager.lastIndexEntriesFromClosedSegments((String)a3, (long)a2, ((Long)standardIndexManager.a.keySet().first()).longValue());
        }
        return null;
    }

    private /* synthetic */ void E() {
        StandardIndexManager a2;
        StandardIndexManager standardIndexManager = a2;
        standardIndexManager.G.set(standardIndexManager.a.keySet().stream().skip(((StorageProperties)a2.k.get()).getMaxIndexesInMemory()).findFirst().orElse(-1L));
    }

    private /* synthetic */ boolean H(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return ((StorageProperties)a3.k.get()).dataFile(a3.D, (FileVersion)a2).exists();
    }

    /*
     * WARNING - void declaration
     */
    public SegmentIndexEntries lastIndexEntriesFromClosedSegments(String string, long l2, long l3) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        for (Map.Entry entry : standardIndexManager.a.entrySet()) {
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            StandardIndexManager a4 = standardIndexManager.H(fileVersion, (String)a3);
            if (a4 == null || a4.firstSequenceNumber() >= a2) continue;
            StandardIndexManager standardIndexManager2 = a4;
            return new SegmentIndexEntries(fileVersion, standardIndexManager2.range(standardIndexManager2.firstSequenceNumber(), (long)a2, EventType.L.equals((Object)standardIndexManager.A)));
        }
        IndexManager a5 = (IndexManager)standardIndexManager.h.get();
        if (a5 != null) {
            return a5.lastIndexEntriesFromClosedSegments((String)a3, (long)a2, (Long)standardIndexManager.a.keySet().last() - 1L);
        }
        return null;
    }

    private static /* synthetic */ void H(Map.Entry a2) {
        ((I)a2.getValue()).close();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void E(FileVersion fileVersion, Map<String, IndexEntries> map) {
        DBMaker.Maker maker;
        void a2;
        File file;
        Map a3;
        StorageProperties storageProperties;
        StandardIndexManager standardIndexManager;
        block14: {
            DBMaker.Maker maker2;
            block9: {
                DBMaker.Maker maker3;
                block13: {
                    block12: {
                        block11: {
                            standardIndexManager = this;
                            storageProperties = (StorageProperties)standardIndexManager.k.get();
                            if (a3 == null) {
                                a3 = Collections.emptyMap();
                            }
                            if (!FileUtils.H((File)(file = storageProperties.indexTemp(standardIndexManager.D, a2.H())))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + file);
                            }
                            maker2 = DBMaker.fileDB((File)file);
                            if (!storageProperties.isUseMmapIndex()) break block11;
                            maker2.fileMmapEnable();
                            if (!storageProperties.isForceCleanMmapIndex()) break block12;
                            DBMaker.Maker maker4 = maker2;
                            maker3 = maker4;
                            maker4.cleanerHackEnable();
                            break block13;
                        }
                        maker2.fileChannelEnable();
                    }
                    maker3 = maker2;
                }
                maker2 = maker3.make();
                StandardIndexManager a4 = maker2.hashMap(d, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.H()).createOrOpen();
                try {
                    a4.putAll(a3);
                    if (a4 == null) break block9;
                    maker = maker2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block10: {
                        if (a4 != null) {
                            try {
                                a4.close();
                                throwable2 = throwable;
                                break block10;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                a4.close();
                break block14;
            }
            maker = maker2;
        }
        maker.close();
        try {
            CopyOption[] copyOptionArray = new CopyOption[1];
            copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            Files.move(file.toPath(), storageProperties.index(standardIndexManager.D, (FileVersion)a2).toPath(), copyOptionArray);
        }
        catch (IOException a4) {
            throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to rename index file" + storageProperties.index(standardIndexManager.D, (FileVersion)a2), (Throwable)a4);
        }
        StandardIndexManager standardIndexManager2 = a4 = new PersistedBloomFilter(storageProperties.bloomFilter(standardIndexManager.D, (FileVersion)a2).getAbsolutePath(), a3.keySet().size(), storageProperties.getBloomIndexFpp());
        standardIndexManager2.G();
        standardIndexManager2.H(a3.keySet());
        standardIndexManager2.H();
        standardIndexManager.L.put(a2, a4);
        standardIndexManager.a.put(a2.H(), a2.H());
        standardIndexManager.E((FileVersion)a2);
    }

    /*
     * WARNING - void declaration
     */
    public Stream<File> getBackupFilenames(long l2, int n) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        StandardIndexManager a4 = (StorageProperties)standardIndexManager.k.get();
        return standardIndexManager.a.entrySet().stream().filter(arg_0 -> StandardIndexManager.H((long)a3, (int)a2, arg_0)).flatMap(arg_0 -> standardIndexManager.H((StorageProperties)a4, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono H(FileVersion fileVersion) {
        void a2;
        StandardIndexManager standardIndexManager = this;
        Object a3 = ((StorageProperties)standardIndexManager.k.get()).transformedIndex(standardIndexManager.D, (FileVersion)a2);
        return standardIndexManager.activateVersion((FileVersion)a2, (File)a3);
    }

    public boolean validIndex(FileVersion fileVersion) {
        block3: {
            boolean bl;
            StandardIndexManager a2;
            block4: {
                a2 = fileVersion;
                StandardIndexManager a3 = this;
                if (!a3.a.containsKey(a2.H()) || ((Integer)a3.a.get(a2.H())).intValue() != a2.H()) break block3;
                if (a3.H((FileVersion)a2) == null || a3.E((FileVersion)a2) == null) break block4;
                return true;
            }
            try {
                bl = false;
            }
            catch (Exception exception) {
                f.warn(ContextResourceCleaner.H((Object)"J\u0016e\u001bi\u0013,\u0003cWz\u0016`\u001eh\u0016x\u0012,\u001eb\u0013i\u000f,\u0011c\u0005,\u0004i\u0010a\u0012b\u00036Ww\n"), (Object)a2, (Object)exception);
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ int H(long l2, long l3, SortedMap<FileVersion, IndexEntries> sortedMap, FileVersion fileVersion, IndexEntries indexEntries) {
        void a2;
        void a3;
        StandardIndexManager a4;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntries;
        StandardIndexManager a5 = standardIndexManager;
        if (!(a4 = a4.range((long)a3, (long)a2, EventType.L.equals((Object)a5.A))).isEmpty()) {
            void a6;
            void a7;
            a7.put(a6, a4);
        }
        return a4.size();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void H(Long l2, String string, List list) {
        void a3;
        void a4;
        Object a5 = list;
        StandardIndexManager a6 = this;
        a6.i.computeIfAbsent(a4, a2 -> new ConcurrentHashMap()).computeIfAbsent(a3, arg_0 -> StandardIndexManager.E((List)a5, arg_0)).addAll((List)a5);
    }

    public void addExistingIndex(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        a3.a.put(a2.H(), a2.H());
        a3.E();
    }

    /*
     * WARNING - void declaration
     */
    public SortedMap<FileVersion, IndexEntries> lookupAggregateInClosedSegments(String string, long l2, long l3, long l4, long l5, long l6) {
        void a2;
        void a3;
        void a4;
        void a5;
        long a6;
        IndexManager indexManager;
        StandardIndexManager standardIndexManager = this;
        TreeMap a7 = new TreeMap();
        IndexManager indexManager2 = indexManager = standardIndexManager.a.entrySet().iterator();
        while (indexManager2.hasNext()) {
            Map.Entry entry = indexManager.next();
            if (a6 < a5) {
                return a7;
            }
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            IndexEntries indexEntries = standardIndexManager.H(fileVersion, (String)a4);
            Object[] objectArray = new Object[4];
            objectArray[0] = standardIndexManager.J;
            objectArray[1] = a4;
            objectArray[2] = entry;
            objectArray[3] = indexEntries;
            f.debug(AxonServerEnterpriseConfiguration.H((Object)"\u0014\u0000U]\u0003\u0012\u0000\u0016\u001a\r.\u001a\b\u000f\n\u001a\u000e\t\n]\u0014\u0000O\u0014\u0001]\u001c\u0018\b\u0010\n\u0013\u001b]\u0014\u0000O\u001b\u0000\b\u0001\u0019O\u0006\u0012"), objectArray);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager2 = standardIndexManager;
                int n = standardIndexManager2.H((long)a3, (long)a2, (SortedMap)a7, fileVersion, indexEntries);
                if (standardIndexManager2.H((long)a3, (long)(a8 -= (long)n), indexEntries)) {
                    return a7;
                }
            }
            a6 = (Long)entry.getKey();
            indexManager2 = indexManager;
        }
        indexManager = (IndexManager)standardIndexManager.h.get();
        if (indexManager != null) {
            void a8;
            a7.putAll(indexManager.lookupAggregateInClosedSegments((String)a4, (long)a3, (long)a2, (long)a8, (long)a5, a6));
        }
        return a7;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono<Void> H(FileVersion fileVersion, File file) {
        void a3;
        StandardIndexManager a4 = fileVersion;
        StandardIndexManager a5 = this;
        return Mono.fromSupplier(() -> a5.H((FileVersion)a4)).filter(a2 -> {
            if (!a2.exists()) {
                return true;
            }
            return false;
        }).flatMap(arg_0 -> StandardIndexManager.H((File)a3, arg_0)).doOnSuccess(arg_0 -> a5.H((FileVersion)a4, arg_0));
    }

    public Mono<Void> activateVersion(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return Mono.defer(() -> a3.H((FileVersion)a2));
    }

    /*
     * WARNING - void declaration
     */
    public Mono<Void> activateVersion(FileVersion fileVersion, File file) {
        void a2;
        StandardIndexManager a3 = fileVersion;
        StandardIndexManager a4 = this;
        if (a4.a.containsKey(a3.H())) {
            return a4.H((FileVersion)a3, (File)a2);
        }
        IndexManager indexManager = (IndexManager)a4.h.get();
        if (indexManager != null) {
            return indexManager.activateVersion((FileVersion)a3, (File)a2);
        }
        return Mono.empty();
    }

    private static /* synthetic */ boolean H(long l2, int n, Map.Entry entry) {
        long a2;
        Map.Entry a3 = entry;
        int a4 = n;
        if ((Long)a3.getKey() > a2 || (Integer)a3.getValue() > a4) {
            return true;
        }
        return false;
    }

    private static /* synthetic */ IndexEntries E(List list, String string) {
        String a2 = string;
        List a3 = list;
        return new StandardIndexEntries(((IndexEntry)a3.get(0)).H());
    }

    /*
     * WARNING - void declaration
     */
    public void addToActiveSegment(Long l2, Map<String, List<IndexEntry>> map) {
        void a2;
        Object a3 = l2;
        StandardIndexManager a4 = this;
        if (a4.a.containsKey(a3)) {
            throw new IndexNotFoundException((Long)a3 + ": already completed");
        }
        a2.forEach((arg_0, arg_1) -> a4.H((Long)a3, arg_0, arg_1));
    }

    public List<File> indexFiles(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        File[] fileArray = new File[2];
        fileArray[0] = ((StorageProperties)a3.k.get()).index(a3.D, (FileVersion)a2);
        fileArray[1] = ((StorageProperties)a3.k.get()).bloomFilter(a3.D, (FileVersion)a2);
        return Arrays.asList(fileArray);
    }

    public boolean remove(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        I i2 = (I)a3.m.remove(a2);
        if (i2 != null) {
            i2.close();
        }
        StandardIndexManager standardIndexManager = a3;
        standardIndexManager.L.remove(a2);
        if (FileUtils.H((File)((StorageProperties)standardIndexManager.k.get()).index(a3.D, (FileVersion)a2)) && FileUtils.H((File)((StorageProperties)a3.k.get()).bloomFilter(a3.D, (FileVersion)a2))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void createIndex(FileVersion fileVersion, Map<String, List<IndexEntry>> map) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        Object a4 = new HashMap();
        a3.forEach((arg_0, arg_1) -> StandardIndexManager.H((Map)a4, arg_0, arg_1));
        standardIndexManager.H((FileVersion)a2, (Map)a4);
    }

    /*
     * WARNING - void declaration
     */
    public void cleanup(boolean bl) {
        void a2;
        StandardIndexManager standardIndexManager;
        StandardIndexManager standardIndexManager2 = standardIndexManager = this;
        standardIndexManager2.i.clear();
        standardIndexManager2.L.clear();
        standardIndexManager2.m.forEach((fileVersion, i2) -> {
            FileVersion a2 = i2;
            FileVersion a3 = fileVersion;
            a2.close();
        });
        StandardIndexManager standardIndexManager3 = standardIndexManager;
        standardIndexManager3.m.clear();
        if (standardIndexManager3.j != null && !standardIndexManager.j.isDone()) {
            standardIndexManager.j.cancel(true);
        }
        if (a2 != false) {
            standardIndexManager.a.keySet().forEach(arg_0 -> standardIndexManager.removeAllVersions(arg_0));
        }
        StandardIndexManager standardIndexManager4 = standardIndexManager;
        standardIndexManager4.a.clear();
        StandardIndexManager a3 = (IndexManager)standardIndexManager4.h.get();
        if (a3 != null) {
            a3.cleanup((boolean)a2);
        }
    }

    public void complete(FileVersion fileVersion) {
        StandardIndexManager a2;
        StandardIndexManager a3 = fileVersion;
        StandardIndexManager standardIndexManager = a2 = this;
        standardIndexManager.E((FileVersion)a3, (Map)standardIndexManager.i.get(a3.H()));
        a2.i.remove(a3.H());
        a2.E();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean H(long l2, long l3, IndexEntries indexEntries) {
        void a2;
        void a3;
        StandardIndexManager a4;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntries;
        StandardIndexManager a5 = standardIndexManager;
        if (!a4.isEmpty() && a3 >= a4.firstSequenceNumber() || a2 <= 0L) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, MeterFactory meterFactory, Supplier<IndexManager> supplier2) {
        Object a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        StandardIndexManager standardIndexManager = object;
        Object object = supplier2;
        StandardIndexManager a8 = standardIndexManager;
        a8((String)a7, (Supplier)a6, (String)a5, (EventType)a4, null, (MeterFactory)a3, (Supplier)a2);
    }

    private /* synthetic */ File H(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return ((StorageProperties)a3.k.get()).index(a3.D, (FileVersion)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void H(FileVersion fileVersion, Map<String, IndexEntries> map) {
        void a2;
        StandardIndexManager a3 = this;
        StandardIndexManager a4 = fileVersion;
        if (a3.H((FileVersion)a4)) {
            a3.E((FileVersion)a4, (Map)a2);
            return;
        }
        StandardIndexManager standardIndexManager = (StandardIndexManager)a3.h.get();
        if (standardIndexManager != null) {
            standardIndexManager.H((FileVersion)a4, (Map)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ IndexEntries H(FileVersion fileVersion, String string) {
        int n;
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        if (standardIndexManager.H((FileVersion)a3, (String)a2)) {
            return null;
        }
        RuntimeException runtimeException = new RuntimeException();
        int n2 = n = 0;
        while (true) {
            if (n2 >= 3) break;
            try {
                StandardIndexManager a4 = standardIndexManager.E((FileVersion)a3);
                return a4.H((String)a2);
            }
            catch (IndexNotFoundException a4) {
                return null;
            }
            catch (Exception a4) {
                runtimeException = new RuntimeException("Error happened while trying get positions for " + a3.H() + " segment.", a4);
                n2 = ++n;
                continue;
            }
            break;
        }
        throw runtimeException;
    }

    public Stream<AggregateIndexEntries> latestSequenceNumbers(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return a3.E((FileVersion)a2).H();
    }

    private static /* synthetic */ IndexEntries H(IndexEntry indexEntry, String string) {
        Object a2 = string;
        IndexEntry a3 = indexEntry;
        return new StandardIndexEntries(a3.H());
    }

    private static /* synthetic */ Integer H(FileVersion fileVersion, Long l2, Integer n) {
        Integer a2 = n;
        FileVersion a3 = fileVersion;
        return a2 == null ? a3.H() : Math.max(a3.H(), a2);
    }

    private /* synthetic */ void H(FileVersion fileVersion, Void void_) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        a3.a.put(a2.H(), a2.H());
    }

    public void init() {
        int n;
        StandardIndexManager standardIndexManager = this;
        StorageProperties storageProperties = (StorageProperties)standardIndexManager.k.get();
        String[] stringArray = FileUtils.H((File)new File(standardIndexManager.D), (String)storageProperties.getIndexSuffix());
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            StandardIndexManager a2 = FileUtils.H((String)stringArray[n]);
            if (storageProperties.dataFile(standardIndexManager.D, (FileVersion)a2).exists()) {
                standardIndexManager.a.compute(a2.H(), (arg_0, arg_1) -> StandardIndexManager.H((FileVersion)a2, arg_0, arg_1));
            } else {
                standardIndexManager.remove((FileVersion)a2);
            }
            n3 = ++n;
        }
        standardIndexManager.E();
    }

    /*
     * WARNING - void declaration
     */
    public void addToActiveSegment(long l2, String string, IndexEntry indexEntry) {
        StandardIndexManager a3;
        void a4;
        void a5;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntry;
        StandardIndexManager a6 = standardIndexManager;
        if (a6.a.containsKey((long)a5)) {
            throw new IndexNotFoundException((long)a5 + ": already completed");
        }
        a6.i.computeIfAbsent((long)a5, a2 -> new ConcurrentHashMap()).computeIfAbsent(a4, arg_0 -> StandardIndexManager.H((IndexEntry)a3, arg_0)).add((IndexEntry)a3);
    }

    /*
     * WARNING - void declaration
     */
    public void createNewVersion(long l2, int n, Map<String, List<IndexEntry>> map) {
        StandardIndexManager standardIndexManager;
        HTreeMap hTreeMap;
        Map<String, List> a2;
        FileVersion a222;
        StandardIndexManager standardIndexManager2;
        block12: {
            StandardIndexManager a3;
            block7: {
                StandardIndexManager standardIndexManager3;
                block11: {
                    block10: {
                        block9: {
                            void a222;
                            void a4;
                            standardIndexManager2 = this;
                            a222 = new FileVersion((long)a4, (int)a222);
                            if (a2 == null) {
                                a2 = Collections.emptyMap();
                            }
                            if (!FileUtils.H((File)(a4 = ((StorageProperties)standardIndexManager2.k.get()).transformedIndex(standardIndexManager2.D, a222)))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + a4);
                            }
                            a3 = DBMaker.fileDB((File)a4);
                            if (!((StorageProperties)standardIndexManager2.k.get()).isUseMmapIndex()) break block9;
                            a3.fileMmapEnable();
                            if (!((StorageProperties)standardIndexManager2.k.get()).isForceCleanMmapIndex()) break block10;
                            StandardIndexManager standardIndexManager4 = a3;
                            standardIndexManager3 = standardIndexManager4;
                            standardIndexManager4.cleanerHackEnable();
                            break block11;
                        }
                        a3.fileChannelEnable();
                    }
                    standardIndexManager3 = a3;
                }
                a3 = standardIndexManager3.make();
                hTreeMap = a3.hashMap(d, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.H()).createOrOpen();
                try {
                    a2.forEach((string, list) -> {
                        void a2;
                        int n;
                        List a3 = list;
                        HTreeMap a4 = hTreeMap;
                        IndexEntry indexEntry = (IndexEntry)a3.get(0);
                        Integer[] integerArray = new Integer[a3.size()];
                        int n2 = n = 0;
                        while (n2 < a3.size()) {
                            int n3 = n++;
                            integerArray[n3] = ((IndexEntry)a3.get(n3)).H();
                            n2 = n;
                        }
                        a4.put((Object)a2, (Object)new StandardIndexEntries(indexEntry.H(), integerArray));
                    });
                    if (hTreeMap == null) break block7;
                    standardIndexManager = a3;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block8: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block8;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block12;
            }
            standardIndexManager = a3;
        }
        standardIndexManager.close();
        HTreeMap hTreeMap2 = hTreeMap = new PersistedBloomFilter(((StorageProperties)standardIndexManager2.k.get()).bloomFilter(standardIndexManager2.D, a222).getAbsolutePath(), a2.keySet().size(), ((StorageProperties)standardIndexManager2.k.get()).getBloomIndexFpp());
        hTreeMap2.G();
        hTreeMap2.H(a2.keySet());
        hTreeMap2.H();
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, MeterFactory meterFactory) {
        StandardIndexManager a2;
        void a3;
        void a4;
        void a5;
        void a6;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = meterFactory;
        StandardIndexManager a7 = standardIndexManager;
        a7((String)a6, (Supplier)a5, (String)a4, (EventType)a3, null, (MeterFactory)a2, () -> null);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Stream H(StorageProperties storageProperties, Map.Entry entry) {
        void a2;
        Map.Entry a3 = entry;
        StandardIndexManager a4 = this;
        File[] fileArray = new File[2];
        fileArray[0] = a2.index(a4.D, ((Long)a3.getKey()).longValue());
        fileArray[1] = a2.bloomFilter(a4.D, ((Long)a3.getKey()).longValue());
        return Stream.of(fileArray);
    }

    /*
     * WARNING - void declaration
     */
    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String string, long l2, long l3, long l4, long l5, long l6) {
        void a2;
        void a3;
        Iterator iterator;
        void a4;
        void a5;
        void a6;
        StandardIndexManager standardIndexManager = this;
        TreeMap<FileVersion, IndexEntries> a7 = new TreeMap<FileVersion, IndexEntries>();
        Object[] objectArray = new Object[4];
        objectArray[0] = standardIndexManager.J;
        objectArray[1] = a6;
        objectArray[2] = (long)a5;
        objectArray[3] = (long)a4;
        f.debug(AxonServerEnterpriseConfiguration.H((Object)"\u0006\u0012GO\u0011\u0000\u0012\u0004\b\u001f<\b\u001a\u001d\u0018\b\u001c\u001b\u0018O\u0006\u0012]\u0002\u0014\u0001.\n\f\u001a\u0018\u0001\u001e\n3\u001a\u0010\r\u0018\u001d]\u0014\u0000C]\u0003\u001c\u001c\t<\u0018\u001e\b\n\u0013\f\u0018!\b\u0002\u001f\n\u000fO\u0006\u0012"), objectArray);
        long l7 = Long.MAX_VALUE;
        Iterator iterator2 = iterator = standardIndexManager.i.descendingKeySet().iterator();
        while (iterator2.hasNext()) {
            Long a8 = (Long)iterator.next();
            if (l7 < a3) {
                return a7;
            }
            IndexEntries indexEntries = (IndexEntries)standardIndexManager.i.getOrDefault(a8, Collections.emptyMap()).get(a6);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager2 = standardIndexManager;
                int n = standardIndexManager2.H((long)a5, (long)a4, a7, new FileVersion(a8.longValue(), 0), indexEntries);
                if (standardIndexManager2.H((long)a5, (long)(a2 -= (long)n), indexEntries)) {
                    return a7;
                }
            }
            l7 = a8;
            iterator2 = iterator;
        }
        TreeMap<FileVersion, IndexEntries> treeMap = a7;
        treeMap.putAll(standardIndexManager.lookupAggregateInClosedSegments((String)a6, (long)a5, (long)a4, (long)a2, (long)a3, l7));
        return treeMap;
    }

    static {
        f = LoggerFactory.getLogger(StandardIndexManager.class);
        l = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(ContextResourceCleaner.H((Object)"e\u0019h\u0012tZa\u0016b\u0016k\u0012~Z")));
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, RemoteAggregateSequenceNumberResolver remoteAggregateSequenceNumberResolver, MeterFactory meterFactory, Supplier<IndexManager> supplier2) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        StandardIndexManager a8;
        Object a9 = string;
        StandardIndexManager standardIndexManager = a8 = this;
        StandardIndexManager standardIndexManager2 = a8;
        StandardIndexManager standardIndexManager3 = a8;
        StandardIndexManager standardIndexManager4 = a8;
        a8.i = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager5 = a8;
        standardIndexManager4.L = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager6 = a8;
        a8.m = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager7 = a8;
        standardIndexManager3.a = new ConcurrentSkipListMap(Comparator.reverseOrder());
        StandardIndexManager standardIndexManager8 = a8;
        standardIndexManager3.G = new AtomicLong();
        standardIndexManager3.k = a7;
        standardIndexManager2.D = a6;
        standardIndexManager2.J = a9;
        standardIndexManager.A = a5;
        standardIndexManager.K = a4;
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a9;
        stringArray[2] = "type";
        stringArray[3] = a5.name();
        a9 = Tags.of((String[])stringArray);
        StandardIndexManager standardIndexManager9 = a8;
        void v10 = a3;
        a8.e = a3.rateMeter((MetricName)BaseMetricName.Ca, (Tags)a9);
        a8.E = v10.rateMeter((MetricName)BaseMetricName.j, (Tags)a9);
        standardIndexManager9.C = v10.counter((MetricName)BaseMetricName.O, (Tags)a9);
        standardIndexManager9.B = a3.counter((MetricName)BaseMetricName.Ea, (Tags)a9);
        l.scheduleAtFixedRate(() -> {
            Object a2;
            StandardIndexManager standardIndexManager = this;
            StorageProperties storageProperties = (StorageProperties)standardIndexManager.k.get();
            StandardIndexManager standardIndexManager2 = standardIndexManager;
            while (standardIndexManager2.m.size() > storageProperties.getMaxIndexesInMemory()) {
                a2 = standardIndexManager.m.pollFirstEntry();
                f.debug(ContextResourceCleaner.H((Object)"w\n6WO\u001bc\u0004e\u0019kWe\u0019h\u0012tWw\n"), (Object)standardIndexManager.J, a2.getKey());
                standardIndexManager.j = l.schedule(() -> StandardIndexManager.H((Map.Entry)a2), 2L, TimeUnit.SECONDS);
                standardIndexManager2 = standardIndexManager;
            }
            StandardIndexManager standardIndexManager3 = standardIndexManager;
            while (standardIndexManager3.L.size() > storageProperties.getMaxBloomFiltersInMemory()) {
                StandardIndexManager standardIndexManager4 = standardIndexManager;
                standardIndexManager3 = standardIndexManager4;
                a2 = standardIndexManager4.L.pollFirstEntry();
                StandardIndexManager standardIndexManager5 = standardIndexManager;
                f.debug(AxonServerEnterpriseConfiguration.H((Object)"\u0014\u0000U]=\u0018\u0002\u0012\u0019\u0018\u000b]\r\u0011\u0000\u0012\u0002]\t\u0014\u0003\t\n\u000fO\u001b\u0000\u000fO\u0006\u0012]\t\u000f\u0000\u0010O\u0010\n\u0010\u0000\u000f\u0016"), (Object)standardIndexManager5.J, a2.getKey());
                standardIndexManager5.B.increment();
            }
        }, 10L, 10L, TimeUnit.SECONDS);
        a8.h = a2;
    }

    /*
     * WARNING - void declaration
     */
    public Optional<Long> getLastSequenceNumber(String string, EventStorageEngine.SearchHint searchHint, long l2) {
        void a2;
        void a3;
        StandardIndexManager a222 = searchHint;
        StandardIndexManager a4 = this;
        int a222 = a222.equals((Object)EventStorageEngine.SearchHint.G) ? ((StorageProperties)a4.k.get()).segmentsForSequenceNumberCheck() : Integer.MAX_VALUE;
        return a4.H((String)a3, a222, (long)a2);
    }

    private static /* synthetic */ Mono H(File file, File file2) {
        File a2 = file2;
        File a3 = file;
        return Mono.fromSupplier(() -> a3).filter(File::exists).switchIfEmpty(Mono.error((Throwable)new RuntimeException())).flatMap(file3 -> {
            File a2 = a2;
            File a3 = a3;
            return FileUtils.H((File)a3, (File)a2);
        });
    }

    public long size() {
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAllVersions(long l2) {
        Integer n;
        void a2;
        StandardIndexManager standardIndexManager = this;
        StorageProperties storageProperties = (StorageProperties)standardIndexManager.k.get();
        if (standardIndexManager.i.remove((long)a2) == null && (n = (Integer)standardIndexManager.a.remove((long)a2)) != null) {
            FileVersion fileVersion;
            int a222;
            int n2 = a222 = 0;
            while (n2 < n) {
                fileVersion = new FileVersion((long)a2, a222);
                if (storageProperties.index(standardIndexManager.D, fileVersion).exists()) {
                    standardIndexManager.remove(fileVersion);
                }
                n2 = ++a222;
            }
            FileVersion a222 = new FileVersion((long)a2, n.intValue());
            fileVersion = (I)standardIndexManager.m.remove(a222);
            if (fileVersion != null) {
                fileVersion.close();
            }
            standardIndexManager.L.remove(a222);
        }
        if (FileUtils.H((File)storageProperties.index(standardIndexManager.D, (long)a2)) && FileUtils.H((File)storageProperties.bloomFilter(standardIndexManager.D, (long)a2))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean H(FileVersion fileVersion2, String string) {
        void a2;
        StandardIndexManager a3 = fileVersion2;
        StandardIndexManager a4 = this;
        if ((a3 = a4.L.computeIfAbsent(a3, fileVersion -> {
            StandardIndexManager a2 = fileVersion;
            StandardIndexManager a3 = this;
            f.debug(ContextResourceCleaner.H((Object)"w\n6Wc\u0007i\u0019,\u0015`\u0018c\u001a,\u0011e\u001bx\u0012~Wj\u0018~Ww\n"), (Object)a3.J, (Object)a2.H());
            StorageProperties storageProperties = (StorageProperties)a3.k.get();
            a2 = new PersistedBloomFilter(storageProperties.bloomFilter(a3.D, (FileVersion)a2).getAbsolutePath(), 0, 0.03f);
            if (!a2.H()) {
                return null;
            }
            a3.C.increment();
            StandardIndexManager standardIndexManager = a2;
            standardIndexManager.E();
            return standardIndexManager;
        })) != null && !a3.H((String)a2)) {
            return true;
        }
        return false;
    }
}

