/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.localstorage.file.EmbeddedDBProperties;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.rest.ApplicationJSON;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

public class StorageProperties
implements Cloneable,
Serializable {
    private boolean useMmapIndex;
    private Boolean forceClean;
    private long syncInterval;
    private int readBufferSize;
    private int segmentSize;
    private int sksRocksdbCacheSize;
    private static final String TEMP_PATH_FORMAT = "%s/%020d%s.temp";
    private float bloomIndexFpp;
    private int entriesPerSegment;
    private int globalIndexSegmentsCheck;
    private static final String TEMP_PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s.temp";
    private static final int DEFAULT_READ_BUFFER_SIZE = 32768;
    public static final String PRIMARY_STORAGE_KEY = "primary";
    private int streamThreadsPerContext;
    private int maxIndexesInMemory;
    private String sksAggregateIdEncoder;
    private String posIndexSuffix;
    private static final String PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s";
    private String bloomIndexSuffix;
    private int eventsPerSegmentPrefetch;
    private long forceInterval;
    private static final String TRANSFORMED_PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s.transformed";
    private long warnFreeSpace;
    private int primaryCleanupDelay;
    private int flags;
    private Duration[] retentionTime;
    private int memoryMappedSegments;
    private int validationSegments;
    private final SystemInfoProvider systemInfoProvider;
    private Duration globalIndexPreloadTimeout;
    private int sksMaxOpenedPositionIndexFiles;
    private String storage;
    private String newIndexSuffix;
    private GlobalIndexPreload globalIndexPreload;
    private String eventsSuffix;
    public static final String TRANSFORMED_SUFFIX = ".transformed";
    private String indexFormat;
    private boolean bulkIndexAllowParallel;
    private static final String PATH_FORMAT = "%s/%020d%s";
    private String sksPositionIndexFileSuffix;
    private String globalIndexSuffix;
    private Map<String, String> storages;
    private String indexSuffix;
    private long minFreeSpace;
    private int segmentsForSequenceNumberCheck;
    private boolean keepOldVersions;
    private int secondaryCleanupDelay;
    private int maxBloomFiltersInMemory;
    private static final String FILE_WITH_VERSION_FORMAT = "%020d_%05d%s";
    private static final String OLD_PATH_FORMAT = "%s/%014d%s";
    private static final String FILE_FORMAT = "%020d%s";
    private Boolean forceCleanMmapIndex;

    public int getValidationSegments() {
        StorageProperties a2;
        return a2.validationSegments;
    }

    public void setSegmentSize(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)ApplicationJSON.H((Object)"=H\t@\u000bC\u001a\r\u001dD\u0014HN@\u001b^\u001a\r\fHNA\u000b^\u001d\r\u001aE\u000fCN\u001f_\u0019Y\u0019V\u001eX\u0019Y"));
        Assert.isTrue((a2.toBytes() > 0L ? 1 : 0) != 0, (String)EmbeddedDBProperties.H((Object)"C(w u#dmc$j(0 e>dmr(0*b(q9u?09x,~m "));
        a3.segmentSize = (int)a2.toBytes();
    }

    /*
     * WARNING - void declaration
     */
    public File indexTemp(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.H();
        objectArray[2] = a3.H();
        objectArray[3] = a4.indexSuffix;
        return new File(String.format(TEMP_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public int getMaximumNumberOfPendingSegmentSeals() {
        return 3;
    }

    public StorageProperties withSksMaxOpenedPositionIndexFiles(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.H().sksMaxOpenedPositionIndexFiles = a2;
        return a3.H();
    }

    public long getSyncInterval() {
        StorageProperties a2;
        return a2.syncInterval;
    }

    /*
     * WARNING - void declaration
     */
    public File oldIndex(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    public String getStorage(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        String string2 = (String)a3.storages.get(a2);
        if (string2 == null) {
            if (PRIMARY_STORAGE_KEY.equals(a2)) {
                return a3.storage;
            }
            Object object = a2;
            throw new IllegalStateException("Storage " + (String)object + " not defined on this node.To define storage set property: axoniq.axonserver.event.storages." + (String)object);
        }
        return string2;
    }

    public int getPrimaryCleanupDelay() {
        StorageProperties a2;
        return a2.primaryCleanupDelay;
    }

    /*
     * WARNING - void declaration
     */
    public StorageProperties(SystemInfoProvider systemInfoProvider, String string, String string2, String string3, String string4, String string5, String string6) {
        Object a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        StorageProperties a9;
        StorageProperties storageProperties = object;
        Object object = string6;
        StorageProperties storageProperties2 = a9 = storageProperties;
        StorageProperties storageProperties3 = a9;
        StorageProperties storageProperties4 = a9;
        a9((SystemInfoProvider)a8);
        storageProperties4.eventsSuffix = a7;
        storageProperties4.indexSuffix = a6;
        storageProperties3.bloomIndexSuffix = a5;
        storageProperties3.globalIndexSuffix = a4;
        storageProperties2.newIndexSuffix = a3;
        storageProperties2.sksPositionIndexFileSuffix = a2;
    }

    public int getStreamThreadsPerContext() {
        StorageProperties a2;
        return a2.streamThreadsPerContext;
    }

    public void setNewIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.newIndexSuffix = a2;
    }

    private /* synthetic */ StorageProperties H() {
        StorageProperties storageProperties = this;
        try {
            return (StorageProperties)storageProperties.clone();
        }
        catch (CloneNotSupportedException a2) {
            throw new RuntimeException(a2.getMessage(), a2);
        }
    }

    public StorageProperties withGlobalIndexSegmentsCheck(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.H().globalIndexSegmentsCheck = a2;
        return a3.H();
    }

    public void setIndexFormat(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.indexFormat = a2;
    }

    public String getSksAggregateIdEncoder() {
        StorageProperties a2;
        return a2.sksAggregateIdEncoder;
    }

    public int segmentsForSequenceNumberCheck() {
        StorageProperties a2;
        return a2.segmentsForSequenceNumberCheck;
    }

    /*
     * WARNING - void declaration
     */
    public File oldDataFile(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.eventsSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public File indexTemp(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    public StorageProperties withGlobalIndexPreloadTimeout(Duration duration) {
        Object a2 = duration;
        StorageProperties a3 = this;
        a3.H().globalIndexPreloadTimeout = a2;
        return a3.H();
    }

    public int getMaxIndexesInMemory() {
        StorageProperties a2;
        return a2.maxIndexesInMemory;
    }

    public void setForceClean(Boolean bl) {
        Object a2 = bl;
        StorageProperties a3 = this;
        a3.forceClean = a2;
    }

    public String getPrimaryStorage(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[2];
        objectArray[0] = a3.storages.getOrDefault(PRIMARY_STORAGE_KEY, a3.storage);
        objectArray[1] = a2;
        return String.format(EmbeddedDBProperties.H((Object)"5>?hc"), objectArray);
    }

    public int getEventsPerSegmentPrefetch() {
        StorageProperties a2;
        return a2.eventsPerSegmentPrefetch;
    }

    /*
     * WARNING - void declaration
     */
    public File newIndexTemp(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.newIndexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    public StorageProperties withSksRocksdbCacheSize(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.H().sksRocksdbCacheSize = a2;
        return a3.H();
    }

    /*
     * WARNING - void declaration
     */
    public String getStorage(String string, String string2) {
        void a2;
        Object a3 = string2;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[2];
        objectArray[0] = a4.getStorage((String)a2);
        objectArray[1] = a3;
        return String.format(ApplicationJSON.H((Object)"K^A\b\u001d"), objectArray);
    }

    public String getEventsSuffix() {
        StorageProperties a2;
        return a2.eventsSuffix;
    }

    /*
     * WARNING - void declaration
     */
    public File newIndex(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.H() == 0) {
            return a4.newIndex((String)a2, a3.H());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.H();
        objectArray[2] = a3.H();
        objectArray[3] = a4.newIndexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public int getSksRocksdbCacheSize() {
        StorageProperties a2;
        return a2.sksRocksdbCacheSize;
    }

    public void setStorages(Map<String, String> map) {
        Object a2 = map;
        StorageProperties a3 = this;
        if (a3.storages != null && a3.storages.containsKey(PRIMARY_STORAGE_KEY)) {
            a3.storages.putAll(a2);
            return;
        }
        a3.storages = a2;
    }

    public void setEventsPerSegmentPrefetch(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.eventsPerSegmentPrefetch = a2;
    }

    public StorageProperties withBulkIndexAllowParallel(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.H().bulkIndexAllowParallel = a2;
        return a3.H();
    }

    /*
     * WARNING - void declaration
     */
    public File dataFile(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        return new File((String)a2 + File.separator + a4.dataFile((FileVersion)a3));
    }

    public String getSksPositionIndexFileSuffix() {
        StorageProperties a2;
        return a2.sksPositionIndexFileSuffix;
    }

    public void setSecondaryCleanupDelay(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.secondaryCleanupDelay = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File transformedDataFile(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.H() == 0) {
            throw new RuntimeException(ApplicationJSON.H((Object)"\rL\u0000C\u0001YNY\u001cL\u0000^\bB\u001c@NY\u0001\r\u0018H\u001c^\u0007B\u0000\r^"));
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.H();
        objectArray[2] = a3.H();
        objectArray[3] = a4.eventsSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setKeepOldVersions(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.keepOldVersions = a2;
    }

    public String dataFile(long a2) {
        StorageProperties a3;
        Object[] objectArray = new Object[2];
        objectArray[0] = a2;
        objectArray[1] = a3.eventsSuffix;
        return String.format(FILE_FORMAT, objectArray);
    }

    public StorageProperties withGlobalIndexPreload(GlobalIndexPreload globalIndexPreload) {
        StorageProperties a2 = globalIndexPreload;
        StorageProperties a3 = this;
        a3.H().globalIndexPreload = a2;
        return a3.H();
    }

    public void setMaxIndexesInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.maxIndexesInMemory = a2;
    }

    public void setGlobalIndexPreloadTimeout(Duration duration) {
        Object a2 = duration;
        StorageProperties a3 = this;
        a3.globalIndexPreloadTimeout = a2;
    }

    public GlobalIndexPreload getGlobalIndexPreload() {
        StorageProperties a2;
        return a2.globalIndexPreload;
    }

    public void setForceCleanMmapIndex(Boolean bl) {
        Object a2 = bl;
        StorageProperties a3 = this;
        a3.forceCleanMmapIndex = a2;
    }

    public void setMaxBloomFiltersInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.maxBloomFiltersInMemory = a2;
    }

    public void setMemoryMappedSegments(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.memoryMappedSegments = a2;
    }

    public boolean isUseMmapIndex() {
        StorageProperties a2;
        return a2.useMmapIndex;
    }

    public int getFlags() {
        StorageProperties a2;
        return a2.flags;
    }

    public StorageProperties withKeepOldVersions(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.H().keepOldVersions = a2;
        return a3.H();
    }

    public void setGlobalIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.globalIndexSuffix = a2;
    }

    public void setGlobalIndexPreload(GlobalIndexPreload globalIndexPreload) {
        StorageProperties a2 = globalIndexPreload;
        StorageProperties a3 = this;
        a3.globalIndexPreload = a2;
    }

    public long warnFreeSpace() {
        StorageProperties a2;
        return a2.warnFreeSpace;
    }

    public void setStorage(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.storage = a2;
        if (a3.storages != null) {
            if (!a3.storages.containsKey(PRIMARY_STORAGE_KEY)) {
                a3.storages.put(PRIMARY_STORAGE_KEY, a2);
                return;
            }
        } else {
            a3.storages = new HashMap();
            a3.storages.put(PRIMARY_STORAGE_KEY, a2);
        }
    }

    public Duration getGlobalIndexPreloadTimeout() {
        StorageProperties a2;
        return a2.globalIndexPreloadTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public File posIndex(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.posIndexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public int globalIndexSegmentsCheck() {
        StorageProperties a2;
        return a2.globalIndexSegmentsCheck;
    }

    public int getSecondaryCleanupDelay() {
        StorageProperties a2;
        return a2.secondaryCleanupDelay;
    }

    public Duration getSegmentSealingBlockInterval() {
        return Duration.ofSeconds(1L);
    }

    public String getGlobalIndexSuffix() {
        StorageProperties a2;
        return a2.globalIndexSuffix;
    }

    /*
     * WARNING - void declaration
     */
    public File newTransformedIndex(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.H() == 0) {
            return a4.transformedIndex((String)a2, a3.H());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.H();
        objectArray[2] = a3.H();
        objectArray[3] = a4.newIndexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public float getBloomIndexFpp() {
        StorageProperties a2;
        return a2.bloomIndexFpp;
    }

    public void setFlags(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.flags = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File bloomFilter(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.bloomIndexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public String getIndexFormat() {
        StorageProperties a2;
        return a2.indexFormat;
    }

    public void setSksMaxOpenedPositionIndexFiles(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.sksMaxOpenedPositionIndexFiles = a2;
    }

    public void setForceInterval(long a2) {
        a.forceInterval = a2;
    }

    public boolean isCleanRequired() {
        StorageProperties a2;
        if (Boolean.TRUE.equals(a2.forceClean) || a2.systemInfoProvider.javaOnWindows()) {
            return true;
        }
        return false;
    }

    public boolean isForceCleanMmapIndex() {
        StorageProperties a2;
        if (a2.forceCleanMmapIndex != null) {
            return a2.forceCleanMmapIndex;
        }
        return a2.systemInfoProvider.javaOnWindows();
    }

    public void setSksPositionIndexFileSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.sksPositionIndexFileSuffix = a2;
    }

    public void setSegmentsForSequenceNumberCheck(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.segmentsForSequenceNumberCheck = a2;
    }

    public String getIndexSuffix() {
        StorageProperties a2;
        return a2.indexSuffix;
    }

    public int getSegmentSize() {
        StorageProperties a2;
        return a2.segmentSize;
    }

    public void setSyncInterval(long a2) {
        a.syncInterval = a2;
    }

    public StorageProperties withMaxIndexesInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.H().maxIndexesInMemory = a2;
        return a3.H();
    }

    public StorageProperties withMaxBloomFiltersInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.H().maxBloomFiltersInMemory = a2;
        return a3.H();
    }

    public Map<String, String> getAvailableStorages() {
        StorageProperties a2;
        return a2.storages;
    }

    public StorageProperties withIndexFormat(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.H().indexFormat = a2;
        return a3.H();
    }

    /*
     * WARNING - void declaration
     */
    public File index(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public File dataFile(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        return a4.dataFile((String)a3, new FileVersion((long)a2, 0));
    }

    public void setRetentionTime(Duration[] durationArray) {
        Duration[] a2 = durationArray;
        Duration[] a3 = this;
        a3.retentionTime = a2;
    }

    public long getRetentionTime(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        if (a2 < 0 || a2 >= a3.retentionTime.length) {
            return System.currentTimeMillis();
        }
        return a3.retentionTime[a2].toMillis();
    }

    public StorageProperties withSegmentSize(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.H().segmentSize = a2;
        return a3.H();
    }

    public String getBloomIndexSuffix() {
        StorageProperties a2;
        return a2.bloomIndexSuffix;
    }

    /*
     * WARNING - void declaration
     */
    public File newIndexTemp(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.H() == 0) {
            return a4.newIndexTemp((String)a2, a3.H());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.H();
        objectArray[2] = a3.H();
        objectArray[3] = a4.newIndexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public File transformedIndex(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.H() == 0) {
            return a4.transformedIndex((String)a2, a3.H());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.H();
        objectArray[2] = a3.H();
        objectArray[3] = a4.indexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setEventsSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.eventsSuffix = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File oldBloomFilter(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.bloomIndexSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    public long getForceInterval() {
        StorageProperties a2;
        return a2.forceInterval;
    }

    public void setGlobalIndexSegmentsCheck(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.globalIndexSegmentsCheck = a2;
    }

    public void setReadBufferSize(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.readBufferSize = a2;
    }

    public void setPrimaryCleanupDelay(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.primaryCleanupDelay = a2;
    }

    public StorageProperties withSksAggregateIdEncoder(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.H().sksAggregateIdEncoder = a2;
        return a3.H();
    }

    /*
     * WARNING - void declaration
     */
    public File newIndex(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.newIndexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public int getMaxBloomFiltersInMemory() {
        StorageProperties a2;
        return a2.maxBloomFiltersInMemory;
    }

    /*
     * WARNING - void declaration
     */
    public File index(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.H() == 0) {
            return a4.index((String)a2, a3.H());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.H();
        objectArray[2] = a3.H();
        objectArray[3] = a4.indexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public StorageProperties(SystemInfoProvider systemInfoProvider) {
        StorageProperties a2;
        StorageProperties a3 = systemInfoProvider;
        StorageProperties storageProperties = a2 = this;
        StorageProperties storageProperties2 = a2;
        StorageProperties storageProperties3 = a2;
        StorageProperties storageProperties4 = a2;
        StorageProperties storageProperties5 = a2;
        StorageProperties storageProperties6 = a2;
        StorageProperties storageProperties7 = a2;
        StorageProperties storageProperties8 = a2;
        StorageProperties storageProperties9 = a2;
        StorageProperties storageProperties10 = a2;
        StorageProperties storageProperties11 = a2;
        a2.eventsSuffix = ".events";
        storageProperties11.indexSuffix = ".index";
        storageProperties11.newIndexSuffix = ".nindex";
        storageProperties10.globalIndexSuffix = ".xref";
        storageProperties10.bloomIndexSuffix = ".bloom";
        storageProperties9.segmentSize = 0x10000000;
        storageProperties9.storage = "./data";
        StorageProperties storageProperties12 = a2;
        storageProperties9.storages = new HashMap();
        storageProperties8.bloomIndexFpp = 0.03f;
        storageProperties8.forceInterval = 1000L;
        storageProperties7.validationSegments = 10;
        storageProperties7.memoryMappedSegments = 5;
        storageProperties6.primaryCleanupDelay = 0;
        storageProperties6.secondaryCleanupDelay = 0;
        storageProperties5.maxIndexesInMemory = 50;
        storageProperties5.maxBloomFiltersInMemory = 100;
        storageProperties4.syncInterval = 1000L;
        storageProperties4.useMmapIndex = true;
        storageProperties3.forceCleanMmapIndex = true;
        storageProperties3.eventsPerSegmentPrefetch = 10;
        storageProperties2.globalIndexSegmentsCheck = Integer.MAX_VALUE;
        storageProperties2.readBufferSize = 32768;
        storageProperties.keepOldVersions = false;
        Duration[] durationArray = new Duration[1];
        durationArray[0] = Duration.ofDays(7L);
        storageProperties.retentionTime = durationArray;
        StorageProperties storageProperties13 = a2;
        StorageProperties storageProperties14 = a2;
        StorageProperties storageProperties15 = a2;
        StorageProperties storageProperties16 = a2;
        StorageProperties storageProperties17 = a2;
        StorageProperties storageProperties18 = a2;
        StorageProperties storageProperties19 = a2;
        storageProperties19.segmentsForSequenceNumberCheck = 10;
        storageProperties19.minFreeSpace = DataSize.ofMegabytes((long)512L).toBytes();
        storageProperties18.warnFreeSpace = DataSize.ofGigabytes((long)5L).toBytes();
        storageProperties18.entriesPerSegment = 1000000;
        storageProperties17.globalIndexPreload = GlobalIndexPreload.L;
        storageProperties17.globalIndexPreloadTimeout = Duration.ofSeconds(10L);
        storageProperties16.sksPositionIndexFileSuffix = ".rindex";
        storageProperties16.sksAggregateIdEncoder = "plain";
        storageProperties15.sksMaxOpenedPositionIndexFiles = 100;
        storageProperties15.sksRocksdbCacheSize = (int)DataSize.ofMegabytes((long)512L).toBytes();
        storageProperties14.posIndexSuffix = ".pos";
        storageProperties14.bulkIndexAllowParallel = false;
        storageProperties13.streamThreadsPerContext = 1;
        storageProperties13.systemInfoProvider = a3;
    }

    public void setIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.indexSuffix = a2;
    }

    public int getMemoryMappedSegments() {
        StorageProperties a2;
        return a2.memoryMappedSegments;
    }

    public void setBloomIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.bloomIndexSuffix = a2;
    }

    public void setStreamThreadsPerContext(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.streamThreadsPerContext = a2;
    }

    public void setWarnFreeSpace(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        a3.warnFreeSpace = a2.toBytes();
    }

    public void setUseMmapIndex(Boolean bl) {
        Boolean a2 = bl;
        StorageProperties a3 = this;
        a3.useMmapIndex = a2;
    }

    public void setBulkIndexAllowParallel(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.bulkIndexAllowParallel = a2;
    }

    public void setMinFreeSpace(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        a3.minFreeSpace = a2.toBytes();
    }

    public long minFreeSpace() {
        StorageProperties a2;
        return a2.minFreeSpace;
    }

    public StorageProperties withSegmentsForSequenceNumberCheck(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.H().segmentsForSequenceNumberCheck = a2;
        return a3.H();
    }

    public void setBloomIndexFpp(float f) {
        float a2 = f;
        StorageProperties a3 = this;
        a3.bloomIndexFpp = a2;
    }

    public void setSksAggregateIdEncoder(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.sksAggregateIdEncoder = a2;
    }

    public int getReadBufferSize() {
        StorageProperties a2;
        return a2.readBufferSize;
    }

    public void setSksRocksdbCacheSize(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.sksRocksdbCacheSize = a2;
    }

    public boolean isBulkIndexAllowParallel() {
        StorageProperties a2;
        return a2.bulkIndexAllowParallel;
    }

    /*
     * WARNING - void declaration
     */
    public File bloomFilter(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.H() == 0) {
            return a4.bloomFilter((String)a2, a3.H());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.H();
        objectArray[2] = a3.H();
        objectArray[3] = a4.bloomIndexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public int getSksMaxOpenedPositionIndexFiles() {
        StorageProperties a2;
        return a2.sksMaxOpenedPositionIndexFiles;
    }

    public boolean isKeepOldVersions() {
        StorageProperties a2;
        return a2.keepOldVersions;
    }

    public String getNewIndexSuffix() {
        StorageProperties a2;
        return a2.newIndexSuffix;
    }

    public StorageProperties withForceClean(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.H().forceClean = a2;
        return a3.H();
    }

    public void setEntriesPerSegment(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.entriesPerSegment = a2;
    }

    public String dataFile(FileVersion fileVersion) {
        StorageProperties a2 = fileVersion;
        StorageProperties a3 = this;
        if (a2.H() == 0) {
            return a3.dataFile(a2.H());
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = a2.H();
        objectArray[1] = a2.H();
        objectArray[2] = a3.eventsSuffix;
        return String.format(FILE_WITH_VERSION_FORMAT, objectArray);
    }

    public int getEntriesPerSegment() {
        StorageProperties a2;
        return a2.entriesPerSegment;
    }

    /*
     * WARNING - void declaration
     */
    public File transformedIndex(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    public StorageProperties withRetentionTime(Duration[] durationArray) {
        Duration[] a2 = durationArray;
        Duration[] a3 = this;
        a3.H().retentionTime = a2;
        return a3.H();
    }

    public void setValidationSegments(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.validationSegments = a2;
    }

    public Boolean getForceClean() {
        StorageProperties a2;
        return a2.forceClean;
    }
}

